<div class="row">

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-md-12">
        <h1 class="page-header"><i class="fa-solid fa-briefcase"></i><strong> Vacantes</strong></h1>
    </div>

    <div class="col-md-12">
        <br>
        <a id="downloadLink" style="display: none;"></a>
        <table class="table table-responsive table-striped" id="tabla_vacantes">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Nombre</th>
                    <th>Descripción</th>
                    <th style="display: none;">Descripción</th>
                    <th>Categoría</th>
                    <th>Postulados</th>
                    <th>Estatus</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (!is_null($vacantes)) {

                    $cont = 1;
                    foreach ($vacantes as $vacante) {

                        if ($vacante->estatus == 1) {
                            $estatus = "<h4><span class='label label-success'>Activo</span></h4>";
                        }else{
                            $estatus = "<h4><span class='label label-danger'>Inactivo</span></h4>";
                        }

                        if (is_null($vacante->descripcion) || $vacante->descripcion == "") {
                            $desc = "N/A";
                        }else {
                            $descripcion = $vacante->descripcion;

                            $descripcion = str_replace('"', '', $descripcion);
                            $descripcion = str_replace('“', '', $descripcion);
                            $descripcion = str_replace("'", '', $descripcion);
    
                            $cont_desc = strlen($descripcion);
                            if($cont_desc > 30){
                                $desc = substr($descripcion,0, 30).'... <a href class="showMensaje"  data-mensaje="'.nl2br($descripcion).'">Ver más</a>'; 
                            }else{
                                $desc = $descripcion;
                            }
                        }

                        $cadena = rawurlencode("Da enter para saber de la vacante ".$vacante->nombre." ".$vacante->codigo_vacante.";".$reclutador->codigo_reclutador);

                        $url = "https://wa.me/5218185263284?text=".$cadena;

                        $idVacante = base64_encode($vacante->id_vacante);

                        ?>

                        <tr>
                            <td><?=$cont; ?></td>
                            <td><?=$vacante->nombre; ?></td>
                            <td><?=$desc ?></td>
                            <td style="display: none;"><?=$vacante->descripcion; ?></td>
                            <td><?=$vacante->categoria;?></td>
                            <td style="text-align: center;">
                                <h4><span class="label" style="background-color: #1d70b6; color: white;"><?=$vacante->postulaciones;?></span></h4>
                            </td>
                            <td><?=$estatus; ?></td>
                            <td>
                                <button class="verPreguntas btn" data-id="<?=$vacante->id_vacante;?>" style="width: 140px; background-color: #29265b; 
                                color: white; margin-bottom: 0.5rem;">
                                    <i class="fa-solid fa-circle-question"></i> Preguntas</button><br>
                                <a class="btn" style="width: 140px; background-color: #1d70b6; color: white; margin-bottom: 0.5rem;"
                                href="<?php echo base_url();?>index.php/postuladosVacanteReclutador?v=<?=$idVacante?>">
                                    <i class="fa-solid fa-user-check"></i> Postulados</a><br>
                                <button class="verQR btn" data-id="<?=$vacante->id_vacante; ?>" data-reclutador='<?=$vacante->id_reclutador?>'
                                data-vacante="<?=$vacante->nombre; ?>" style="width: 140px; margin-top: 0.5rem; background-color:#29265b; color:white;">
                                <i class="fa fa-eye"></i> QR</button><br>

                                <!-- <?php 
                                    if(!is_null($vacante->url_qr)){
                                ?>
                                <button class="copyURL btn btn-primary" data-url="<?=$url; ?>" style="width: 140px; margin-top: 0.5rem;">
                                    <i class="fa fa-clipboard"></i> Copiar Link QR</button>

                                <?php }?> -->

                            </td>
                        </tr>
                            
                    <?php $cont++;

                    }
                 } 
                 ?>
                
            </tbody>
        </table>
    </div>
</div>

<div class="modal fade"  tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" id="mensaje_modal">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>Descripción:</b></h3>
            </div>
            <div class="modal-body" id="mensaje_body">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Aceptar</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal preguntas -->
<div class="modal fade" id="preguntasModal" tabindex="-1" role="dialog" aria-labelledby="preguntasModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h3 class="modal-title" id="preguntasModalLabel" style="color: white; font-weight: bold;">Preguntas</h3>
      </div>
      <div class="modal-body">
        <div class="row">
            <div class="contenedor col-md-12">
              
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn" data-dismiss="modal" style="background-color: #3f5364; color: white;">
        <i class="fa-solid fa-rectangle-xmark"></i> Cerrar
        </button>
      </div>
    </div>
  </div>
</div>

<div class="modal fade" id="modal_qr" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 style="text-align: center; color: white;" class="modal-title" id="txt_modal_qr">QR</h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body modal-salidas">
                <div class="row">
                    <div class="col-md-12" style="text-align: center">
                        <img id="imgQR" src="" class="img-rounded" alt="IMG1" width="330" height="330" title="IMG1" />
                    </div>
                    <br><br>
                    <div class="col-md-12" style="text-align: center">
                        <label>URL:</label>
                        <br>
                        <a href="https://example.com" id="url" target="_blank"></a>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-success" id="btnCopiar" data-url=""><i class="fa fa-copy"></i> Copiar</button>
                <a href="" download="" id="descargar" class="btn btn-primary"><i class="fa fa-download"></i> Descargar</a>
            </div>
        </div>
    </div>
</div>

<style type="text/css">

    a:hover,a:focus{
    text-decoration: none;
    outline: none;
    }

    #accordion .panel{
        border: none;
        box-shadow: none;
        border-radius: 30px;
        margin-bottom: 15px;
    }
    #accordion .panel-heading{
        padding: 0;
        border-radius: 30px;
    }
    #accordion .panel-title a{
        display: block;
        padding: 12px 20px 12px 50px;
        background: #3f536430;
        font-size: 14px;
        font-weight: 600;
        color: #1d70b6;
        border: none;
        border-radius: 30px;
        position: relative;
        transition: all 0.3s ease 0s;
    }
    #accordion .panel-title a.collapsed{ color: #3f5364; }
    #accordion .panel-title a:after,
    #accordion .panel-title a.collapsed:after{
        content: "\f107";
        font-family: "Font Awesome 5 Free";
        font-weight: 900;
        width: 45px;
        height: 45px;
        line-height: 50px;
        border-radius: 50%;
        background: #1d70b6;
        font-size: 25px;
        color: #fff;
        text-align: center;
        position: absolute;
        top: -0.3rem;
        left: 0;
        transition: all 0.3s ease 0s;
    }
    #accordion .panel-title a.collapsed:after{ content: "\f105"; }
    #accordion .panel-body{
        padding: 20px 0 0 0;
        font-size: 14px;
        color: #3f5364;
        line-height: 25px;
        border-top: none;
        position: relative;
    }
    #accordion .panel-body p{
        padding: 10px 20px 10px;
        margin: 0;
        background: #3f536430;
        border-radius: 15px;
    }


    @media(max-width:1300px){
        .postuladosV {
            margin-top: 0.5rem;
        }
    }

    @media(max-width:750px){
        #divFiltro {
            display: grid;
            grid-template-columns: 1fr 1fr;
        }
    }


</style>

<script type="text/javascript" src="<?=base_url();?>public/js/jquery.js"></script>
<!-- <script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script> -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="<?php echo base_url('public/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('public/dataTables.bootstrap.js')?>"></script>
<script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.4.2/css/buttons.dataTables.min.css">
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

<script type="text/javascript">
    jQuery(document).ready(function($){

        ocultarLoader();

        var tabla = $('#tabla_vacantes').DataTable( {
            dom: "<'top-btns'<'col-md-2 col-sm-2 col-xs-6 'B> <'col-md-10 col-sm-10 col-xs-10 '<'col-md-6 col-sm-6 col-xs-6 'l><'col-md-6 col-sm-6 col-xs-6 'f>>>"+ "<br/>" +
            "<'top'<'col-md-12 table-date scroll-x'tr>>" +
            "<'top'<'col-md-4'i><'col-md-7'p>>",
            oLanguage: { 
                "sSearch": "Buscar: ",
                "sInfo" : "Mostrando del _START_ al _END_ de _TOTAL_ registros totales",
                "sLengthMenu": "Mostrando _MENU_ entradas",
            },
            buttons: [
                {
                    text: '<i class="fa-solid fa-file-excel"></i> Excel',
                    extend: 'excelHtml5', 
                    className : 'btn btn-primary',
                    exportOptions: {
                        columns: [0, 1, 3, 4, 5, 6, 7]
                    }
                }
            ]
        });

        $("#tabla_vacantes").css("margin-top", "1em");
        $("#tabla_vacantes_info").css("margin-top", "2em");
        $("#tabla_vacantes_paginate").css("margin-top", "2em");
        $("#tabla_vacantes_previous").find( "a" ).html("Anterior");
        $("#tabla_vacantes_next").find( "a" ).html("Siguiente");

        $(document).on('click', '.paginate_button', function(){

            $("#tabla_vacantes_previous").find( "a" ).html("Anterior");
            $("#tabla_vacantes_next").find( "a" ).html("Siguiente");

        });

        $(document).on('click', '.showMensaje', function(){

            event.preventDefault()
            var mensaje = $(this).attr("data-mensaje");

            // mensaje     = mensajeConvertido(mensaje); 

            $("#mensaje_body").html(mensaje);
            $("#mensaje_modal").modal("show");

        });

        $(document).on('click', '.verPreguntas', function(event) {
            
            var idVacante = $(this).attr("data-id");

            getPreguntasVacante(idVacante);

        });

        $(document).on('click', '.verQR', function(event) {

            var idVacante    = $(this).attr("data-id");
            var idReclutador = $(this).attr("data-reclutador");
            var nombre       = $(this).attr("data-vacante");

           generarCodigoQr(idVacante, idReclutador, nombre);

        });

        $('#btnCopiar').on('click', function () {
            var textoACopiar = $(this).data('url');

            navigator.clipboard.writeText(textoACopiar).then(function () {
                Swal.fire({
                    title: 'URL copiada con éxito',
                    icon: 'success',
                    showConfirmButton: false,
                    timer: 2000,
                    timerProgressBar: true
                });
            }, function (err) {
                alert("Error al copiar: " + err);
            });

        });

        $(document).on('click', '.copyURL', function(event) {

            var copyText = $(this).attr("data-url");

            /*Ajax para hacer el link mas corto con una api, ya regreso la url
            $.ajax({
                url : "<?php //echo base_url();?>index.php/acortarUrl",
                type : "POST",
                dataType : "json",
                data :{"copyText": copyText},
                success : function(response){

                }
            });*/

            var textarea            = document.createElement("textarea");
            textarea.textContent    = copyText;
            textarea.style.position = "fixed"; // Prevent scrolling to bottom of page in MS Edge.
            document.body.appendChild(textarea);
            textarea.select();
            document.execCommand("copy"); 

            document.body.removeChild(textarea);

            Swal.fire({
                title: "URL copiada con éxito",
                type: 'success'
            });

        });


    });//termina jQuery

    function generarCodigoQr(idVacante, idReclutador, nombre){

        $.ajax({
            url : "<?php echo base_url();?>index.php/generarCodigoQrReclutador",
            type : "POST",
            dataType : "json",
            data :{"idVacante": idVacante, "idReclutador" : idReclutador, "nombre" : nombre},
            success : function(response){

                // var imageUrl = response.url_qr;

                // // Crear un enlace oculto y asignarle el URL de la imagen
                // var link = $('#downloadLink');
                // link.attr('href', imageUrl);
                // link.attr('download', response.nombreQr);

                // // Simular un clic en el enlace
                // link[0].click();

                $("#btnCopiar").attr("data-url", response.urlCopia);
                
                $("#txt_modal_qr").html("QR - " + response.nombreQr);
                $("#url").attr("href", response.url_qr);
                $("#url").text(response.url_qr);

                $("#imgQR").attr("src", response.url_qr);

                $("#descargar").attr("href", response.url_qr);
                $("#descargar").attr("download", "QR-" + response.nombreQr);

                $("#modal_qr").modal("show");

            }
        });

    }//termina generarCodigoQr

    function mensajeConvertido(mensaje){

        var asteriscos      = mensaje.split("*").length - 1;
        var guiones_bajos   = mensaje.split("_").length - 1;
        var tachados        = mensaje.split("~").length - 1;

        if(asteriscos > 0){

            for (let i = 1; i <= asteriscos; i++) {

                if (i%2==0){
                    mensaje = mensaje.replace("*", "</strong>");
                }else{
                    mensaje = mensaje.replace("*", "<strong>");
                }
                
            }

        }

        if(guiones_bajos > 0){

            for (let i = 1; i <= guiones_bajos; i++) {

                if (i%2==0){
                    mensaje = mensaje.replace("_", "</i>");
                }else{
                    mensaje = mensaje.replace("_", "<i>");
                }
                
            }

        }

        if(tachados > 0){

            for (let i = 1; i <= tachados; i++) {

                if (i%2==0){
                    mensaje = mensaje.replace("~", "</span>");
                }else{
                    mensaje = mensaje.replace("~", "<span style='font-size: 14px; text-decoration-line: line-through;'>");
                }
                
            }

        }

        return mensaje;

    }//termina mensajeConvertido

    function getPreguntasVacante(idVacante){
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/preguntasVacante",
            type : "POST",
            dataType : "json",
            data :{"idVacante": idVacante},
            success : function(response){

                $(".contenedor").html(response.preguntas);
                $("#preguntasModal").modal("show");

            }
        });
    }//termina getPreguntasVacante

    function actualizarReclutador(nombre, correo, lada, celular, estatus){
        
        var id_usuario = $("#usuario_id").val();

        $.ajax({
            url : "<?php echo base_url();?>index.php/actualizarReclutador",
            type : "POST",
            dataType : "json",
            data :{"nombre": nombre, "correo": correo, "lada" : lada, "celular" : celular, "estatus" : estatus, "idUsuario" : id_usuario},
            success : function(datos){

                if(datos.regreso == 200){
                    swal({
                        title: datos.mensaje,
                        icon: 'success'
                    });
                    setTimeout(function(){
                        location. reload();
                    }, 2500);
                }else if(datos.regreso == 300 || datos.regreso == 400){

                    swal({
                        icon: 'info',
                        title: datos.mensaje
                    });
                }else{
                    swal({
                        icon: 'error',
                        title: datos.mensaje
                    });
                }
                
                setTimeout(ocultarLoader, 1000);
                
            }
        });

    }//termina updateUsuario

    function validar(nombre, correo, contrasena, celular) {
        
        var regex               = /[\w-\.]{2,}@([\w-]{2,}\.)*([\w-]{2,}\.)[\w-]{2,4}/;
        var contador_contrasena = $("#contrasena").val().length;
        var regreso             = true;

        if (celular.length < 10 || !$.isNumeric(celular)) {
            regreso = false;
            swal({
                icon: 'info',
                title: "Por favor ingresa un celular válido"
            });
        }else if (nombre.length < 2) {
            regreso = false;
            swal({
                icon: 'info',
                title: "Por favor ingresa el nombre"
            });
        }else if (regex.test(correo) != true) {
            regreso = false;
            swal({
                icon: 'info',
                title: "Por favor ingresa un correo válido"
            });
        }else if (contrasena.length < 3) {
            regreso = false;
            swal({
                icon: 'info',
                title: "Por favor ingresa una contraseña mayor a 3 caracteres"
            });
        }

        return regreso;
    }//termina validar

    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }

</script>