
<script src="https://ajax.googleapis.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>

<style>
/* Estilos responsive adicionales */
@media (max-width: 768px) {
    /* Ajustes generales */
    .row {
        margin: 0;
    }
    
    .col-lg-12 {
        padding: 0;
    }
    
    /* Contenedor principal del chat */
    .box-message {
        display: flex;
        flex-direction: column;
        height: 100vh;
        width: 100%;
        position: relative;
    }
    
    /* Panel de usuarios - Móvil */
    .user-tickets {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: #fff;
        z-index: 10;
        transform: translateX(0);
        transition: transform 0.3s ease;
        display: flex;
        flex-direction: column;
    }
    
    .user-tickets.hidden {
        transform: translateX(-100%);
    }
    
    /* Header búsqueda */
    .header-search {
        padding: 10px;
    }
    
    .status-tickets {
        display: flex;
        gap: 10px;
        margin-bottom: 10px;
    }
    
    .status-tickets a {
        flex: 1;
        text-align: center;
        padding: 10px;
        border-radius: 20px;
        background: #f0f0f0;
        text-decoration: none;
        color: #333;
        font-size: 14px;
    }
    
    .status-tickets a.active {
        background: #ff4458;
        color: white;
    }
    
    /* Lista de contactos */
    .list-chat {
        flex: 1;
        overflow-y: auto;
        padding: 0;
        margin: 0;
    }
    
    .list-chat li {
        padding: 12px;
        display: flex;
        align-items: center;
        border-bottom: 1px solid #f0f0f0;
    }
    
    .initial {
        width: 45px;
        height: 45px;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        color: white;
        font-weight: bold;
        margin-right: 12px;
        flex-shrink: 0;
    }
    
    .datos-chat {
        flex: 1;
        min-width: 0;
    }
    
    .datos-chat h4 {
        margin: 0 0 3px 0;
        font-size: 15px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .number-ticket {
        margin: 0;
        font-size: 12px;
        color: #666;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .date {
        font-size: 11px;
        color: #999;
        text-align: right;
        margin-left: 10px;
    }
    
    /* Vista del chat - Móvil */
    .chat-view {
        position: absolute;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background: #f5f5f5;
        display: flex;
        flex-direction: column;
        transform: translateX(100%);
        transition: transform 0.3s ease;
    }
    
    .chat-view.active {
        transform: translateX(0);
    }
    
    /* Header del chat */
    .header-chat {
        background: white;
        padding: 10px 15px;
        border-bottom: 1px solid #e0e0e0;
        display: flex;
        align-items: center;
        justify-content: space-between;
        min-height: 60px;
    }
    
    .header-chat .position-left {
        display: flex;
        align-items: center;
    }
    
    /* Botón de regreso */
    .back-button-mobile {
        background: none;
        border: none;
        font-size: 24px;
        color: #666;
        padding: 5px 10px 5px 0;
        cursor: pointer;
        display: block;
    }
    
    /* Área de mensajes */
    .viewport-chat {
        flex: 1;
        overflow-y: auto;
        padding: 10px;
        background: #f5f5f5;
    }
    
    /* Input del chat */
    .chat-enter {
        background: white;
        border-top: 1px solid #e0e0e0;
        padding: 10px;
    }
    
    .chat-enter form {
        display: flex;
        align-items: flex-end;
        gap: 8px;
    }
    
    .botones-chat {
        display: flex;
        align-items: center;
        gap: 5px;
        order: -1;
    }
    
    .chat-input-tool {
        background: none;
        border: none;
        padding: 8px;
        cursor: pointer;
        color: #666;
        border-radius: 50%;
        transition: all 0.3s;
        display: flex;
        align-items: center;
        justify-content: center;
    }
    
    .chat-input-tool:hover:not(:disabled) {
        background: #f0f0f0;
    }
    
    .chat-input-tool:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    
    .btnImg {
        background: none;
        border: none;
        padding: 8px;
        font-size: 18px;
        color: #666;
        cursor: pointer;
        border-radius: 50%;
        transition: all 0.3s;
    }
    
    .btnImg:hover:not(:disabled) {
        background: #f0f0f0;
        color: #4caf50;
    }
    
    .btnImg:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    
    .message {
        flex: 1;
        padding: 10px 15px;
        border: 1px solid #ddd;
        border-radius: 25px;
        outline: none;
        resize: none;
        font-size: 16px; /* Previene zoom en iOS */
        min-height: 40px;
        max-height: 120px;
    }
    
    .enviar {
        background: #ff4458;
        color: white;
        border: none;
        padding: 10px 18px;
        border-radius: 50%;
        cursor: pointer;
        font-size: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        transition: background 0.3s;
    }
    
    .enviar:hover:not(:disabled) {
        background: #e63946;
    }
    
    .enviar:disabled {
        opacity: 0.5;
        cursor: not-allowed;
    }
    
    /* Mensajes */
    .message-view {
        margin-bottom: 10px;
    }
    
    .contenedor-message {
        max-width: 85%;
        padding: 8px 12px;
        border-radius: 18px;
        word-wrap: break-word;
    }
    
    .message-in .contenedor-message {
        background: white;
        margin-right: auto;
    }
    
    .message-out .contenedor-message {
        background: #dcf8c6;
        margin-left: auto;
    }
    
    /* Botones de acción del chat */
    #button_tomar_ticket button {
        padding: 8px 16px;
        border-radius: 20px;
        border: 1px solid #ddd;
        background: white;
        cursor: pointer;
        font-size: 13px;
        white-space: nowrap;
    }
    
    /* Ocultar elementos desktop en móvil */
    .desktop-only {
        display: none;
    }
    
    /* Modales */
    .modal-dialog {
        margin: 10px;
    }
    
    .modal-content {
        border-radius: 10px;
    }
    
    /* Emoji picker móvil */
    .intercom-composer-emoji-popover {
        position: fixed;
        bottom: 60px;
        left: 10px;
        right: 10px;
        max-width: none;
        width: auto;
        z-index: 1050;
    }
    
    /* Scrollbar personalizado móvil */
    ::-webkit-scrollbar {
        width: 4px;
    }
}

/* Ajustes para pantallas muy pequeñas */
@media (max-width: 360px) {
    .status-tickets a {
        font-size: 12px;
        padding: 8px;
    }
    
    .initial {
        width: 40px;
        height: 40px;
        font-size: 14px;
    }
    
    .datos-chat h4 {
        font-size: 14px;
    }
    
    .number-ticket {
        font-size: 11px;
    }
    
    .message {
        font-size: 14px;
        padding: 8px 12px;
    }
    
    .enviar {
        padding: 8px 15px;
        font-size: 14px;
    }
}

/* Desktop - mantener estilos actuales */
@media (min-width: 769px) {
    .back-button-mobile {
        display: none;
    }
    
    .user-tickets {
        width: 350px;
        position: relative;
        transform: none !important;
    }
    
    .chat-view {
        position: relative;
        transform: none !important;
        flex: 1;
    }
    
    .box-message {
        display: flex;
        flex-direction: row;
        height: 100vh;
    }
}
</style>

<div class="row">

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-lg-12 padding-0">
        <div class="box-message">
            <div class="user-tickets" id="userTicketsPanel">
                <div class="header-search">
                    <div class="status-tickets">
                        <a id="conversaciones_por_tomar" class="active">Por tomar <i id="icon_por_tomar" style="font-size: .9em; display: none;" class="fa fa-bell"></i><span id="tot_tickets"></span></a>
                        <a id="conversaciones_tomadas" class="">Tomadas <i style="font-size: .9em; display: none;" class="fa fa-bell"></i></a>
                    </div>
                </div>

                <div class="header-search">
                    <div class="status-tickets">
                        <input type="search" id="buscar" name="buscar" class="form-control" placeholder="Buscar chat" style="border-radius: 40px;">
                    </div>
                </div>

                <ul class="nav list-chat" id="contactos">
                    <!-- AQUÍ VA LA FUNCIÓN QUE TRAE LAS CONVERSACIONES -->
                </ul>
                
            </div>
            <div class="chat-view" id="chatViewPanel">
        
                <div class="header-chat">
                    <div class="position-left" style="text-align:left;">
                        <button class="back-button-mobile" onclick="showContactList()">
                            <i class="fa fa-arrow-left"></i>
                        </button>
                        <span><h4 id="cel_actual"></h4></span>
                    </div>
                    <div class="position-left" id="button_tomar_ticket" style="text-align:right;"> </div>
                </div>
                <div class="viewport-chat" id="showmessages" style="position:relative;">
                    <!-- Mensajes del chat -->
                </div>

                <div class="chat-enter" id="toda_conversacion">

                    <div class="auto-complete" id="auto-complete">
                    </div>
                    
                    <form>
                        <div class="botones-chat">
                            <button id="emoji-picker" class="chat-input-tool" disabled>
                                <svg preserveAspectRatio="xMidYMid" viewBox="0 0 24 24" style="width: 25px; height: 25px;">
                                <path d="M12 24C5.38 24 0 18.62 0 12S5.38 0 12 0s12 5.38 12 12-5.38 12-12 12zm0-22C6.5 2 2 6.5 2 12s4.5 10 10 10 10-4.5 10-10S17.5 2 12 2zm0 18c-2.9 0-5.56-1.75-6.9-4.57-.24-.5-.03-1.1.47-1.33.5-.24 1.1-.03 1.33.47C7.9 16.67 9.86 18 12 18c2.15 0 4.1-1.3 5.1-3.43.23-.5.83-.7 1.33-.47.5.23.7.83.47 1.33C17.58 18.25 14.93 20 12 20zm4-8c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2zm-8 0c-1.1 0-2-.9-2-2s.9-2 2-2 2 .9 2 2-.9 2-2 2z" fill="#32A8E6"></path>
                                </svg>
                            </button>
                            <button type="button" class="btnImg subir-archivo" disabled><i class="fa fa-paperclip"></i></button>
                        </div>
                        
                        <textarea class="message" name="" id="message" cols="40" rows="1" disabled ></textarea>
                        <input type="hidden" name="" id="numero_u"/>
                        <input type="hidden" name="" id="status"/>
                        <input type="hidden" name="" id="id_ticket_hidden">
                        <input type="hidden" name="" id="cel">
                        
                        <button class="enviar" id="send_message" disabled><i class="fa fa-paper-plane"></i></button>
                    </form>

                    <div class="intercom-composer-popover intercom-composer-emoji-popover">
                        <div class="intercom-emoji-picker">
                            <div class="intercom-composer-popover-header"><input class="intercom-composer-popover-input" placeholder="Buscar" value=""></div>
                            <div class="intercom-composer-popover-body-container">
                            <div class="intercom-composer-popover-body">
                                <div class="intercom-emoji-picker-groups">
                                            <div class="intercom-emoji-picker-group">
                                                <div class="intercom-emoji-picker-group-title">Más usados</div><span class="intercom-emoji-picker-emoji" title="thumbs_up">👍</span><span class="intercom-emoji-picker-emoji" title="-1">👎</span><span class="intercom-emoji-picker-emoji" title="sob">😭</span><span class="intercom-emoji-picker-emoji" title="confused">😕</span><span class="intercom-emoji-picker-emoji" title="neutral_face">😐</span><span class="intercom-emoji-picker-emoji" title="blush">😊</span><span class="intercom-emoji-picker-emoji" title="heart_eyes">😍</span>
                                            </div>
                                            <div class="intercom-emoji-picker-group">
                                                <div class="intercom-emoji-picker-group-title">Emoticonos y personas</div><span class="intercom-emoji-picker-emoji" title="smile">😄</span><span class="intercom-emoji-picker-emoji" title="smiley">😃</span><span class="intercom-emoji-picker-emoji" title="grinning">😀</span><span class="intercom-emoji-picker-emoji" title="blush">😊</span><span class="intercom-emoji-picker-emoji" title="wink">😉</span><span class="intercom-emoji-picker-emoji" title="heart_eyes">😍</span><span class="intercom-emoji-picker-emoji" title="kissing_heart">😘</span><span class="intercom-emoji-picker-emoji" title="kissing_closed_eyes">😚</span><span class="intercom-emoji-picker-emoji" title="kissing">😗</span><span class="intercom-emoji-picker-emoji" title="kissing_smiling_eyes">😙</span><span class="intercom-emoji-picker-emoji" title="stuck_out_tongue_winking_eye">😜</span><span class="intercom-emoji-picker-emoji" title="stuck_out_tongue_closed_eyes">😝</span><span class="intercom-emoji-picker-emoji" title="stuck_out_tongue">😛</span><span class="intercom-emoji-picker-emoji" title="flushed">😳</span><span class="intercom-emoji-picker-emoji" title="grin">😁</span><span class="intercom-emoji-picker-emoji" title="pensive">😔</span><span class="intercom-emoji-picker-emoji" title="relieved">😌</span><span class="intercom-emoji-picker-emoji" title="unamused">😒</span><span class="intercom-emoji-picker-emoji" title="disappointed">😞</span><span class="intercom-emoji-picker-emoji" title="persevere">😣</span><span class="intercom-emoji-picker-emoji" title="cry">😢</span><span class="intercom-emoji-picker-emoji" title="joy">😂</span><span class="intercom-emoji-picker-emoji" title="sob">😭</span><span class="intercom-emoji-picker-emoji" title="sleepy">😪</span><span class="intercom-emoji-picker-emoji" title="disappointed_relieved">😥</span><span class="intercom-emoji-picker-emoji" title="cold_sweat">😰</span><span class="intercom-emoji-picker-emoji" title="sweat_smile">😅</span><span class="intercom-emoji-picker-emoji" title="sweat">😓</span><span class="intercom-emoji-picker-emoji" title="weary">😩</span><span class="intercom-emoji-picker-emoji" title="tired_face">😫</span><span class="intercom-emoji-picker-emoji" title="fearful">😨</span><span class="intercom-emoji-picker-emoji" title="scream">😱</span><span class="intercom-emoji-picker-emoji" title="angry">😠</span><span class="intercom-emoji-picker-emoji" title="rage">😡</span><span class="intercom-emoji-picker-emoji" title="triumph">😤</span><span class="intercom-emoji-picker-emoji" title="confounded">😖</span><span class="intercom-emoji-picker-emoji" title="laughing">😆</span><span class="intercom-emoji-picker-emoji" title="yum">😋</span><span class="intercom-emoji-picker-emoji" title="mask">😷</span><span class="intercom-emoji-picker-emoji" title="sunglasses">😎</span><span class="intercom-emoji-picker-emoji" title="sleeping">😴</span><span class="intercom-emoji-picker-emoji" title="dizzy_face">😵</span><span class="intercom-emoji-picker-emoji" title="astonished">😲</span><span class="intercom-emoji-picker-emoji" title="worried">😟</span><span class="intercom-emoji-picker-emoji" title="frowning">😦</span><span class="intercom-emoji-picker-emoji" title="anguished">😧</span><span class="intercom-emoji-picker-emoji" title="imp">👿</span><span class="intercom-emoji-picker-emoji" title="open_mouth">😮</span><span class="intercom-emoji-picker-emoji" title="grimacing">😬</span><span class="intercom-emoji-picker-emoji" title="neutral_face">😐</span><span class="intercom-emoji-picker-emoji" title="confused">😕</span><span class="intercom-emoji-picker-emoji" title="hushed">😯</span><span class="intercom-emoji-picker-emoji" title="smirk">😏</span><span class="intercom-emoji-picker-emoji" title="expressionless">😑</span><span class="intercom-emoji-picker-emoji" title="man_with_gua_pi_mao">👲</span><span class="intercom-emoji-picker-emoji" title="man_with_turban">👳</span><span class="intercom-emoji-picker-emoji" title="cop">👮</span><span class="intercom-emoji-picker-emoji" title="construction_worker">👷</span><span class="intercom-emoji-picker-emoji" title="guardsman">💂</span><span class="intercom-emoji-picker-emoji" title="baby">👶</span><span class="intercom-emoji-picker-emoji" title="boy">👦</span><span class="intercom-emoji-picker-emoji" title="girl">👧</span><span class="intercom-emoji-picker-emoji" title="man">👨</span><span class="intercom-emoji-picker-emoji" title="woman">👩</span><span class="intercom-emoji-picker-emoji" title="older_man">👴</span><span class="intercom-emoji-picker-emoji" title="older_woman">👵</span><span class="intercom-emoji-picker-emoji" title="person_with_blond_hair">👱</span><span class="intercom-emoji-picker-emoji" title="angel">👼</span><span class="intercom-emoji-picker-emoji" title="princess">👸</span><span class="intercom-emoji-picker-emoji" title="smiley_cat">😺</span><span class="intercom-emoji-picker-emoji" title="smile_cat">😸</span><span class="intercom-emoji-picker-emoji" title="heart_eyes_cat">😻</span><span class="intercom-emoji-picker-emoji" title="kissing_cat">😽</span><span class="intercom-emoji-picker-emoji" title="smirk_cat">😼</span><span class="intercom-emoji-picker-emoji" title="scream_cat">🙀</span><span class="intercom-emoji-picker-emoji" title="crying_cat_face">😿</span><span class="intercom-emoji-picker-emoji" title="joy_cat">😹</span><span class="intercom-emoji-picker-emoji" title="pouting_cat">😾</span><span class="intercom-emoji-picker-emoji" title="japanese_ogre">👹</span><span class="intercom-emoji-picker-emoji" title="japanese_goblin">👺</span><span class="intercom-emoji-picker-emoji" title="see_no_evil">🙈</span><span class="intercom-emoji-picker-emoji" title="hear_no_evil">🙉</span><span class="intercom-emoji-picker-emoji" title="speak_no_evil">🙊</span><span class="intercom-emoji-picker-emoji" title="skull">💀</span><span class="intercom-emoji-picker-emoji" title="alien">👽</span><span class="intercom-emoji-picker-emoji" title="hankey">💩</span><span class="intercom-emoji-picker-emoji" title="fire">🔥</span><span class="intercom-emoji-picker-emoji" title="sparkles">✨</span><span class="intercom-emoji-picker-emoji" title="star2">🌟</span><span class="intercom-emoji-picker-emoji" title="dizzy">💫</span><span class="intercom-emoji-picker-emoji" title="boom">💥</span><span class="intercom-emoji-picker-emoji" title="anger">💢</span><span class="intercom-emoji-picker-emoji" title="sweat_drops">💦</span><span class="intercom-emoji-picker-emoji" title="droplet">💧</span><span class="intercom-emoji-picker-emoji" title="zzz">💤</span><span class="intercom-emoji-picker-emoji" title="dash">💨</span><span class="intercom-emoji-picker-emoji" title="ear">👂</span><span class="intercom-emoji-picker-emoji" title="eyes">👀</span><span class="intercom-emoji-picker-emoji" title="nose">👃</span><span class="intercom-emoji-picker-emoji" title="tongue">👅</span><span class="intercom-emoji-picker-emoji" title="lips">👄</span><span class="intercom-emoji-picker-emoji" title="thumbs_up">👍</span><span class="intercom-emoji-picker-emoji" title="-1">👎</span><span class="intercom-emoji-picker-emoji" title="ok_hand">👌</span><span class="intercom-emoji-picker-emoji" title="facepunch">👊</span><span class="intercom-emoji-picker-emoji" title="fist">✊</span><span class="intercom-emoji-picker-emoji" title="wave">👋</span><span class="intercom-emoji-picker-emoji" title="hand">✋</span><span class="intercom-emoji-picker-emoji" title="open_hands">👐</span><span class="intercom-emoji-picker-emoji" title="point_up_2">👆</span><span class="intercom-emoji-picker-emoji" title="point_down">👇</span><span class="intercom-emoji-picker-emoji" title="point_right">👉</span><span class="intercom-emoji-picker-emoji" title="point_left">👈</span><span class="intercom-emoji-picker-emoji" title="raised_hands">🙌</span><span class="intercom-emoji-picker-emoji" title="pray">🙏</span><span class="intercom-emoji-picker-emoji" title="clap">👏</span><span class="intercom-emoji-picker-emoji" title="muscle">💪</span><span class="intercom-emoji-picker-emoji" title="walking">🚶</span><span class="intercom-emoji-picker-emoji" title="runner">🏃</span><span class="intercom-emoji-picker-emoji" title="dancer">💃</span><span class="intercom-emoji-picker-emoji" title="couple">👫</span><span class="intercom-emoji-picker-emoji" title="family">👪</span><span class="intercom-emoji-picker-emoji" title="couplekiss">💏</span><span class="intercom-emoji-picker-emoji" title="couple_with_heart">💑</span><span class="intercom-emoji-picker-emoji" title="dancers">👯</span><span class="intercom-emoji-picker-emoji" title="ok_woman">🙆</span><span class="intercom-emoji-picker-emoji" title="no_good">🙅</span><span class="intercom-emoji-picker-emoji" title="information_desk_person">💁</span><span class="intercom-emoji-picker-emoji" title="raising_hand">🙋</span><span class="intercom-emoji-picker-emoji" title="massage">💆</span><span class="intercom-emoji-picker-emoji" title="haircut">💇</span><span class="intercom-emoji-picker-emoji" title="nail_care">💅</span><span class="intercom-emoji-picker-emoji" title="bride_with_veil">👰</span><span class="intercom-emoji-picker-emoji" title="person_with_pouting_face">🙎</span><span class="intercom-emoji-picker-emoji" title="person_frowning">🙍</span><span class="intercom-emoji-picker-emoji" title="bow">🙇</span><span class="intercom-emoji-picker-emoji" title="tophat">🎩</span><span class="intercom-emoji-picker-emoji" title="crown">👑</span><span class="intercom-emoji-picker-emoji" title="womans_hat">👒</span><span class="intercom-emoji-picker-emoji" title="athletic_shoe">👟</span><span class="intercom-emoji-picker-emoji" title="mans_shoe">👞</span><span class="intercom-emoji-picker-emoji" title="sandal">👡</span><span class="intercom-emoji-picker-emoji" title="high_heel">👠</span><span class="intercom-emoji-picker-emoji" title="boot">👢</span><span class="intercom-emoji-picker-emoji" title="shirt">👕</span><span class="intercom-emoji-picker-emoji" title="necktie">👔</span><span class="intercom-emoji-picker-emoji" title="womans_clothes">👚</span><span class="intercom-emoji-picker-emoji" title="dress">👗</span><span class="intercom-emoji-picker-emoji" title="running_shirt_with_sash">🎽</span><span class="intercom-emoji-picker-emoji" title="jeans">👖</span><span class="intercom-emoji-picker-emoji" title="kimono">👘</span><span class="intercom-emoji-picker-emoji" title="bikini">👙</span><span class="intercom-emoji-picker-emoji" title="briefcase">💼</span><span class="intercom-emoji-picker-emoji" title="handbag">👜</span><span class="intercom-emoji-picker-emoji" title="pouch">👝</span><span class="intercom-emoji-picker-emoji" title="purse">👛</span><span class="intercom-emoji-picker-emoji" title="eyeglasses">👓</span><span class="intercom-emoji-picker-emoji" title="ribbon">🎀</span><span class="intercom-emoji-picker-emoji" title="closed_umbrella">🌂</span><span class="intercom-emoji-picker-emoji" title="lipstick">💄</span><span class="intercom-emoji-picker-emoji" title="yellow_heart">💛</span><span class="intercom-emoji-picker-emoji" title="blue_heart">💙</span><span class="intercom-emoji-picker-emoji" title="purple_heart">💜</span><span class="intercom-emoji-picker-emoji" title="green_heart">💚</span><span class="intercom-emoji-picker-emoji" title="broken_heart">💔</span><span class="intercom-emoji-picker-emoji" title="heartpulse">💗</span><span class="intercom-emoji-picker-emoji" title="heartbeat">💓</span><span class="intercom-emoji-picker-emoji" title="two_hearts">💕</span><span class="intercom-emoji-picker-emoji" title="sparkling_heart">💖</span><span class="intercom-emoji-picker-emoji" title="revolving_hearts">💞</span><span class="intercom-emoji-picker-emoji" title="cupid">💘</span><span class="intercom-emoji-picker-emoji" title="love_letter">💌</span><span class="intercom-emoji-picker-emoji" title="kiss">💋</span><span class="intercom-emoji-picker-emoji" title="ring">💍</span><span class="intercom-emoji-picker-emoji" title="gem">💎</span><span class="intercom-emoji-picker-emoji" title="bust_in_silhouette">👤</span><span class="intercom-emoji-picker-emoji" title="speech_balloon">💬</span><span class="intercom-emoji-picker-emoji" title="footprints">👣</span>
                                            </div>
                                            <div class="intercom-emoji-picker-group">
                                                <div class="intercom-emoji-picker-group-title">Animales y naturaleza</div><span class="intercom-emoji-picker-emoji" title="dog">🐶</span><span class="intercom-emoji-picker-emoji" title="wolf">🐺</span><span class="intercom-emoji-picker-emoji" title="cat">🐱</span><span class="intercom-emoji-picker-emoji" title="mouse">🐭</span><span class="intercom-emoji-picker-emoji" title="hamster">🐹</span><span class="intercom-emoji-picker-emoji" title="rabbit">🐰</span><span class="intercom-emoji-picker-emoji" title="frog">🐸</span><span class="intercom-emoji-picker-emoji" title="tiger">🐯</span><span class="intercom-emoji-picker-emoji" title="koala">🐨</span><span class="intercom-emoji-picker-emoji" title="bear">🐻</span><span class="intercom-emoji-picker-emoji" title="pig">🐷</span><span class="intercom-emoji-picker-emoji" title="pig_nose">🐽</span><span class="intercom-emoji-picker-emoji" title="cow">🐮</span><span class="intercom-emoji-picker-emoji" title="boar">🐗</span><span class="intercom-emoji-picker-emoji" title="monkey_face">🐵</span><span class="intercom-emoji-picker-emoji" title="monkey">🐒</span><span class="intercom-emoji-picker-emoji" title="horse">🐴</span><span class="intercom-emoji-picker-emoji" title="sheep">🐑</span><span class="intercom-emoji-picker-emoji" title="elephant">🐘</span><span class="intercom-emoji-picker-emoji" title="panda_face">🐼</span><span class="intercom-emoji-picker-emoji" title="penguin">🐧</span><span class="intercom-emoji-picker-emoji" title="bird">🐦</span><span class="intercom-emoji-picker-emoji" title="baby_chick">🐤</span><span class="intercom-emoji-picker-emoji" title="hatched_chick">🐥</span><span class="intercom-emoji-picker-emoji" title="hatching_chick">🐣</span><span class="intercom-emoji-picker-emoji" title="chicken">🐔</span><span class="intercom-emoji-picker-emoji" title="snake">🐍</span><span class="intercom-emoji-picker-emoji" title="turtle">🐢</span><span class="intercom-emoji-picker-emoji" title="bug">🐛</span><span class="intercom-emoji-picker-emoji" title="bee">🐝</span><span class="intercom-emoji-picker-emoji" title="ant">🐜</span><span class="intercom-emoji-picker-emoji" title="beetle">🐞</span><span class="intercom-emoji-picker-emoji" title="snail">🐌</span><span class="intercom-emoji-picker-emoji" title="octopus">🐙</span><span class="intercom-emoji-picker-emoji" title="shell">🐚</span><span class="intercom-emoji-picker-emoji" title="tropical_fish">🐠</span><span class="intercom-emoji-picker-emoji" title="fish">🐟</span><span class="intercom-emoji-picker-emoji" title="dolphin">🐬</span><span class="intercom-emoji-picker-emoji" title="whale">🐳</span><span class="intercom-emoji-picker-emoji" title="racehorse">🐎</span><span class="intercom-emoji-picker-emoji" title="dragon_face">🐲</span><span class="intercom-emoji-picker-emoji" title="blowfish">🐡</span><span class="intercom-emoji-picker-emoji" title="camel">🐫</span><span class="intercom-emoji-picker-emoji" title="poodle">🐩</span><span class="intercom-emoji-picker-emoji" title="feet">🐾</span><span class="intercom-emoji-picker-emoji" title="bouquet">💐</span><span class="intercom-emoji-picker-emoji" title="cherry_blossom">🌸</span><span class="intercom-emoji-picker-emoji" title="tulip">🌷</span><span class="intercom-emoji-picker-emoji" title="four_leaf_clover">🍀</span><span class="intercom-emoji-picker-emoji" title="rose">🌹</span><span class="intercom-emoji-picker-emoji" title="sunflower">🌻</span><span class="intercom-emoji-picker-emoji" title="hibiscus">🌺</span><span class="intercom-emoji-picker-emoji" title="maple_leaf">🍁</span><span class="intercom-emoji-picker-emoji" title="leaves">🍃</span><span class="intercom-emoji-picker-emoji" title="fallen_leaf">🍂</span><span class="intercom-emoji-picker-emoji" title="herb">🌿</span><span class="intercom-emoji-picker-emoji" title="ear_of_rice">🌾</span><span class="intercom-emoji-picker-emoji" title="mushroom">🍄</span><span class="intercom-emoji-picker-emoji" title="cactus">🌵</span><span class="intercom-emoji-picker-emoji" title="palm_tree">🌴</span><span class="intercom-emoji-picker-emoji" title="chestnut">🌰</span><span class="intercom-emoji-picker-emoji" title="seedling">🌱</span><span class="intercom-emoji-picker-emoji" title="blossom">🌼</span><span class="intercom-emoji-picker-emoji" title="new_moon">🌑</span><span class="intercom-emoji-picker-emoji" title="first_quarter_moon">🌓</span><span class="intercom-emoji-picker-emoji" title="moon">🌔</span><span class="intercom-emoji-picker-emoji" title="full_moon">🌕</span><span class="intercom-emoji-picker-emoji" title="first_quarter_moon_with_face">🌛</span><span class="intercom-emoji-picker-emoji" title="crescent_moon">🌙</span><span class="intercom-emoji-picker-emoji" title="earth_asia">🌏</span><span class="intercom-emoji-picker-emoji" title="volcano">🌋</span><span class="intercom-emoji-picker-emoji" title="milky_way">🌌</span><span class="intercom-emoji-picker-emoji" title="stars">🌠</span><span class="intercom-emoji-picker-emoji" title="partly_sunny">⛅</span><span class="intercom-emoji-picker-emoji" title="snowman">⛄</span><span class="intercom-emoji-picker-emoji" title="cyclone">🌀</span><span class="intercom-emoji-picker-emoji" title="foggy">🌁</span><span class="intercom-emoji-picker-emoji" title="rainbow">🌈</span><span class="intercom-emoji-picker-emoji" title="ocean">🌊</span>
                                            </div>
                                            <div class="intercom-emoji-picker-group">
                                                <div class="intercom-emoji-picker-group-title">Objetos</div><span class="intercom-emoji-picker-emoji" title="bamboo">🎍</span><span class="intercom-emoji-picker-emoji" title="gift_heart">💝</span><span class="intercom-emoji-picker-emoji" title="dolls">🎎</span><span class="intercom-emoji-picker-emoji" title="school_satchel">🎒</span><span class="intercom-emoji-picker-emoji" title="mortar_board">🎓</span><span class="intercom-emoji-picker-emoji" title="flags">🎏</span><span class="intercom-emoji-picker-emoji" title="fireworks">🎆</span><span class="intercom-emoji-picker-emoji" title="sparkler">🎇</span><span class="intercom-emoji-picker-emoji" title="wind_chime">🎐</span><span class="intercom-emoji-picker-emoji" title="rice_scene">🎑</span><span class="intercom-emoji-picker-emoji" title="jack_o_lantern">🎃</span><span class="intercom-emoji-picker-emoji" title="ghost">👻</span><span class="intercom-emoji-picker-emoji" title="santa">🎅</span><span class="intercom-emoji-picker-emoji" title="christmas_tree">🎄</span><span class="intercom-emoji-picker-emoji" title="gift">🎁</span><span class="intercom-emoji-picker-emoji" title="tanabata_tree">🎋</span><span class="intercom-emoji-picker-emoji" title="tada">🎉</span><span class="intercom-emoji-picker-emoji" title="confetti_ball">🎊</span><span class="intercom-emoji-picker-emoji" title="balloon">🎈</span><span class="intercom-emoji-picker-emoji" title="crossed_flags">🎌</span><span class="intercom-emoji-picker-emoji" title="crystal_ball">🔮</span><span class="intercom-emoji-picker-emoji" title="movie_camera">🎥</span><span class="intercom-emoji-picker-emoji" title="camera">📷</span><span class="intercom-emoji-picker-emoji" title="video_camera">📹</span><span class="intercom-emoji-picker-emoji" title="vhs">📼</span><span class="intercom-emoji-picker-emoji" title="cd">💿</span><span class="intercom-emoji-picker-emoji" title="dvd">📀</span><span class="intercom-emoji-picker-emoji" title="minidisc">💽</span><span class="intercom-emoji-picker-emoji" title="floppy_disk">💾</span><span class="intercom-emoji-picker-emoji" title="computer">💻</span><span class="intercom-emoji-picker-emoji" title="iphone">📱</span><span class="intercom-emoji-picker-emoji" title="telephone_receiver">📞</span><span class="intercom-emoji-picker-emoji" title="pager">📟</span><span class="intercom-emoji-picker-emoji" title="fax">📠</span><span class="intercom-emoji-picker-emoji" title="satellite">📡</span><span class="intercom-emoji-picker-emoji" title="tv">📺</span><span class="intercom-emoji-picker-emoji" title="radio">📻</span><span class="intercom-emoji-picker-emoji" title="loud_sound">🔊</span><span class="intercom-emoji-picker-emoji" title="bell">🔔</span><span class="intercom-emoji-picker-emoji" title="loudspeaker">📢</span><span class="intercom-emoji-picker-emoji" title="mega">📣</span><span class="intercom-emoji-picker-emoji" title="hourglass_flowing_sand">⏳</span><span class="intercom-emoji-picker-emoji" title="hourglass">⌛</span><span class="intercom-emoji-picker-emoji" title="alarm_clock">⏰</span><span class="intercom-emoji-picker-emoji" title="watch">⌚</span><span class="intercom-emoji-picker-emoji" title="unlock">🔓</span><span class="intercom-emoji-picker-emoji" title="lock">🔒</span><span class="intercom-emoji-picker-emoji" title="lock_with_ink_pen">🔏</span><span class="intercom-emoji-picker-emoji" title="closed_lock_with_key">🔐</span><span class="intercom-emoji-picker-emoji" title="key">🔑</span><span class="intercom-emoji-picker-emoji" title="mag_right">🔎</span><span class="intercom-emoji-picker-emoji" title="bulb">💡</span><span class="intercom-emoji-picker-emoji" title="flashlight">🔦</span><span class="intercom-emoji-picker-emoji" title="electric_plug">🔌</span><span class="intercom-emoji-picker-emoji" title="battery">🔋</span><span class="intercom-emoji-picker-emoji" title="mag">🔍</span><span class="intercom-emoji-picker-emoji" title="bath">🛀</span><span class="intercom-emoji-picker-emoji" title="toilet">🚽</span><span class="intercom-emoji-picker-emoji" title="wrench">🔧</span><span class="intercom-emoji-picker-emoji" title="nut_and_bolt">🔩</span><span class="intercom-emoji-picker-emoji" title="hammer">🔨</span><span class="intercom-emoji-picker-emoji" title="door">🚪</span><span class="intercom-emoji-picker-emoji" title="smoking">🚬</span><span class="intercom-emoji-picker-emoji" title="bomb">💣</span><span class="intercom-emoji-picker-emoji" title="gun">🔫</span><span class="intercom-emoji-picker-emoji" title="hocho">🔪</span><span class="intercom-emoji-picker-emoji" title="pill">💊</span><span class="intercom-emoji-picker-emoji" title="syringe">💉</span><span class="intercom-emoji-picker-emoji" title="moneybag">💰</span><span class="intercom-emoji-picker-emoji" title="yen">💴</span><span class="intercom-emoji-picker-emoji" title="dollar">💵</span><span class="intercom-emoji-picker-emoji" title="credit_card">💳</span><span class="intercom-emoji-picker-emoji" title="money_with_wings">💸</span><span class="intercom-emoji-picker-emoji" title="calling">📲</span><span class="intercom-emoji-picker-emoji" title="e-mail">📧</span><span class="intercom-emoji-picker-emoji" title="inbox_tray">📥</span><span class="intercom-emoji-picker-emoji" title="outbox_tray">📤</span><span class="intercom-emoji-picker-emoji" title="envelope_with_arrow">📩</span><span class="intercom-emoji-picker-emoji" title="incoming_envelope">📨</span><span class="intercom-emoji-picker-emoji" title="mailbox">📫</span><span class="intercom-emoji-picker-emoji" title="mailbox_closed">📪</span><span class="intercom-emoji-picker-emoji" title="postbox">📮</span><span class="intercom-emoji-picker-emoji" title="package">📦</span><span class="intercom-emoji-picker-emoji" title="memo">📝</span><span class="intercom-emoji-picker-emoji" title="page_facing_up">📄</span><span class="intercom-emoji-picker-emoji" title="page_with_curl">📃</span><span class="intercom-emoji-picker-emoji" title="bookmark_tabs">📑</span><span class="intercom-emoji-picker-emoji" title="bar_chart">📊</span><span class="intercom-emoji-picker-emoji" title="chart_with_upwards_trend">📈</span><span class="intercom-emoji-picker-emoji" title="chart_with_downwards_trend">📉</span><span class="intercom-emoji-picker-emoji" title="scroll">📜</span><span class="intercom-emoji-picker-emoji" title="clipboard">📋</span><span class="intercom-emoji-picker-emoji" title="date">📅</span><span class="intercom-emoji-picker-emoji" title="calendar">📆</span><span class="intercom-emoji-picker-emoji" title="card_index">📇</span><span class="intercom-emoji-picker-emoji" title="file_folder">📁</span><span class="intercom-emoji-picker-emoji" title="open_file_folder">📂</span><span class="intercom-emoji-picker-emoji" title="pushpin">📌</span><span class="intercom-emoji-picker-emoji" title="paperclip">📎</span><span class="intercom-emoji-picker-emoji" title="straight_ruler">📏</span><span class="intercom-emoji-picker-emoji" title="triangular_ruler">📐</span><span class="intercom-emoji-picker-emoji" title="closed_book">📕</span><span class="intercom-emoji-picker-emoji" title="green_book">📗</span><span class="intercom-emoji-picker-emoji" title="blue_book">📘</span><span class="intercom-emoji-picker-emoji" title="orange_book">📙</span><span class="intercom-emoji-picker-emoji" title="notebook">📓</span><span class="intercom-emoji-picker-emoji" title="notebook_with_decorative_cover">📔</span><span class="intercom-emoji-picker-emoji" title="ledger">📒</span><span class="intercom-emoji-picker-emoji" title="books">📚</span><span class="intercom-emoji-picker-emoji" title="book">📖</span><span class="intercom-emoji-picker-emoji" title="bookmark">🔖</span><span class="intercom-emoji-picker-emoji" title="name_badge">📛</span><span class="intercom-emoji-picker-emoji" title="newspaper">📰</span><span class="intercom-emoji-picker-emoji" title="art">🎨</span><span class="intercom-emoji-picker-emoji" title="clapper">🎬</span><span class="intercom-emoji-picker-emoji" title="microphone">🎤</span><span class="intercom-emoji-picker-emoji" title="headphones">🎧</span><span class="intercom-emoji-picker-emoji" title="musical_score">🎼</span><span class="intercom-emoji-picker-emoji" title="musical_note">🎵</span><span class="intercom-emoji-picker-emoji" title="notes">🎶</span><span class="intercom-emoji-picker-emoji" title="musical_keyboard">🎹</span><span class="intercom-emoji-picker-emoji" title="violin">🎻</span><span class="intercom-emoji-picker-emoji" title="trumpet">🎺</span><span class="intercom-emoji-picker-emoji" title="saxophone">🎷</span><span class="intercom-emoji-picker-emoji" title="guitar">🎸</span><span class="intercom-emoji-picker-emoji" title="space_invader">👾</span><span class="intercom-emoji-picker-emoji" title="video_game">🎮</span><span class="intercom-emoji-picker-emoji" title="black_joker">🃏</span><span class="intercom-emoji-picker-emoji" title="flower_playing_cards">🎴</span><span class="intercom-emoji-picker-emoji" title="mahjong">🀄</span><span class="intercom-emoji-picker-emoji" title="game_die">🎲</span><span class="intercom-emoji-picker-emoji" title="dart">🎯</span><span class="intercom-emoji-picker-emoji" title="football">🏈</span><span class="intercom-emoji-picker-emoji" title="basketball">🏀</span><span class="intercom-emoji-picker-emoji" title="soccer">⚽</span><span class="intercom-emoji-picker-emoji" title="baseball">⚾</span><span class="intercom-emoji-picker-emoji" title="tennis">🎾</span><span class="intercom-emoji-picker-emoji" title="8ball">🎱</span><span class="intercom-emoji-picker-emoji" title="bowling">🎳</span><span class="intercom-emoji-picker-emoji" title="golf">⛳</span><span class="intercom-emoji-picker-emoji" title="checkered_flag">🏁</span><span class="intercom-emoji-picker-emoji" title="trophy">🏆</span><span class="intercom-emoji-picker-emoji" title="ski">🎿</span><span class="intercom-emoji-picker-emoji" title="snowboarder">🏂</span><span class="intercom-emoji-picker-emoji" title="swimmer">🏊</span><span class="intercom-emoji-picker-emoji" title="surfer">🏄</span><span class="intercom-emoji-picker-emoji" title="fishing_pole_and_fish">🎣</span><span class="intercom-emoji-picker-emoji" title="tea">🍵</span><span class="intercom-emoji-picker-emoji" title="sake">🍶</span><span class="intercom-emoji-picker-emoji" title="beer">🍺</span><span class="intercom-emoji-picker-emoji" title="beers">🍻</span><span class="intercom-emoji-picker-emoji" title="cocktail">🍸</span><span class="intercom-emoji-picker-emoji" title="tropical_drink">🍹</span><span class="intercom-emoji-picker-emoji" title="wine_glass">🍷</span><span class="intercom-emoji-picker-emoji" title="fork_and_knife">🍴</span><span class="intercom-emoji-picker-emoji" title="pizza">🍕</span><span class="intercom-emoji-picker-emoji" title="hamburger">🍔</span><span class="intercom-emoji-picker-emoji" title="fries">🍟</span><span class="intercom-emoji-picker-emoji" title="poultry_leg">🍗</span><span class="intercom-emoji-picker-emoji" title="meat_on_bone">🍖</span><span class="intercom-emoji-picker-emoji" title="spaghetti">🍝</span><span class="intercom-emoji-picker-emoji" title="curry">🍛</span><span class="intercom-emoji-picker-emoji" title="fried_shrimp">🍤</span><span class="intercom-emoji-picker-emoji" title="bento">🍱</span><span class="intercom-emoji-picker-emoji" title="sushi">🍣</span><span class="intercom-emoji-picker-emoji" title="fish_cake">🍥</span><span class="intercom-emoji-picker-emoji" title="rice_ball">🍙</span><span class="intercom-emoji-picker-emoji" title="rice_cracker">🍘</span><span class="intercom-emoji-picker-emoji" title="rice">🍚</span><span class="intercom-emoji-picker-emoji" title="ramen">🍜</span><span class="intercom-emoji-picker-emoji" title="stew">🍲</span><span class="intercom-emoji-picker-emoji" title="oden">🍢</span><span class="intercom-emoji-picker-emoji" title="dango">🍡</span><span class="intercom-emoji-picker-emoji" title="egg">🍳</span><span class="intercom-emoji-picker-emoji" title="bread">🍞</span><span class="intercom-emoji-picker-emoji" title="doughnut">🍩</span><span class="intercom-emoji-picker-emoji" title="custard">🍮</span><span class="intercom-emoji-picker-emoji" title="icecream">🍦</span><span class="intercom-emoji-picker-emoji" title="ice_cream">🍨</span><span class="intercom-emoji-picker-emoji" title="shaved_ice">🍧</span><span class="intercom-emoji-picker-emoji" title="birthday">🎂</span><span class="intercom-emoji-picker-emoji" title="cake">🍰</span><span class="intercom-emoji-picker-emoji" title="cookie">🍪</span><span class="intercom-emoji-picker-emoji" title="chocolate_bar">🍫</span><span class="intercom-emoji-picker-emoji" title="candy">🍬</span><span class="intercom-emoji-picker-emoji" title="lollipop">🍭</span><span class="intercom-emoji-picker-emoji" title="honey_pot">🍯</span><span class="intercom-emoji-picker-emoji" title="apple">🍎</span><span class="intercom-emoji-picker-emoji" title="green_apple">🍏</span><span class="intercom-emoji-picker-emoji" title="tangerine">🍊</span><span class="intercom-emoji-picker-emoji" title="cherries">🍒</span><span class="intercom-emoji-picker-emoji" title="grapes">🍇</span><span class="intercom-emoji-picker-emoji" title="watermelon">🍉</span><span class="intercom-emoji-picker-emoji" title="strawberry">🍓</span><span class="intercom-emoji-picker-emoji" title="peach">🍑</span><span class="intercom-emoji-picker-emoji" title="melon">🍈</span><span class="intercom-emoji-picker-emoji" title="banana">🍌</span><span class="intercom-emoji-picker-emoji" title="pineapple">🍍</span><span class="intercom-emoji-picker-emoji" title="sweet_potato">🍠</span><span class="intercom-emoji-picker-emoji" title="eggplant">🍆</span><span class="intercom-emoji-picker-emoji" title="tomato">🍅</span><span class="intercom-emoji-picker-emoji" title="corn">🌽</span>
                                            </div>
                                            <div class="intercom-emoji-picker-group">
                                                <div class="intercom-emoji-picker-group-title">Viajes y lugares</div><span class="intercom-emoji-picker-emoji" title="house">🏠</span><span class="intercom-emoji-picker-emoji" title="house_with_garden">🏡</span><span class="intercom-emoji-picker-emoji" title="school">🏫</span><span class="intercom-emoji-picker-emoji" title="office">🏢</span><span class="intercom-emoji-picker-emoji" title="post_office">🏣</span><span class="intercom-emoji-picker-emoji" title="hospital">🏥</span><span class="intercom-emoji-picker-emoji" title="bank">🏦</span><span class="intercom-emoji-picker-emoji" title="convenience_store">🏪</span><span class="intercom-emoji-picker-emoji" title="love_hotel">🏩</span><span class="intercom-emoji-picker-emoji" title="hotel">🏨</span><span class="intercom-emoji-picker-emoji" title="wedding">💒</span><span class="intercom-emoji-picker-emoji" title="church">⛪</span><span class="intercom-emoji-picker-emoji" title="department_store">🏬</span><span class="intercom-emoji-picker-emoji" title="city_sunrise">🌇</span><span class="intercom-emoji-picker-emoji" title="city_sunset">🌆</span><span class="intercom-emoji-picker-emoji" title="japanese_castle">🏯</span><span class="intercom-emoji-picker-emoji" title="european_castle">🏰</span><span class="intercom-emoji-picker-emoji" title="tent">⛺</span><span class="intercom-emoji-picker-emoji" title="factory">🏭</span><span class="intercom-emoji-picker-emoji" title="tokyo_tower">🗼</span><span class="intercom-emoji-picker-emoji" title="japan">🗾</span><span class="intercom-emoji-picker-emoji" title="mount_fuji">🗻</span><span class="intercom-emoji-picker-emoji" title="sunrise_over_mountains">🌄</span><span class="intercom-emoji-picker-emoji" title="sunrise">🌅</span><span class="intercom-emoji-picker-emoji" title="night_with_stars">🌃</span><span class="intercom-emoji-picker-emoji" title="statue_of_liberty">🗽</span><span class="intercom-emoji-picker-emoji" title="bridge_at_night">🌉</span><span class="intercom-emoji-picker-emoji" title="carousel_horse">🎠</span><span class="intercom-emoji-picker-emoji" title="ferris_wheel">🎡</span><span class="intercom-emoji-picker-emoji" title="fountain">⛲</span><span class="intercom-emoji-picker-emoji" title="roller_coaster">🎢</span><span class="intercom-emoji-picker-emoji" title="ship">🚢</span><span class="intercom-emoji-picker-emoji" title="boat">⛵</span><span class="intercom-emoji-picker-emoji" title="speedboat">🚤</span><span class="intercom-emoji-picker-emoji" title="rocket">🚀</span><span class="intercom-emoji-picker-emoji" title="seat">💺</span><span class="intercom-emoji-picker-emoji" title="station">🚉</span><span class="intercom-emoji-picker-emoji" title="bullettrain_side">🚄</span><span class="intercom-emoji-picker-emoji" title="bullettrain_front">🚅</span><span class="intercom-emoji-picker-emoji" title="metro">🚇</span><span class="intercom-emoji-picker-emoji" title="railway_car">🚃</span><span class="intercom-emoji-picker-emoji" title="bus">🚌</span><span class="intercom-emoji-picker-emoji" title="blue_car">🚙</span><span class="intercom-emoji-picker-emoji" title="car">🚗</span><span class="intercom-emoji-picker-emoji" title="taxi">🚕</span><span class="intercom-emoji-picker-emoji" title="truck">🚚</span><span class="intercom-emoji-picker-emoji" title="rotating_light">🚨</span><span class="intercom-emoji-picker-emoji" title="police_car">🚓</span><span class="intercom-emoji-picker-emoji" title="fire_engine">🚒</span><span class="intercom-emoji-picker-emoji" title="ambulance">🚑</span><span class="intercom-emoji-picker-emoji" title="bike">🚲</span><span class="intercom-emoji-picker-emoji" title="barber">💈</span><span class="intercom-emoji-picker-emoji" title="busstop">🚏</span><span class="intercom-emoji-picker-emoji" title="ticket">🎫</span><span class="intercom-emoji-picker-emoji" title="traffic_light">🚥</span><span class="intercom-emoji-picker-emoji" title="construction">🚧</span><span class="intercom-emoji-picker-emoji" title="beginner">🔰</span><span class="intercom-emoji-picker-emoji" title="fuelpump">⛽</span><span class="intercom-emoji-picker-emoji" title="izakaya_lantern">🏮</span><span class="intercom-emoji-picker-emoji" title="slot_machine">🎰</span><span class="intercom-emoji-picker-emoji" title="moyai">🗿</span><span class="intercom-emoji-picker-emoji" title="circus_tent">🎪</span><span class="intercom-emoji-picker-emoji" title="performing_arts">🎭</span><span class="intercom-emoji-picker-emoji" title="round_pushpin">📍</span><span class="intercom-emoji-picker-emoji" title="triangular_flag_on_post">🚩</span>
                                            </div>
                                            <div class="intercom-emoji-picker-group">
                                                <div class="intercom-emoji-picker-group-title">Simbolos</div><span class="intercom-emoji-picker-emoji" title="keycap_ten">🔟</span><span class="intercom-emoji-picker-emoji" title="1234">🔢</span><span class="intercom-emoji-picker-emoji" title="symbols">🔣</span><span class="intercom-emoji-picker-emoji" title="capital_abcd">🔠</span><span class="intercom-emoji-picker-emoji" title="abcd">🔡</span><span class="intercom-emoji-picker-emoji" title="abc">🔤</span><span class="intercom-emoji-picker-emoji" title="arrow_up_small">🔼</span><span class="intercom-emoji-picker-emoji" title="arrow_down_small">🔽</span><span class="intercom-emoji-picker-emoji" title="rewind">⏪</span><span class="intercom-emoji-picker-emoji" title="fast_forward">⏩</span><span class="intercom-emoji-picker-emoji" title="arrow_double_up">⏫</span><span class="intercom-emoji-picker-emoji" title="arrow_double_down">⏬</span><span class="intercom-emoji-picker-emoji" title="ok">🆗</span><span class="intercom-emoji-picker-emoji" title="new">🆕</span><span class="intercom-emoji-picker-emoji" title="up">🆙</span><span class="intercom-emoji-picker-emoji" title="cool">🆒</span><span class="intercom-emoji-picker-emoji" title="free">🆓</span><span class="intercom-emoji-picker-emoji" title="ng">🆖</span><span class="intercom-emoji-picker-emoji" title="signal_strength">📶</span><span class="intercom-emoji-picker-emoji" title="cinema">🎦</span><span class="intercom-emoji-picker-emoji" title="koko">🈁</span><span class="intercom-emoji-picker-emoji" title="u6307">🈯</span><span class="intercom-emoji-picker-emoji" title="u7a7a">🈳</span><span class="intercom-emoji-picker-emoji" title="u6e80">🈵</span><span class="intercom-emoji-picker-emoji" title="u5408">🈴</span><span class="intercom-emoji-picker-emoji" title="u7981">🈲</span><span class="intercom-emoji-picker-emoji" title="ideograph_advantage">🉐</span><span class="intercom-emoji-picker-emoji" title="u5272">🈹</span><span class="intercom-emoji-picker-emoji" title="u55b6">🈺</span><span class="intercom-emoji-picker-emoji" title="u6709">🈶</span><span class="intercom-emoji-picker-emoji" title="u7121">🈚</span><span class="intercom-emoji-picker-emoji" title="restroom">🚻</span><span class="intercom-emoji-picker-emoji" title="mens">🚹</span><span class="intercom-emoji-picker-emoji" title="womens">🚺</span><span class="intercom-emoji-picker-emoji" title="baby_symbol">🚼</span><span class="intercom-emoji-picker-emoji" title="wc">🚾</span><span class="intercom-emoji-picker-emoji" title="no_smoking">🚭</span><span class="intercom-emoji-picker-emoji" title="u7533">🈸</span><span class="intercom-emoji-picker-emoji" title="accept">🉑</span><span class="intercom-emoji-picker-emoji" title="cl">🆑</span><span class="intercom-emoji-picker-emoji" title="sos">🆘</span><span class="intercom-emoji-picker-emoji" title="id">🆔</span><span class="intercom-emoji-picker-emoji" title="no_entry_sign">🚫</span><span class="intercom-emoji-picker-emoji" title="underage">🔞</span><span class="intercom-emoji-picker-emoji" title="no_entry">⛔</span><span class="intercom-emoji-picker-emoji" title="negative_squared_cross_mark">❎</span><span class="intercom-emoji-picker-emoji" title="white_check_mark">✅</span><span class="intercom-emoji-picker-emoji" title="heart_decoration">💟</span><span class="intercom-emoji-picker-emoji" title="vs">🆚</span><span class="intercom-emoji-picker-emoji" title="vibration_mode">📳</span><span class="intercom-emoji-picker-emoji" title="mobile_phone_off">📴</span><span class="intercom-emoji-picker-emoji" title="ab">🆎</span><span class="intercom-emoji-picker-emoji" title="diamond_shape_with_a_dot_inside">💠</span><span class="intercom-emoji-picker-emoji" title="ophiuchus">⛎</span><span class="intercom-emoji-picker-emoji" title="six_pointed_star">🔯</span><span class="intercom-emoji-picker-emoji" title="atm">🏧</span><span class="intercom-emoji-picker-emoji" title="chart">💹</span><span class="intercom-emoji-picker-emoji" title="heavy_dollar_sign">💲</span><span class="intercom-emoji-picker-emoji" title="currency_exchange">💱</span><span class="intercom-emoji-picker-emoji" title="x">❌</span><span class="intercom-emoji-picker-emoji" title="exclamation">❗</span><span class="intercom-emoji-picker-emoji" title="question">❓</span><span class="intercom-emoji-picker-emoji" title="grey_exclamation">❕</span><span class="intercom-emoji-picker-emoji" title="grey_question">❔</span><span class="intercom-emoji-picker-emoji" title="o">⭕</span><span class="intercom-emoji-picker-emoji" title="top">🔝</span><span class="intercom-emoji-picker-emoji" title="end">🔚</span><span class="intercom-emoji-picker-emoji" title="back">🔙</span><span class="intercom-emoji-picker-emoji" title="on">🔛</span><span class="intercom-emoji-picker-emoji" title="soon">🔜</span><span class="intercom-emoji-picker-emoji" title="arrows_clockwise">🔃</span><span class="intercom-emoji-picker-emoji" title="clock12">🕛</span><span class="intercom-emoji-picker-emoji" title="clock1">🕐</span><span class="intercom-emoji-picker-emoji" title="clock2">🕑</span><span class="intercom-emoji-picker-emoji" title="clock3">🕒</span><span class="intercom-emoji-picker-emoji" title="clock4">🕓</span><span class="intercom-emoji-picker-emoji" title="clock5">🕔</span><span class="intercom-emoji-picker-emoji" title="clock6">🕕</span><span class="intercom-emoji-picker-emoji" title="clock7">🕖</span><span class="intercom-emoji-picker-emoji" title="clock8">🕗</span><span class="intercom-emoji-picker-emoji" title="clock9">🕘</span><span class="intercom-emoji-picker-emoji" title="clock10">🕙</span><span class="intercom-emoji-picker-emoji" title="clock11">🕚</span><span class="intercom-emoji-picker-emoji" title="heavy_plus_sign">➕</span><span class="intercom-emoji-picker-emoji" title="heavy_minus_sign">➖</span><span class="intercom-emoji-picker-emoji" title="heavy_division_sign">➗</span><span class="intercom-emoji-picker-emoji" title="white_flower">💮</span><span class="intercom-emoji-picker-emoji" title="100">💯</span><span class="intercom-emoji-picker-emoji" title="radio_button">🔘</span><span class="intercom-emoji-picker-emoji" title="link">🔗</span><span class="intercom-emoji-picker-emoji" title="curly_loop">➰</span><span class="intercom-emoji-picker-emoji" title="trident">🔱</span><span class="intercom-emoji-picker-emoji" title="small_red_triangle">🔺</span><span class="intercom-emoji-picker-emoji" title="black_square_button">🔲</span><span class="intercom-emoji-picker-emoji" title="white_square_button">🔳</span><span class="intercom-emoji-picker-emoji" title="red_circle">🔴</span><span class="intercom-emoji-picker-emoji" title="large_blue_circle">🔵</span><span class="intercom-emoji-picker-emoji" title="small_red_triangle_down">🔻</span><span class="intercom-emoji-picker-emoji" title="white_large_square">⬜</span><span class="intercom-emoji-picker-emoji" title="black_large_square">⬛</span><span class="intercom-emoji-picker-emoji" title="large_orange_diamond">🔶</span><span class="intercom-emoji-picker-emoji" title="large_blue_diamond">🔷</span><span class="intercom-emoji-picker-emoji" title="small_orange_diamond">🔸</span><span class="intercom-emoji-picker-emoji" title="small_blue_diamond">🔹</span>
                                            </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                    <div class="intercom-composer-popover-caret"></div>
                                </div>

                                <button type="button" class="btnImg subir-archivo" disabled><i class="fa fa-upload"></i></button>
                                <button class="enviar" id="send_message" disabled><i class="fa fa-paper-plane"></i></button>
                            </div>
                            
                        </form>


                </div>
            </div>
        </div>

        <!-- Modal Boton Opciones -->
        <div class="modal fade" id="modalOpciones" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
            <div class="modal-dialog" role="document">
                <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
                    <h3 class="modal-title w-100 text-center" style="color: white;"><b>OPCIONES</b></h3>
                </div>
                <div class="modal-body">
                    <ul id="body_lista_menu">
                        
                    </ul>
                </div>
                <div class="modal-footer">
                    <!-- <button type="button" class="btn btn-default" data-dismiss="modal">Close</button> -->
                    <button type="button" class="btn btn-primary" data-dismiss="modal">Cerrar</button>
                </div>
                </div>
            </div>
        </div>


    </div>
        <!-- /.col-lg-12 -->
</div>
<div class="modal fade" id="modalImagen" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>ENVIAR ARCHIVO</b></h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">

                <div class="col-md-12">
                    <input class="form-control" type="file" id="archivo" accept="application/vnd.openxmlformats-officedocument.spreadsheetml.sheet, application/msword, image/png, image/jpeg, application/pdf">
                </div>

                <div id="carga" class="col-md-12" style="display: none;">
                <center>
                  <img src="<?php echo base_url();?>public/images/espera.gif" style="width: 60px; height: 60px;">
                  <h2>Cargando...</h2>
                </center>
                </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
                <button type="button" class="subirImagen btn" style="background-color: #2a7ab7; color: white;">
                    <i class="fa-solid fa-paper-plane"></i> Enviar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalReasignar" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>Reasignar conversación</b></h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-12">
                        <label for="">
                            Seleccionar usuario:
                        </label>
                        <select class="form-control" name="usuario_id" id="usuario_id">
                            <option value="">--Seleccionar--</option>
                            <?php
                            if (!is_null($usuarios)) {
                                foreach ($usuarios as $usu) { ?>
                                    <option value="<?=$usu->id_usuario?>"><?=$usu->usuario?></option>
                                <?php
                                }
                            }
                            ?>
                        </select>
                    </div>

                </div>
            </div>
            <input type="hidden" id="cel_reasignar">
            <div class="modal-footer">
            <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
            <button type="button" class="btnReasignar btn" style="background-color: #2a7ab7; color: white;">
            <i class="fa fa-save"></i> Guardar</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="modalVer" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>IMAGEN</b></h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <center>
                            <img class="img-chat" style="max-width: 500px; max-height: 500px;" id="imagen_modal">
                        </center>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<input type="hidden" id="tipo_conversacion" value="Actuales">

<input type="hidden" name="" id="id_firestore_hidden"/>
<input type="hidden" name="" id="celular_hidden"/>

<style>

   .active-tic {
      background: #EEE7E7 !important;
      color: #000000 !important;
    }

    .tic-success{
        background: #c0ffc0;
        color: #F9F5F5;
    }
    .tic-success div.datos-chat h4{
        color:#333333!important;
    }

    .tic-danger{
        background: #dedede;
        color: #F9F5F5;
    }
    .tic-danger div.datos-chat{
        color:#969696;
    }
    .tic-danger div.initial{
        background-color:#969696!important;
    }
    .tic-danger p.usuario span{
        background-color:#969696;
    }


 
 a:hover{text-decoration:none;} a{text-decoration:none;} a{color: #B11E1E;}
    li.selected{
     background: #FF5900;
     color: white;
    }
    li.selected span{
     color: white;   
    }

    li.selected div.ticket p{
    color: white;
    }

    li.selected div.numero-existente {
    background: #e9e9e9;
    color: black;
    transition: ease-in-out .5s;
    }

    .verImgLocation {
        cursor: pointer;
    }

    #message {
        overflow-y: scroll !important;
        z-index: 999999 !important;
    }

    #message:active, 
    #message:focus,
    #message:focus-visible,
    #message:focus-within,
    #message:target { 
        overflow-y: scroll;
        touch-action: manipulation;
        -webkit-overflow-scrolling: touch;
    }

</style>
<script>

var textarea = document.querySelector('textarea');

textarea.addEventListener('keydown', autosize);


             
function autosize(){
  var el = this;
  setTimeout(function(){
    el.style.cssText = 'height:auto; padding:0';
    el.style.cssText = 'height:' + el.scrollHeight + 'px';
  },0);
}            
</script>

<script type="text/javascript" src="<?=base_url();?>public/js/jquery.js"></script>
<script src="<?php echo base_url('public/jquery.dataTables.min.js')?>"></script>
<script src="//cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo base_url('public/dataTables.bootstrap.js')?>"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css">

<!-- FIREBASE -->
<script src="https://www.gstatic.com/firebasejs/7.17.2/firebase.js"></script>	
<script src="https://www.gstatic.com/firebasejs/7.17.2/firebase-auth.js"></script>
<script src="https://www.gstatic.com/firebasejs/7.17.2/firebase-firestore.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.18.1/moment.min.js"></script>
    
<script type="text/javascript">

    var firebaseConfig = {
        apiKey    : "AIzaSyBuNiBTW2QipNlAzizdANaZqfY6iyRJ7sM",
        authDomain: "medina-consultores.firebaseapp.com",
        projectId : "medina-consultores"
    };

    firebase.initializeApp(firebaseConfig);
    var db = firebase.firestore();

    var cont_contactos      = 0;
    var id_usuario          = parseInt('<?=$idUsuario; ?>');
    var id_tipo_usuario     = parseInt('<?=$id_tipo_usuario; ?>');
    var celular_ticket      = 0;
    var id_firestore_global = 0;
    var estatus_global      = 0;

    const idsVacantes = <?= json_encode($idsVacantes); ?>;

    var tot_items     = 0;
    var array_tickets = [];

      // VARIABLES GLOBALES PARA SABER QUE LLEGO NUEVO MENSAJE
    var ticketsPorTomarInicial = 0;
    var ticketsTomadosInicial  = 0;

    jQuery(document).ready(function($){

        // // Seleccionamos el textarea
        // var $message = $('#message'); // Usamos un nombre diferente a 'textarea'

        // // Ajustamos la altura del textarea conforme se escribe
        // $message.on('input', function() {
        // $message.css('height', 'auto'); // Restablece la altura para recalcular
        // $message.css('height', $message[0].scrollHeight + 'px'); // Ajusta la altura al contenido
        // });

        $(document).on("click", "#emoji-picker", function (e) {
            e.stopPropagation();
            event.preventDefault()
            $(".intercom-composer-emoji-popover").toggleClass("active");
        });

        $(document).click(function (e) {
        if (
            $(e.target).attr("class") != ".intercom-composer-emoji-popover" &&
            $(e.target).parents(".intercom-composer-emoji-popover").length == 0
        ) {
            $(".intercom-composer-emoji-popover").removeClass("active");
        }
        });

        $(document).on("click", ".intercom-emoji-picker-emoji", function (e) {
            
            var valor = $("#message").val();

            $("#message").val(valor+""+$(this).html());

        });

        $(".intercom-composer-popover-input").on("input", function () {
        var query = this.value;
        if (query != "") {
            $(".intercom-emoji-picker-emoji:not([title*='" + query + "'])").hide();
        } else {
            $(".intercom-emoji-picker-emoji").show();
        }
        });

        var fecha_hoy = obtenerFechaHoraActual();

        tot_items = 0;

        // getRegistrosUpdateMasivo();

        getTickets();

        $(document).on('click', '.optionsModal', function(event) {

            var options     = $(this).attr('data-options');
            var options     = JSON.parse(decodeURIComponent(options));

            var items_list  = '';

            for (let i = 0; i < options.length; i++) {
                
                items_list += '<li>'+(i+1)+'.- '+options[i].option+'</li>';
                
            }

            $("#body_lista_menu").html(items_list);

        });

        $(document).on('click', '.btnImg', function(event) {
            $("#modalImagen").modal("show");
        });

        $(document).on('click', '.sesionFin', function(event) {

            var id_firestore    = $(this).attr('data-id');
            var celular         = $(this).attr('data-cel');

            const dataUpdate    = {"cont_msj": 0};
            updateTicketFirestore(id_firestore, dataUpdate);
            updateContador(celular);

            $("#numero_u").val("");
            $("#showmessages").html("<h1 style='text-align: center;margin-top: 60px;'>La sesión ha finalizado</h1>");
            // $('#button_tomar_ticket').html('<button class="sendPlantilla" data-cel="'+celular+'"> Enviar plantilla</button>');
            $('#button_tomar_ticket').html('');
        });

        $(document).on('click', '.sendPlantilla', function(event) {

            var celular    = $(this).attr('data-cel');

            $.confirm({
                title: "¿Quieres enviar plantilla de sesión a este candidato?",
                theme: 'dark',
                content: '',
                buttons: {
                    Si: function () {

                        sendPlantilla(celular);

                    },
                    No: function () {
                        
                    }}
            });

        });

        $(document).on('click', '.subirImagen', function(event) {

            var img = $("#archivo").val();

            if (img != "") {
                
                var fileSize = $('#archivo')[0].files[0].size;

                if (fileSize > 4194304) {
                    alert("Por favor ingresa un archivo menor a 4 MB")
                }else if (img != "") {
                    subirArchivo(id_firestore_global);
                }else{
                    alert("Por favor selecciona un archivo");
                }

            }else {

                alert("Por favor selecciona un archivo");

            }

 
        });
        
        $(document).on('click', '.verImg', function(event) {
            var url = $(this).attr('src');
            $("#modalVer").modal("show");
            $("#imagen_modal").attr('src', url);
            // $("#url_img").val(url)
        });

        $(document).on('click', '.asignar', function(){

            var id_firestore    = $(this).attr('data-id');
            var cel             = $(this).attr('data-cel');
            
            var fecha_hoy       = obtenerFechaHoraActual();

            $.confirm({
                title: "¿Quieres tomar esta conversación?",
                theme: 'dark',
                content: '',
                buttons: {
                    Si: function () {

                        mostrarLoader();
                        tomarTicket(id_firestore, cel);

                        //Firebase
                        const dataUpdate = {"estatus": 1, "conversacion": 2, "id_usuario": id_usuario};
                        // const dataInsert = {
                        //     "cel": celular_ticket, "estatus": 1, "fecha": fecha_hoy, "fecha_msj": fecha_hoy, "file_img": "",
                        //     "mensaje": "¡Bienvenido! Mi nombre es "+nombre_usuario+" y estoy aquí para apoyarte.", "tipo": 2, "type_file": 0,
                        //     "id_ticket": parseInt(id_firestore)
                        // };

                        updateTicketFirestore(id_firestore, dataUpdate);
                        // insertConversacionFirestore(dataInsert);

                    },
                    No: function () {
                        
                    }}
            });

        });


        $(document).on('click', '.reasignar', function(){

            var id_firestore = $(this).attr('data-id');
            var cel          = $(this).attr('data-cel');
            $("#id_ticket_reasignar").val(id_firestore);
            $("#cel_reasignar").val(cel);
            
            $("#modalReasignar").modal("show");

        });

        $(document).on('click', '.btnReasignar', function(){

            var id_usuario_new = $("#usuario_id").val();
                id_usuario_new = parseInt(id_usuario_new);
            var id_ticket      = $("#id_ticket_reasignar").val();
            var cel            = $("#cel_reasignar").val();

            const dataUpdate = {"id_usuario": id_usuario_new};
            updateTicketFirestore(id_ticket, dataUpdate);
            mostrarLoader();
            reasignarTicketSql(id_ticket, id_usuario_new, cel);

        })

        $(function() {
  
          // elementos de la lista
          var menues = $(".nav li"); 

          // manejador de click sobre todos los elementos
          menues.click(function() {
             // eliminamos active de todos los elementos
             menues.removeClass("active-tic");
             // menues.removeClass("tic-danger");
             // menues.removeClass("tic-success");
             // activamos el elemento clicado.
             // $(this).removeClass("tic-success");
             $(this).addClass("active-tic");
          });

        });

        $(document).on('click', '.cerrar_ticket', function(){

            var id_firestore    = $(this).attr('data-id');
			var celular         = $(this).attr('data-cel');

            var fecha_hoy = obtenerFechaHoraActual();

            $.confirm({
                title: "¿Quieres cerrar esta conversación?",
                theme: 'dark',
                content: '',
                buttons: {
                    Si: function () {
                        
                        mostrarLoader();
                        cerrarTicket(id_firestore, celular);

                        id_firestore_global = 0;

                        //Firebase
                        const dataUpdate = {"fecha_cierre": fecha_hoy, "estatus": 2, "conversacion": 1, "id_usuario": id_usuario};

                        updateTicketFirestore(id_firestore, dataUpdate);

                    },
                    No: function () {
                        
                    }}
            });

        })

        $(document).on('click', '.click_ticket', function(){
            
            var id_firestore    = $(this).attr('data-id');
            var cel             = $(this).attr('data-cel');
            var fecha           = $(this).attr('data-fecha');
            var estatus         = $(this).attr('data-estatus');

            celular_ticket      = cel;
            id_firestore_global = id_firestore;
            // console.log("global: "+id_firestore_global);

            var nombre          = $(this).attr('data-nombre');

            var fecha_hoy = obtenerFechaHoraActual();

            $("#cel").val(cel);

            cleanClassSelected(tot_items, array_tickets);

            $("#ticket-"+cel).addClass("active-tic");
                
            if (estatus == 0) {

                $("#button_tomar_ticket").html('<button class="asignar" data-id="'+id_firestore+'" data-cel="'+cel+'"> Tomar conversación</button>');

                $("#interactua").html("CHAT HUMANO");

                $("#message").attr("disabled", true);
                $("#send_message").attr("disabled", true);
                $(".btnImg ").attr("disabled", true);

                $("#emoji-picker").prop("disabled", true);


            }else{

                $("#button_tomar_ticket").html('<button class="cerrar_ticket" data-id="'+id_firestore+'" data-cel="'+cel+'"> Cerrar conversación</button>');
                $("#interactua").html("CHAT HUMANO");

                $("#message").attr("disabled", false);
                $("#send_message").attr("disabled", false);
                $(".btnImg ").attr("disabled", false);

                $("#message").focus();

                $("#emoji-picker").prop("disabled", false);

            }

            getConversacion(cel);
            var div = document.getElementById('showmessages');
            div.scrollTop = div.scrollHeight;

            const dataUpdate = {"cont_msj": 0};
            updateTicketFirestore(id_firestore, dataUpdate);
            updateContador(celular_ticket);

        });

        $(document).on('click', '.complete', function(){
            event.preventDefault();
            var message = this.textContent || this.innerText;
            message     = message.substr(12);

            var numero = $("#numero_u").val();
            var status = $("#status").val();
            document.getElementById("auto-complete").innerHTML="";
            $("#message").val(message);

        });


        $(document).on('click', '#send_message', function(){
            event.preventDefault();

            var message = $("#message").val();
            if(message.length > 1){
                sendMessages(celular_ticket, message, id_firestore_global);

                var fecha_hoy = obtenerFechaHoraActual();

                // Firebase
                //  const dataInsert = {
                //      "cel": celular_ticket, "estatus": 1, "fecha": fecha_hoy, "fecha_msj": fecha_hoy, "file_img": "",
                //      "mensaje": message, "tipo": 2, "type_file": 0, "id_ticket": parseInt(id_firestore_global)
                //  };

                // insertConversacionFirestore(dataInsert);

                const dataUpdate = {"cont_msj": 0};
                updateTicketFirestore(id_firestore_global, dataUpdate);
                updateContador(celular_ticket);

            }

        });

        $("#message").keypress(function(event) {

            if (event.keyCode == 13 && !event.shiftKey) {
                event.preventDefault();

                var message = $("#message").val();
                if(message.length > 0){

                    sendMessages(celular_ticket, message, id_firestore_global);

                    const dataUpdate = {"cont_msj": 0};
                    updateTicketFirestore(id_firestore_global, dataUpdate);
                    updateContador(celular_ticket);

                }

                return false;
            }

        });

        $("#conversaciones_por_tomar").click(function(event) {

            $("#conversaciones_por_tomar").addClass("active");
            $("#conversaciones_tomadas").removeClass("active");

            $("#button_tomar_ticket").html("");
            $("#interactua").html("");
            $("#message").attr("disabled", true);
            $("#send_message").attr("disabled", true);
            $(".btnImg ").attr("disabled", true);
            $("#showmessages").html("");
            $("#cel_actual").html("");

            $("#emoji-picker").prop("disabled", true);

            celular_ticket = 0;
            cleanClassSelected(tot_items, array_tickets);

            ticketsPorTomarInicial = 0;
            $("#icon_por_tomar").css("display", "none");

            // id_firestore_global = 0;
            estatus_global      = 0;
            getTickets();

        });

        $("#conversaciones_tomadas").click(function(event) {

            $("#conversaciones_tomadas").addClass("active");
            $("#conversaciones_por_tomar").removeClass("active");

            $("#button_tomar_ticket").html("");
            $("#interactua").html("");
            $("#message").attr("disabled", true);
            $("#send_message").attr("disabled", true);
            $(".btnImg ").attr("disabled", true);
            $("#showmessages").html("");
            $("#cel_actual").html("");

            $("#emoji-picker").prop("disabled", true);

            celular_ticket = 0;
            cleanClassSelected(tot_items, array_tickets);

            ticketsPorTomarInicial = 0;
            $("#icon_por_tomar").css("display", "none");

            // id_firestore_global = 0;
            estatus_global      = 1;
            getTickets();

        });

        $("#buscar").on("keyup", function() {

            var patron = $(this).val();
            var cont_coincidencias = 0;

            // console.log(patron);
            // si el campo está vacío
            if (patron == "") {

                // mostrar todos los elementos
                $(".click_ticket").css("display", "block");
                $(".mensaje_buscador").css("display", "none");

                // si tiene valores, realizar la búsqueda
            } else {

                $(".mensaje_buscador").css("display", "block");

                // atravesar la lista
                $(".click_ticket").each(function() {

                    if ($(this).text().indexOf(patron) < 0) {
                        // si el texto NO contiene el patrón de búsqueda, esconde el elemento
                        $(this).css("display", "none");
                    } else {
                        // si el texto SÍ contiene el patrón de búsqueda, muestra el elemento
                        $(this).css("display", "block");
                        $(".mensaje_buscador").css("display", "none");
                    }
                });
            }

        });

        function sendPlantilla(celular){

            $.ajax({
                url : "<?php echo base_url();?>index.php/sendPlantilla",
                type : "POST",
                async: false,
                dataType : "json",
                data :{celular: celular},
                success : function(result){

                    if(result.respuesta == 200){

                        Swal.fire(
                            '¡Muy bien!',
                            result.mensaje,
                            'success'
                        );

                    }else {

                        Swal.fire(
                            'ERROR',
                            result.mensaje,
                            'error'
                        );

                    }

                }

            });

        }//termina sendPlantilla

        function getRegistrosUpdateMasivo(){

            return;

            var query             = "";
            var id_usuario_update = 20;
            var id_vacante_update = 9;

            query = db.collection("ticket")
            .where("id_usuario", "==", 0)
            .where("id_vacante", "==", parseInt(id_vacante_update))

            query.onSnapshot((querySnapshot) => {

                querySnapshot.forEach((doc) => {

                    console.log("ID: "+doc.id);
                    console.log("ID USUARIO: "+id_usuario_update);

                    const dataUpdate    = {"id_usuario": parseInt(id_usuario_update)};
                    updateTicketFirestore(doc.id, dataUpdate);

                    // if(id_usuario_update == 9){
                    //     id_usuario_update = 12;
                    // }else if(id_usuario_update == 12){
                    //     id_usuario_update = 9;
                    // }

                });

            });

        }//termina getRegistrosUpdateMasivo

        function getTickets(){

            var query = "";
            // console.log(estatus_global);

            if(parseInt(estatus_global) == 0){//POR TOMAR

                if (id_tipo_usuario == 1) {
                    query = db.collection("ticket")
                    .where("estatus", "==", 0)
                    // .where("tipo_usuario", "==", parseInt(id_tipo_usuario))
                    // .where("id_usuario", "==", 0)
                    .orderBy("fecha_registro", "asc")
                    // .limit(100);   
                }else{

                    // query = db.collection("ticket")
                    // .where("estatus", "==", 0)
                    // //.where("id_usuario", "in", [0, parseInt(id_usuario)])
                    // .where("id_vacante", "in", idsVacantes)
                    // .where("id_usuario", "==", parseInt(id_usuario))
                    // .orderBy("fecha_registro", "asc")
                    // // .limit(100);

                    query = db.collection("ticket")
                    .where("estatus", "==", 0)
                    //.where("id_usuario", "in", [0, parseInt(id_usuario)])
                    .where("id_usuario", "==", parseInt(id_usuario))
                    .orderBy("fecha_registro", "asc")
                    // .limit(100);

                }

            }else {

                query = db.collection("ticket")
                .where("id_usuario", "==", parseInt(id_usuario))
                .where("estatus", "==", 1)
                .orderBy("fecha_registro", "asc")
                // .limit(100);

            }

            $("#buscar").val("");
            $(".mensaje_buscador").css("display", "none");

            $("#contactos").html("");

            query.onSnapshot((querySnapshot) => {

                var estatus_from_bd = 0;

                const colores       = ["#673ab7", "#ffeb3b", "#3f51b5", "#e91e63", "#8bc34a", "#2196f3"];
                var cont_color      = 0;

                var nombre          = "";
                var palabra         = "";
                var alerta          = "";
                var tot_tickets     = 0;
                
                var my_ticket       = 0;
                
                var body            = '<a class="mensaje_buscador" style="display: none;"><li id="ticket-5211038777375" class=""><div class="datos-chat"><p class="number-ticket">No se encontraron resultados</p></div></li></a>';

                var nombre_vacante  = "";

                querySnapshot.forEach((doc) => {

                    if(doc.data().estatus == 0){
                        tot_tickets++;
                    }

                    if((doc.data().estatus == 1 && doc.data().id_usuario == parseInt(id_usuario)) || (doc.data().estatus == 0)){
                        my_ticket = 1;
                    }

                    if(my_ticket == 1 && celular_ticket == doc.data().cel){
                        id_firestore_global = doc.id;
                    }

                    estatus_from_bd = doc.data().estatus;
                    
                    if(doc.data().estatus == parseInt(estatus_global)){

                        nombre = "Usuario";

                        if(cont_color > 5){
                            cont_color = 0;
                        }

                        palabra = "U";

                        if (doc.data().nombre != "" && doc.data().nombre != null) {    
                            nombre  = doc.data().nombre;
                            palabra = obtenerPrimeraLetra(nombre);
                        }

                        var fecha_bd        = doc.data().fecha_ultima;
                        var hora_array      = fecha_bd.split(' ');
                        var date            = hora_array[0];
                        var hora            = hora_array[1].substring(0, 5);

                        var hora_now_array  = fecha_hoy.split(' ');
                        var date_now        = hora_now_array[0];
                        var hora_now        = hora_now_array[1].substring(0, 5);

                        if (doc.data().cont_msj > 0) {
                            alerta = '<div id="alerta-'+doc.data().cel+'"><br><p class="notification"><i style="font-size: .9em;" class="fa fa-bell"></i>  <b>'+doc.data().cont_msj+'</b></p></div>';
                        }else{
                            alerta = '';
                        }

                        //Sacar diferencia de horas
                        var futureDate      = new Date(''+date+'T'+hora+':00.83');
                        var todayDate       = new Date(''+date_now+'T'+hora_now+':00.83');
                        var milliseconds    = futureDate.getTime() - todayDate.getTime();
                        var hours           = Math.floor(milliseconds / (60 * 60 * 1000));

                        if (doc.data().nombre_vacante != "" && doc.data().nombre_vacante != null) {  
                            nombre_vacante = doc.data().nombre_vacante;
                        }

                        if (hours < -24) {

                            body += '<a id="id_a-'+doc.data().cel+'" class="sesionFin" data-id="'+doc.id+'" data-cel="'+doc.data().cel+'"  data-nombre="'+nombre+'"" data-fecha="'+doc.data().fecha_ultima+'" data-estatus="'+doc.data().estatus+'">';
                            body += '<li id="ticket-'+doc.data().cel+'" class="tic-danger">';
                            body += '<div class="initial" style="background-color:'+colores[cont_color]+';"><span>'+palabra+'</span></div>';
                            body += '<div class="datos-chat"><h4 class="name">'+nombre+'</h4><p class="number-ticket">Celular:<span>'+doc.data().cel+'</span></p><p class="number-ticket">Vacante:<span>'+nombre_vacante+'</span></p></div>';
                            body += '<div class="date">'+alerta+'</div>';
                            body += '<div class="date">'+hora+'<br></div>';
                            body += '</li>';
                            body += '</a>';
                            
                        }else {

                            if(doc.data().cel == celular_ticket){

                                body += '<a id="id_a-'+doc.data().cel+'" class="click_ticket" data-id="'+doc.id+'" data-cel="'+doc.data().cel+'"  data-nombre="'+nombre+'"" data-fecha="'+doc.data().fecha_ultima+'" data-estatus="'+doc.data().estatus+'">';
                                body += '<li id="ticket-'+doc.data().cel+'" class="tic-success active-tic">';
                                body += '<div class="initial" style="background-color:'+colores[cont_color]+';"><span>'+palabra+'</span></div>';
                                body += '<div class="datos-chat"><h4 class="name">'+nombre+'</h4><p class="number-ticket">Celular:<span>'+doc.data().cel+'</span></p><p class="number-ticket">Vacante:<span>'+nombre_vacante+'</span></p></div>';
                                body += '<div class="date">'+hora+' '+alerta+'</div>';
                                body += '</li>';
                                body += '</a>';

                            }else{

                                body += '<a id="id_a-'+doc.data().cel+'" class="click_ticket" data-id="'+doc.id+'" data-cel="'+doc.data().cel+'"  data-nombre="'+nombre+'"" data-fecha="'+doc.data().fecha_ultima+'" data-estatus="'+doc.data().estatus+'">';
                                body += '<li id="ticket-'+doc.data().cel+'" class="tic-success">';
                                body += '<div class="initial" style="background-color:'+colores[cont_color]+';"><span>'+palabra+'</span></div>';
                                body += '<div class="datos-chat"><h4 class="name">'+nombre+'</h4><p class="number-ticket">Celular:<span>'+doc.data().cel+'</span></p><p class="number-ticket">Vacante:<span>'+nombre_vacante+'</span></p></div>';
                                body += '<div class="date">'+hora+' '+alerta+'</div>';
                                body += '</li>';
                                body += '</a>'

                            }

                        }

                        array_tickets[tot_items] = doc.data().cel;

                        cont_color++;
                        tot_items++;

                    }

                    if(tot_tickets == 100){
                        tot_tickets = tot_tickets+"+";
                    }

                    if(estatus_global == 0){
                        $("#tot_tickets").html(tot_tickets);
                    }

                });

                ticketsPorTomarInicial++;

                if(ticketsPorTomarInicial > 1){
                    // $("#icon_por_tomar").css("display", "block");
                }

                if(estatus_from_bd == estatus_global){
                    $("#contactos").html(body);
                }

                // console.log("MY TICKET => "+my_ticket+ " ESTATUS GLOBAL => "+estatus_global);

                if(my_ticket == 0 && estatus_global == 0){//el ticket seleccionado ya lo tomo otro usuario y limpiamos la conversación
                    $("#button_tomar_ticket").html("");
                    $("#interactua").html("");
                    $("#message").attr("disabled", true);
                    $("#send_message").attr("disabled", true);
                    $(".btnImg ").attr("disabled", true);
                    $("#showmessages").html("");
                    $("#cel_actual").html("");
                    $("#emoji-picker").prop("disabled", true);
                    id_firestore_global = -1;
                    getConversacion(-1);

                    var div = document.getElementById('showmessages');
                    div.scrollTop = div.scrollHeight;
                }

                // if(id_firestore_global == -1){
                //     getConversacion(-1, -1);
                // }

            });

        }//termina getTickets

        function getConversacion(celular) {

            var div = document.getElementById('showmessages');

            $("#showmessages").html("");

            if(celular > 0){

                $("#cel_actual").html(celular);

                db.collection("conversacion").where("cel", "==", celular).orderBy('fecha', 'asc').onSnapshot((querySnapshot) => {

                // console.log("celular: "+celular+" id_firestore: "+id_firestore_global);

                var type                        = "";
                var cont                        = 1;
                var mensaje                     = "";
                var celular_ticket_from_bd      = 0;
                var id_firestore_from_bd        = 0;

                var date_validar                = "";
                var date_anterior               = "";

                var ubicacion    = "";
                var latitud      = "";
                var longitud     = "";
                
                //ajustar diseño para que se vea bien mensaje location
                var contenedor_html = "";

                querySnapshot.forEach((doc) => {

                    if(doc.data().cel == celular){

                        // console.log("data: "+doc.data().id_ticket+" Global: "+id_firestore_global+" celular_ticket: "+doc.data().cel);

                        celular_ticket_from_bd      = doc.data().cel;
                        id_firestore_from_bd        = doc.data().id_ticket;

                        var explode                 = doc.data().fecha_msj.split(' ');
                        var explode_2               = explode[1].split(':');
                        var hora_msj                = explode_2[0]+":"+explode_2[1];

                        date_validar                = explode[0];

                        //console.log(doc.data().type_file);

                        if (doc.data().type_file == 1) {
                            type = '<img style="cursor: pointer;" class="verImg img-chat" src="'+doc.data().file_img+'" alt="imagen-whatsa">';
                        }else if (doc.data().type_file == 2){
                            type = "<a href='"+doc.data().file_img+"' target='_blank'><i class='fa fa-file-text-o fa-2x'></i> Archivo</a>";
                        }else if (doc.data().type_file == 5){
                            type = "<video src='"+doc.data().file_img+"' controls></video>";
                        }else if (doc.data().type_file == 6){
                            type = "<img style='cursor: pointer;' class='verImg img-chat img-sticker' src='"+doc.data().file_img+"' alt='imagen-whatsa'></div>";
                        }else if (doc.data().type_file == 7){
                            type = "<audio controls><source src='"+doc.data().file_img+"' type='audio/ogg'><source src='"+doc.data().file_img+"' type='audio/mpeg'></audio></div>";
                        }else if (doc.data().type_file == 8){

                            ubicacion   = doc.data().mensaje.split(',');

                            latitud     = ubicacion[0].trim();
                            longitud    = ubicacion[1].trim();

                            type = '<a href="https://www.google.com/maps/search/?api=1&query='+latitud+','+longitud+'&zoom=20" target=_blank"><img style="cursor: pointer;" class="verImgLocation img-chat" src="https://maps.googleapis.com/maps/api/staticmap?center='+latitud+','+longitud+'&zoom=14&size=500x500&maptype=roadmap&markers=color:red%7C'+latitud+','+longitud+'&key=AIzaSyBF_oQwG26rerDYtHXuGld6pEY7Vd_qBNM" alt="imagen-whatsa"></a>';

                        }else{

                            if (isJson(doc.data().mensaje) == 1) {

                                var replaceJson = doc.data().mensaje.replace(/\'/g,'"');
                                replaceJson     = replaceJson.replace(/\n|\r|\s{2,}/g, '');

                                var objMsj      = JSON.parse(replaceJson);
                                var title       = objMsj['title'];
                                var options     = objMsj['options']['options'];

                                // CONVERTIR ARRAY EN STRING PARA PODERLO MANDAR EN EL DATA
                                var data_str    = encodeURIComponent(JSON.stringify(options));

                                type = '<h5><b>'+title+'</b></h5>';
                                type += '<p>Selecciona alguna de las siguientes opciones:</p>';
                                type += '<a href="#" class="optionsModal opciones-chat" data-toggle="modal" data-target="#modalOpciones" data-options='+data_str+'><i class="fa fa-list-ul" aria-hidden="true"></i> Opciones</a>';

                            }else if (isJson(doc.data().mensaje) == 2) {

                                var replaceJson = doc.data().mensaje.replace(/\'/g,'"');
                                replaceJson     = replaceJson.replace(/\n|\r|\s{2,}/g, '');

                                var objMsj      = JSON.parse(replaceJson);
                                var body        = objMsj['body'];
                                var options     = objMsj['options'];

                                // body            = formatWhatsApp(body);

                                type = '<h5>'+body+'</h5>';
                                type += '<p>Oprime el botón de tu preferencia</p>';

                                for (let i = 0; i < options.length; i++) {

                                    type += '<p class="boton-chat">'+options[i].options+'</p>';

                                }

                            }else {

                                // type = formatWhatsApp(doc.data().mensaje);
                                type = doc.data().mensaje;

                            }
                        }

                        if(date_validar != date_anterior){

                            var result1 = new Date(doc.data().fecha_msj).toLocaleDateString('en-GB');

                            mensaje += '<div class="emisor message-viewdate message-date bg-color">';
                            mensaje += '<div class="contenedor-date shadow-color">';
                            mensaje += '<div class="text-date">';
                            mensaje += '<div class="message">'+result1+'</div>';
                            mensaje += '</div>';
                            mensaje += '</div>';
                            mensaje += '</div>';

                            date_anterior = date_validar;
                        }

                        if(doc.data().type_file == 8){
                            contenedor_html = "contenedor-message-location";
                        }else {
                            contenedor_html = "contenedor-message";
                        }

                        if (doc.data().tipo == 1) {

                            mensaje += '<div class="emisor message-view message-in bg-color">';
                            mensaje += '<div class="'+contenedor_html+' shadow-color">';
                            mensaje += '<div class="text-echo">';
                            mensaje += '<div class="message">'+type+'</div>';
                            mensaje += '<div class="hora">'+hora_msj+'</div>';
                            mensaje += '</div>';
                            mensaje += '</div>';
                            mensaje += '</div>';

                        }else{

                            mensaje += '<div class="receptor message-view message-out">';
                            mensaje += '<div class="'+contenedor_html+' shadow-color">';
                            mensaje += '<span class="flechita">';
                            mensaje += '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 13" width="8" height="13"><path opacity=".13" d="M5.188 1H0v11.193l6.467-8.625C7.526 2.156 6.958 1 5.188 1z"></path><path fill="currentColor" d="M5.188 0H0v11.193l6.467-8.625C7.526 1.156 6.958 0 5.188 0z"></path></svg>';
                            mensaje += '</span>';
                            mensaje += '<div class="text-echo">';
                            mensaje += '<div class="message">'+type+'</div>';
                            mensaje += '<div class="hora">'+hora_msj+'</div>';
                            mensaje += '</div>';
                            mensaje += '</div>';
                            mensaje += '</div>';

                        }

                        cont++;

                    }

                });


                if (celular_ticket == celular_ticket_from_bd && celular > 0) {           
                    if (!querySnapshot.empty) {
                        $("#showmessages").html(mensaje);
                        //$("#showmessages").scrollTop($('#showmessages').prop("scrollHeight"));
                        div.scrollTop = div.scrollHeight;

                    }else {
                        $("#showmessages").html("");
                    }
                    
                }else {
                    $("#showmessages").html("");
                }

                });

            }

            setTimeout(function(){
                div.scrollTop = div.scrollHeight;
            },1000);

            setTimeout(function(){
                div.scrollTop = div.scrollHeight;
            },3500);

            setTimeout(function(){
                div.scrollTop = div.scrollHeight;
            },6500);

            setTimeout(function(){
                div.scrollTop = div.scrollHeight;
            },7500);


        }//termina getConversacion

        function tomarTicket(id_firestore, celular, nombre_persona, fecha_registro){

            $.ajax({
                url : "<?php echo base_url();?>index.php/tomarTicket",
                type : "POST",
                dataType : "json",
                data :{id_firestore: id_firestore_global, celular: celular},
                success : function(result){
                        
                    if(result.respuesta == 200){

                        Swal.fire(
                            '¡Muy bien!',
                            result.mensaje,
                            'success'
                        );

                        $("#id_a-"+celular).attr("data-status-t", 1);
                        $("#message").attr("disabled", false);
                        $("#send_message").attr("disabled", false);
                        $(".btnImg ").attr("disabled", false);
                        $("#button_tomar_ticket").html('<button class="cerrar_ticket" data-id="'+id_firestore+'" data-cel="'+celular+'"> Cerrar conversación</button>');
                        $("#conversaciones_tomadas").addClass("active");
                        $("#conversaciones_por_tomar").removeClass("active");

                        $("#emoji-picker").prop("disabled", false);

                        $("#message").focus();

                        estatus_global = 1;

                        getTickets();

                        getConversacion(celular);
                        var div = document.getElementById('showmessages');
                        div.scrollTop = div.scrollHeight;
                        
                    }else{
                    
                        Swal.fire(
                            'ERROR',
                            result.mensaje,
                            'error'
                        );
                    
                    }

                    setTimeout(ocultarLoader, 1000);

                }

            });

        }//termina tomarTicket

        function cerrarTicket(id_firestore, celular){

            $.ajax({
                url : "<?php echo base_url();?>index.php/cerrarTicket",
                type : "POST",
                dataType : "json",
                data :{celular: celular, id_firestore: id_firestore},
                success : function(result){
                        
                    if(result.respuesta == 200){

                        Swal.fire(
                            '¡Muy bien!',
                            result.mensaje,
                            'success'
                        );

                        $("#id_a-"+celular).attr("data-status-t", 1);
                        $("#message").attr("disabled", true);
                        $("#send_message").attr("disabled", true);
                        $(".btnImg ").attr("disabled", true);
                        $("#button_tomar_ticket").html("");

                        $("#showmessages").html("");
                        $("#cel_actual").html("");

                        $("#emoji-picker").prop("disabled", true);
                        celular_ticket = 0;

                        getTickets();
                        
                    }else{
                    
                        Swal.fire(
                            'ERROR',
                            result.mensaje,
                            'error'
                        );
                    
                    }

                    setTimeout(ocultarLoader, 1000);

                }

            });

        }  //termina cerrarTicket
        
        function reasignarTicketSql(id_firestore, id_usuario_new, celular){

            $.ajax({
                url : "<?php echo base_url();?>index.php/reasignarTicketSql",
                type : "POST",
                dataType : "json",
                data :{celular: celular, id_usuario_new: id_usuario_new, id_firestore: id_firestore},
                success : function(result){
                        
                    if(result.respuesta == 200){

                        Swal.fire(
                            '¡Muy bien!',
                            result.mensaje,
                            'success'
                        );

                        $("#id_a-"+celular).attr("data-status-t", 1);
                        $("#message").attr("disabled", true);
                        $("#send_message").attr("disabled", true);
                        $(".btnImg ").attr("disabled", true);
                        $("#button_tomar_ticket").html("");

                        $("#showmessages").html("");
                        $("#cel_actual").html("");

                        $("#emoji-picker").prop("disabled", true);
                        celular_ticket = 0;

                        getTickets();
                        
                    }else{
                    
                        Swal.fire(
                            'ERROR',
                            result.mensaje,
                            'error'
                        );
                    
                    }

                    setTimeout(ocultarLoader, 1000);

                }

            });

        }//termina reasignarTicketSql
        
    });//termina jQuery

    function cleanClassSelected(tot, array_tickets){

        for (let i = 0; i < tot; i++) {
            $("#ticket-"+array_tickets[i]).removeClass("active-tic");
        }
        
    }

    function subirArchivo(id_firestore) {

        mostrarLoader();

        $(".subirImagen").hide();
        var cel       = $("#cel").val();
        var formData  = new FormData();
        var files     = $('#archivo')[0].files[0];
        formData.append('file',files);
        formData.append('cel',cel);
        formData.append('id_firestore',id_firestore);

        const dataUpdate    = {"cont_msj": 0};
        updateTicketFirestore(id_firestore, dataUpdate);
        updateContador(cel);

        $.ajax({
            url: '<?php echo base_url();?>index.php/subirArchivo',
            type: 'post',
            data: formData,
            dataType : "json",
            contentType: false,
            processData: false,
            success: function(result) {

                if (result.respuesta == 200) {
                    
                    Swal.fire(
                    '¡Muy bien!',
                    result.mensaje,
                    'success'
                    );

                    $("#modalImagen").modal("hide");

                }else {

                    Swal.fire(
                    '¡Ups!',
                    result.mensaje,
                    'info'
                    );


                }
                
                // ocultarLoader();
                
                $("#archivo").val("");

                $(".subirImagen").show();

                setTimeout(ocultarLoader, 1000);

            }
        });
    }//termina subirArchivo

    function sendMessages(celular, message, id_ticket) {
        $("#message").val("");
        $.ajax({
            url : "<?php echo base_url();?>index.php/sendMessageWeb",
            type : "POST",
            dataType : "json",
            data :{celular : celular, message: message, id_ticket: id_ticket},
            success : function(result){
                
                if(result == 200){
                    // $("#showmessages").append('<div class="emisor message-view message-out"><div class="contenedor-message shadow-color"><span class="flechita"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 13" width="8" height="13"><path opacity=".13" d="M5.188 1H0v11.193l6.467-8.625C7.526 2.156 6.958 1 5.188 1z"></path><path fill="currentColor" d="M5.188 0H0v11.193l6.467-8.625C7.526 1.156 6.958 0 5.188 0z"></path></svg></span><div class="text-echo"><div class="message">'+message+'</div><div class="hora">20:21</div></div></div></div>');
                    // $("#showmessages").scrollTop(100000);
                // getConversacion(id_bot_persona, selector);
                    var div = document.getElementById('showmessages');
                    div.scrollTop = div.scrollHeight;

                }else{
                    alert("Ocurrió un problema, intentelo nuevamente...");
                }
            },
        error: function(jqXHR, textStatus, errorThrown) {
            console.error("AJAX Error: ", textStatus, errorThrown);
            console.log("Respuesta recibida: ", jqXHR.responseText);
            alert("Error en la solicitud: " + textStatus + ". " + errorThrown);
        }

        });

    }//termina sendMessages

    function updateContador(celular){

        $.ajax({
            url : "<?php echo base_url();?>index.php/updateContador",
            type : "POST",
            async: false,
            dataType : "json",
            data :{celular: celular},
            success : function(result){

                if(result.respuesta == 200){


                }

            }

        });

    }//termina updateContador

    function deleteConversacionFirestore(id_ticket){

        db.collection('conversacion').where('id_ticket_facebook', '==', parseInt(id_ticket)).get().then(function(querySnapshot) {
            querySnapshot.forEach(function(doc) {
                doc.ref.delete();
            });
        });

    }

    function insertConversacionFirestore(data){

        db.collection("conversacion").add(data)
        .then(function(docRef) {
            // console.log("Conversación agregada con éxito en Firestore");
        })
        .catch(function() {
            // console.log("Error al agregar conversación en Firestore");
        });

    }

    function updateTicketFirestore(id_firestore, data){

        db.collection("ticket").doc(id_firestore).update(data)
        .then(function(){
            // console.log("Ticket actualizado con éxito en Firestore");
        })
        .catch(function() {
            // console.log("Error al actualizar ticket en Firestore");
        });

    }

    function isJson(str) {
        if (str.charAt(0) == "{" && str.charAt(str.length - 1) == "}" && str.includes("title")) {
            return 1;
        }else if (str.charAt(0) == "{" && str.charAt(str.length - 1) == "}" && str.includes("header")){
            return 2;
        }
        return false;    
    }

    function formatWhatsApp(mensaje){

        var asteriscos      = mensaje.split("*").length - 1;
        var guiones_bajos   = mensaje.split("_").length - 1;
        var tachados        = mensaje.split("~").length - 1;

        if(asteriscos > 0){

            for (let i = 1; i <= asteriscos; i++) {

                if (i%2==0){
                    mensaje = mensaje.replace("*", "</strong>");
                }else{
                    mensaje = mensaje.replace("*", "<strong>");
                }
                
            }

        }

        if(guiones_bajos > 0){

            for (let i = 1; i <= guiones_bajos; i++) {

                if (i%2==0){
                    mensaje = mensaje.replace("_", "</i>");
                }else{
                    mensaje = mensaje.replace("_", "<i>");
                }
                
            }

        }

        if(tachados > 0){

            for (let i = 1; i <= tachados; i++) {

                if (i%2==0){
                    mensaje = mensaje.replace("~", "</span>");
                }else{
                    mensaje = mensaje.replace("~", "<span style='font-size: 14px; text-decoration-line: line-through;'>");
                }
                
            }

        }

        return mensaje;

    }

    function obtenerPrimeraLetra(texto) {
        // Eliminar caracteres no deseados utilizando una expresión regular
        let soloLetras = texto.replace(/[^a-zA-Z]/g, '');

        // Tomar la primera letra
        let primeraLetra = soloLetras.charAt(0);

        return primeraLetra;
    }

    function crearTarjetaImagen(cont, url){

        var card    = '<div class="card">';
        card        += '<div class="card-header" id="heading_'+cont+'">';
        card        += '<button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse_'+cont+'" aria-expanded="false" aria-controls="collapse_'+cont+'">';
        card        += '<div class="bot_acc">';
        card        += '<span class="btns_controls" onclick=""><i class="fa fa-picture-o swhite" aria-hidden="true" style="margin-top: 5px;"></i></span>';
        card        += '</div>';
        card        += '</button>';
        card        += '<button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse_'+cont+'" aria-expanded="false" aria-controls="collapse_'+cont+'">';
        card        += '<div class="tit_acc">';
        card        += '<strong class="tt_act">IMAGEN</strong>';
        card        += '<p class="mlistap">Ver imagen</p>';
        card        += '</div>';
        card        += '</button>';
        card        += '</div>';
        card        += '<div id="collapse_'+cont+'" class="collapse" aria-labelledby="heading_'+cont+'" data-parent="#accordion">';
        card        += '<div class="card-body">';
        card        += '<div class="block_accion_contenido" id="" style="display: block; text-align: center;">';
        card        += '<a href="'+url+'" target="_blank">';
        card        += '<img src="'+url+'" style="max-width: 100%; height: auto;"/>';
        card        += '</a>';
        card        += '</div>';
        card        += '</div>';
        card        += '</div>';
        card        += '</div>';

        return card;

    }//termina crearTarjetaImagen

    function crearTarjetaDocumento(cont, url){

        var card    = '<div class="card">';
        card        += '<div class="card-header" id="heading_'+cont+'">';
        card        += '<button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse_'+cont+'" aria-expanded="false" aria-controls="collapse_'+cont+'">';
        card        += '<div class="bot_acc">';
        card        += '<span class="btns_controls" onclick=""><i class="fa fa-file swhite" aria-hidden="true" style="margin-top: 5px;"></i></span>';
        card        += '</div>';
        card        += '</button>';
        card        += '<button class="btn btn-link collapsed" data-toggle="collapse" data-target="#collapse_'+cont+'" aria-expanded="false" aria-controls="collapse_'+cont+'">';
        card        += '<div class="tit_acc">';
        card        += '<strong class="tt_act">DOCUMENTO</strong>';
        card        += '<p class="mlistap">Ver documento</p>';
        card        += '</div>';
        card        += '</button>';
        card        += '</div>';
        card        += '<div id="collapse_'+cont+'" class="collapse" aria-labelledby="heading_'+cont+'" data-parent="#accordion">';
        card        += '<div class="card-body">';
        card        += '<div class="block_accion_contenido" id="" style="display: block; text-align: center;">';
        card        += '<iframe src="'+url+'" width="95%" height="650px"></iframe>';
        card        += '</div>';
        card        += '</div>';
        card        += '</div>';
        card        += '</div>';

        return card;

    }//termina crearTarjetaDocumento

    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }

    // Función para obtener la fecha y hora actual en el formato solicitado
    function obtenerFechaHoraActual() {

        // Obtener la fecha y hora actual en el huso horario de México
        var fechaHoraActual = new Date().toLocaleString("en-US", { timeZone: "America/Mexico_City", hour12: false });

        // Obtener los componentes de la fecha y hora
        var fechaHora = new Date(fechaHoraActual);
        var año = fechaHora.getFullYear();
        var mes = ('0' + (fechaHora.getMonth() + 1)).slice(-2);
        var día = ('0' + fechaHora.getDate()).slice(-2);
        var horas = ('0' + fechaHora.getHours()).slice(-2);
        var minutos = ('0' + fechaHora.getMinutes()).slice(-2);
        var segundos = ('0' + fechaHora.getSeconds()).slice(-2);

        // Formatear la fecha y hora en el formato YYYY-mm-dd H:i:s
        var fechaHoraFormateada = año + '-' + mes + '-' + día + ' ' + horas + ':' + minutos + ':' + segundos;

        return fechaHoraFormateada;

    }//obtenerFechaHoraActual

</script>



