<div class="row">
    <div class="col-md-12">
        <h1 id="subir" class="page-header"><i class="fa-solid fa-comments"></i> Conversaciones atendidas</h1>

    </div>

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-md-12" id="divFiltrarConversacion">
        <div class="col-md-4 col-sm-9">
            <div class="form-group">
                <label>
                    Fecha:
                </label>
                <input type="text" name="dates" id="rango" class="form-control" style="cursor: pointer;" />
                <input type="hidden" name="inicio" id="fecha_inicio" class="form-control" />
                <input type="hidden" name="fin" id="fecha_fin" class="form-control" />
            </div>
        </div>

        <div class="col-md-4 col-sm-3">
            <button class="btn" style="margin-top: 24px; background-color: #2a7ab7; color: white;" id="filtrar"><i class="fa fa-search"></i> Buscar</button>
        </div>
    </div>

</div>

<br>

<div class="row">
    <div class="col-md-12">
        <table class="table table-responsive table-striped" id="tabla_conversaciones">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Nombre</th>
                    <th>Celular</th>
                    <th>Vacante</th>
                    <th>Fecha Inicio</th>
                    <th>Fecha Fin</th>
                    <th>Duración Conversación</th>
                    <th>Tipo</th>
                    <th>Atendió</th>
                    <th style="text-align: center;">Acciones</th>
                </tr>
            </thead>
            <tbody id="tbody_conversaciones">
                <?php
                if (!is_null($conversaciones)) {
                    $cont = 1;

                    foreach ($conversaciones as $v) {
                        
                        ?>

                        <tr>
                            <td><?= $cont; ?></td>
                            <td><?= $v->nombre; ?></td>
                            <td><?= $v->celular; ?></td>
                            <td><?= $v->nombre_vacante; ?></td>
                            <td><?= $v->fecha_inicio; ?></td>
                            <td><?= $v->fecha_cerrado; ?></td>
                            <td><?= $v->tiempo_tomado; ?></td>
                            <td><?= $v->t_usuario; ?></td>
                            <td><?= $v->nombre_usuario; ?></td>
                            <td style="text-align: center;">
                                <button class="showConversation btn btn-primary" style="min-width: 135px;" data-id="<?= $v->id_ticket; ?>" data-celular="<?= $v->celular; ?>">
                                    <i class="fa fa-comments"></i> Conversación
                                </button>
                            </td>
                        </tr>

                <?php $cont++;
                    }
                }
                ?>
            </tbody>
        </table>

    </div>

</div>

<!-- MODAL CONVERSACION  -->
<div class="modal fade" id="modalConversacion" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>CONVERSACIÓN</b></h3>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">

                    <div class="col-lg-12">
                        <div class="box-message-2">

                            <div class="chat-view" id="div_mnsj" style="flex-basis: 99%; width: 100%">

                                <div class="viewport-chat" id="showmessages" style="height: 100%;">
                                    <div style="display: block; position: absolute; margin-top: -20px; margin-left: 95px;" id="contenido" class="col-md-8">
                                        <div style="text-align: center;"><br /><img src="<?php echo base_url(); ?>public/images/espera.gif" alt="loading" style="width: 100px; height: 100%; margin-top: 0px;" /></div>
                                        <div style="text-align: center;"><strong>
                                                <h1 style="color: white;">Cargando</h1>
                                            </strong></div>
                                    </div>
                                </div>


                            </div>
                        </div>
                    </div>

                </div>

            </div>

            <div class="modal-footer">
                <button type="button" class="btn btn-danger" data-dismiss="modal" style="margin-top: 2em;">Cerrar</button>
            </div>
        </div>
    </div>
</div>
<!-- FIN MODAL CONVERSACION  -->

<!-- MODAL CAMBIAR ESTADO -->
<div class="modal fade" id="modalEstado" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-xl" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>Actualizar Estatus</b></h3>
            </div>

            <div class="modal-body">
                <div class="form-group">
                    <label for="nuevo_estado" class="control-label">
                        Nuevo Estatus:
                        <i class="text-danger fa fa-asterisk"></i>
                    </label>
                    <select class="form-control" id="nuevo_estado" name="nuevo_estado" required>
                        <option value="">== SELECCIONE ==</option> 
                        <option value="0">Pendiente</option>
                        <option value="1">Prueba</option>
                        <option value="2">En Proceso</option>
                        <option value="3">Vendido</option>
                        <option value="4">No Calificado</option>
                        <option value="5">No Atendido</option>
                        <option value="6">No Vendido</option>
                    </select>
                </div>
                <input type="hidden" id="id_estado" />
            </div>


            <div class="modal-footer">
                <button type="button" class="btn" id="aceptar_estado" style="background-color: #29265b; color: white;">
                    <i class="fa-solid fa-floppy-disk"></i> Guardar
                </button>
                <button type="button" class="btn" data-dismiss="modal" style="background-color: #2a7ab7; color: white;">
                    <i class="fa-solid fa-xmark"></i> Cerrar
                </button>
            </div>
        </div>
    </div>
</div>
<!-- TERMINA MODAL CAMBIAR ESTADO -->


<style type="text/css">
    @media(max-width:750px) {
        #divFiltrarConversacion {
            display: grid;
            grid-template-columns: 2fr 1fr;
        }
    }
</style>

<script type="text/javascript" src="<?= base_url(); ?>public/js/jquery.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo base_url('public/jquery.dataTables.min.js') ?>"></script>
<script src="<?php echo base_url('public/dataTables.bootstrap.js') ?>"></script>
<script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.4.2/css/buttons.dataTables.min.css">
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<!-- FIREBASE -->
<script src="https://www.gstatic.com/firebasejs/7.17.2/firebase.js"></script>
<script src="https://www.gstatic.com/firebasejs/7.17.2/firebase-auth.js"></script>
<script src="https://www.gstatic.com/firebasejs/7.17.2/firebase-firestore.js"></script>

<script type="text/javascript">

    var celular_ticket = 0;
    var id_ticket      = 0;

    var firebaseConfig = {
        apiKey    : "AIzaSyBuNiBTW2QipNlAzizdANaZqfY6iyRJ7sM",
        authDomain: "medina-consultores.firebaseapp.com",
        projectId : "medina-consultores"
    };

    firebase.initializeApp(firebaseConfig);
    var db = firebase.firestore();

    jQuery(document).ready(function($) {

        const now = new Date();
        const offsetMs = now.getTimezoneOffset() * 60 * 1000;
        const dateLocal = new Date(now.getTime() - offsetMs);
        const today = dateLocal.toISOString().slice(0, 19).replace(/-/g, "-").replace("T", " ");
        const explodeDate = today.split(' ');

        $("#fecha_inicio").val(explodeDate[0]);
        $("#fecha_fin").val(explodeDate[0]);


        $('input[name="dates"]').daterangepicker({
            "locale": {
                "format": "DD/MM/YYYY",
                "separator": " - ",
                "applyLabel": "Aceptar",
                "cancelLabel": "Cancelar",
                "fromLabel": "From",
                "toLabel": "To",
                "customRangeLabel": "Custom",
                "daysOfWeek": [
                    "Dom",
                    "Lun",
                    "Mar",
                    "Mie",
                    "Jue",
                    "Vie",
                    "Sab"
                ],
                "monthNames": [
                    "Enero",
                    "Febrero",
                    "Marzo",
                    "Abril",
                    "Mayo",
                    "Junio",
                    "Julio",
                    "Agosto",
                    "Septiembre",
                    "Octubre",
                    "Noviembre",
                    "Diciembre"
                ],
                "firstDay": 1
            }
        });

        var tabla = $('#tabla_conversaciones').DataTable({
            dom: "<'top-btns'<'col-md-2 col-sm-2 col-xs-6 'B> <'col-md-10 col-sm-10 col-xs-10 '<'col-md-6 col-sm-6 col-xs-6 'l><'col-md-6 col-sm-6 col-xs-6 'f>>>" + "<br/>" +
                "<'top'<'col-md-12 table-date scroll-x'tr>>" +
                "<'top'<'col-md-4'i><'col-md-7'p>>",
            oLanguage: {
                "sSearch": "Buscar: ",
                "sInfo": "Mostrando del _START_ al _END_ de _TOTAL_ registros totales",
                "sLengthMenu": "Mostrando _MENU_ entradas",
            },
            buttons: [{
                text: '<i class="fa-solid fa-file-excel"></i> Excel',
                extend: 'excelHtml5',
                className: 'btn btn-success',
                exportOptions: {
                    columns: [0, 1, 2, 3, 4, 5, 6, 7, 8]
                }
            }]
        });

        $("#tabla_conversaciones").css("margin-top", "1em");
        $("#tabla_conversaciones_info").css("margin-top", "2em");
        $("#tabla_conversaciones_paginate").css("margin-top", "2em");
        $("#tabla_conversaciones_previous").find("a").html("Anterior");
        $("#tabla_conversaciones_next").find("a").html("Siguiente");

        $(document).on('click', '.paginate_button', function() {

            $("#tabla_conversaciones_previous").find("a").html("Anterior");
            $("#tabla_conversaciones_next").find("a").html("Siguiente");

        });

        $("#rango").on('apply.daterangepicker', function(ev, picker) {
            var inicio = picker.startDate.format('YYYY-MM-DD');
            var fin = picker.endDate.format('YYYY-MM-DD');
            $("#fecha_inicio").val(inicio);
            $("#fecha_fin").val(fin);
        });

        $(document).on('click', '#filtrar', function(event) {

            var fecha_inicio = $('#fecha_inicio').val();
            var fecha_fin = $('#fecha_fin').val();

            mostrarLoader();
            filtrar(fecha_inicio, fecha_fin);

        });

        $(document).on('click', '.verImg', function(event) {
            $(this).toggleClass("imgActive");
        });

        $(document).on('click', '.showConversation', function(event) {

            id_ticket      = $(this).attr('data-id');
            celular_ticket = $(this).attr('data-celular');

            getConversacion();

            $("#modalConversacion").modal("show");

        });

        $(document).on('click', '.actualizarContra', function() {
            id_ticket = $(this).attr("data-id-ticket");
            $("#id_estado").val(id_ticket);
            $("#modalEstado").modal("show");
        });

        $(document).on('click', '#aceptar_estado', function() {
            var id_ticket        = $("#id_estado").val();
            var id_estado_update = $("#nuevo_estado").val();

            updateStatus(id_ticket, id_estado_update);
        });

        function updateStatus(id_ticket, id_estado_update) {
            console.log("ID del ticket:", id_ticket);
            console.log("ID del estado seleccionado:", id_estado_update);

            $.ajax({
                url : "<?php echo base_url(); ?>index.php/updateEstadoTicket",
                type: 'POST',
                data: {
                    id_ticket: id_ticket,
                    id_estado_update: id_estado_update
                },
                success: function(response) {
                    if (response.status === 'success') {
                        Swal.fire({
                            title: '¡Éxito!',
                            text: response.message,
                            icon: 'success',
                            confirmButtonText: 'Aceptar'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                location.reload();
                            }
                        });
                    } else {
                        Swal.fire({
                            title: '¡Error!',
                            text: response.message,
                            icon: 'warning',
                            confirmButtonText: 'Aceptar'
                        });
                    }
                },
                error: function(xhr, status, error) {
                    console.error("Error en la solicitud AJAX:", error);
                    Swal.fire({
                        title: 'Error',
                        text: 'Hubo un problema con la solicitud.',
                        icon: 'error',
                        confirmButtonText: 'Aceptar'
                    });
                }
            });
        } // termina updateStatus

        function getConversacion() {

            $("#showmessages").html("");

            id_ticket = parseInt(id_ticket);

            // db.collection("conversacion").where("cel", "==", celular_ticket).orderBy('fecha', 'asc').onSnapshot((querySnapshot) => {
            db.collection("conversacion").where("id_ticket", "==", id_ticket).orderBy('fecha', 'asc').onSnapshot((querySnapshot) => {

                var type = "";
                var cont = 1;
                var mensaje = "";
                var celular_from_bd = 0;

                var date_validar = "";
                var date_anterior = "";

                var contenedor_html = "";

                querySnapshot.forEach((doc) => {

                    if (doc.data().id_ticket == id_ticket) {

                        celular_from_bd = doc.data().cel;

                        var explode = doc.data().fecha_msj.split(' ');
                        var explode_2 = explode[1].split(':');
                        var hora_msj = explode_2[0] + ":" + explode_2[1];

                        date_validar = explode[0];

                        if (doc.data().type_file == 1) {
                            type = '<img style="cursor: pointer;" class="verImg img-chat" src="' + doc.data().file_img + '" alt="imagen-whatsa">';
                        } else if (doc.data().type_file == 2) {
                            type = "<a href='" + doc.data().file_img + "' target='_blank'><i class='fa fa-file-text-o fa-2x'></i> Archivo</a>";
                        } else if (doc.data().type_file == 5) {
                            type = "<video src='" + doc.data().file_img + "' controls></video>";
                        } else if (doc.data().type_file == 6) {
                            type = "<img style='cursor: pointer;' class='verImg img-chat img-sticker' src='" + doc.data().file_img + "' alt='imagen-whatsa'></div>";
                        } else if (doc.data().type_file == 7) {
                            type = "<audio controls><source src='" + doc.data().file_img + "' type='audio/ogg'><source src='" + doc.data().file_img + "' type='audio/mpeg'></audio></div>";
                        } else if (doc.data().type_file == 8) {

                            ubicacion = doc.data().mensaje.split(',');

                            latitud = ubicacion[0].trim();
                            longitud = ubicacion[1].trim();

                            type = '<a href="https://www.google.com/maps/search/?api=1&query=' + latitud + ',' + longitud + '&zoom=20" target=_blank"><img style="cursor: pointer;" class="verImgLocation img-chat" src="https://maps.googleapis.com/maps/api/staticmap?center=' + latitud + ',' + longitud + '&zoom=14&size=500x500&maptype=roadmap&markers=color:red%7C' + latitud + ',' + longitud + '&key=AIzaSyBF_oQwG26rerDYtHXuGld6pEY7Vd_qBNM" alt="imagen-whatsa"></a>';

                        } else {

                            if (isJson(doc.data().mensaje) == 1) {

                                var replaceJson = doc.data().mensaje.replace(/\'/g, '"');
                                replaceJson = replaceJson.replace(/\n|\r|\s{2,}/g, '');
                                var objMsj = JSON.parse(replaceJson);
                                var title = objMsj['title'];
                                var options = objMsj['options']['options'];

                                // CONVERTIR ARRAY EN STRING PARA PODERLO MANDAR EN EL DATA
                                var data_str = encodeURIComponent(JSON.stringify(options));

                                type = '<h5><b>' + title + '</b></h5>';
                                type += '<p>Selecciona alguna de las siguientes opciones:</p>';
                                type += '<a href="#" class="optionsModal opciones-chat" data-toggle="modal" data-target="#modalOpciones" data-options=' + data_str + '><i class="fa fa-list-ul" aria-hidden="true"></i> Opciones</a>';

                            } else if (isJson(doc.data().mensaje) == 2) {

                                var replaceJson = doc.data().mensaje.replace(/\'/g, '"');
                                replaceJson = replaceJson.replace(/\n|\r|\s{2,}/g, '');
                                var objMsj = JSON.parse(replaceJson);
                                var body = objMsj['body'];
                                var options = objMsj['options'];

                                // body = formatWhatsApp(body);

                                type = '<h5>' + body + '</h5>';
                                type += '<p>Oprime el botón de tu preferencia</p>';

                                for (let i = 0; i < options.length; i++) {

                                    type += '<p class="boton-chat">' + options[i].options + '</p>';

                                }

                            } else {

                                // type = formatWhatsApp(doc.data().mensaje);
                                type = doc.data().mensaje;

                            }
                        }

                        if (date_validar != date_anterior) {

                            var result1 = new Date(doc.data().fecha_msj).toLocaleDateString('en-GB');

                            mensaje += '<div class="emisor message-viewdate message-date bg-color">';
                            mensaje += '<div class="contenedor-date shadow-color">';
                            mensaje += '<div class="text-date">';
                            mensaje += '<div class="message">' + result1 + '</div>';
                            mensaje += '</div>';
                            mensaje += '</div>';
                            mensaje += '</div>';

                            date_anterior = date_validar;
                        }

                        if (doc.data().type_file == 8) {
                            contenedor_html = "contenedor-message-location";
                        } else {
                            contenedor_html = "contenedor-message";
                        }

                        if (doc.data().tipo == 1) {


                            mensaje += '<div class="emisor message-view message-in bg-color">';
                            mensaje += '<div class="contenedor-message shadow-color">';
                            mensaje += '<div class="text-echo">';
                            mensaje += '<div class="message">' + type + '</div>';
                            mensaje += '<div class="hora">' + hora_msj + '</div>';
                            mensaje += '</div>';
                            mensaje += '</div>';
                            mensaje += '</div>';

                        } else {

                            mensaje += '<div class="receptor message-view message-out">';
                            mensaje += '<div class="contenedor-message shadow-color">';
                            mensaje += '<span class="flechita">';
                            mensaje += '<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 8 13" width="8" height="13"><path opacity=".13" d="M5.188 1H0v11.193l6.467-8.625C7.526 2.156 6.958 1 5.188 1z"></path><path fill="currentColor" d="M5.188 0H0v11.193l6.467-8.625C7.526 1.156 6.958 0 5.188 0z"></path></svg>';
                            mensaje += '</span>';
                            mensaje += '<div class="text-echo">';
                            mensaje += '<div class="message">' + type + '</div>';
                            mensaje += '<div class="hora">' + hora_msj + '</div>';
                            mensaje += '</div>';
                            mensaje += '</div>';
                            mensaje += '</div>';

                        }
                        cont++;

                    }

                });

                if (celular_ticket == celular_from_bd) {

                    if (!querySnapshot.empty) {
                        $("#showmessages").html(mensaje);
                        $("#showmessages").scrollTop($('#showmessages').prop("scrollHeight"));
                    } else {
                        $("#showmessages").html("");
                    }

                }

            });

        } //termina getConversacion

    }); //termina jQuery


    function filtrar(fecha_inicio, fecha_fin) {

        $("#tabla_conversaciones").dataTable().fnDestroy();

        $.ajax({
            url: '<?php echo base_url(); ?>index.php/getFiltroAtendidas',
            type: "POST",
            dataType: "json",
            data: {
                "fecha_inicio": fecha_inicio,
                "fecha_fin": fecha_fin
            },
            success: function(dato) {

                if (dato.length > 0) {

                    $("#tbody_conversaciones").html(dato);

                    var tabla = $('#tabla_conversaciones').DataTable({
                        dom: "<'top-btns'<'col-md-2 col-sm-2 col-xs-6 'B> <'col-md-10 col-sm-10 col-xs-10 '<'col-md-6 col-sm-6 col-xs-6 'l><'col-md-6 col-sm-6 col-xs-6 'f>>>" + "<br/>" +
                            "<'top'<'col-md-12 table-date scroll-x'tr>>" +
                            "<'top'<'col-md-4'i><'col-md-7'p>>",
                        oLanguage: {
                            "sSearch": "Buscar: ",
                            "sInfo": "Mostrando del _START_ al _END_ de _TOTAL_ registros totales",
                            "sLengthMenu": "Mostrando _MENU_ entradas",
                        },
                        buttons: [{
                            text: '<i class="fa-solid fa-file-excel"></i> Excel',
                            extend: 'excelHtml5',
                            className: 'btn btn-success',
                            exportOptions: {
                                columns: [0, 1, 2, 3, 4, 5, 6, 7, 8]
                            }
                        }]
                    });

                    $("#tabla_conversaciones").css("margin-top", "1em");
                    $("#tabla_conversaciones_info").css("margin-top", "2em");
                    $("#tabla_conversaciones_paginate").css("margin-top", "2em");
                    $("#tabla_conversaciones_previous").find("a").html("Anterior");
                    $("#tabla_conversaciones_next").find("a").html("Siguiente");


                } else {
                    Swal.fire({
                        type: 'info',
                        title: "No se encontraron datos"
                    });
                    $("#tbody_conversaciones").html("");

                }

                setTimeout(ocultarLoader, 1000);

            }
        });
    } //termina filtrar

    // function getConversacion(id_ticket) {

    //     $.ajax({
    //         url : "<?php echo base_url(); ?>index.php/admin/conversaciones_usebeq/showMessageUsuario",
    //         type : "POST",
    //         dataType : "json",
    //         data :{id_ticket : id_ticket},
    //         success : function(datos){

    //             $("#showmessages").html(datos.conversacion);
    //             setTimeout(function(){
    //               $("#showmessages").scrollTop(15002.39990234375)
    //             }, 300);

    //         }

    //     });

    // }//termina getConversacion

    function isJson(str) {
        if (str.charAt(0) == "{" && str.charAt(str.length - 1) == "}" && str.includes("title")) {
            return 1;
        } else if (str.charAt(0) == "{" && str.charAt(str.length - 1) == "}" && str.includes("header")) {
            return 2;
        }
        return false;
    }

    function formatWhatsApp(mensaje) {

        var asteriscos = mensaje.split("*").length - 1;
        var guiones_bajos = mensaje.split("_").length - 1;
        var tachados = mensaje.split("~").length - 1;

        if (asteriscos > 0) {

            for (let i = 1; i <= asteriscos; i++) {

                if (i % 2 == 0) {
                    mensaje = mensaje.replace("*", "</strong>");
                } else {
                    mensaje = mensaje.replace("*", "<strong>");
                }

            }

        }

        if (guiones_bajos > 0) {

            for (let i = 1; i <= guiones_bajos; i++) {

                if (i % 2 == 0) {
                    mensaje = mensaje.replace("_", "</i>");
                } else {
                    mensaje = mensaje.replace("_", "<i>");
                }

            }

        }

        if (tachados > 0) {

            for (let i = 1; i <= tachados; i++) {

                if (i % 2 == 0) {
                    mensaje = mensaje.replace("~", "</span>");
                } else {
                    mensaje = mensaje.replace("~", "<span style='font-size: 14px; text-decoration-line: line-through;'>");
                }

            }

        }

        return mensaje;

    }

    function mostrarLoader() {
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }

    function ocultarLoader() {
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }
</script>