<?php

namespace App\Models;
use CodeIgniter\Model;

class TicketsModel extends Model{

  protected $table = 'ticket';

  public function insertHistorialCambioEstado($datosHistorialCambio){

    $query = $this->db->table('historial_cambios_estado');
    $query->insert($datosHistorialCambio);

    return $this->db->insertID();

   }  //termina insertHistorialCambioEstado
   
   public function insertBitacoraTicket($datos){

    $query = $this->db->table('bitacora_ticket_reasignado');
    $query->insert($datos);

    return TRUE;

   }//termina insertBitacoraTicket

    public function getPreguntaByCel($celular){

		$query = $this->query("SELECT * FROM pregunta p WHERE p.celular = '".$celular."';");
		
		return ($query->getNumRows() <= 0) ? null : $query->getRow();

	}  //termina getPreguntaByCel
	
	public function getTicket($id_ticket){

		$query = $this->query("SELECT * FROM ticket t
		INNER JOIN personas p ON p.celular_persona = t.celular
		WHERE t.id_ticket = ".$id_ticket.";");
		
		return ($query->getNumRows() <= 0) ? null : $query->getRow();

	}//termina getTicket

	public function getEstadoTicket($id_ticket){

		$query = $this->query("SELECT estatus_conversacion FROM ticket WHERE id_ticket = '".$id_ticket."';");
		
		return ($query->getNumRows() <= 0) ? null : $query->getRow();
	
	}  // termina getEstadoTicket
	
	public function getUsuario($id_usuario){

		$query = $this->query("SELECT * FROM usuarios u WHERE u.id_usuario = ".$id_usuario.";");
		
		return ($query->getNumRows() <= 0) ? null : $query->getRow();
	
	}// termina getUsuario
	
	public function getUsuarioTicket($id_usuario){

		$query = $this->query("SELECT * FROM usuarios u WHERE u.id_usuario <> ".$id_usuario.";");
		
		return ($query->getNumRows() <= 0) ? null : $query->getResult();

	}  //termina getUsuarioTicket
	
	public function getTipoUsuarioTicket($id_usuario, $id_tipo_usuario){

		$query = $this->query("SELECT * FROM usuarios u WHERE u.id_usuario <> ".$id_usuario." AND u.id_tipo_usuario = ".$id_tipo_usuario."");
		
		return ($query->getNumRows() <= 0) ? null : $query->getResult();

	}//termina getTipoUsuarioTicket

  public function getTicketsAtendidosAll(){

    $query = $this->query("SELECT t.*, IF(u.usuario IS NULL, 'N/A', u.usuario) AS nombre_usuario,
		CONCAT(FLOOR(HOUR(TIMEDIFF(t.fecha_cerrado, t.fecha_inicio)) / 24), ' Días ',
		MOD(HOUR(TIMEDIFF(t.fecha_cerrado, t.fecha_inicio)), 24), ' Horas ',
		MINUTE(TIMEDIFF(t.fecha_cerrado, t.fecha_inicio)), ' Minutos') AS tiempo_tomado, p.nombre,
		tp.tipo_usuario AS t_usuario,
		IF(v.nombre IS NOT NULL AND v.nombre != '', v.nombre, 'N/A') AS nombre_vacante
		FROM ticket t 
		INNER JOIN usuarios u ON u.id_usuario = t.id_usuario
		INNER JOIN pregunta p ON t.celular    = p.celular
		INNER JOIN tipo_usuarios tp ON tp.id_tipo_usuario = u.id_tipo_usuario
		LEFT JOIN vacantes v ON v.id_vacante = t.id_vacante
		WHERE t.fecha_cerrado IS NOT NULL
		ORDER BY t.id_ticket DESC;");

		return($query->getNumRows() <= 0) ? null: $query->getResult();

	}  //termina getTicketsAtendidosAll
	
	public function getTicketsAtendidosByUsuario($id_usuario){

		$query = $this->query("SELECT t.*, IF(u.usuario IS NULL, 'N/A', u.usuario) AS nombre_usuario,
			CONCAT(FLOOR(HOUR(TIMEDIFF(t.fecha_cerrado, t.fecha_inicio)) / 24), ' Días ',
			MOD(HOUR(TIMEDIFF(t.fecha_cerrado, t.fecha_inicio)), 24), ' Horas ',
			MINUTE(TIMEDIFF(t.fecha_cerrado, t.fecha_inicio)), ' Minutos') AS tiempo_tomado, p.nombre,
			tp.tipo_usuario AS t_usuario,
			IF(v.nombre IS NOT NULL AND v.nombre != '', v.nombre, 'N/A') AS nombre_vacante
			FROM ticket t 
			INNER JOIN usuarios u ON u.id_usuario = t.id_usuario
			INNER JOIN pregunta p ON t.celular    = p.celular
			INNER JOIN tipo_usuarios tp ON tp.id_tipo_usuario = u.id_tipo_usuario
			LEFT JOIN vacantes v ON v.id_vacante = t.id_vacante
			WHERE t.fecha_cerrado IS NOT NULL
			AND t.id_usuario = ".$id_usuario."
			ORDER BY t.id_ticket DESC;");
	
			return($query->getNumRows() <= 0) ? null: $query->getResult();
	
	}//termina getTicketsAtendidosByUsuario

	public function getFiltroTicketsAtendidosAll($inicio, $fin){

		$query = $this->query("SELECT t.*, IF(u.usuario IS NULL, 'N/A', u.usuario) AS nombre_usuario,
		CONCAT(FLOOR(HOUR(TIMEDIFF(t.fecha_cerrado, t.fecha_inicio)) / 24), ' Días ',
		MOD(HOUR(TIMEDIFF(t.fecha_cerrado, t.fecha_inicio)), 24), ' Horas ',
		MINUTE(TIMEDIFF(t.fecha_cerrado, t.fecha_inicio)), ' Minutos') AS tiempo_tomado, p.nombre,
		tp.tipo_usuario AS t_usuario,
		IF(v.nombre IS NOT NULL AND v.nombre != '', v.nombre, 'N/A') AS nombre_vacante
		FROM ticket t
		INNER JOIN usuarios u ON u.id_usuario = t.id_usuario
		INNER JOIN pregunta p ON t.celular    = p.celular
		INNER JOIN tipo_usuarios tp ON tp.id_tipo_usuario = u.id_tipo_usuario
		LEFT JOIN vacantes v ON v.id_vacante = t.id_vacante
		WHERE t.fecha_cerrado IS NOT NULL
		AND DATE(t.fecha_inicio) BETWEEN '".$inicio."' AND '".$fin."'
		ORDER BY t.id_ticket DESC;");

		return($query->getNumRows() <= 0) ? null: $query->getResult();

	}  //termina getFiltroTicketsAtendidosAll
	
	public function getFiltroTicketsAtendidosByUsuario($inicio, $fin, $id_usuario){

		$query = $this->query("SELECT t.*, IF(u.usuario IS NULL, 'N/A', u.usuario) AS nombre_usuario,
		CONCAT(FLOOR(HOUR(TIMEDIFF(t.fecha_cerrado, t.fecha_inicio)) / 24), ' Días ',
		MOD(HOUR(TIMEDIFF(t.fecha_cerrado, t.fecha_inicio)), 24), ' Horas ',
		MINUTE(TIMEDIFF(t.fecha_cerrado, t.fecha_inicio)), ' Minutos') AS tiempo_tomado, p.nombre,
		tp.tipo_usuario AS t_usuario,
		IF(v.nombre IS NOT NULL AND v.nombre != '', v.nombre, 'N/A') AS nombre_vacante
		FROM ticket t
		INNER JOIN usuarios u ON u.id_usuario = t.id_usuario
		INNER JOIN pregunta p ON t.celular    = p.celular
		INNER JOIN tipo_usuarios tp ON tp.id_tipo_usuario = u.id_tipo_usuario
		LEFT JOIN vacantes v ON v.id_vacante = t.id_vacante
		WHERE t.fecha_cerrado IS NOT NULL
		AND t.id_usuario = ".$id_usuario."
		AND DATE(t.fecha_inicio) BETWEEN '".$inicio."' AND '".$fin."'
		ORDER BY t.id_ticket DESC;");

		return($query->getNumRows() <= 0) ? null: $query->getResult();

	}//termina getFiltroTicketsAtendidosByUsuario

	public function getVacantesByReclutador($id_usuario){

		$query = $this->query("SELECT vr.*
		FROM vacante_reclutador vr
		INNER JOIN reclutadores r ON r.id_reclutador = vr.id_reclutador
		INNER JOIN usuarios u ON u.id_usuario = r.id_usuario
		WHERE u.id_usuario = ?", array($id_usuario));

		return($query->getNumRows() <= 0) ? null: $query->getResult();

	}//termina getVacantesByReclutador

  	public function updatePregunta($datos, $celular){

		$query = $this->db->table('pregunta');
        $query->where('celular', $celular);
        $query->update($datos);

        return true;

	}//termina updatePregunta

   public function updateEstadoTicket($id_ticket, $id_estado) {
		
		$query = $this->db->table('ticket');
		$query->set('estatus_conversacion', $id_estado); 
		$query->where('id_ticket', $id_ticket);
		$query->update(); 
	
		return true;

	}// termina updateEstadoTicket	

  public function updateTicket($update, $idTicket){

		$query = $this->db->table('ticket');
    	$query->where("id_ticket", $idTicket);
		$query->update($update);

		return true;

  }//termina updateTicket

}