<?php

namespace App\Models;
use CodeIgniter\Model;

class MetricasModel extends Model{

    protected $table = 'candidatos';

    public function candidatos($inicio, $fin){

      $query = $this->query("SELECT COUNT(id_candidato) AS tot FROM candidatos
      WHERE DATE(fecha_registro) BETWEEN '".$inicio."' AND '".$fin."';");
  
      return($query->getNumRows() <= 0) ? null: $query->getResult();
  
    }//termina candidatos

    public function candidatosLider($inicio, $fin, $idUsuario){

      $query = $this->query("SELECT COUNT(vc.id_candidato) AS tot FROM vacante_candidato_reclutador vc
      INNER JOIN vacantes v ON vc.id_vacante=v.id_vacante
      INNER JOIN candidatos c ON vc.id_candidato=c.id_candidato
      WHERE v.id_lider = (SELECT id_lider FROM lideres WHERE id_usuario='$idUsuario')
      AND DATE(c.fecha_registro) BETWEEN '$inicio' AND '$fin';");
  
      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina candidatosLider
  
    public function topVacantes($inicio, $fin){

      $query = $this->query("SELECT COUNT(v.id_vacante) AS tot, va.nombre, va.id_vacante
      FROM vacante_candidato_reclutador v INNER JOIN vacantes va ON v.id_vacante=va.id_vacante
      WHERE DATE(fecha_postulacion) BETWEEN '$inicio' AND '$fin'
      GROUP BY v.id_vacante
      ORDER BY tot DESC LIMIT 5");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina topVacantes

    public function topVacantesLider($inicio, $fin, $idUsuario){

      $query = $this->query("SELECT COUNT(v.id_vacante) AS tot, va.nombre, va.id_vacante
      FROM vacante_candidato_reclutador v INNER JOIN vacantes va ON v.id_vacante=va.id_vacante
      WHERE va.id_lider=(SELECT id_lider FROM lideres WHERE id_usuario='$idUsuario')
      AND DATE(fecha_postulacion) BETWEEN '$inicio' AND '$fin'
      GROUP BY v.id_vacante
      ORDER BY tot DESC LIMIT 5");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina topVacantesLider

    public function top5ReclutadoresVacante($inicio, $fin, $idVacante){

      $query = $this->query("SELECT COUNT(vcr.id_vacante_candidato_reclutador) AS tot, r.nombre_reclutador, v.nombre  FROM vacante_candidato_reclutador vcr
      LEFT JOIN reclutadores r ON vcr.id_reclutador=r.id_reclutador
      INNER JOIN vacantes v ON vcr.id_vacante=v.id_vacante
      WHERE vcr.id_vacante='$idVacante' AND DATE(vcr.fecha_postulacion) BETWEEN '$inicio' AND '$fin'
      GROUP BY vcr.id_reclutador
      ORDER BY tot DESC LIMIT 5");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina top5ReclutadoresVacante

    public function postulaciones($inicio, $fin){

      $query = $this->query("SELECT COUNT(id_vacante_candidato_reclutador) AS tot FROM vacante_candidato_reclutador
      WHERE DATE(fecha_postulacion) BETWEEN '".$inicio."' AND '".$fin."';");
  
      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina postulaciones

    public function postulacionesLider($inicio, $fin, $idUsuario){

      $query = $this->query("SELECT COUNT(vcr.id_vacante_candidato_reclutador) AS tot FROM vacante_candidato_reclutador vcr
      INNER JOIN vacantes va ON vcr.id_vacante=va.id_vacante
      WHERE va.id_lider=(SELECT id_lider FROM lideres WHERE id_usuario='$idUsuario')
      AND DATE(vcr.fecha_postulacion) BETWEEN '".$inicio."' AND '".$fin."';");
  
      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina postulacionesLider

    public function candidatosNo($inicio, $fin){

      $query = $this->query("SELECT COUNT(id_no_continuo_proceso) AS tot FROM no_continuo_proceso
      WHERE DATE(fecha_registro) BETWEEN '".$inicio."' AND '".$fin."';");
  
      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina candidatosNo

    public function candidatosNoLider($inicio, $fin, $idUsuario){

      $query = $this->query("SELECT COUNT(n.id_no_continuo_proceso) AS tot FROM no_continuo_proceso n
      INNER JOIN vacantes va ON n.id_vacante=va.id_vacante
      WHERE va.id_lider=(SELECT id_lider FROM lideres WHERE id_usuario='$idUsuario')
      AND DATE(n.fecha_registro) BETWEEN '".$inicio."' AND '".$fin."';");
  
      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina candidatosNoLider

    public function candidatosViablesNoViables($inicio, $fin){

      $query = $this->query("SELECT IF(v.es_viable = 1, 'Viables', 'No viables') AS descripcion,
      COUNT(*) AS tot
      FROM vacante_candidato_reclutador v
      WHERE DATE(v.fecha_postulacion) BETWEEN ? AND ?
      GROUP BY v.es_viable
      ORDER BY v.es_viable ASC", array($inicio, $fin));

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina candidatosViablesNoViables

    public function candidatosViablesNoViablesLider($inicio, $fin, $idUsuario){

      $query = $this->query("SELECT 'Viables' AS estado, SUM(IF(vcr.es_viable = 1, 1, 0)) AS cantidad
      FROM vacante_candidato_reclutador vcr
      INNER JOIN vacantes va ON vcr.id_vacante=va.id_vacante
      WHERE va.id_lider=(SELECT id_lider FROM lideres WHERE id_usuario='$idUsuario')
      AND DATE(vcr.fecha_postulacion) BETWEEN '$inicio' AND '$fin'
      UNION ALL
      SELECT 'No Viables' AS estado, SUM(IF(vcr.es_viable = 2, 1, 0)) AS cantidad
      FROM vacante_candidato_reclutador vcr
      INNER JOIN vacantes va ON vcr.id_vacante=va.id_vacante
      WHERE va.id_lider=(SELECT id_lider FROM lideres WHERE id_usuario='$idUsuario')
      AND DATE(vcr.fecha_postulacion) BETWEEN '$inicio' AND '$fin';");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina candidatosViablesNoViablesLider

    public function vacantesLideres($inicio, $fin){

      $query = $this->query("SELECT l.*, (SELECT COUNT(v.id_vacante) FROM vacantes v WHERE v.id_lider=l.id_lider
      AND DATE(v.fecha_registro) BETWEEN '".$inicio."' AND '".$fin."') AS num_vacantes
      FROM lideres l;");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina vacantesLideres

    public function postulacionesLideres($inicio, $fin){

      $query = $this->query("SELECT COUNT(vcr.id_vacante_candidato_reclutador) AS tot,l.nombre_lider FROM vacante_candidato_reclutador vcr
      INNER JOIN vacantes v ON vcr.id_vacante=v.id_vacante
      LEFT JOIN lideres l ON v.id_lider=l.id_lider
      WHERE DATE(vcr.fecha_postulacion) BETWEEN '$inicio' AND '$fin'
      GROUP BY v.id_lider
      ORDER BY tot DESC LIMIT 5;");

      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina postulacionesLideres

    public function tickets($inicio, $fin){

      $query = $this->query("SELECT 'Creados' AS estatus, COUNT(*) AS total
      FROM ticket
      WHERE DATE(fecha_registro) BETWEEN '".$inicio."' AND '".$fin."'
      UNION ALL
      SELECT 'Pendientes' AS estatus, COUNT(*) AS total
      FROM ticket
      WHERE estatus = 0 AND DATE(fecha_registro) BETWEEN '".$inicio."' AND '".$fin."'
      UNION ALL
      SELECT 'Tomados' AS estatus, COUNT(*) AS total
      FROM ticket
      WHERE estatus = 1 AND DATE(fecha_registro) BETWEEN '".$inicio."' AND '".$fin."'
      UNION ALL
      SELECT 'Cerrados' AS estatus, COUNT(*) AS total
      FROM ticket
      WHERE estatus = 2 AND DATE(fecha_registro) BETWEEN '".$inicio."' AND '".$fin."';");
  
      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina tickets

    public function ticketsTotalesByUsuario($inicio, $fin){

      $query = $this->query("SELECT 
          r.nombre_reclutador AS Reclutador, SUBSTRING_INDEX(u.correo, '@', 1) AS correo,
          COUNT(*) AS Tickets_Creados,
          SUM(CASE WHEN t.estatus = 0 THEN 1 ELSE 0 END) AS Tickets_Pendientes,
          SUM(CASE WHEN t.estatus = 1 THEN 1 ELSE 0 END) AS Tickets_Tomados,
          SUM(CASE WHEN t.estatus = 2 THEN 1 ELSE 0 END) AS Tickets_Atendidos
      FROM ticket t
      INNER JOIN usuarios u ON t.id_usuario = u.id_usuario
      INNER JOIN reclutadores r ON u.id_usuario = r.id_usuario
      WHERE DATE(t.fecha_registro) BETWEEN ? AND ?
      GROUP BY r.nombre_reclutador
      ORDER BY correo ASC", array($inicio, $fin));
  
      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina ticketsTotalesByUsuario

    public function ticketsPorUsuarioByEstatus($inicio, $fin, $estatus){

      $query = $this->query("SELECT COUNT(t.id_ticket) AS tot, t.id_usuario, SUBSTRING_INDEX(u.correo, '@', 1) AS correo
      FROM ticket t
      INNER JOIN usuarios u ON t.id_usuario=u.id_usuario
      WHERE DATE(t.fecha_registro) BETWEEN ? AND ?
      AND t.estatus = ?
      GROUP BY t.id_usuario
      ORDER BY correo ASC", array($inicio, $fin, $estatus));
  
      return($query->getNumRows() <= 0) ? null: $query->getResult();

    }//termina ticketsPorUsuarioByEstatus

    public function getSpCandidatos($inicio, $fin){

      $query = $this->query("CALL `sp_total_candidatos`('".$inicio."', '".$fin."');");

      $result = ($query->getNumRows() <= 0) ? null : $query->getRow();

      $query->freeResult();// liberar sp

      return $result;

    }//termina getSpCandidatos

}