<?php
namespace App\Controllers\Adminapp;

use App\Controllers\BaseController;

use App\Models\LoginModel;



class Login extends BaseController
{

    private $LoginModel;
    private $encrypter;

    public function __construct(){
        
        $this->LoginModel = new LoginModel();
        $this->encrypter = \Config\Services::encrypter();


    }//termina __construct


    
    protected $filters = [
        
    ];


    public function loginApp(){

        $json = $this->request->getBody();
        $data = json_decode($json, true);

        if(isset($data['correo']) || isset($data['password'])){

            $correo   = $data['correo'];
            $password = $data['password'];
            $response = 400;
            $userData = NULL;

            

            $verificarUsuario = $this->LoginModel->getUsuario($correo);
        
           

            if(is_null($verificarUsuario)){
                
                $mensaje  = "Usuario / Contraseña incorrecto";
                
            }else{

                $pass        = $verificarUsuario->password;
                $passDecrypt = $this->encrypter->decrypt(base64_decode($pass));// Desenciptar
                
                if($passDecrypt == $password){

                    $id_usuario = $verificarUsuario->id_usuario;
                    $usuario    = $verificarUsuario->usuario;
                    $id_tipo    = $verificarUsuario->id_tipo_usuario;                
                    
                    $userData = [
                        'id_usuario' => $id_usuario,
                        'usuario'    => $usuario,
                        'id_tipo_usuario' => $id_tipo,
                        'correo' => $correo
                    ];

                    $response = 200;
                    $mensaje  = "OK";

                    
                }else{

                    $mensaje  = "Usuario / Contraseña incorrecto";

                }//Si no coinciden las contraseñas

            } //termina else verificarUsuario
        
            echo json_encode(array(
                'response' => $response,
                'mensaje'  => $mensaje,
                'userData' => $userData
            ));

        }

    }//termina loginApp




    public function icon(){

        $session = session();
        $session->start();

          // Array de datos de usuario
        $userData = [
            'user_id' => 123,
            'username' => 'example_user',
            // Puedes agregar más datos aquí si es necesario
        ];

        // Establecer datos en la sesión utilizando un array
        $session->set($userData);

        // Redirigir a otra página después de iniciar sesión
        return redirect()->to('/dashboard');


    }


}
