<?php

namespace App\Controllers\Admin;
use App\Controllers\BaseController;
use App\Libraries\Ciqrcode;
use App\Models\DashboardModel;

class Dashboard extends BaseController{

    private $DashboardModel;
    protected $session;

    public function __construct(){
        
        $this->DashboardModel = new DashboardModel(); 
        $this->session = session();

    }//termina __construct
    
    public function index(){

        $session   = session();
        $nombre    = $session->get('usuario');
        $idUsuario = $session->get('id_usuario');
        
        $data                = array();
        $data["nombre"]      = strtoupper($nombre);
        $data["_APP_TITTLE"] = "Inicio";
        $data["_TAB"]        = "Dashboard";
        $data["fragment"]    = view("admin/fragments/dashboard_view", $data);
        $data["main_menu"]   = view("admin/nav/main_menu_nav", $data);
        $data["nav"]         = view("admin/nav/main_nav", $data);
        
        return view("admin/main_view", $data);

    }  //termina index

    public function getVacantesReclutador(){

        $request = service('request');
        $idReclutador = $request->getPost('idReclutador');
        $opciones = "";

        $vacantes = $this->DashboardModel->getVacantesReclutador($idReclutador);

        $opciones .= "<option value=''>--Selecciona--</option>";

        if(!is_null($vacantes)){

            foreach ($vacantes as $vacante) {   
                $opciones .= "<option value='".$vacante->id_vacante."'>".$vacante->nombre."</option>";
            }
        }

        echo json_encode(array("vacantes" => $opciones));

    }//termina getVacantesReclutador

    public function codigoQR(){

        $request = service('request');
        $idReclutador = $request->getPost('idReclutador');
        $idVacante    = $request->getPost("idVacante");

        $datosVacante = $this->DashboardModel->getDatosVacante($idVacante);
		$reclutador   = $this->DashboardModel->getReclutador($idReclutador);

		$codigoReclutador 	= $reclutador->codigo_reclutador;
		$codigoVacante		= $datosVacante->codigo_vacante;
		$vacante			= $datosVacante->nombre;

		$url_qr   = base_url()."public/vacantes_qr/".$codigoVacante.$codigoReclutador.".png";
		$nombreQr = $codigoVacante.$codigoReclutador.".png";
        $cadena = rawurlencode("Hola, estoy interesad@ en la vacante ".$vacante." ".$codigoVacante.";".$codigoReclutador);

		if (!file_exists($url_qr)) {
	
			$this->ciqrcode 	= new Ciqrcode();
			$params['data']     = 'https://api.whatsapp.com/send?phone=5218185263284&text='.$cadena;
			$params['level']    = 'H';
			$params['size']     = 10;
			$params['savename'] = FCPATH.'public/vacantes_qr/'.$codigoVacante.$codigoReclutador.'.png';
			$this->ciqrcode->generate($params);

		}

		$this->DashboardModel->actualizarVacanteReclutador($url_qr, $idVacante, $idReclutador);

		echo json_encode(array("url_qr" => $url_qr, "nombreQr" => $nombreQr, "cadena" => $cadena));

    }//termina codigoQR
    
    public function prueba(){

        /*$request = service('request');

        $id   = $request->getGet('id');

        echo "Numero: ".$id;*/

            $cadena = rawurlencode("Hola, estoy interesad@");
	
			$this->ciqrcode 	= new Ciqrcode();
			$params['data']     = 'https://api.whatsapp.com/send?phone=5218185263284&text='.$cadena;
			$params['level']    = 'H';
			$params['size']     = 10;
			$params['savename'] = FCPATH.'public/vacantes_qr/generico.png';
			$this->ciqrcode->generate($params);

            die("Creado");

    }//termina prueba

    public function cambiarVariableSesion(){

        $session = session();

        if($session->get('wrapper')){

            $session->set('wrapper',false);

        }else{
            $session->set('wrapper', true);
        }

        echo json_encode(array("sesion" => $session->get('wrapper')));

    }//termina cambiarVariableSesion

    public function variableSesion(){

        $session = session();
        $request = service('request');

        $variable = $request->getPost("variable");

        $session->set('wrapper' , $variable);

        echo json_encode(array("sesion" => $session->get('wrapper')));

    }//termina variableSesion

	public function logOut(){
        
        $session = session();
        $session->destroy();

        return redirect()->to('/');

	}//termina logOut

}//termina Class Dashboard
