<?php

namespace App\Controllers\Admin;
use App\Controllers\BaseController;
use App\Models\CandidatosModel;

class Candidatos extends BaseController {
	
	private $CandidatosModel; //Nombre de la variable para el modelo 
    protected $session;

    public function __construct(){
        
        $this->CandidatosModel = new CandidatosModel(); // modelo a usar
        $this->session = session();

    }//termina __construct

	public function index(){	

		$session   = session();
		$tipo      = $session->get('id_tipo_usuario');
		$idUsuario = $session->get('id_usuario');

		if($tipo == 1){
			$candidatos = $this->CandidatosModel->getCandidatos();
		}else {
			$candidatos = $this->CandidatosModel->getCandidatosReclutador($idUsuario);
		}

		$data                = array();
		$data["_APP_TITTLE"] = "Candidatos";
		$data["_TAB"]        = "candidatos";
		$data["candidatos"]  = $candidatos;
		$data["fragment"]    = view('admin/fragments/candidatos_view', $data);
		$data["main_menu"]   = view('admin/nav/main_menu_nav', $data);
		$data["nav"]         = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina index

	public function filtrarCandidatos(){

		$request    = service('request');
		$inicio 	= $request->getPost("inicio");
		$fin    	= $request->getPost("fin");

		$session 	= session();
		$tipo 		= $session->get('id_tipo_usuario');
		$idUsuario	= $session->get('id_usuario');


		if($tipo == 1){
			$filtro 	= $this->CandidatosModel->getFiltroCandidatos($inicio, $fin);
		}else if($tipo == 2){
			$filtro 	= $this->CandidatosModel->getFiltroCandidatosReclutador($inicio, $fin, $idUsuario);
		}

		$tabla  		= "";
		$cont   		= 1;

		if(!is_null($filtro)){

			foreach ($filtro as $candidato) {

				$idCandidato = base64_encode($candidato->id_candidato);

				if ($candidato->es_viable == 1) {
					$viable  = "<h4><span class='label label-success'>Viable</span></h4>";
				}else{
					$viable  = "<h4><span class='label label-danger'>No viable</span></h4>";
				}

				if(is_null($candidato->id_reclutador) || $candidato->id_reclutador == 0){
					$reclutador = "No llegó por QR de reclutador";
				}else{
					$reclutador = $candidato->nombre_reclutador;
				}
				
                $tabla .= "<tr>";
                $tabla .= "<td>".$cont."</td>";
                $tabla .= "<td>".$candidato->nombre_candidato."</td>";
                $tabla .= "<td style='text-align: center;'>(+".substr($candidato->celular_candidato, 0, -10).") ".substr($candidato->celular_candidato, -10)."</td>";
                $tabla .= "<td style='text-align: center;'>".$candidato->fecha_postulacion."</td>";
				$tabla .= "<td>".$reclutador."</td>";
                $tabla .= "<td>".$candidato->nombre."</td>";
				// $tabla .= "<td style='text-align: center;'>".$viable."</td>";
                $tabla .= "<td style='text-align: center;'>";

				// $tabla .= " <button class='btn verPreguntas' style='background-color: #29265b; color: white; width: 130px;' data-vacante='".$candidato->id_vacante."'
                //                 data-candidato='".$candidato->id_candidato."'>
                //                     <i class='fa-solid fa-clipboard-question'></i> Preguntas
                //             </button><br>";

				$tabla .= "<a class='btn' href='https://api.whatsapp.com/send?phone=".$candidato->celular_candidato."&amp;text=Hola ".$candidato->nombre_candidato."'
                                target='_blank' title='Comienza a Chatear' style='background-color: #03E676; color: #FFF; width: 130px;
                                margin-top: 0.5rem;'>
                                    <i class='fa-brands fa-whatsapp'></i> Chatear</a><br>";
                                    
				if(!is_null($candidato->cv_candidato)){
                            
					$tabla .= "<a class='btn' style='background-color: #29265b; color: white; margin-top: 0.5rem; width: 130px;' 
                                    href='".$candidato->cv_candidato."' target='_blank'>
                                    <i class='fa-solid fa-file-contract'></i> CV
                                </a>";
                }
                            
				$tabla .= "</td>"; 
                $tabla .= "</tr>";
                            
            	$cont++;

			}//foreach

		}//is_null

		echo json_encode(array("tabla" => $tabla));

	}//termina filtrarCandidatos

	public function candidatosSinResponder(){

		$data                = array();
		$data["_APP_TITTLE"] = "Candidatos sin responder";
		$data["_TAB"]        = "sinResponder";
		$data["candidatos"]  = $this->CandidatosModel->getCandidatosSinResponder();
		$data["fragment"]    = view('admin/fragments/candidatos_sin_responder_view', $data);
		$data["main_menu"]   = view('admin/nav/main_menu_nav', $data);
		$data["nav"]         = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina candidatosSinResponder

	public function filtrarCandidatosSinPostular(){

		$request    = service('request');
		$inicio 	= $request->getPost("inicio");
		$fin    	= $request->getPost("fin");

		$filtro 		= $this->CandidatosModel->getFiltroCandidatosSinResponder($inicio, $fin);

		$tabla  		= "";
		$cont   		= 1;

		if(!is_null($filtro)){

			foreach ($filtro as $candidato) {

                if (is_null($candidato->nombre_candidato) || $candidato->nombre_candidato == "") {
                    $desc = "N/A";
                }else {
                    $nombre = $candidato->nombre_candidato;
    
                    $nombre = str_replace('"', '', $nombre);
                    $nombre = str_replace('“', '', $nombre);
                    $nombre = str_replace("'", '', $nombre);
        
                    $cont_desc = strlen($nombre);
                    if($cont_desc > 30){
                        $desc = substr($nombre,0, 20).'... <a href class="showMensaje"  data-mensaje="'.nl2br($nombre).'">Ver más</a>'; 
                    }else{
                        $desc = $nombre;
                    }
                }
                $tabla .= "<tr>";
                $tabla .= "<td>".$cont."</td>";
                $tabla .= "<td>".$desc."</td>";
                $tabla .= "<td style='display: none;'>".$candidato->nombre_candidato."</td>";
                $tabla .= "<td>(+".substr($candidato->celular_candidato, 0, -10).") ".substr($candidato->celular_candidato, -10)."</td>";
                $tabla .= "<td>".$candidato->fecha_nacimiento."</td>";
                $tabla .= "<td>".$candidato->escolaridad."</td>";
                $tabla .= "<td>".$candidato->fecha_registro."</td>";
                $tabla .= "<td style='text-align: center;'>";

				$tabla .= '<a class="btn" style="background-color: #03E676; color: white; border-radius: 15px;"href="https://api.whatsapp.com/send?phone='.$candidato->celular_candidato.'"&amp;text=Hola '.$candidato->nombre_candidato.'" target="_blank" title="Comienza a Chatear"><i class="fa-brands fa-whatsapp"></i> Chatear</a><br>';
                                    
				if(!is_null($candidato->cv_candidato)){
                            
					$tabla .= "<a class='btn' style='background-color: #29265b; color: white; margin-top: 0.5rem; width: 130px;' 
                                    href='".$candidato->cv_candidato."' target='_blank'>
                                    <i class='fa-solid fa-file-contract'></i> CV
                                </a>";
                }
                            
				$tabla .= "</td>"; 
                $tabla .= "</tr>";
                            
            	$cont++;

			}//foreach

		}//is_null

		echo json_encode(array("tabla" => $tabla));

	}//termina filtrarCandidatosSinPostular

	public function getPostulaciones(){

		$request 		= service('request');
		$idCandidato 	= base64_decode($request->getGet("c"));

		$session 		= session();
		$postulaciones 	= "";
		$tipo 			= $session->get('id_tipo_usuario');
		$idUsuario		= $session->get('id_usuario');

		if($tipo == 1){
			$postulaciones = $this->CandidatosModel->postulacionesCandidato($idCandidato);
		}else if($tipo == 2){
			$postulaciones = $this->CandidatosModel->postulacionesCandidatoReclutador($idCandidato,$idUsuario);
		}

		$data                	= array();
		$data["_APP_TITTLE"] 	= "Postulaciones";
		$data["_TAB"]        	= "candidatos";
		$data["candidato"]		= $this->CandidatosModel->datosCandidato($idCandidato);
		$data["postulaciones"]  = $postulaciones;
		$data["fragment"]    	= view('admin/fragments/postulaciones_view', $data);
		$data["main_menu"]   	= view('admin/nav/main_menu_nav', $data);
		$data["nav"]         	= view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina getPostulaciones

	public function respuestasCandidato(){

		$request 		= service('request');
		$idVacante 		= $request->getPost("idVacante");
		$idCandidato 	= $request->getPost("idCandidato");
		$preguntas		= "";

		$data = $this->CandidatosModel->getPreguntasVacante($idVacante);

		if (!is_null($data)) {

			$preguntas .= "<div class='panel-group' id='accordion' role='tablist' aria-multiselectable='true'>";
			
			foreach ($data as $da) {

				$esNoViable = false;

				if ($da->tipo_respuesta == 2) {
					$respuestas = $this->CandidatosModel->opcionesMultiples($da->id_pregunta_vacante);
					$respuestaCandidato = $this->CandidatosModel->respuestaCandidato($da->id_pregunta_vacante, $idCandidato);

					foreach ($respuestas as $respuesta) {
						if (
							$respuesta->descarte == 1 &&
							trim(strtolower($respuestaCandidato->respuesta)) == trim(strtolower($respuesta->opcion))
						) {
							$esNoViable = true;
							break;
						}
					}
				}

				
				$claseExtra = $esNoViable ? " panel-descarte" : "";
				$style      = $esNoViable ? ' style="border: 5px solid red !important;"' : '';
				$preguntas .= "<div class='panel panel-default$claseExtra' $style>";
				$preguntas .= "<div class='panel-heading' role='tab' id='heading$da->id_pregunta_vacante'>";
				$preguntas .= "<h4 class='panel-title'>";
				$preguntas .= "<a class='collapsed' role='button' data-toggle='collapse' data-parent='#accordion' href='#collapse$da->id_pregunta_vacante' aria-expanded='false' aria-controls='collapse$da->id_pregunta_vacante'>";
				$preguntas .= $da->pregunta;
				$preguntas .= "</a></h4></div>";
				$preguntas .= "<div id='collapse$da->id_pregunta_vacante' class='panel-collapse collapse' role='tabpanel' aria-labelledby='heading$da->id_pregunta_vacante'>";
				$preguntas .= "<div class='panel-body'>";
				$preguntas .= "<p>";

					if ($da->tipo_respuesta == 2) {

						$respuestas = $this->CandidatosModel->opcionesMultiples($da->id_pregunta_vacante);
						$preguntas .= "<strong>Opciones:</strong><br>";
						$cont = 1;

						foreach ($respuestas as $respuesta) {
							if ($respuesta->descarte == 1) {
								$preguntas .= "<span style='margin-left: 2rem; color: red !important;'>".$cont.".- ".$respuesta->opcion."</span><br>";
							} else {
								$preguntas .= "<span style='margin-left: 2rem;'>".$cont.".- ".$respuesta->opcion."</span><br>";
							}
							$cont++;
						}

						$respuestaCandidato = $this->CandidatosModel->respuestaCandidato($da->id_pregunta_vacante, $idCandidato);
						$preguntas .= "<strong>Respuesta candidato:</strong><br>";
						$preguntas .= $respuestaCandidato->respuesta;

					} else {

						$preguntas .= "Pregunta con tipo de respuesta libre <br>";

						$respuestaCandidato = $this->CandidatosModel->respuestaCandidato($da->id_pregunta_vacante, $idCandidato);

						$preguntas .= "<span style='margin-left: 2rem;'><strong>Respuesta candidato:</strong></span><br>";
						$preguntas .= "<span style='margin-left: 2rem;'>".$respuestaCandidato->respuesta."</span>";
					}

					if (!is_null($da->pdf_pregunta)) {
						$preguntas .= "<br><strong>Archivo:</strong><br>";
						$preguntas .= '<a class="btn" style="width: 80px; background-color: #1d70b6; color: white; margin-top: 0.5rem;"
								href="'.$da->pdf_pregunta.'" target="_blank"><i class="fa-solid fa-file-pdf"></i> Ver</a>';
					}

				$preguntas .= "</p>";
				$preguntas .= "</div>";
				$preguntas .= "</div></div>";

			}

			$preguntas .= "</div>";
		}

		echo json_encode(array("preguntas" => $preguntas));

	} // termina respuestasCandidato

}
