<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cotización <?= htmlspecialchars($cotizacion->numero) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .cotizacion-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            border-radius: 10px;
            margin-bottom: 30px;
        }
        .info-box {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 15px;
            margin-bottom: 20px;
        }
        .print-hide { display: block; }
        @media print {
            .print-hide { display: none !important; }
            .container { max-width: 100% !important; }
        }
    </style>
</head>
<body>
<?php
    // ===== Helpers locales para formateo de moneda/IVA =====
    $moneda         = isset($cotizacion->moneda) ? $cotizacion->moneda : 'MXN';
    $aplicar_iva    = isset($cotizacion->aplicar_iva) ? (int)$cotizacion->aplicar_iva : 1;
    $iva_porcentaje = isset($cotizacion->iva_porcentaje) ? (float)$cotizacion->iva_porcentaje : 16;

    // símbolo: si prefieres "US$" para USD, cambia aquí
    $currency_symbol = function($code) {
        $code = strtoupper((string)$code);
        return $code === 'USD' ? '$' : '$';
    };
    $currency_suffix = function($code) {
        $code = strtoupper((string)$code);
        return in_array($code, ['MXN','USD']) ? $code : 'MXN';
    };
    $fmt = function($amount, $code) use ($currency_symbol, $currency_suffix) {
        return $currency_symbol($code) . number_format((float)$amount, 2, '.', ',') . ' ' . $currency_suffix($code);
    };

    // Normalizar y preparar totales (respeta lo guardado en BD)
    $subtotal  = (float)($cotizacion->subtotal ?? 0);
    $descuento = (float)($cotizacion->descuento ?? 0);
    if ($descuento < 0) $descuento = 0;
    if ($descuento > $subtotal) $descuento = $subtotal;

    $base      = $subtotal - $descuento;

    // Si hay iva/total en BD, úsalos; si no, calcula con aplicar_iva + iva_porcentaje
    $iva   = isset($cotizacion->iva)   ? (float)$cotizacion->iva   : ($aplicar_iva ? round($base * ($iva_porcentaje/100), 2) : 0.00);
    $total = isset($cotizacion->total) ? (float)$cotizacion->total : round($base + $iva, 2);

    // Etiqueta IVA para el título
    $iva_label_pct = $aplicar_iva ? (strpos((string)$iva_porcentaje, '.') === false ? (int)$iva_porcentaje : $iva_porcentaje) : 0;
?>
    <div class="container mt-5">
        <div class="print-hide d-flex justify-content-between align-items-center mb-4">
            <h2><i class="fas fa-file-invoice"></i> Cotización <?= htmlspecialchars($cotizacion->numero) ?></h2>
            <div class="d-flex gap-2">
                <span class="badge bg-dark align-self-center">Moneda: <?= $currency_suffix($moneda) ?></span>
                <a href="<?= base_url('index.php/cotizaciones') ?>" class="btn btn-secondary">
                    <i class="fas fa-arrow-left"></i> Volver
                </a>
                <a href="<?= base_url('index.php/cotizaciones/editar/' . $cotizacion->id) ?>" class="btn btn-warning">
                    <i class="fas fa-edit"></i> Editar
                </a>
                <a href="<?= base_url('index.php/cotizaciones/exportar_pdf/' . $cotizacion->id) ?>" class="btn btn-success">
                    <i class="fas fa-file-pdf"></i> Exportar PDF
                </a>
                <button onclick="window.print()" class="btn btn-info">
                    <i class="fas fa-print"></i> Imprimir
                </button>
            </div>
        </div>

        <?php if($this->session->flashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show print-hide">
                <?= $this->session->flashdata('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="cotizacion-header">
            <div class="row">
                <div class="col-md-8">
                    <h3>JESÚS RODRÍGUEZ MORALES</h3>
                    <p class="mb-1">FOUNDER - CEO</p>
                    <p class="mb-1"><i class="fas fa-phone"></i> +52 442 546 8718</p>
                    <p class="mb-1"><i class="fas fa-globe"></i> www.raasmex.com</p>
                    <p class="mb-0"><i class="fas fa-envelope"></i> jrodriguez@raasmex.com</p>
                </div>
                <div class="col-md-4 text-end">
                    <h4>PROPUESTA N° <?= htmlspecialchars($cotizacion->numero) ?></h4>
                    <p class="mb-1"><strong>Fecha:</strong> <?= date('d/m/Y', strtotime((string)$cotizacion->fecha)) ?></p>
                    <p class="mb-0"><strong>Vigencia:</strong> <?= (int)$cotizacion->vigencia_dias ?> días</p>
                </div>
            </div>
        </div>

        <!-- Cliente -->
        <div class="card mb-4">
            <div class="card-header bg-primary text-white">
                <h5 class="mb-0"><i class="fas fa-user"></i> Información del Cliente</h5>
            </div>
            <div class="card-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Empresa:</strong> <?= htmlspecialchars($cotizacion->empresa) ?></p>
                        <p><strong>Nombre:</strong> <?= htmlspecialchars($cotizacion->nombre) ?></p>
                        <p><strong>Email:</strong> <?= htmlspecialchars($cotizacion->email) ?></p>
                        <p><strong>Teléfono:</strong> <?= htmlspecialchars($cotizacion->telefono) ?></p>
                    </div>
                    <div class="col-md-6">
                        <p><strong>Dirección:</strong> <?= htmlspecialchars($cotizacion->direccion) ?></p>
                        <p><strong>RFC:</strong> <?= htmlspecialchars($cotizacion->rfc) ?></p>
                        <p><strong>Cargo:</strong> <?= htmlspecialchars($cotizacion->cargo) ?></p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Items -->
        <div class="card mb-4">
            <div class="card-header bg-success text-white">
                <h5 class="mb-0"><i class="fas fa-list"></i> Detalle de la Cotización</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-bordered align-middle">
                        <thead class="table-dark">
                            <tr>
                                <th>Servicio</th>
                                <th>Descripción</th>
                                <th width="10%" class="text-center">Cantidad</th>
                                <th width="15%" class="text-end">Precio Unitario</th>
                                <th width="15%" class="text-end">Total</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($items as $item): ?>
                                <tr>
                                    <td><?= nl2br(htmlspecialchars($item->servicio)) ?></td>
                                    <td><small><?= nl2br($item->descripcion) /* permite formato básico ya guardado */ ?></small></td>
                                    <td class="text-center"><?= (int)$item->cantidad ?></td>
                                    <td class="text-end"><?= $fmt($item->precio_unitario, $moneda) ?></td>
                                    <td class="text-end"><strong><?= $fmt($item->total, $moneda) ?></strong></td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>

                <?php if(!empty($cotizacion->observaciones)): ?>
                    <div class="info-box mt-3">
                        <h6><strong>Observaciones:</strong></h6>
                        <p class="mb-0 small"><?= nl2br($cotizacion->observaciones) ?></p>
                    </div>
                <?php else: ?>
                    <div class="info-box mt-3">
                        <h6><strong>Observaciones:</strong></h6>
                        <ul class="small mb-0">
                            <li>Se requiere el pago de la implementación al confirmar el servicio.</li>
                            <li>Los precios no incluyen I.V.A.</li>
                            <li>Vigencia del Servicio: 12 meses. Cancelación sin penalización con aviso anticipado de 25 días.</li>
                            <li>Facturación de la licencia: Se enviará a inicios de cada mes con un plazo de crédito de 25 días.</li>
                        </ul>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <!-- Totales -->
        <div class="card">
            <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="fas fa-calculator"></i> <?= htmlspecialchars($cotizacion->tipo_inversion) ?></h5>
                <?php if ($descuento > 0): ?>
                    <span class="badge bg-warning text-dark">Descuento: <?= $fmt($descuento, $moneda) ?></span>
                <?php endif; ?>
            </div>

            <div class="card-body">
                <div class="row">
                    <div class="col-md-8"></div>
                    <div class="col-md-4">
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>SUBTOTAL:</strong></td>
                                <td class="text-end"><?= $fmt($subtotal, $moneda) ?></td>
                            </tr>
                            <tr>
                                <td><strong>DESCUENTO:</strong></td>
                                <td class="text-end">
                                    <?php if ($descuento > 0): ?>
                                        <span class="text-danger">− <?= $fmt($descuento, $moneda) ?></span>
                                    <?php else: ?>
                                        <?= $fmt(0, $moneda) ?>
                                    <?php endif; ?>
                                </td>
                            </tr>
                            <tr>
                                <td><strong>BASE (Subt. − Desc.):</strong></td>
                                <td class="text-end"><?= $fmt($base, $moneda) ?></td>
                            </tr>
                            <tr>
                                <td>
                                    <strong>
                                        IVA (<?= $iva_label_pct ?>%):
                                    </strong>
                                </td>
                                <td class="text-end"><?= $fmt($iva, $moneda) ?></td>
                            </tr>
                            <tr class="table-primary">
                                <td><h5 class="mb-0"><strong>TOTAL:</strong></h5></td>
                                <td class="text-end">
                                    <h5 class="mb-0"><strong><?= $fmt($total, $moneda) ?></strong></h5>
                                </td>
                            </tr>
                        </table>

                        <!-- Sello de moneda para claridad -->
                        <div class="text-end">
                            <span class="badge bg-secondary">Importes en <?= $currency_suffix($moneda) ?></span>
                            <?php if (!$aplicar_iva): ?>
                                <span class="badge bg-light text-dark border ms-1">IVA no aplicado</span>
                            <?php endif; ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="mb-5"></div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
