<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cotizaciones</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .badge-mxn { background-color: #0d6efd; } /* azul */
        .badge-usd { background-color: #198754; } /* verde */
        .table thead th { white-space: nowrap; }
        .table td { vertical-align: middle; }
    </style>
</head>
<body>
<?php
    // Helpers de formateo de moneda
    $currency_symbol = function($code) {
        $c = strtoupper((string)$code);
        // Si prefieres 'US$' para USD, cambia aquí:
        return $c === 'USD' ? '$' : '$';
    };
    $currency_suffix = function($code) {
        $c = strtoupper((string)$code);
        return in_array($c, ['MXN','USD']) ? $c : 'MXN';
    };
    $fmt_money = function($n, $code) use ($currency_symbol, $currency_suffix) {
        return $currency_symbol($code) . number_format((float)$n, 2, '.', ',') . ' ' . $currency_suffix($code);
    };
?>
    <div class="container mt-5">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="mb-0"><i class="fas fa-file-invoice"></i> Cotizaciones</h2>
            <div class="d-flex gap-2">
                <a href="<?= base_url('index.php/clientes') ?>" class="btn btn-secondary">
                    <i class="fas fa-users"></i> Clientes
                </a>
                <a href="<?= base_url('index.php/cotizaciones/crear') ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Nueva Cotización
                </a>
                <a href="<?= base_url('index.php/auth/logout') ?>" class="btn btn-danger">
                    <i class="fas fa-right-from-bracket"></i> Cerrar Sesión
                </a>
            </div>
        </div>

        <?php if($this->session->flashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <?= $this->session->flashdata('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead>
                            <tr>
                                <th>Número</th>
                                <th>Cliente</th>
                                <th>Empresa</th>
                                <th>Fecha</th>
                                <th>Inversión</th>
                                <th class="text-end">Total</th>
                                <th class="text-center">Moneda</th>
                                <th class="text-center">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if(empty($cotizaciones)): ?>
                                <tr>
                                    <td colspan="8" class="text-center text-muted">No hay cotizaciones registradas</td>
                                </tr>
                            <?php else: ?>
                                <?php foreach($cotizaciones as $cot): 
                                    $moneda = $cot->moneda ?? 'MXN';
                                    $badgeClass = (strtoupper($moneda) === 'USD') ? 'badge-usd' : 'badge-mxn';
                                ?>
                                    <tr>
                                        <td><strong><?= htmlspecialchars($cot->numero) ?></strong></td>
                                        <td><?= htmlspecialchars($cot->cliente_nombre) ?></td>
                                        <td><?= htmlspecialchars($cot->empresa) ?></td>
                                        <td><?= date('d/m/Y', strtotime((string)$cot->fecha)) ?></td>
                                        <td><?= htmlspecialchars($cot->tipo_inversion) ?></td>
                                        <td class="text-end"><?= $fmt_money($cot->total, $moneda) ?></td>
                                        <td class="text-center">
                                            <span class="badge <?= $badgeClass ?>">
                                                <?= strtoupper($moneda) ?>
                                            </span>
                                        </td>
                                        <td class="text-center" style="white-space: nowrap;">
                                            <a href="<?= base_url('index.php/cotizaciones/ver/' . $cot->id) ?>" class="btn btn-sm btn-info" title="Ver">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="<?= base_url('index.php/cotizaciones/editar/' . $cot->id) ?>" class="btn btn-sm btn-warning" title="Editar">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="<?= base_url('index.php/cotizaciones/exportar_pdf/' . $cot->id) ?>" class="btn btn-sm btn-success" title="Exportar PDF">
                                                <i class="fas fa-file-pdf"></i>
                                            </a>
                                            <a href="<?= base_url('index.php/cotizaciones/eliminar/' . $cot->id) ?>" 
                                               class="btn btn-sm btn-danger" 
                                               title="Eliminar"
                                               onclick="return confirm('¿Está seguro de eliminar esta cotización?')">
                                                <i class="fas fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <?php
                    // Resumen rápido por moneda (opcional, útil cuando mezclas MXN y USD)
                    $sumMXN = 0; $sumUSD = 0;
                    if (!empty($cotizaciones)) {
                        foreach ($cotizaciones as $c) {
                            $m = strtoupper($c->moneda ?? 'MXN');
                            if ($m === 'USD') $sumUSD += (float)$c->total;
                            else $sumMXN += (float)$c->total;
                        }
                    }
                ?>
                <?php if ($sumMXN > 0 || $sumUSD > 0): ?>
                    <div class="mt-3 d-flex justify-content-end gap-3">
                        <?php if ($sumMXN > 0): ?>
                            <span class="badge bg-primary">Total MXN: <?= $fmt_money($sumMXN, 'MXN') ?></span>
                        <?php endif; ?>
                        <?php if ($sumUSD > 0): ?>
                            <span class="badge bg-success">Total USD: <?= $fmt_money($sumUSD, 'USD') ?></span>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
