<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Clientes</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <div class="container mt-5">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2><i class="fas fa-users"></i> Clientes</h2>
            <div>
                <a href="<?= base_url('index.php/cotizaciones') ?>" class="btn btn-secondary">
                    <i class="fas fa-file-invoice"></i> Cotizaciones
                </a>
                <a href="<?= base_url('index.php/clientes/crear') ?>" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Nuevo Cliente
                </a>
            </div>
        </div>

        <?php if($this->session->flashdata('success')): ?>
            <div class="alert alert-success alert-dismissible fade show">
                <?= $this->session->flashdata('success') ?>
                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
        <?php endif; ?>

        <div class="card">
            <div class="card-body">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Nombre</th>
                            <th>Empresa</th>
                            <th>Email</th>
                            <th>Teléfono</th>
                            <th>RFC</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if(empty($clientes)): ?>
                            <tr>
                                <td colspan="6" class="text-center text-muted">No hay clientes registrados</td>
                            </tr>
                        <?php else: ?>
                            <?php foreach($clientes as $cliente): ?>
                                <tr>
                                    <td><strong><?= $cliente->nombre ?></strong></td>
                                    <td><?= $cliente->empresa ?></td>
                                    <td><?= $cliente->email ?></td>
                                    <td><?= $cliente->telefono ?></td>
                                    <td><?= $cliente->rfc ?></td>
                                    <td>
                                        <a href="<?= base_url('index.php/clientes/editar/' . $cliente->id) ?>" class="btn btn-sm btn-warning" title="Editar">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <a href="<?= base_url('index.php/clientes/eliminar/' . $cliente->id) ?>" 
                                           class="btn btn-sm btn-danger" 
                                           title="Eliminar"
                                           onclick="return confirm('¿Está seguro de eliminar este cliente?')">
                                            <i class="fas fa-trash"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
