<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Restablecer Contraseña</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .reset-container {
            max-width: 450px;
            width: 100%;
            padding: 20px;
        }
        .reset-card {
            background: white;
            border-radius: 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
            overflow: hidden;
        }
        .reset-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 40px 30px;
            text-align: center;
        }
        .reset-header h2 {
            margin: 0;
            font-size: 24px;
            font-weight: 600;
        }
        .reset-header p {
            margin: 10px 0 0 0;
            opacity: 0.9;
            font-size: 14px;
        }
        .reset-body {
            padding: 40px 30px;
        }
        .form-control {
            height: 50px;
            border-radius: 10px;
            border: 2px solid #e0e0e0;
            padding-left: 45px;
            padding-right: 45px;
            font-size: 15px;
            transition: all 0.3s;
        }
        .form-control:focus {
            border-color: #667eea;
            box-shadow: 0 0 0 0.2rem rgba(102, 126, 234, 0.1);
        }
        .form-control.is-valid {
            border-color: #28a745;
        }
        .form-control.is-invalid {
            border-color: #dc3545;
        }
        .input-group {
            position: relative;
            margin-bottom: 20px;
        }
        .input-icon {
            position: absolute;
            left: 15px;
            top: 50%;
            transform: translateY(-50%);
            color: #999;
            z-index: 10;
            font-size: 18px;
        }
        .password-toggle {
            position: absolute;
            right: 15px;
            top: 50%;
            transform: translateY(-50%);
            cursor: pointer;
            color: #999;
            z-index: 10;
            font-size: 18px;
        }
        .btn-reset {
            width: 100%;
            height: 50px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border: none;
            border-radius: 10px;
            color: white;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            text-transform: uppercase;
            letter-spacing: 1px;
            margin-top: 10px;
        }
        .btn-reset:hover:not(:disabled) {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px rgba(102, 126, 234, 0.4);
        }
        .btn-reset:disabled {
            opacity: 0.6;
            cursor: not-allowed;
        }
        .alert {
            border-radius: 10px;
            border: none;
            margin-bottom: 20px;
        }
        .password-requirements {
            background: #f8f9fa;
            border-radius: 10px;
            padding: 15px;
            margin-bottom: 20px;
            font-size: 13px;
        }
        .requirement {
            color: #dc3545;
            margin: 5px 0;
        }
        .requirement.met {
            color: #28a745;
        }
        .requirement i {
            margin-right: 8px;
            width: 16px;
        }
        .password-strength {
            height: 5px;
            background: #e0e0e0;
            border-radius: 10px;
            margin-top: 10px;
            overflow: hidden;
        }
        .password-strength-bar {
            height: 100%;
            width: 0%;
            transition: all 0.3s;
        }
        .strength-weak { background: #dc3545; width: 33%; }
        .strength-medium { background: #ffc107; width: 66%; }
        .strength-strong { background: #28a745; width: 100%; }
    </style>
</head>
<body>
    <div class="reset-container">
        <div class="reset-card">
            <div class="reset-header">
                <h2><i class="fas fa-lock-open"></i> Nueva Contraseña</h2>
                <p>Ingresa tu nueva contraseña segura</p>
            </div>
            <div class="reset-body">
                <?php if($this->session->flashdata('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show">
                        <i class="fas fa-exclamation-circle"></i>
                        <?= $this->session->flashdata('error') ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <div class="password-requirements">
                    <strong>Requisitos de contraseña:</strong>
                    <div class="requirement" id="req-length">
                        <i class="fas fa-times-circle"></i> Mínimo 8 caracteres
                    </div>
                    <div class="requirement" id="req-uppercase">
                        <i class="fas fa-times-circle"></i> Una letra mayúscula
                    </div>
                    <div class="requirement" id="req-lowercase">
                        <i class="fas fa-times-circle"></i> Una letra minúscula
                    </div>
                    <div class="requirement" id="req-number">
                        <i class="fas fa-times-circle"></i> Un número
                    </div>
                    <div class="requirement" id="req-special">
                        <i class="fas fa-times-circle"></i> Un carácter especial (!@#$%^&*)
                    </div>
                </div>

                <form action="<?= base_url('auth/procesar_restablecer') ?>" method="POST" id="resetForm">
                    <input type="hidden" name="<?=$this->security->get_csrf_token_name();?>" value="<?=$this->security->get_csrf_hash();?>" />
                    <input type="hidden" name="token" value="<?= $token ?>">
                    
                    <div class="input-group">
                        <i class="fas fa-key input-icon"></i>
                        <input type="password" 
                               class="form-control" 
                               id="password" 
                               name="password" 
                               placeholder="Nueva contraseña" 
                               required
                               autocomplete="new-password">
                        <i class="fas fa-eye password-toggle" id="togglePassword"></i>
                        <div class="password-strength">
                            <div class="password-strength-bar" id="strengthBar"></div>
                        </div>
                    </div>

                    <div class="input-group">
                        <i class="fas fa-check-circle input-icon"></i>
                        <input type="password" 
                               class="form-control" 
                               id="password_confirm" 
                               name="password_confirm" 
                               placeholder="Confirmar contraseña" 
                               required
                               autocomplete="new-password">
                        <i class="fas fa-eye password-toggle" id="togglePasswordConfirm"></i>
                    </div>

                    <button type="submit" class="btn btn-reset" id="submitBtn" disabled>
                        <i class="fas fa-save"></i> Guardar Nueva Contraseña
                    </button>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        const password = document.getElementById('password');
        const passwordConfirm = document.getElementById('password_confirm');
        const submitBtn = document.getElementById('submitBtn');
        const strengthBar = document.getElementById('strengthBar');

        // Toggle password visibility
        document.getElementById('togglePassword').addEventListener('click', function() {
            togglePasswordVisibility(password, this);
        });

        document.getElementById('togglePasswordConfirm').addEventListener('click', function() {
            togglePasswordVisibility(passwordConfirm, this);
        });

        function togglePasswordVisibility(input, icon) {
            const type = input.getAttribute('type') === 'password' ? 'text' : 'password';
            input.setAttribute('type', type);
            icon.classList.toggle('fa-eye');
            icon.classList.toggle('fa-eye-slash');
        }

        // Validar contraseña en tiempo real
        password.addEventListener('input', function() {
            const value = this.value;
            
            // Verificar requisitos
            const length = value.length >= 8;
            const uppercase = /[A-Z]/.test(value);
            const lowercase = /[a-z]/.test(value);
            const number = /[0-9]/.test(value);
            const special = /[!@#$%^&*(),.?":{}|<>]/.test(value);

            updateRequirement('req-length', length);
            updateRequirement('req-uppercase', uppercase);
            updateRequirement('req-lowercase', lowercase);
            updateRequirement('req-number', number);
            updateRequirement('req-special', special);

            // Calcular fortaleza
            const met = [length, uppercase, lowercase, number, special].filter(Boolean).length;
            strengthBar.className = 'password-strength-bar';
            if (met <= 2) strengthBar.classList.add('strength-weak');
            else if (met <= 4) strengthBar.classList.add('strength-medium');
            else strengthBar.classList.add('strength-strong');

            // Validar
            const allMet = length && uppercase && lowercase && number && special;
            this.classList.toggle('is-valid', allMet);
            this.classList.toggle('is-invalid', value.length > 0 && !allMet);

            validateForm();
        });

        passwordConfirm.addEventListener('input', function() {
            const match = this.value === password.value;
            this.classList.toggle('is-valid', match && this.value.length > 0);
            this.classList.toggle('is-invalid', !match && this.value.length > 0);
            validateForm();
        });

        function updateRequirement(id, met) {
            const el = document.getElementById(id);
            const icon = el.querySelector('i');
            
            if (met) {
                el.classList.add('met');
                icon.className = 'fas fa-check-circle';
            } else {
                el.classList.remove('met');
                icon.className = 'fas fa-times-circle';
            }
        }

        function validateForm() {
            const passwordValid = password.classList.contains('is-valid');
            const confirmValid = passwordConfirm.classList.contains('is-valid');
            submitBtn.disabled = !(passwordValid && confirmValid);
        }

        document.getElementById('resetForm').addEventListener('submit', function(e) {
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Guardando...';
        });
    </script>
</body>
</html>