<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sistema de Cotizaciones</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
    body {
        background: linear-gradient(135deg, #01315B 0%, #025A9E 100%);
        min-height: 100vh;
        display: flex;
        align-items: center;
        justify-content: center;
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }
    .login-container {
        max-width: 450px;
        width: 100%;
        padding: 20px;
    }
    .login-card {
        background: #ffffff;
        border-radius: 20px;
        box-shadow: 0 10px 40px rgba(0, 0, 0, 0.15);
        overflow: hidden;
    }
    .login-header {
        background: linear-gradient(135deg, #01315B 0%, #025A9E 100%);
        color: white;
        padding: 40px 30px;
        text-align: center;
    }
    .login-header h2 {
        margin: 0;
        font-size: 28px;
        font-weight: 700;
        letter-spacing: 1px;
    }
    .login-header p {
        margin-top: 8px;
        opacity: 0.9;
        font-size: 14px;
    }
    .login-body {
        padding: 40px 30px;
    }
    .form-control {
        height: 50px;
        border-radius: 10px;
        border: 2px solid #e0e0e0;
        padding-left: 45px;
        font-size: 15px;
        transition: all 0.3s ease;
    }
    .form-control:focus {
        border-color: #25D366;
        box-shadow: 0 0 0 0.2rem rgba(37, 211, 102, 0.15);
    }
    .input-group {
        position: relative;
        margin-bottom: 25px;
    }
    .input-icon {
        position: absolute;
        left: 15px;
        top: 50%;
        transform: translateY(-50%);
        color: #999;
        z-index: 10;
        font-size: 18px;
    }
    .btn-login {
        width: 100%;
        height: 50px;
        background: linear-gradient(135deg, #25D366 0%, #1EBE5B 100%);
        border: none;
        border-radius: 10px;
        color: white;
        font-size: 16px;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s;
        text-transform: uppercase;
        letter-spacing: 1px;
    }
    .btn-login:hover {
        transform: translateY(-2px);
        box-shadow: 0 5px 15px rgba(37, 211, 102, 0.4);
    }
    .forgot-password {
        text-align: center;
        margin-top: 20px;
    }
    .forgot-password a {
        color: #01315B;
        text-decoration: none;
        font-size: 14px;
        transition: all 0.3s;
    }
    .forgot-password a:hover {
        color: #025A9E;
        text-decoration: underline;
    }
    .alert {
        border-radius: 10px;
        border: none;
        margin-bottom: 20px;
    }
    .alert-danger {
        background: #FEECEC;
        color: #B91C1C;
    }
    .alert-success {
        background: #E8FCEE;
        color: #0F9D58;
    }
    .password-toggle {
        position: absolute;
        right: 15px;
        top: 50%;
        transform: translateY(-50%);
        cursor: pointer;
        color: #999;
        z-index: 10;
        font-size: 18px;
    }
    .security-info {
        background: #F5F7FA;
        border-radius: 10px;
        padding: 15px;
        margin-top: 20px;
        font-size: 12px;
        color: #555;
        border-left: 4px solid #25D366;
    }
    .security-info i {
        color: #25D366;
        margin-right: 6px;
    }
</style>

</head>
<body>
    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <h2>RAASMEX</h2>
                <p>Sistema de Cotizaciones</p>
            </div>
            <div class="login-body">
                <?php if($this->session->flashdata('error')): ?>
                    <div class="alert alert-danger alert-dismissible fade show">
                        <i class="fas fa-exclamation-circle"></i>
                        <?= $this->session->flashdata('error') ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <?php if($this->session->flashdata('success')): ?>
                    <div class="alert alert-success alert-dismissible fade show">
                        <i class="fas fa-check-circle"></i>
                        <?= $this->session->flashdata('success') ?>
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <form action="<?= base_url('index.php/auth/login') ?>" method="POST" id="loginForm">
                    <input type="hidden" name="<?=$this->security->get_csrf_token_name();?>" value="<?=$this->security->get_csrf_hash();?>" />
                    
                    <div class="input-group">
                        <i class="fas fa-user input-icon"></i>
                        <input type="text" 
                               class="form-control" 
                               name="username" 
                               placeholder="Usuario o Email" 
                               required 
                               autocomplete="username"
                               autofocus>
                    </div>

                    <div class="input-group">
                        <i class="fas fa-lock input-icon"></i>
                        <input type="password" 
                               class="form-control" 
                               id="password" 
                               name="password" 
                               placeholder="Contraseña" 
                               required
                               autocomplete="current-password">
                        <i class="fas fa-eye password-toggle" id="togglePassword"></i>
                    </div>

                    <button type="submit" class="btn btn-login">
                        <i class="fas fa-sign-in-alt"></i> Iniciar Sesión
                    </button>
                </form>

                <!-- <div class="forgot-password">
                    <a href="<?= base_url('auth/recuperar') ?>">
                        <i class="fas fa-key"></i> ¿Olvidaste tu contraseña?
                    </a>
                </div> -->

                <div class="security-info">
                    <i class="fas fa-shield-alt"></i> Conexión segura cifrada<br>
                    <i class="fas fa-lock"></i> Tus datos están protegidos
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Toggle password visibility
        const togglePassword = document.getElementById('togglePassword');
        const password = document.getElementById('password');

        togglePassword.addEventListener('click', function() {
            const type = password.getAttribute('type') === 'password' ? 'text' : 'password';
            password.setAttribute('type', type);
            
            this.classList.toggle('fa-eye');
            this.classList.toggle('fa-eye-slash');
        });

        // Prevenir múltiples envíos del formulario
        const loginForm = document.getElementById('loginForm');
        loginForm.addEventListener('submit', function(e) {
            const submitBtn = this.querySelector('button[type="submit"]');
            submitBtn.disabled = true;
            submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Verificando...';
        });

        // Auto-dismiss alerts después de 5 segundos
        setTimeout(function() {
            const alerts = document.querySelectorAll('.alert');
            alerts.forEach(function(alert) {
                const bsAlert = new bootstrap.Alert(alert);
                bsAlert.close();
            });
        }, 5000);
    </script>
</body>
</html>