<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cotizacion_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function get_all() {
        $this->db->select('cotizaciones.*, clientes.nombre as cliente_nombre, clientes.empresa');
        $this->db->from('cotizaciones');
        $this->db->join('clientes', 'cotizaciones.cliente_id = clientes.id');
        $this->db->order_by('cotizaciones.created_at', 'DESC');
        return $this->db->get()->result();
    }

    public function get_by_id($id) {
        $this->db->select('cotizaciones.*, clientes.nombre, clientes.empresa, clientes.email, clientes.telefono, clientes.direccion, clientes.rfc, clientes.cargo');
        $this->db->from('cotizaciones');
        $this->db->join('clientes', 'cotizaciones.cliente_id = clientes.id');
        $this->db->where('cotizaciones.id', $id);
        return $this->db->get()->row();
    }

    public function get_items($cotizacion_id) {
        $this->db->where('cotizacion_id', $cotizacion_id);
        $this->db->order_by('orden', 'ASC');
        return $this->db->get('cotizacion_items')->result();
    }

    public function insert($data) {
        $this->db->insert('cotizaciones', $data);
        return $this->db->insert_id();
    }

    public function insert_item($data) {
        return $this->db->insert('cotizacion_items', $data);
    }

    public function update($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('cotizaciones', $data);
    }

    public function delete($id) {
        return $this->db->delete('cotizaciones', array('id' => $id));
    }

    public function delete_items($cotizacion_id) {
        return $this->db->delete('cotizacion_items', array('cotizacion_id' => $cotizacion_id));
    }

    public function generate_numero() {
        $this->db->select('numero');
        $this->db->order_by('id', 'DESC');
        $this->db->limit(1);
        $last = $this->db->get('cotizaciones')->row();
        
        if ($last) {
            $num = intval($last->numero) + 1;
        } else {
            $num = 1;
        }
        
        return str_pad($num, 3, '0', STR_PAD_LEFT);
    }
}