<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Cliente_model extends CI_Model {

    public function __construct() {
        parent::__construct();
        $this->load->database();
    }

    public function get_all() {
        return $this->db->get('clientes')->result();
    }

    public function get_by_id($id) {
        return $this->db->get_where('clientes', array('id' => $id))->row();
    }

    public function insert($data) {
        $this->db->insert('clientes', $data);
        return $this->db->insert_id();
    }

    public function update($id, $data) {
        $this->db->where('id', $id);
        return $this->db->update('clientes', $data);
    }

    public function delete($id) {
        return $this->db->delete('clientes', array('id' => $id));
    }

    public function search($search) {
        $this->db->like('nombre', $search);
        $this->db->or_like('empresa', $search);
        $this->db->or_like('email', $search);
        return $this->db->get('clientes')->result();
    }
}
