<div class="row" id="subir">

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-md-12" style="display: grid; grid-template-columns: 1fr 1fr">
        <h1 class="page-header"><i class="fa-solid fa-users-between-lines"></i><strong> Postulaciones</strong> | 
        <span style="font-size: 1.2vw"><?=$vacante->nombre?></span></h1>

        <button class="btn" style="background-color: #1d70b6; color: white; align-self: center; justify-self: end;" onclick="window.history.back();">
            <i class="fa-regular fa-hand-point-left"></i> Regresar
        </button>
    </div>
    <div class="col-md-12" style="margin-top: 2em;">
        <table class="table table-responsive table-striped" id="tabla_postulaciones">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Candidato</th>
                    <th>Celular</th>
                    <th>Fecha postulación</th>
                    <th>Viable</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody id="tbody_postulaciones">
                <?php
                if (!is_null($postulaciones)) {

                    $cont = 1;

                    foreach ($postulaciones as $postulacion) {

                        if ($postulacion->es_viable == 1) {
                            $viable  = "<h4><span class='label label-success'>Viable</span></h4>";
                        }/*else if ($postulacion->es_viable == 0) {
                            $viable  = "<h4><span class='label label-warning'>Sin evaluar</span></h4>";
                        }*/else{
                            $viable  = "<h4><span class='label label-danger'>No viable</span></h4>";
                        }

                        if(is_null($postulacion->id_reclutador) || $postulacion->id_reclutador == 0){
                            $reclutador = "No llegó por QR";
                        }else{
                            $reclutador = $postulacion->nombre_reclutador;
                        }
                        ?>

                        <tr>
                            <td><?=$cont;?></td>
                            <td><?=$postulacion->nombre_candidato;?></td>
                            <td><?=$postulacion->celular_candidato;?></td>
                            <td><?=$postulacion->fecha_postulacion;?></td> 
                            <td><?=$viable;?></td> 
                            <td>
                                <button class="btn verPreguntas" style="background-color: #1d70b6; color: white;" data-vacante="<?=$postulacion->id_vacante?>"
                                data-candidato="<?=$postulacion->id_candidato?>">
                                    <i class="fa-solid fa-clipboard-question"></i> Preguntas
                                </button>
                            </td> 
                        </tr>
                            
                    <?php $cont++;

                    }

                 } 
                 ?>
                
            </tbody>
        </table>

    </div>
    
</div>

<!-- Modal preguntas -->
<div class="modal fade" id="preguntasModal" tabindex="-1" role="dialog" aria-labelledby="preguntasModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h3 class="modal-title" id="preguntasModalLabel" style="color: white; font-weight: bold;">Preguntas</h3>
      </div>
      <div class="modal-body">
        <div class="row">
            <div class="contenedor col-md-12">
              
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn" data-dismiss="modal" style="background-color: #3f5364; color: white;">
        <i class="fa-solid fa-rectangle-xmark"></i> Cerrar
        </button>
      </div>
    </div>
  </div>
</div>


<style type="text/css">

    a:hover,a:focus{
    text-decoration: none;
    outline: none;
    }

    #accordion .panel{
        border: none;
        box-shadow: none;
        border-radius: 30px;
        margin-bottom: 15px;
    }
    #accordion .panel-heading{
        padding: 0;
        border-radius: 30px;
    }
    #accordion .panel-title a{
        display: block;
        padding: 12px 20px 12px 50px;
        background: #3f536430;
        font-size: 14px;
        font-weight: 600;
        color: #1d70b6;
        border: none;
        border-radius: 30px;
        position: relative;
        transition: all 0.3s ease 0s;
    }
    #accordion .panel-title a.collapsed{ color: #3f5364; }
    #accordion .panel-title a:after,
    #accordion .panel-title a.collapsed:after{
        content: "\f107";
        font-family: "Font Awesome 5 Free";
        font-weight: 900;
        width: 45px;
        height: 45px;
        line-height: 50px;
        border-radius: 50%;
        background: #1d70b6;
        font-size: 25px;
        color: #fff;
        text-align: center;
        position: absolute;
        top: -0.3rem;
        left: 0;
        transition: all 0.3s ease 0s;
    }
    #accordion .panel-title a.collapsed:after{ content: "\f105"; }
    #accordion .panel-body{
        padding: 20px 0 0 0;
        font-size: 14px;
        color: #3f5364;
        line-height: 25px;
        border-top: none;
        position: relative;
    }
    #accordion .panel-body p{
        padding: 10px 20px 10px;
        margin: 0;
        background: #3f536430;
        border-radius: 15px;
    }


    @media(max-width:1300px){
        .postuladosV {
            margin-top: 0.5rem;
        }
    }

    @media(max-width:750px){
        #divFiltro {
            display: grid;
            grid-template-columns: 1fr 1fr;
        }
    }


</style>


<script type="text/javascript" src="<?=base_url();?>public/js/jquery.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="<?php echo base_url('public/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('public/dataTables.bootstrap.js')?>"></script>
<script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.4.2/css/buttons.dataTables.min.css">
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<script type="text/javascript">
    jQuery(document).ready(function($){

        var tabla = $('#tabla_postulaciones').DataTable( {
            dom: "<'top-btns'<'col-md-2 col-sm-2 col-xs-6 'B> <'col-md-10 col-sm-10 col-xs-10 '<'col-md-6 col-sm-6 col-xs-6 'l><'col-md-6 col-sm-6 col-xs-6 'f>>>"+ "<br/>" +
            "<'top'<'col-md-12 table-date scroll-x'tr>>" +
            "<'top'<'col-md-4'i><'col-md-7'p>>",
            oLanguage: {
                "sSearch": "Buscar: ",
                "sInfo" : "Mostrando del _START_ al _END_ de _TOTAL_ registros totales",
                "sLengthMenu": "Mostrando _MENU_ entradas",
            },
            buttons: [
                {
                    text: '<i class="fa-solid fa-file-excel"></i> Excel',
                    className: 'btn btn-primary',
                    action: function (e, dt, node, config) {
                        const urlExcel = '<?php echo base_url(); ?>index.php/generarExcelPostulaciones?idV=<?php echo base64_encode($idVacante); ?>';

                        // Deshabilitar botón
                        $(node).prop('disabled', true).addClass('disabled');

                        // Crear iframe oculto para forzar descarga sin bloquear redirección
                        const iframe = $('<iframe>', {
                            src: urlExcel,
                            style: 'display: none;'
                        }).appendTo('body');

                        // Rehabilitar el botón después de 5 segundos
                        setTimeout(function () {
                            $(node).prop('disabled', false).removeClass('disabled');
                        }, 5000);

                    }
                }
            ]
        });

        let $rows    = $('#tbody_postulaciones tr');
        let sinDatos = $rows.length === 1 && $rows.first().find('td').text().includes('No data available');

        if (sinDatos) {
            // Deshabilita el botón de Excel (basado en btn-primary)
            $('.dt-buttons .btn-primary')
                .addClass('disabled') // clase visual
                .css('pointer-events', 'none') // evita que hagan click
                .attr('title', 'No hay postulaciones para exportar');
        }

        $("#tabla_postulaciones").css("margin-top", "1em");
        $("#tabla_postulaciones_info").css("margin-top", "2em");
        $("#tabla_postulaciones_paginate").css("margin-top", "2em");
        $("#tabla_postulaciones_previous").find( "a" ).html("Anterior");
        $("#tabla_postulaciones_next").find( "a" ).html("Siguiente");

        $(document).on('click', '.paginate_button', function(){

            $("#tabla_postulaciones_previous").find( "a" ).html("Anterior");
            $("#tabla_postulaciones_next").find( "a" ).html("Siguiente");

        });
        
        $(document).on('click', '.verPreguntas', function(){

            var idVacante   = $(this).attr("data-vacante");
            var idCandidato = $(this).attr("data-candidato");

            getPreguntas(idVacante, idCandidato);

        });

    });//termina jQuery

    function getPreguntas(idVacante, idCandidato){

        $.ajax({
            url: "<?php echo base_url();?>index.php/respuestasCandidato",
            type : "POST",
            dataType : "json",
            data :{"idVacante" : idVacante, "idCandidato" : idCandidato},
            success : function(response){

                $(".contenedor").html(response.preguntas);

                $("#preguntasModal").modal("show");
            }
        });

    }//termina getPreguntas


    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }//termina mostrarLoader

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }//termina ocultarLoader
   
</script>