<div class="row">

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-md-12" style="display: grid; grid-template-columns: 1fr 1fr; margin-top: -1rem;">
        <h1 class="page-header"><i class="fa-solid fa-users-between-lines"></i> <strong> Sucursales</strong></h1>
        <button type="button" class="btn agregar" style="margin-top: 3.2rem; align-self: center; justify-self: end; background-color: #1d70b6; color: white;">
        <i class="fa-solid fa-circle-plus"></i> Agregar sucursal</button>
    </div>

    <div class="col-md-12">
        <br>
        <table class="table table-responsive table-striped" id="tabla_clientes">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Sucursal</th>
                    <th>Fecha registro</th>
                    <th>Estatus</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php
                if (!is_null($sucursales)) {

                    $cont = 1;
                    foreach ($sucursales as $s) {

                        if ($s->estatus_sucursal == 1) {
                            $estatus = "<h4><span class='label label-success'>Activo</span></h4>";
                        }else{
                            $estatus = "<h4><span class='label label-danger'>Inactivo</span></h4>";
                        }

                        $idCliente = base64_encode($s->id_sucursal);

                        ?>

                        <tr>
                            <td><?=$cont; ?></td>
                            <td><?=$s->nombre_sucursal;?></td>
                            <td><?=$s->fecha_registro?></td>
                            <td><?=$estatus; ?></td>
                            <td>
                                <button class="update btn" data-id="<?=$s->id_sucursal; ?>" style="width: 110px; background-color: #db343b; 
                                color: white;">
                                    <i class="fa-solid fa-pen-to-square"></i> Actualizar</button><br>
                            </td>
                        </tr>
                            
                    <?php $cont++;

                    }

                 } 
                 ?>
                
            </tbody>
        </table>
    </div>
</div>

<!-- The Modal agregar sucursal-->
<div class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" id="modal_agregar" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>Agregar sucursal</b></h3>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Sucursal:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <input type="text" class="form-control" placeholder="Ingresa la sucursal" id="sucursal" name="sucursal" required="">
                        </div>  
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Estatus:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <select class="form-control" id="estatus" style="cursor: pointer;">
                                <option value="1">Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>  
                    </div>
                </div>
            </div>
            <!-- Modal footer -->
            <div class="modal-footer">
                <button id="cerrarModal" type="button" class="btn" data-dismiss="modal" style="background-color: #1d70b6; color: white;">
                    <i class="fa-solid fa-xmark"></i> Cerrar</button>
                <button class="btn guardar" style="background-color: #db343b; color: white;">
                    <i class="fa-solid fa-floppy-disk"></i>  Guardar</button>
            </div>
        </div>
    </div>
</div>
<!--Termina modal Agregar -->

<!-- The Modal actualizar-->
<div class="modal fade" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" id="modal_editar" data-backdrop="static" data-keyboard="false">
    <div class="modal-dialog">
        <div class="modal-content">
            <!-- Modal Header -->
            <div class="modal-header">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>Actualizar sucursal</b></h3>
            </div>
            <!-- Modal body -->
            <div class="modal-body">
                <div class="row">
                    <input type="hidden" id="idSucursal">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Sucursal:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <input type="text" class="form-control" placeholder="Ingresa la sucursal" id="sucursal_update" name="sucursal_update" required="">
                        </div>  
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for="cveprodep" class="control-label">
                                Estatus:
                                <i class="text-danger fa fa-asterisk"> </i> 
                            </label>
                            <select class="form-control" id="estatus_update">
                                <option value="1">Activo</option>
                                <option value="0">Inactivo</option>
                            </select>
                        </div>  
                    </div>
                </div>
            </div>
            <!-- Modal footer -->
            <div class="modal-footer">
                <button type="button" class="btn" data-dismiss="modal" style="background-color: #1d70b6; color: white;">    
                    <i class="fa-solid fa-xmark"></i> Cerrar</button>
                <button class="btn actualizar" style="background-color: #db343b; color: white;">
                    <i class="fa-solid fa-floppy-disk"></i>  Guardar</button>
            </div>
        </div>
    </div>
</div>
<!--Termina modal Editar -->


<script type="text/javascript" src="<?=base_url();?>public/js/jquery.js"></script>
<!-- <script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script> -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo base_url('public/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('public/dataTables.bootstrap.js')?>"></script>
<script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.4.2/css/buttons.dataTables.min.css">
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.css">
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-confirm/3.3.2/jquery-confirm.min.js"></script>

<script type="text/javascript">
    jQuery(document).ready(function($){

        ocultarLoader();

        var tabla = $('#tabla_clientes').DataTable( {
            dom: "<'top-btns'<'col-md-2 col-sm-2 col-xs-6 'B> <'col-md-10 col-sm-10 col-xs-10 '<'col-md-6 col-sm-6 col-xs-6 'l><'col-md-6 col-sm-6 col-xs-6 'f>>>"+ "<br/>" +
            "<'top'<'col-md-12 table-date scroll-x'tr>>" +
            "<'top'<'col-md-4'i><'col-md-7'p>>",
            oLanguage: { 
                "sSearch": "Buscar: ",
                "sInfo" : "Mostrando del _START_ al _END_ de _TOTAL_ registros totales",
                "sLengthMenu": "Mostrando _MENU_ entradas",
            },
            buttons: [
                {
                    text: '<i class="fa-solid fa-file-excel"></i> Excel',
                    extend: 'excelHtml5', 
                    className : 'btn btn-primary',
                    exportOptions: {
                        columns: [0, 1, 2, 3]
                    }
                }
            ]
        });

        $("#tabla_clientes").css("margin-top", "1em");
        $("#tabla_clientes_info").css("margin-top", "2em");
        $("#tabla_clientes_paginate").css("margin-top", "2em");
        $("#tabla_clientes_previous").find( "a" ).html("Anterior");
        $("#tabla_clientes_next").find( "a" ).html("Siguiente");

        $(document).on('click', '.paginate_button', function(){

            $("#tabla_clientes_previous").find( "a" ).html("Anterior");
            $("#tabla_clientes_next").find( "a" ).html("Siguiente");

        });

        $('#cerrarModal').click(function() {

            $("#cliente").val("");
            $("#estatus").val("1");
        });

        $(document).on('click', '.agregar', function(event) {
            $("#modal_agregar").modal("show");
        });

        $(document).on('click', '.guardar', function(){

            var sucursal     = $("#sucursal").val().trim();
            var estatus      = $("#estatus").val();

            if (validar(sucursal)) {
                mostrarLoader();
                agregarSucursal(sucursal, estatus);            
            }
        });

        $(document).on('click', '.actualizar', function(){

            var sucursal     = $("#sucursal_update").val().trim();
            var estatus      = $("#estatus_update").val();

            if (validarUpdate(sucursal)) {
                mostrarLoader();
                updateSucursal(sucursal, estatus);
            }
        });

        $(document).on('click', '.update', function(){
        
            var idSucursal = $(this).attr('data-id');
        
            $("#idSucursal").val(idSucursal);

            getSucursal(idSucursal);

            $("#modal_editar").modal("show");
        });


    });//termina jQuery

    function getSucursal(idSucursal){
        $.ajax({
            url : "<?php echo base_url();?>index.php/getSucursal",
            type : "POST",
            dataType : "json",
            data :{"idSucursal" : idSucursal},
            success : function(result){

                $("#sucursal_update").val(result.datos.nombre_sucursal);
                $("#estatus_update").val(result.datos.estatus_sucursal);

            }
        });
    }//termina getSucursal
    
    function agregarSucursal(sucursal, estatus) {
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/agregarSucursal",
            type : "POST",
            dataType : "json",
            data :{"sucursal": sucursal, "estatus" : estatus},
            success : function(response){

                if(response.regreso == 200){
                    Swal.fire({
                        title: "¡Agregada con éxito!",
                        text: response.mensaje,
                        icon: "success"
                    });
                    setTimeout(function(){
                        location. reload();
                    }, 2500);
                }else{
                    Swal.fire({
                        title: "¡Atención!",
                        text: response.mensaje,
                        icon: "info"
                    });
                }

                setTimeout(ocultarLoader, 1000);
            }
        });
    }//termina agregarSucursal

    function updateSucursal(sucursal, estatus){
        
        var idSucursal = $("#idSucursal").val();

        $.ajax({
            url : "<?php echo base_url();?>index.php/actualizarSucursal",
            type : "POST",
            dataType : "json",
            data :{"sucursal": sucursal, "idSucursal" : idSucursal, "estatus" : estatus},
            success : function(response){

                if(response.respuesta == 200){
                    Swal.fire({
                        title: "¡Actualizado con éxito!",
                        text: response.mensaje,
                        icon: "success"
                    });
                    setTimeout(function(){
                        location. reload();
                    }, 2500);
                }else{
                    Swal.fire({
                        title: "¡Atención!",
                        text: response.mensaje,
                        icon: "info"
                    });
                }

                setTimeout(ocultarLoader, 1000);
                
            }
        });

    }//termina updateSucursal

    function validar(sucursal) {
        
        var regreso = true;

        if (sucursal == "") {
            regreso = false;
            Swal.fire({
                title: "¡Atención!",
                text: "Por favor ingresa la sucursal",
                icon: "warning"
            });
        }

        return regreso;
    }//termina validar

    function validarUpdate(sucursal) {
        
        var regreso = true;

        if (sucursal == "") {
            regreso = false;
            Swal.fire({
                title: "¡Atención!",
                text: "Por favor ingresa la sucursal",
                icon: "warning"
            });
        }

        return regreso;
    }//termina validarUpdate

    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }

</script>