<div class="row" id="subir">

    <?php 

        $session 	= session();
        $tipo 		= $session->get('id_tipo_usuario');
        $idUsuario	= $session->get('id_usuario');
    
    ?>

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-md-12">
        <h1 class="page-header"><i class="fa-solid fa-user-tie fa-xl"></i><strong> Candidatos</strong></h1>
    </div>

    <div class="col-md-4">
            <div class="form-group">
                <label>
                    Filtrar por fecha:
                </label>
                <input type="text" name="dates" id="rango" class="form-control" />
            </div>
    </div>

    <div class="col-md-12" style="margin-top: 2em;">
        <table class="table table-responsive table-striped" id="tabla_candidatos">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Nombre</th>
                    <th style="text-align: center;">Celular</th>
                    <th style="text-align: center;">Fecha postulación</th>
                    <th>Reclutador</th>
                    <th>Vacante</th>
                    <!-- <th style="text-align: center;">Viable</th> -->
                    <th style="text-align: center;">Acciones</th>
                </tr>
            </thead>
            <tbody id="tbody_candidatos">
                <?php
                if (!is_null($candidatos)) {

                    $cont  = 1;

                    foreach ($candidatos as $candidato) {

                        $idCandidato = base64_encode($candidato->id_candidato);

                        if ($candidato->es_viable == 1) {
                            $viable  = "<h4><span class='label label-success'>Viable</span></h4>";
                        }else{
                            $viable  = "<h4><span class='label label-danger'>No viable</span></h4>";
                        }

                        if(is_null($candidato->id_reclutador) || $candidato->id_reclutador == 0){
                            $reclutador = "No llegó por QR de reclutador";
                        }else{
                            $reclutador = $candidato->nombre_reclutador;
                        }


                        ?>

                        <tr>
                            <td><?=$cont;?></td>
                            <td><?=$candidato->nombre_candidato;?></td>
                            <td style="text-align: center;">(+<?=substr($candidato->celular_candidato, 0, -10)?>) <?=substr($candidato->celular_candidato, -10)?></td>
                            <td style="text-align: center;"><?=$candidato->fecha_postulacion?></td>
                            <td><?=$reclutador?></td>
                            <td><?=$candidato->nombre?></td>
                            <!-- <td style="text-align: center;"><?=$viable?></td> -->
                            <td style="text-align: center;">
                                <!-- <button class="btn verPreguntas" style="background-color: #29265b; color: white; width: 130px;" data-vacante="<?=$candidato->id_vacante?>"
                                data-candidato="<?=$candidato->id_candidato?>">
                                    <i class="fa-solid fa-clipboard-question"></i> Preguntas
                                </button><br> -->
                                <a class="btn" href="https://api.whatsapp.com/send?phone=<?=$candidato->celular_candidato?>&amp;text=Hola <?=$candidato->nombre_candidato?>"
                                target="_blank" title="Comienza a Chatear" style="background-color: #03E676; color: #FFF; width: 130px;
                                margin-top: 0.5rem;">
                                    <i class="fa-brands fa-whatsapp"></i> Chatear</a><br>
                                <?php 
                                    if(!is_null($candidato->cv_candidato)){
                                ?>
                                <a class="btn" style="background-color: #29265b; color: white; margin-top: 0.5rem; width: 130px;" 
                                    href="<?=$candidato->cv_candidato?>" target="_blank">
                                    <i class="fa-solid fa-file-contract"></i> CV
                                </a>
                                <?php } ?>
                            </td> 
                        </tr>
                            
                    <?php $cont++;

                    }

                 } 
                 ?>
                
            </tbody>
        </table>

    </div>
    
</div>

<!-- Modal preguntas -->
<div class="modal fade" id="preguntasModal" tabindex="-1" role="dialog" aria-labelledby="preguntasModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h3 class="modal-title" id="preguntasModalLabel" style="color: white; font-weight: bold;">Preguntas</h3>
      </div>
      <div class="modal-body">
        <div class="row">
            <div class="contenedor col-md-12">
              
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn" data-dismiss="modal" style="background-color: #3f5364; color: white;">
        <i class="fa-solid fa-rectangle-xmark"></i> Cerrar
        </button>
      </div>
    </div>
  </div>
</div>


<input type="hidden" id="id_vacante"/>
<input type="hidden" id="imagen_url"/>


<style type="text/css">

    a.btn-postulate {
        background-color: #03E676;
        color: #FFF;
        padding: 5px 10px;
        border-radius: 15px;
    }

    #accordion .panel{
        border: none;
        box-shadow: none;
        border-radius: 30px;
        margin-bottom: 15px;
    }
    #accordion .panel-heading{
        padding: 0;
        border-radius: 30px;
    }
    #accordion .panel-title a{
        display: block;
        padding: 12px 20px 12px 50px;
        background: #3f536430;
        font-size: 14px;
        font-weight: 600;
        color: #1d70b6;
        border: none;
        border-radius: 30px;
        position: relative;
        transition: all 0.3s ease 0s;
    }
    #accordion .panel-title a.collapsed{ color: #3f5364; }
    #accordion .panel-title a:after,
    #accordion .panel-title a.collapsed:after{
        content: "\f107";
        font-family: "Font Awesome 5 Free";
        font-weight: 900;
        width: 45px;
        height: 45px;
        line-height: 50px;
        border-radius: 50%;
        background: #1d70b6;
        font-size: 25px;
        color: #fff;
        text-align: center;
        position: absolute;
        top: -0.3rem;
        left: 0;
        transition: all 0.3s ease 0s;
    }
    #accordion .panel-title a.collapsed:after{ content: "\f105"; }
    #accordion .panel-body{
        padding: 20px 0 0 0;
        font-size: 14px;
        color: #3f5364;
        line-height: 25px;
        border-top: none;
        position: relative;
    }
    #accordion .panel-body p{
        padding: 10px 20px 10px;
        margin: 0;
        background: #3f536430;
        border-radius: 15px;
    }
#accordion .panel.panel-default.panel-descarte {
    border: 2px solid red !important;
    box-shadow: 0 0 8px red !important;
}

</style>


<script type="text/javascript" src="<?=base_url();?>public/js/jquery.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="<?php echo base_url('public/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('public/dataTables.bootstrap.js')?>"></script>
<script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.4.2/css/buttons.dataTables.min.css">
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<script type="text/javascript">
    jQuery(document).ready(function($){

        var tabla = $('#tabla_candidatos').DataTable( {
            dom: "<'top-btns'<'col-md-2 col-sm-2 col-xs-6 'B> <'col-md-10 col-sm-10 col-xs-10 '<'col-md-6 col-sm-6 col-xs-6 'l><'col-md-6 col-sm-6 col-xs-6 'f>>>"+ "<br/>" +
            "<'top'<'col-md-12 table-date scroll-x'tr>>" +
            "<'top'<'col-md-4'i><'col-md-7'p>>",
            oLanguage: {
                "sSearch": "Buscar: ",
                "sInfo" : "Mostrando del _START_ al _END_ de _TOTAL_ registros totales",
                "sLengthMenu": "Mostrando _MENU_ entradas",
            },
            buttons: [
                {
                    text: '<i class="fa-solid fa-file-excel"></i> Excel',
                    extend: 'excelHtml5',
                    className : 'btn btn-primary',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5]
                    }
                }
            ]
        });

        $("#tabla_candidatos").css("margin-top", "1em");
        $("#tabla_candidatos_info").css("margin-top", "2em");
        $("#tabla_candidatos_paginate").css("margin-top", "2em");
        $("#tabla_candidatos_previous").find( "a" ).html("Anterior");
        $("#tabla_candidatos_next").find( "a" ).html("Siguiente");

        $(document).on('click', '.paginate_button', function(){

            $("#tabla_candidatos_previous").find( "a" ).html("Anterior");
            $("#tabla_candidatos_next").find( "a" ).html("Siguiente");

        });

    $('input[name="dates"]').daterangepicker({
        "locale": {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aceptar",
        "cancelLabel": "Cancelar",
        "fromLabel": "From",
        "toLabel": "To",
        "customRangeLabel": "Custom",
        "daysOfWeek": [
            "Dom",
            "Lun",
            "Mar",
            "Mie",
            "Jue",
            "Vie",
            "Sab"
        ],
        "monthNames": [
            "Enero",
            "Febrero",
            "Marzo",
            "Abril",
            "Mayo",
            "Junio",
            "Julio",
            "Agosto",
            "Septiembre",
            "Octubre",
            "Noviembre",
            "Diciembre"
        ],
        "firstDay": 1
        }
    });

    $("#rango").on('apply.daterangepicker', function(ev, picker) {

        var inicio = picker.startDate.format('YYYY-MM-DD');
        var fin    = picker.endDate.format('YYYY-MM-DD');
        mostrarLoader();
        filtrar(inicio, fin);

    });

    $(document).on('click', '.verPreguntas', function(){

        var idVacante   = $(this).attr("data-vacante");
        var idCandidato = $(this).attr("data-candidato");

        getPreguntas(idVacante, idCandidato);

    });



    });//termina jQuery

    function getPreguntas(idVacante, idCandidato){

    $.ajax({
        url: "<?php echo base_url();?>index.php/respuestasCandidato",
        type : "POST",
        dataType : "json",
        data :{"idVacante" : idVacante, "idCandidato" : idCandidato},
        success : function(response){

            $(".contenedor").html(response.preguntas);

            $("#preguntasModal").modal("show");
        }
    });

    }//termina getPreguntas

    function filtrar(inicio, fin) {

        $('#tabla_candidatos').DataTable().destroy();
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/filtrarCandidatos",
            type : "POST",
            dataType : "json",
            data :{"inicio" : inicio, "fin" : fin},
            success : function(response){

                $("#tbody_candidatos").html(response.tabla);

                var tabla = $('#tabla_candidatos').DataTable( {
                dom: "<'top-btns'<'col-md-2 col-sm-2 col-xs-6 'B> <'col-md-10 col-sm-10 col-xs-10 '<'col-md-6 col-sm-6 col-xs-6 'l><'col-md-6 col-sm-6 col-xs-6 'f>>>"+ "<br/>" +
                "<'top'<'col-md-12 table-date scroll-x'tr>>" +
                "<'top'<'col-md-4'i><'col-md-7'p>>",
                oLanguage: {
                    "sSearch": "Buscar: ",
                    "sInfo" : "Mostrando del _START_ al _END_ de _TOTAL_ registros totales",
                    "sLengthMenu": "Mostrando _MENU_ entradas",
                },
                buttons: [
                    {
                        text: '<i class="fa-solid fa-file-excel"></i> Excel',
                        extend: 'excelHtml5',
                        className : 'btn btn-primary',
                        exportOptions: {
                            columns: [0, 1, 2, 3, 4, 5]
                        }
                    }
                ]
                });

                $("#tabla_candidatos").css("margin-top", "1em");
                $("#tabla_candidatos_info").css("margin-top", "2em");
                $("#tabla_candidatos_paginate").css("margin-top", "2em");
                $("#tabla_candidatos_previous").find( "a" ).html("Anterior");
                $("#tabla_candidatos_next").find( "a" ).html("Siguiente");

                $(document).on('click', '.paginate_button', function(){

                    $("#tabla_candidatos_previous").find( "a" ).html("Anterior");
                    $("#tabla_candidatos_next").find( "a" ).html("Siguiente");

                });

                setTimeout(ocultarLoader, 1000);

            }//termina success
        });

    }//termina filtrar


    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }//termina mostrarLoader

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }//termina ocultarLoader
   
</script>