<div class="row" id="subir">

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-md-12">
        <h1 class="page-header"><i class="fa-solid fa-user-xmark"></i><strong> Candidatos sin responder</strong></h1>
    </div>

    <div class="col-md-4">
            <div class="form-group">
                <label>
                    Filtrar por fecha:
                </label>
                <input type="text" name="dates" id="rango" class="form-control" />
            </div>
    </div>

    <div class="col-md-12" style="margin-top: 2em;">
        <table class="table table-responsive table-striped" id="tabla_candidatos">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Nombre</th>
                    <th style="display: none;">Nombre</th>
                    <th>Celular</th>
                    <th>Fecha nacimiento</th>
                    <th>Escolaridad</th>
                    <th>Fecha registro</th>
                    <th style="text-align: center;">Acciones</th>
                </tr>
            </thead>
            <tbody id="tbody_candidatos">
                <?php
                if (!is_null($candidatos)) {

                    $cont  = 1;

                    foreach ($candidatos as $candidato) {

                            $idCandidato = base64_encode($candidato->id_candidato);

                            if (is_null($candidato->nombre_candidato) || $candidato->nombre_candidato == "") {
                                $desc = "N/A";
                            }else {
                                $nombre = $candidato->nombre_candidato;
    
                                $nombre = str_replace('"', '', $nombre);
                                $nombre = str_replace('“', '', $nombre);
                                $nombre = str_replace("'", '', $nombre);
        
                                $cont_desc = strlen($nombre);
                                if($cont_desc > 30){
                                    $desc = substr($nombre,0, 20).'... <a href class="showMensaje"  data-mensaje="'.nl2br($nombre).'">Ver más</a>'; 
                                }else{
                                    $desc = $nombre;
                                }
                            }

                        ?>

                        <tr>
                            <td><?=$cont;?></td>
                            <td><?=$desc ?></td>
                            <td style="display: none;"><?=$candidato->nombre_candidato;?></td>
                            <td>(+<?=substr($candidato->celular_candidato, 0, -10)?>) <?=substr($candidato->celular_candidato, -10)?></td>
                            <td><?=$candidato->fecha_nacimiento?></td>
                            <td><?=$candidato->escolaridad?></td>
                            <td><?=$candidato->fecha_registro?></td>
                            <td style="text-align: center;">
                                <a class="btn" style="background-color: #03E676; color: white; border-radius: 15px;"
                                href="https://api.whatsapp.com/send?phone=<?=$candidato->celular_candidato?>'&amp;text=Hola <?=$candidato->nombre_candidato?>" target="_blank" title="Comienza a Chatear">
                                <i class="fa-brands fa-whatsapp"></i> Chatear
                                </a>
                                <br>
                                <?php 
                                    if(!is_null($candidato->cv_candidato)){
                                ?>
                                <a class="btn" style="background-color: #29265b; color: white; margin-top: 0.5rem; width: 130px;" 
                                    href="<?=$candidato->cv_candidato?>" target="_blank">
                                    <i class="fa-solid fa-file-contract"></i> CV
                                </a>
                                <?php } ?>
                            </td> 
                        </tr>
                            
                    <?php $cont++;

                    }

                 } 
                 ?>
                
            </tbody>
        </table>

    </div>
    
</div>


<input type="hidden" id="id_vacante"/>
<input type="hidden" id="imagen_url"/>

<div class="modal fade"  tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" id="mensaje_modal">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;"><b>Nombre:</b></h3>
            </div>
            <div class="modal-body" id="mensaje_body">

            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Aceptar</button>
            </div>
        </div>
    </div>
</div>


<style type="text/css">

    a.btn-postulate {
        background-color: #03E676;
        color: #FFF;
        padding: 5px 3px;
        border-radius: 15px;
    }

</style>


<script type="text/javascript" src="<?=base_url();?>public/js/jquery.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script src="<?php echo base_url('public/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('public/dataTables.bootstrap.js')?>"></script>
<script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.4.2/css/buttons.dataTables.min.css">
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<script type="text/javascript">
    jQuery(document).ready(function($){

        var tabla = $('#tabla_candidatos').DataTable( {
            dom: "<'top-btns'<'col-md-2 col-sm-2 col-xs-6 'B> <'col-md-10 col-sm-10 col-xs-10 '<'col-md-6 col-sm-6 col-xs-6 'l><'col-md-6 col-sm-6 col-xs-6 'f>>>"+ "<br/>" +
            "<'top'<'col-md-12 table-date scroll-x'tr>>" +
            "<'top'<'col-md-4'i><'col-md-7'p>>",
            oLanguage: {
                "sSearch": "Buscar: ",
                "sInfo" : "Mostrando del _START_ al _END_ de _TOTAL_ registros totales",
                "sLengthMenu": "Mostrando _MENU_ entradas",
            },
            buttons: [
                {
                    text: '<i class="fa-solid fa-file-excel"></i> Excel',
                    extend: 'excelHtml5',
                    className : 'btn btn-primary',
                    exportOptions: {
                        columns: [0, 2, 3, 4, 5, 6]
                    }
                }
            ]
        });

        $("#tabla_candidatos").css("margin-top", "1em");
        $("#tabla_candidatos_info").css("margin-top", "2em");
        $("#tabla_candidatos_paginate").css("margin-top", "2em");
        $("#tabla_candidatos_previous").find( "a" ).html("Anterior");
        $("#tabla_candidatos_next").find( "a" ).html("Siguiente");

        $(document).on('click', '.paginate_button', function(){

            $("#tabla_candidatos_previous").find( "a" ).html("Anterior");
            $("#tabla_candidatos_next").find( "a" ).html("Siguiente");

        });

        $(document).on('click', '.showMensaje', function(){

            event.preventDefault()
            var mensaje = $(this).attr("data-mensaje");

            mensaje     = mensajeConvertido(mensaje); 

            $("#mensaje_body").html(mensaje);
            $("#mensaje_modal").modal("show");

        });

    $('input[name="dates"]').daterangepicker({
        "locale": {
        "format": "DD/MM/YYYY",
        "separator": " - ",
        "applyLabel": "Aceptar",
        "cancelLabel": "Cancelar",
        "fromLabel": "From",
        "toLabel": "To",
        "customRangeLabel": "Custom",
        "daysOfWeek": [
            "Dom",
            "Lun",
            "Mar",
            "Mie",
            "Jue",
            "Vie",
            "Sab"
        ],
        "monthNames": [
            "Enero",
            "Febrero",
            "Marzo",
            "Abril",
            "Mayo",
            "Junio",
            "Julio",
            "Agosto",
            "Septiembre",
            "Octubre",
            "Noviembre",
            "Diciembre"
        ],
        "firstDay": 1
        }
    });

    $("#rango").on('apply.daterangepicker', function(ev, picker) {

        var inicio = picker.startDate.format('YYYY-MM-DD');
        var fin    = picker.endDate.format('YYYY-MM-DD');
        mostrarLoader();
        filtrar(inicio, fin);

    });

    });//termina jQuery

    function filtrar(inicio, fin) {

        $('#tabla_candidatos').DataTable().destroy();
        
        $.ajax({
            url : "<?php echo base_url();?>index.php/filtrarCandidatosSinPostular",
            type : "POST",
            dataType : "json",
            data :{"inicio" : inicio, "fin" : fin},
            success : function(response){

                $("#tbody_candidatos").html(response.tabla);

                var tabla = $('#tabla_candidatos').DataTable( {
                    dom: "<'top-btns'<'col-md-2 col-sm-2 col-xs-6 'B> <'col-md-10 col-sm-10 col-xs-10 '<'col-md-6 col-sm-6 col-xs-6 'l><'col-md-6 col-sm-6 col-xs-6 'f>>>"+ "<br/>" +
                    "<'top'<'col-md-12 table-date scroll-x'tr>>" +
                    "<'top'<'col-md-4'i><'col-md-7'p>>",
                    oLanguage: {
                        "sSearch": "Buscar: ",
                        "sInfo" : "Mostrando del _START_ al _END_ de _TOTAL_ registros totales",
                        "sLengthMenu": "Mostrando _MENU_ entradas",
                    },
                    buttons: [
                        {
                            text: '<i class="fa-solid fa-file-excel"></i> Excel',
                            extend: 'excelHtml5',
                            className : 'btn btn-primary',
                            exportOptions: {
                                columns: [0, 2, 3, 4, 5, 6]
                            }
                        }
                    ]
                });

                $("#tabla_candidatos").css("margin-top", "1em");
                $("#tabla_candidatos_info").css("margin-top", "2em");
                $("#tabla_candidatos_paginate").css("margin-top", "2em");
                $("#tabla_candidatos_previous").find( "a" ).html("Anterior");
                $("#tabla_candidatos_next").find( "a" ).html("Siguiente");

                $(document).on('click', '.paginate_button', function(){

                    $("#tabla_candidatos_previous").find( "a" ).html("Anterior");
                    $("#tabla_candidatos_next").find( "a" ).html("Siguiente");

                });

                setTimeout(ocultarLoader, 1000);

            }//termina success
        });

    }//termina filtrar

    function mensajeConvertido(mensaje){

        var asteriscos      = mensaje.split("*").length - 1;
        var guiones_bajos   = mensaje.split("_").length - 1;
        var tachados        = mensaje.split("~").length - 1;

        if(asteriscos > 0){

            for (let i = 1; i <= asteriscos; i++) {

                if (i%2==0){
                    mensaje = mensaje.replace("*", "</strong>");
                }else{
                    mensaje = mensaje.replace("*", "<strong>");
                }
                
            }

        }

        if(guiones_bajos > 0){

            for (let i = 1; i <= guiones_bajos; i++) {

                if (i%2==0){
                    mensaje = mensaje.replace("_", "</i>");
                }else{
                    mensaje = mensaje.replace("_", "<i>");
                }
                
            }

        }

        if(tachados > 0){

            for (let i = 1; i <= tachados; i++) {

                if (i%2==0){
                    mensaje = mensaje.replace("~", "</span>");
                }else{
                    mensaje = mensaje.replace("~", "<span style='font-size: 14px; text-decoration-line: line-through;'>");
                }
                
            }

        }

        return mensaje;

    }//termina mensajeConvertido

    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }//termina mostrarLoader

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }//termina ocultarLoader
   
</script>