<?php

namespace App\Filters;

use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use CodeIgniter\Filters\FilterInterface;

class RolFilter implements FilterInterface
{
    public function before(RequestInterface $request, $arguments = null)
    {
        $session = session();

        // No actúa si no hay sesión
        if (!$session->has('usuario')) {
            return;
        }

        $usuario = $session->get('usuario');
        $tipo    = $session->get('id_tipo_usuario');

        // Obtener información del controlador actual
        $router     = service('router');
        $controller = ltrim($router->controllerName(), '\\'); // Elimina el \ inicial
        $method     = $router->methodName();      // Ejemplo: index

        // Mapeo de restricciones por tipo de usuario
        $restricciones = [
            2 => [
                'App\Controllers\Admin\Usuarios::index',
                'App\Controllers\Admin\Clientes::index',
                'App\Controllers\Admin\Reclutadores::index',
                'App\Controllers\Admin\Vacantes::index',
                'App\Controllers\Admin\Vacantes::agregar',
                'App\Controllers\Admin\Vacantes::noPostularon',
                'App\Controllers\Admin\Candidatos::candidatosSinResponder',
                'App\Controllers\Admin\Metricas::index',
                // Agrega más métodos restringidos para tipo 2
            ],
            3 => [
                // 'App\Controllers\Admin\Reportes::index',
                // Agrega más métodos restringidos para tipo 3
            ]
        ];

        $claveActual = "{$controller}::{$method}";

        if (isset($restricciones[$tipo]) && in_array($claveActual, $restricciones[$tipo])) {
            return redirect()->to('/Admin/dashboard');
        }
    }

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)
    {
        // No usamos after en este filtro
    }
}