<?php

namespace App\Controllers\Admin;
use App\Controllers\BaseController;
use App\Models\SucursalesModel;

class Sucursales extends BaseController {
	
	private $SucursalesModel; //Nombre de la variable para el modelo 
    protected $session;
	private $encrypter;

    public function __construct(){
        
        $this->SucursalesModel = new SucursalesModel(); // modelo a usar
        $this->session = session();

    }//termina __construct

	public function index(){

		$data                = array();
		$data["_APP_TITTLE"] = "Sucursales";
		$data["_TAB"]        = "sucursales";
		$data["sucursales"]  = $this->SucursalesModel->getSucursales();
		$data["fragment"]    = view('admin/fragments/sucursales_view', $data);
		$data["main_menu"]   = view('admin/nav/main_menu_nav', $data);
		$data["nav"]         = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina index

	public function agregarSucursal(){

		$request 		= service('request');
		$sucursal 		= $request->getPost("sucursal");
		$estatus        = $request->getPost('estatus');
		
		$regreso          = 500;
		$mensaje          = "Error, vuelve a intentarlo";
				
		$nuevaSucursal                     = array();
		$nuevaSucursal['nombre_sucursal']  = $sucursal;
		$nuevaSucursal['estatus_sucursal'] = $estatus;

		if($this->SucursalesModel->insertarSucursal($nuevaSucursal)){
			$regreso = 200;
			$mensaje = "Sucurdal agregada correctamente";
		}

		echo json_encode(array("regreso" => $regreso, "mensaje" => $mensaje));

	}//termina agregarSucursal

	public function getSucursal(){

		$request 	= service('request');
		$idSucursal 	= $request->getPost("idSucursal");

		$datos      = $this->SucursalesModel->getSucursal($idSucursal);

		echo json_encode(array("datos" => $datos));

	}//termina getSucursal

	public function actualizarSucursal(){

		$request    = service('request');
		$idSucursal = $request->getPost("idSucursal");
		$sucursal   = $request->getPost("sucursal");
		$estatus    = $request->getPost('estatus');

		$respuesta      = 500;
		$mensaje      = "Error, vuelve a intentarlo";

		$datos                     = array();
		$datos['nombre_sucursal']  = $sucursal;
		$datos['estatus_sucursal'] = intval($estatus);

		if ($this->SucursalesModel->actualizarSucursal($datos, $idSucursal)) {
			$respuesta = 200;
			$mensaje = "Sucursal actualizada";
		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina actualizarSucursal

	public function clienteLideres(){

		$request 	= service('request');
		$idCliente 	= base64_decode($request->getGet("c"));

		$cliente = $this->SucursalesModel->getCliente($idCliente);

		$data                = array();
		$data["_APP_TITTLE"] = "Lideres - ".$cliente->nombre_cliente;
		$data["_TAB"]        = "clientes";
		$data["cliente"]     = $cliente;
		$data["lideres"]     = $this->SucursalesModel->getLideresCliente($idCliente);
		$data["fragment"]    = view('admin/fragments/lideres_cliente_view', $data);
		$data["main_menu"]   = view('admin/nav/main_menu_nav', $data);
		$data["nav"]         = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina clienteLideres


}
