<?php

namespace App\Controllers\Admin;
use App\Controllers\BaseController;
use App\Models\MetricasModel;

class Metricas extends BaseController {
	
	private $MetricasModel; //Nombre de la variable para el modelo 
    protected $session;

    public function __construct(){
        
        $this->MetricasModel = new MetricasModel(); // modelo a usar
        $this->session = session();

    }//termina __construct

	public function index(){

		$data                = array();
		$data["_APP_TITTLE"] = "Métricas";
		$data["_TAB"]        = "metricas";
		$data["fragment"]    = view('admin/fragments/metricas_view', $data);
		$data["main_menu"]   = view('admin/nav/main_menu_nav', $data);
		$data["nav"]         = view('admin/nav/main_nav', $data);

		return view("admin/main_view", $data);

	}//termina index

	public function filtrar(){

		$request 	= service('request');
		$session 	= session();
        $tipo 		= $session->get('id_tipo_usuario');
        $idUsuario	= $session->get('id_usuario');

		$inicio  = $request->getPost("inicio");
		$fin     = $request->getPost("fin");
		$inicio  = date("Y-m-d", strtotime($inicio));
		$fin     = date("Y-m-d", strtotime($fin));
		$candidatos = NULL;
		if($tipo == 1){
			$candidatos  = $this->MetricasModel->candidatos($inicio, $fin);
		}

		$data_0     		= array();
		$name_0     		= array();
		$contCandidatos   	= 0;

		if (!is_null($candidatos)) {
			foreach ($candidatos as $candidato) {

				$data_0 	= null;
				$data_0[]   = array('name'=> 'Candidatos registrados', 'y' => (int)$candidato->tot, 'drilldown' => 'Tipo', 'color' => '#1d70b6');
				$name_0[]   = array('name' => "", 'colorByPoint' => true, 'data' => $data_0);
				$contCandidatos = $contCandidatos + $candidato->tot;
			}
		}//termina is_null

		$topVacantes = NULL;
		if($tipo == 1){
			$topVacantes = $this->MetricasModel->topVacantes($inicio, $fin);
		}
		$data_1     = array();
		$name_1     = array();
		$data_r     = array();
		$name_r     = array();

		if (!is_null($topVacantes)) {

			$cont = 1;
			
			foreach ($topVacantes as $top) {

				if (($cont % 2) == 0) {
					$color = "#1d70b6";
				} else {
					$color = "#29265b";
				}

				$data_1   = array('name'=> $top->nombre, 'y' => (int)$top->tot, 'drilldown' => ''.$top->nombre.'', 'color' => $color);
				$name_1[] = $data_1;

				$reclutadores = $this->MetricasModel->top5ReclutadoresVacante($inicio, $fin, $top->id_vacante);
				$opciones	  = array();

				if(!is_null($reclutadores)){

					foreach($reclutadores as $r){

						$nombreR = (!is_null($r->nombre_reclutador)) ? $r->nombre_reclutador : "No llegaron por QR";

						$opciones[] = [''.$nombreR.'',(int)$r->tot];

						$data_r    = array("name" => '', "id" => ''.$r->nombre.'', "data" => $opciones );
						$name_r[]  = $data_r;

					}

				}

				$cont++;

			}

		}//termina is_null

		$postulaciones = NULL;
		if($tipo == 1){
			$postulaciones  = $this->MetricasModel->postulaciones($inicio, $fin);
		}

		$data_2     		= array();
		$name_2     		= array();
		$contPostulaciones  = 0;

		if (!is_null($postulaciones)) {
			foreach ($postulaciones as $postulacion) {

				$data_2 	= null;
				$data_2[]   = array('name'=> 'Postulaciones', 'y' => (int)$postulacion->tot, 'drilldown' => 'Tipo', 'color' => '#1d70b6');
				$name_2[]   = array('name' => "", 'colorByPoint' => true, 'data' => $data_2);
				$contPostulaciones = $contPostulaciones + $postulacion->tot;
			}
		}//termina is_null


		$candidatosNo = NULL;
		if($tipo == 1){
			$candidatosNo  = $this->MetricasModel->candidatosNo($inicio, $fin);
		}

		$data_3     		= array();
		$name_3     		= array();
		$contCandidatosNo   = 0;

		if (!is_null($candidatosNo)) {
			foreach ($candidatosNo as $candidato) {

				$data_3 	= null;
				$data_3[]   = array('name'=> 'Candidatos', 'y' => (int)$candidato->tot, 'drilldown' => 'Tipo', 'color' => '#29265b');
				$name_3[]   = array('name' => "", 'colorByPoint' => true, 'data' => $data_3);
				$contCandidatosNo = $contCandidatosNo + $candidato->tot;
			}
		}//termina is_null

		$candidatosViablesNoViables = NULL;
		if($tipo == 1){
			$candidatosViablesNoViables  = $this->MetricasModel->candidatosViablesNoViables($inicio, $fin);
		}

		$data_4     		= array();
		$name_4     		= array();

		if (!is_null($candidatosViablesNoViables)) {
			foreach ($candidatosViablesNoViables as $candidato) {

				$data_4 	= null;
				$data_4[]   = array('name'=> $candidato->estado, 'y' => (int)$candidato->cantidad, 'drilldown' => 'Tipo', 'color' => '#29265b');
				$name_4[]   = array('name' => "", 'colorByPoint' => true, 'data' => $data_4);

			}
		}//termina is_null

		$tickets  = $this->MetricasModel->tickets($inicio, $fin);

		$data_5     		= array();
		$name_5     		= array();

		if (!is_null($tickets)) {
			foreach ($tickets as $ticket) {

				$data_5 	= null;
				$data_5[]   = array('name'=> $ticket->estatus, 'y' => (int)$ticket->total, 'drilldown' => 'Tipo', 'color' => '#2a7ab7');
				$name_5[]   = array('name' => "", 'colorByPoint' => true, 'data' => $data_5);

			}
		}//termina is_null

		$ticketsAtendidos  = $this->MetricasModel->ticketsPorUsuario($inicio, $fin);

		$data_6     		= array();
		$name_6     		= array();

		if (!is_null($ticketsAtendidos)) {
			foreach ($ticketsAtendidos as $ticket) {

				$data_6 	= null;
				$data_6[]   = array('name'=> $ticket->usuario, 'y' => (int)$ticket->tot, 'drilldown' => 'Tipo', 'color' => '#2a7ab7');
				$name_6[]   = array('name' => "", 'colorByPoint' => true, 'data' => $data_6);
				
			}
		}//termina is_null


		echo json_encode(
			array(
				"candidatos"                 => $name_0,
				"contCandidatos"             => $contCandidatos,
				"top5"                       => $name_1,
				"postulaciones"              => $name_2,
				"contPostulaciones"          => $contPostulaciones,
				"noCandidatos"               => $name_3,
				"contCandidatosNo"           => $contCandidatosNo,
				"reclutadores"               => $name_r,
				"candidatosViablesNoViables" => $name_4,
				"tickets"                    => $name_5,
				"ticketsUsuarios"            => $name_6
			)
		);

	}//termina filtrar

}
