<?php
/**
 * @author Daniel Lopez Ibarra
 * @version 0.1
 * @copyright  2015. Todos los Derechos Reservados
*/
?>

<div class="row">

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-md-12">
        <h1 id="subir" class="page-header"><i class="fa fa-book"></i> Rutas</h1>
    </div>
</div>

<br>



<div class="row">

    <div class="col-md-5" style="margin-top: 1em;" id="div_img">
        <div class="form-group">
        <label>
            Archivo:
        </label>
        <input class="form-control" type="file" id="filePDF" accept="application/pdf, image/jpeg, image/png, image/jpg, .xls, .xlsx">
        <input class="form-control" type="hidden" id="filePDF_bd">
        </div>
    </div>

    <div class="col-md-6" style="margin-top: 1em;" id="div_imagen_actual">
        <div class="form-group">
            <label>
                Archivo actual:
            </label>
            <?php
            
            if($pdf->tipo == "xlxs" || $pdf->tipo == "xlsx"){
                
                echo "No se puede previsualizar el archivo (XLSX).";

            }else{?>

                
                <iframe
                frameBorder="0"
                scrolling="auto"
                allowfullscreen
                height="500"
                width="100%"
                id="file_frame_img_actual"
                src="<?php echo $pdf->pdf_ruta; ?>#toolbar=0" ></iframe>
            
            <?php

            }
            
            ?>


            <br>
            <br>
            <a onclick="window.open('<?php echo $pdf->pdf_ruta; ?>','new_window');" class="btn btn-info" style="margin: 0 auto;"><i class="fa fa-eye"></i> Ver completo</a>
        </div>
    </div>

    <div class="col-md-12">
        <button class="btn btn-success" id="btn_guardar" style="margin-top: 1em;"><i class="fa fa-check"></i> Guardar</button>
    </div>
    
</div>

<style type="text/css">

    .swal2-container {
        z-index: 12000 !important;
    }

    .carga {
        border: 24px solid #f3f3f3;
        border-radius: 50%;
        border-top: 24px solid #004593;
        width: 160px;
        height: 160px;
        -webkit-animation: spin 2s linear infinite;
        animation: spin 2s linear infinite;
        margin:auto;
        left:0;
        right:0;
        top:0;
        bottom:0;
        position:fixed;
        z-index: 11000 !important;
    }

    @-webkit-keyframes spin {
        0% { -webkit-transform: rotate(0deg); }
        100% { -webkit-transform: rotate(360deg); }
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

</style>


<script type="text/javascript" src="<?=base_url();?>static/js/jquery.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
<script src="<?php echo base_url('static/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('static/dataTables.bootstrap.js')?>"></script>
<script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.4.2/css/buttons.dataTables.min.css">
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    <script type="text/javascript">
    jQuery(document).ready(function($){

        ocultarLoader();

        $(document).on('click', '#btn_guardar', function(event) {

            $("#filePDF").css("border-color", "#D5D4D4").focus();

            var file  = $("#filePDF").val();

            if (file != ""){

                var fileSize  = $('#filePDF')[0].files[0].size;
                var extension = $('#filePDF')[0].files[0].type
                
                if (extension != 'application/pdf' && extension != 'image/png' && extension != 'image/jpeg' && extension != 'image/jpg' && extension != 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' && extension != 'application/vnd.ms-excel') {

                    $("#filePDF").css("border-color", "red").focus();
                    
                    Swal.fire({
                        title: 'Por favor selecciona un archivo tipo PDF, PNG, JPEG o JPG',
                        type: 'info'
                    });

                }else if (fileSize > 3592388) {

                    $("#filePDF").css("border-color", "red").focus();
                    
                    Swal.fire({
                        title: 'Por favor selecciona un archivo menor a 3 MB',
                        type: 'info'
                    });

                }else{
                    
                mostrarLoader();
                updateFile();

                }

            }else {

                $("#filePDF").css("border-color", "red").focus();

                Swal.fire({
                title: 'Por favor selecciona un archivo',
                type: 'error'
                });

            //Video
            }

        });

    });//termina jQuery

    function updateFile() {

        var formData = new FormData();
        var files    = $('#filePDF')[0].files[0];
        formData.append('file',files);
        $.ajax({
        url : "<?php echo base_url();?>index.php/admin/rutas/updateFile",
        type : "POST",
        dataType : "json",
        data: formData,
        contentType: false,
        processData: false,
        success : function(result){
            if (result.respuesta == 200) {
                Swal.fire({
                    title: result.mensaje,
                    type: 'success'
                });
                setTimeout(
                    function(){
                        location.reload();
                        ocultarLoader();
                    }, 2000
                );
            }else {
                Swal.fire({
                    title: result.mensaje,
                    type: 'error'
                });
                setTimeout(ocultarLoader, 1000);
            }
        }
        });

    }//termina updateFile

    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }

   
    </script>