<div class="row">
    <div class="col-md-12">
        <h1 class="page-header"><i class="fa fa-briefcase"></i> Catálogo de Supervisores</h1>
    </div>
</div>

<div class="row">
    <div class="col-md-12">
        <button class="btn btn-success" data-toggle="modal" data-target="#addSupervisorModal"><i class="fa fa-plus"></i> Agregar Supervisor</button>
    </div>
</div>

<br>

<div class="row">
    <div class="col-md-12">
        <table class="table table-responsive table-striped" id="supervisoresTable">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>No. Empleado</th>
                    <th>Nombre Supervisor</th>
                    <th>Organización</th>
                    <th>Centro de Costos</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php if(!empty($supervisores)): ?>
                    <?php foreach($supervisores as $supervisor): ?>
                        <tr>
                            <td><?php echo $supervisor->id_catalogo_supervisor; ?></td>
                            <td><?php echo $supervisor->num_empleado; ?></td>
                            <td><?php echo $supervisor->nombre_supervisor; ?></td>
                            <td><?php echo $supervisor->organizacion; ?></td>
                            <td><?php echo $supervisor->centro_costos; ?></td>
                            <td>
                                <button class="btn btn-primary update-supervisor" 
                                        data-id="<?php echo $supervisor->id_catalogo_supervisor; ?>"
                                        data-num_empleado="<?php echo $supervisor->num_empleado; ?>"
                                        data-nombre_supervisor="<?php echo $supervisor->nombre_supervisor; ?>"
                                        data-organizacion="<?php echo $supervisor->organizacion; ?>"
                                        data-centro_costos="<?php echo $supervisor->centro_costos; ?>"
                                        data-toggle="modal" 
                                        data-target="#updateSupervisorModal">
                                    <i class="fa fa-pencil"></i> Editar
                                </button>
                                <button class="btn btn-danger delete-supervisor" 
                                        data-id="<?php echo $supervisor->id_catalogo_supervisor; ?>">
                                    <i class="fa fa-trash"></i> Eliminar
                                </button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<!-- Add Supervisor Modal -->
<div class="modal fade" id="addSupervisorModal" tabindex="-1" role="dialog" aria-labelledby="addSupervisorModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #004593; color: white;">
                <h4 class="modal-title text-center" id="addSupervisorModalLabel" style="width: 100%;">Agregar Nuevo Supervisor</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="addSupervisorForm">
                    <div class="form-group">
                        <label for="num_empleado">No. Empleado</label>
                        <input type="text" class="form-control" id="num_empleado" name="num_empleado">
                    </div>
                    <div class="form-group">
                        <label for="nombre_supervisor">Nombre Supervisor</label>
                        <input type="text" class="form-control" id="nombre_supervisor" name="nombre_supervisor">
                    </div>
                    <div class="form-group">
                        <label for="organizacion">Organización</label>
                        <input type="text" class="form-control" id="organizacion" name="organizacion">
                    </div>
                    <div class="form-group">
                        <label for="centro_costos">Centro de Costos</label>
                        <input type="text" class="form-control" id="centro_costos" name="centro_costos">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" id="saveSupervisor">Guardar</button>
            </div>
        </div>
    </div>
</div>

<!-- Update Supervisor Modal -->
<div class="modal fade" id="updateSupervisorModal" tabindex="-1" role="dialog" aria-labelledby="updateSupervisorModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header" style="background-color: #004593; color: white;">
                <h4 class="modal-title text-center" id="updateSupervisorModalLabel" style="width: 100%;">Actualizar Supervisor</h4>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close" style="color: white;">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <form id="updateSupervisorForm">
                    <input type="hidden" id="update_id_catalogo_supervisor" name="id_catalogo_supervisor">
                    <div class="form-group">
                        <label for="update_num_empleado">No. Empleado</label>
                        <input type="text" class="form-control" id="update_num_empleado" name="num_empleado">
                    </div>
                    <div class="form-group">
                        <label for="update_nombre_supervisor">Nombre Supervisor</label>
                        <input type="text" class="form-control" id="update_nombre_supervisor" name="nombre_supervisor">
                    </div>
                    <div class="form-group">
                        <label for="update_organizacion">Organización</label>
                        <input type="text" class="form-control" id="update_organizacion" name="organizacion">
                    </div>
                    <div class="form-group">
                        <label for="update_centro_costos">Centro de Costos</label>
                        <input type="text" class="form-control" id="update_centro_costos" name="centro_costos">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
                <button type="button" class="btn btn-primary" id="updateSupervisorBtn">Guardar Cambios</button>
            </div>
        </div>
    </div>
</div>


<script src="<?php echo base_url('static/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('static/dataTables.bootstrap.js')?>"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>

<script type="text/javascript">
$(document).ready(function() {
    $('#supervisoresTable').DataTable();

    $('#saveSupervisor').on('click', function() {
        var isValid = true;
        var errorMessage = '';

        $('#addSupervisorForm input').each(function() {
            var input = $(this);
            var value = $.trim(input.val());
            var id = input.attr('id');

            // Limpiar estilos de error previos
            input.css({
                "border": "",
                "background": ""
            });

            if (value == '') {
                isValid = false;
                errorMessage = 'Todos los campos son obligatorios.';
                input.css({
                    "border": "1px solid red",
                    "background": "#FFCECE"
                });
            } else {
                // Validacion para enteros
                if (id === 'num_empleado' || id === 'organizacion') {
                    if (!$.isNumeric(value) || parseFloat(value) !== parseInt(value, 10) || value < 0) {
                        isValid = false;
                        errorMessage = 'El campo "' + input.prev('label').text() + '" debe ser un número entero no negativo.';
                        input.css({
                            "border": "1px solid red",
                            "background": "#FFCECE"
                        });
                    }
                }
            }
        });

        if (!isValid) {
            Swal.fire({
                type: 'error',
                title: 'Error de Validación',
                text: errorMessage
            });
            return false;
        }

        $.ajax({
            url: "<?php echo site_url('admin/Catalogo_supervisor/ajax_add_supervisor')?>",
            type: "POST",
            data: $('#addSupervisorForm').serialize(),
            dataType: "JSON",
            success: function(data) {
                if(data.status) {
                    $('#addSupervisorModal').modal('hide');
                    $('#addSupervisorForm')[0].reset();
                    Swal.fire({
                        type: 'success',
                        title: '¡Éxito!',
                        text: 'Supervisor agregado correctamente.'
                    }).then(function(){
                        location.reload();
                    });
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                 Swal.fire({
                    type: 'error',
                    title: 'Error',
                    text: 'No se pudo agregar el supervisor.'
                });
            }
        });
    });

    // Populate update modal
    $(document).on('click', '.update-supervisor', function() {
        $('#update_id_catalogo_supervisor').val($(this).data('id'));
        $('#update_num_empleado').val($(this).data('num_empleado'));
        $('#update_nombre_supervisor').val($(this).data('nombre_supervisor'));
        $('#update_organizacion').val($(this).data('organizacion'));
        $('#update_centro_costos').val($(this).data('centro_costos'));
    });

    // Ajax for update
    $('#updateSupervisorBtn').on('click', function() {
        var isValid = true;
        var errorMessage = '';

        $('#updateSupervisorForm input').each(function() {
            var input = $(this);
            var value = $.trim(input.val());
            var id = input.attr('id');

            // Limpiar estilos de error previos
            input.css({
                "border": "",
                "background": ""
            });

            if (value == '' && input.attr('type') !== 'hidden') {
                isValid = false;
                errorMessage = 'Todos los campos son obligatorios.';
                input.css({
                    "border": "1px solid red",
                    "background": "#FFCECE"
                });
            }
        });

        if (!isValid) {
            Swal.fire({
                type: 'error',
                title: 'Error de Validación',
                text: errorMessage
            });
            return false;
        }

        $.ajax({
            url: "<?php echo site_url('admin/Catalogo_supervisor/ajax_update_supervisor')?>",
            type: "POST",
            data: $('#updateSupervisorForm').serialize(),
            dataType: "JSON",
            success: function(data) {
                if(data.status) {
                    $('#updateSupervisorModal').modal('hide');
                    Swal.fire({
                        type: 'success',
                        title: '¡Éxito!',
                        text: 'Supervisor actualizado correctamente.'
                    }).then(function(){
                        location.reload();
                    });
                }
            },
            error: function (jqXHR, textStatus, errorThrown) {
                 Swal.fire({
                    type: 'error',
                    title: 'Error',
                    text: 'No se pudo actualizar el supervisor.'
                });
            }
        });
    });
    // Ajax for delete
    $(document).on('click', '.delete-supervisor', function() {
        var supervisorId = $(this).data('id');
        Swal.fire({
            title: '¿Estás seguro?',
            text: "¡No podrás revertir esto!",
            type: 'warning',
            showCancelButton: true,
            confirmButtonColor: '#3085d6',
            cancelButtonColor: '#d33',
            confirmButtonText: 'Sí, ¡bórralo!',
            cancelButtonText: 'Cancelar'
        }).then((result) => {
            if (result.value) {
                $.ajax({
                    url: "<?php echo site_url('admin/Catalogo_supervisor/ajax_delete_supervisor')?>",
                    type: "POST",
                    data: {id_catalogo_supervisor: supervisorId},
                    dataType: "JSON",
                    success: function(data) {
                        if(data.status) {
                            Swal.fire(
                                '¡Eliminado!',
                                'El supervisor ha sido eliminado.',
                                'success'
                            ).then(function(){
                                location.reload();
                            });
                        }
                    },
                    error: function (jqXHR, textStatus, errorThrown) {
                         Swal.fire({
                            type: 'error',
                            title: 'Error',
                            text: 'No se pudo eliminar el supervisor.'
                        });
                    }
                });
            }
        });
    });
});
</script>