<div class="row">

    <div class="carga" id="carga" style="display: none;"></div>

    <div class="col-md-12">
        <h1 id="subir" class="page-header"><i class="fa fa-file"></i> Archivos cargados</h1>
    </div>



    <div class="col-md-3">
        <div class="form-group">
            <label for="cveprodep" class="control-label">
                Filtro por fecha de registro:
                <i class="text-danger fa fa-asterisk"> </i> 
            </label>
            <input type="text" name="dates" id="rango" class="form-control" />
        </div>  
    </div>


</div>

<br>


<div class="row" id="row_filtros" style="display: none;">

    <div class="col-md-3">
        <div class="form-group">
            <label for="cveprodep" class="control-label">
                Fecha contratación:
                <i class="text-danger fa fa-asterisk"> </i> 
            </label>
            <input type="date" class="form-control" id="fecha_contratacion" name="fecha_contratacion" placeholder="fecha" value="<?=date('Y-m-d')?>">
        </div>  
    </div>

    <div class="col-md-3">
        <div class="form-group">
            <label for="cveprodep" class="control-label">
                Supervisor:
                <i class="text-danger fa fa-asterisk"> </i> 
            </label>
            <select name="" class="form-control" id="id_catalogo_supervisor">
                <option value="">Seleccione un supervisor</option>
                <?php
                if (!is_null($supervisores)){
                    foreach ($supervisores as $s) {
                        ?>
                        <option value="<?=$s->id_catalogo_supervisor?>"><?=$s->nombre_supervisor?></option>
                        <?php
                    }
                }
                ?>
            </select>
        </div>  
    </div>

    <div class="col-md-3">
        <div class="form-group">
            <label for="cveprodep" class="control-label">
                Puesto:
                <i class="text-danger fa fa-asterisk"> </i> 
            </label>
            <select name="" class="form-control" id="id_catalogo_puesto">
                <option value="">Seleccione un puesto</option>
                <?php
                if (!is_null($puesto)){
                    foreach ($puesto as $p) {
                        ?>
                        <option value="<?=$p->id_catalogo_puesto?>"><?=$p->puesto?></option>
                        <?php
                    }
                }
                ?>
            </select>
        </div>  
    </div>

    
    <div class="col-md-3">
        <div class="form-group">
            <button class="btn btn-success" id="crearExcel" style="margin-top:23px;"><i class="fa fa-file-excel-o"> </i>  Exportar</button>
        </div>  
    </div>


</div>

<br><br>
<div class="row">
    <div class="table-responsive">
        <table class="table table-striped" id="tabla_personas">
            <thead>
                <tr>
                    <th>#</th>
                    <th>Registro</th>
                    <th>Nombres</th>
                    <th>Apellido paterno</th>
                    <th>Apellido materno</th>
                    <th>Correo electrónico</th>
                    <th>Estatus IMSS</th>
                    <th>RFC</th>
                    <th>CURP</th>
                    <th>NSS</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody id="tbody_personas">
                <?php
                if (!is_null($paquetes)) {

                    $cont         = 1;
                    $estatus_imss = "NA";
                    $ine          = "";
                    $constancia   = "";
                    $comprobante  = "";


                    foreach ($paquetes as $v) {

                        if($v->messageCode == 0){
                            $estatus_imss = "<h4><span class='label label-success'>Activo</span></h4>";
                        }else if($v->messageCode == 1){
                            $estatus_imss = "<h4><span class='label label-danger'>Inactivo</span></h4>";
                        }

                        $archivos  = explode(",", $v->archivos);

                        $ine = $comprobante = $constancia = null;

                        foreach ($archivos as $archivo) {
                            if (strpos($archivo, 'INE') !== false) {
                                $ine = $archivo;
                            } elseif (strpos($archivo, 'Comprobante') !== false) {
                                $comprobante = $archivo;
                            } elseif (strpos($archivo, 'Constancia') !== false) {
                                $constancia = $archivo;
                            }
                        }

                        
                        ?>

                        <tr>
                            <td><?php echo $cont;?></td>
                            <td><?php echo $v->fecha_registro;?></td>
                            <td><?php echo $v->nombres;?></td>
                            <td><?php echo $v->primerApellido;?></td>
                            <td><?php echo $v->segundoApellido;?></td>
                            <td><?php echo $v->correoElectronico;?></td>
                            <td><?php echo $estatus_imss;?></td>
                            <td><?php echo $v->rfc;?></td>
                            <td><?php echo $v->curp;?></td>
                            <td><?php echo $v->nss;?></td>
                            <td>
                            <a href="verDatos?idp=<?=$v->id_paquete_archivo?>" class="btn btn-success"> <i class="fa fa-eye"> </i> Ver</a>
                            <button class="verArchivos btn btn-primary"  
                            data-nombres="<?=$v->nombres?>"
                            data-primerApellido="<?=$v->primerApellido?>"
                            data-segundoApellido="<?=$v->segundoApellido?>"
                            data-rfc="<?=$v->rfc?>"
                            data-curp="<?=$v->curp?>"
                            data-nss="<?=$v->nss?>"
                            data-ine="<?=$ine?>"
                            data-comprobante="<?=$comprobante?>"
                            data-foto_candidato="<?=$v->foto_candidato?>"
                            data-constancia="<?=$constancia?>"
                            data-calle="<?=$v->calle?>"
                            data-colonia="<?=$v->colonia?>"
                            data-cp="<?=$v->cp?>">
                                <i class="fa fa-file" aria-hidden="true"></i> archivos
                            </button>

                            </td>
                        </tr>
                            
                    <?php $cont++;

                    }

                 } 
                 ?>
                
            </tbody>
        </table>

    </div>
</div>

<style type="text/css">

    .swal2-container {
        z-index: 12000 !important;
    }

    .carga {
        border: 24px solid #f3f3f3;
        border-radius: 50%;
        border-top: 24px solid #004593;
        width: 160px;
        height: 160px;
        -webkit-animation: spin 2s linear infinite;
        animation: spin 2s linear infinite;
        margin:auto;
        left:0;
        right:0;
        top:0;
        bottom:0;
        position:fixed;
        z-index: 11000 !important;
    }

    @-webkit-keyframes spin {
        0% { -webkit-transform: rotate(0deg); }
        100% { -webkit-transform: rotate(360deg); }
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }

</style>

<div class = "modal fade" tabindex = "-1" role = "dialog" aria-labelledby = "exampleModalLabel" id = "modalInformacion">
<div class = "modal-dialog modal-lg">
<div class = "modal-content">
            <!-- Modal Header -->
            <div class="modal-header" style="background-color: #7b94c4;">
                <h3 class="modal-title w-100 text-center" id="exampleModalLabel" style="color: white;">
                <b id="nombre"></b></h3>
                <!--<button type="button" class="close" data-dismiss="modal">&times;</button>-->
            </div>

            <!-- Modal body -->
            <div class="modal-body">
                <div class="row">

                    <div class="col-md-6">
                        <div class="card">
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item"><span style="font-weight: bold;">Nombres:</span> 
                                <span id="nombres"></span></li>
                                <li class="list-group-item"><span style="font-weight: bold;">Apellido paterno:</span> 
                                <span id="primerApellido"></span></li>
                                <li class="list-group-item"><span style="font-weight: bold;">Apellido materno:</span> 
                                <span id="segundoApellido"></span></li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-md-6">

                        <div class="card">
                            <ul class="list-group list-group-flush">
                                <li class="list-group-item"><span style="font-weight: bold;">Curp:</span> 
                                <span id="curp"></span></li>
                                <li class="list-group-item"><span style="font-weight: bold;">RFC:</span> 
                                <span id="rfc"></span></li>
                                <li class="list-group-item"><span style="font-weight: bold;">NSS:</span> 
                                <span id="nss"></span></li>
                            </ul>
                        </div>

                    </div>

                    <div class="col-md-12">
                        <div class="card">
                            <ul class="list-group list-group-flush">
                            <li class="list-group-item"><span style="font-weight: bold;">Dirección:</span> 
                                <span id="direccion"></span></li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <ul class="list-group list-group-flush">
                                <li class="list-group-item">
                                    <div class="card">
                                        <div class="card-header" id="headingTwo">
                                        <h2 class="mb-0">
                                            <a class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseTwo" aria-expanded="false" aria-controls="collapseTwo">
                                            Foto INE
                                            </a>
                                        </h2>
                                        </div>
                                        <div id="collapseTwo" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                        <div class="card-body" id="ine">
                                            
                                        </div>
                                        </div>
                                    </div>
                                </li>
                        </ul>
                    </div>

                    <div class="col-md-6">
                        <ul class="list-group list-group-flush">
                                <li class="list-group-item">
                                    <div class="card">
                                        <div class="card-header" id="heading3">
                                        <h2 class="mb-0">
                                            <a class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapse3" aria-expanded="false" aria-controls="collapse3">
                                            Comprobante de domicilio
                                            </a>
                                        </h2>
                                        </div>
                                        <div id="collapse3" class="collapse" aria-labelledby="heading3" data-parent="#accordionExample">
                                        <div class="card-body" id="comprobante">
                                        </div>
                                        </div>
                                    </div>
                                </li>
                        </ul>
                    </div>
                    
                    <div class="col-md-6">
                        <ul class="list-group list-group-flush">
                                <li class="list-group-item">
                                    <div class="card">
                                        <div class="card-header" id="headingTwo">
                                        <h2 class="mb-0">
                                            <a class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseThree" aria-expanded="false" aria-controls="collapseThree">
                                            Constancia de situación fiscal
                                            </a>
                                        </h2>
                                        </div>
                                        <div id="collapseThree" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                        <div class="card-body" id="constancia">
                                            
                                        </div>
                                        </div>
                                    </div>
                                </li>
                        </ul>
                    </div>

                    <div class="col-md-6">
                        <ul class="list-group list-group-flush">
                                <li class="list-group-item">
                                    <div class="card">
                                        <div class="card-header" id="headingTwo">
                                        <h2 class="mb-0">
                                            <a class="btn btn-link btn-block text-left collapsed" type="button" data-toggle="collapse" data-target="#collapseFour" aria-expanded="false" aria-controls="collapseFour">
                                            Foto Candidato
                                            </a>
                                        </h2>
                                        </div>
                                        <div id="collapseFour" class="collapse" aria-labelledby="headingTwo" data-parent="#accordionExample">
                                        <div class="card-body" id="foto_candidato">
                                            
                                        </div>
                                        </div>
                                    </div>
                                </li>
                        </ul>
                    </div>


                </div>

            </div>
            <!-- Modal footer -->
            <div class="modal-footer">
                <button id="cerrarModal" type="button" class="btn" data-dismiss="modal" style="background-color: #7b94c4; color: white;">Cerrar</button>
            </div>
        </div>
    </div>
</div>

<style>
.is-invalid {
    border: 2px solid red;
}
</style>
<script type="text/javascript" src="<?=base_url();?>static/js/jquery.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@8"></script>
<script src="<?php echo base_url('static/jquery.dataTables.min.js')?>"></script>
<script src="<?php echo base_url('static/dataTables.bootstrap.js')?>"></script>
<script src="https://cdn.datatables.net/buttons/1.4.2/js/dataTables.buttons.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.bootstrap.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
<script src="https://cdn.datatables.net/buttons/1.5.6/js/buttons.html5.min.js"></script>
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/1.4.2/css/buttons.dataTables.min.css">
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

    <script type="text/javascript">
    jQuery(document).ready(function($){

    var inicio = null;
    var fin    = null;

    $('#crearExcel').click(function (e) {
        e.preventDefault(); // Previene comportamiento por defecto si está en un form

        // Capturamos los valores
        const fecha      = $('#fecha_contratacion').val().trim();
        const supervisor = $('#id_catalogo_supervisor').val().trim();
        const puesto     = $('#id_catalogo_puesto').val().trim();

        // Resaltar campos vacíos
        if (fecha === ''){ 
            $('#fecha_contratacion').addClass('is-invalid');
            return;
        }else{
            $('#fecha_contratacion').removeClass('is-invalid');
        } 

        if (supervisor === ''){
            $('#id_catalogo_supervisor').addClass('is-invalid');
            return;
        }else{
            $('#id_catalogo_supervisor').removeClass('is-invalid');
        } 
        

        if (puesto === ''){
            $('#id_catalogo_puesto').addClass('is-invalid');
            return;
        }else{
            $('#id_catalogo_puesto').removeClass('is-invalid')
        }

        $("#crearExcel").attr("disabled", true);
        crearExcel(fecha, supervisor, puesto, inicio, fin);


    });


        $(document).on('click', '.verArchivos', function(event) {

            // var id = $(this).attr("data-id");
            var base_url = "<?php echo base_url()?>";
            console.log(base_url);
            var nombres         = $(this).attr("data-nombres");
            var primerApellido  = $(this).attr("data-primerApellido");
            var segundoApellido = $(this).attr("data-segundoApellido");
            var rfc             = $(this).attr("data-rfc");
            var curp            = $(this).attr("data-curp");
            var nss             = $(this).attr("data-nss");
            
            var ine            = $.trim($(this).attr("data-ine"));
            var comprobante    = $.trim($(this).attr("data-comprobante"));
            var constancia     = $.trim($(this).attr("data-constancia"));
            var foto_candidato = $.trim($(this).attr("data-foto_candidato"));

            var calle   = $(this).attr("data-calle");
            var colonia = $(this).attr("data-colonia");
            var cp      = $(this).attr("data-cp");
            var direccion = colonia + ", " + calle + ", " + cp;
            
            var extension = comprobante.split('.').pop().toLowerCase();

            if(extension == "pdf"){
                $("#comprobante").html("<a href='"+base_url+comprobante+"' style='width: 100%;' target='_blank' class='btn btn-primary'>Ver Comprobante</a>");
            }else{
                $("#comprobante").html("<img src='"+base_url+comprobante+"' style='width: 100%;' class='verImagen' data-toggle='tooltip' data-placement='right' title='Da clic en la imagen para verla en pantalla completa'/>");
            }

            console.log("url: "+base_url+foto_candidato);
            // console.log(foto_candidato);

            // alert("ine: "+base_url+ine+" comprobante: "+comprobante+" constancia: "+constancia);

            $("#nombres").html(nombres);
            $("#primerApellido").html(primerApellido);
            $("#segundoApellido").html(segundoApellido);
            $("#curp").html(curp);
            $("#rfc").html(rfc);
            $("#nss").html(nss);
            $("#direccion").html(direccion);

            $("#ine").html("<img src='"+base_url+ine+"' style='width: 100%;' class='verImagen' data-toggle='tooltip' data-placement='right' title='Da clic en la imagen para verla en pantalla completa'/>");

            $("#constancia").html("<a href='"+base_url+constancia+"' style='width: 100%;' target='_blank' class='btn btn-primary'>Ver Constancia</a>");
            // $("#foto_candidato").html("<a href='"+base_url+foto_candidato+"' style='width: 100%;' target='_blank' class='btn btn-primary'>Ver Constancia</a>"); 

            $("#foto_candidato").html("<img src='"+base_url+foto_candidato+"' style='width: 100%;' class='verImagen' data-toggle='tooltip' data-placement='right' title='Da clic en la imagen para verla en pantalla completa'/>");
            

            // getInformacionCandidato(id);
            $("#modalInformacion").modal("show");
        });

        ocultarLoader();

        $('input[name="dates"]').daterangepicker({
            "locale": {
            "format": "DD/MM/YYYY",
            "separator": " - ",
            "applyLabel": "Aceptar",
            "cancelLabel": "Cancelar",
            "fromLabel": "From",
            "toLabel": "To",
            "customRangeLabel": "Custom",
            "daysOfWeek": [
                "Dom",
                "Lun",
                "Mar",
                "Mie",
                "Jue",
                "Vie",
                "Sab"
            ],
            "monthNames": [
                "Enero",
                "Febrero",
                "Marzo",
                "Abril",
                "Mayo",
                "Junio",
                "Julio",
                "Agosto",
                "Septiembre",
                "Octubre",
                "Noviembre",
                "Diciembre"
            ],
            "firstDay": 1
            }
        });

        $("#rango").on('apply.daterangepicker', function(ev, picker) {
            
            inicio = picker.startDate.format('YYYY-MM-DD');
            fin    = picker.endDate.format('YYYY-MM-DD');
            
            
            mostrarLoader();
            filtrar(inicio, fin);
        });

        var tabla = $('#tabla_personas').dataTable( {
            dom: "'down'<'col-md-1'B><'col-md-6'l><'col-md-5'f>"+ "<br/>" +
            "<'top'<'col-md-12'tr>>" +
            "<'top'<'col-md-4'i><'col-md-7'p>>",
            buttons: [
                {
                    text: '<i class="fa fa-file-excel-o"></i> Excel',
                    extend: 'excelHtml5',
                    className : 'btn btn-success',
                    exportOptions: {
                        columns: [0, 1, 2, 3, 4, 5, 6, 7, 8]
                    }
                }
            ]
        });

        $(document).on('click', '.cambiar', function(event) {
            
            var id_interesado = $(this).attr('data-id');
            var campo         = $(this).attr('data-cambio');

            cambioEstatus(id_interesado, campo);

        });


    });//termina jQuery


    function crearExcel(fecha, supervisor, puesto, inicio, fin){

        mostrarLoader();    

        $.ajax({
            url : "<?=base_url()?>index.php/admin/archivos/crearExcel",
            type : "POST",
            dataType : "json",
            data :{"inicio" : inicio, "fin" : fin, "fecha" : fecha, "supervisor" : supervisor, "puesto" : puesto},
                success : function(result){

                    $("#crearExcel").attr("disabled", false);

                    if(result.respuesta == 200){

                        Swal.fire({
                            type: 'success',
                            title: "Excel creado correctamente"
                        });

                        // Forzar descarga con <a download>
                        const link = document.createElement('a');
                        link.href = result.url;
                        link.download = ''; // el navegador usa el nombre del servidor
                        document.body.appendChild(link);
                        link.click();
                        document.body.removeChild(link);
                        
                    }else{
                        Swal.fire({
                            type: 'error',
                            title: "No se encontraron datos"
                        });

                    }

                    setTimeout(ocultarLoader, 1000);
                }//termina success
            
            });



    }//termina crearExcel

    function filtrar(inicio, fin){
      
      $("#tabla_personas").dataTable().fnDestroy();

      $.ajax({
        url : "<?=base_url()?>index.php/admin/archivos/filtrar",
        type : "POST",
        dataType : "json",
        data :{"inicio" : inicio, "fin" : fin},
            success : function(result){


                if(result.respuesta == 200){

                    $("#tbody_personas").html(result.tabla);
                    var tabla = $('#tabla_personas').dataTable( {
                        dom: "'down'<'col-md-1'B><'col-md-6'l><'col-md-5'f>"+ "<br/>" +
                        "<'top'<'col-md-12 scroll-x'tr>>" +
                        "<'top'<'col-md-4'i><'col-md-7'p>>",
                        buttons: [
                            {
                                text: '<i class="fa fa-file-excel-o"></i> Excel',
                                extend: 'excelHtml5',
                                className : 'btn btn-success',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4, 5, 6, 7, 8]
                                }
                            }
                        ]
                    });

                    $('#row_filtros').slideDown(400);

                }else{
                    Swal.fire({
                        type: 'error',
                        title: "No se encontraron datos"
                    });

                    $("#tbody_personas").html('');

                    var tabla = $('#tabla_personas').dataTable( {
                        dom: "'down'<'col-md-1'B><'col-md-6'l><'col-md-5'f>"+ "<br/>" +
                        "<'top'<'col-md-12'tr>>" +
                        "<'top'<'col-md-4'i><'col-md-7'p>>",
                        buttons: [
                            {
                                text: '<i class="fa fa-file-excel-o"></i> Excel',
                                extend: 'excelHtml5',
                                className : 'btn btn-success',
                                exportOptions: {
                                    columns: [0, 1, 2, 3, 4, 5, 6, 7, 8]
                                }
                            }
                        ]
                    });


                }

                setTimeout(ocultarLoader, 1000);
            }//termina success
        
        });

    }//termina filtrar

    function mostrarLoader(){
        $("#carga").css("display", "block");
        $("#carga").addClass("carga");
    }

    function ocultarLoader(){
        $("#carga").css("display", "none");
        $("#carga").removeClass("carga");
    }

   
    </script>