<?php class Archivos_model extends CI_Model{


	public function getDatosPendientes(){
		
		$query = $this->db->query("SELECT * FROM datos_ine d WHERE d.estatus_cron = 0  ORDER BY d.id_datos_ine ASC LIMIT 1;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();

	}//termina getDatosPendientes

	public function getPdf(){
	
		$query = $this->db->query("SELECT * FROM pdf_rutas;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getPdf

	public function getRegimenFiscal($id_paquete_archivo){
	
		$query = $this->db->query("SELECT * FROM regimen_fiscal r WHERE r.id_paquete_archivo = ?;", array($id_paquete_archivo));
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}  //termina getRegimenFiscal
	
	public function getLadas(){
	
		$query = $this->db->query("SELECT * FROM lada_pais;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->result();
	
	}//termina getLadas

	public function getPaquetesArchivos(){
	
		$query = $this->db->query("SELECT  GROUP_CONCAT(a.url_archivo SEPARATOR ', ') AS archivos, pa.fecha_registro, pa.celular_persona, pa.foto_candidato, pa.id_paquete_archivo, dco.rfc, di.curp, di.nombres, di.primerApellido, di.segundoApellido, di.sexo, di.fechaNacimiento, di.claveElector,
				dc.calle, dc.colonia, dc.cp,
				dco.situacionContribuyente, dco.correoElectronico, 
				ht.messageCode, ht.message, ht.nss, ht.registroPatronal, ht.rfcPatron, ht.modalidad, ht.razonSocial, ht.salarioBase, ht.dias, ht.fechaRegistro
				FROM paquete_archivo pa
				INNER JOIN archivos a ON a.id_paquete_archivo             = pa.id_paquete_archivo
				INNER JOIN datos_comprobante dc ON dc.id_paquete_archivo  = pa.id_paquete_archivo
				INNER JOIN datos_ine di ON di.id_paquete_archivo          = pa.id_paquete_archivo
				INNER JOIN datos_constancia dco ON dco.id_paquete_archivo = pa.id_paquete_archivo
				LEFT JOIN historial_trabajado ht ON (ht.curp = di.curp AND  ht.nss = pa.nss)
				GROUP BY pa.id_paquete_archivo ORDER BY pa.id_paquete_archivo DESC;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->result();
	
	}//termina getPaquetesArchivos

	public function getCatalogoSupervisor(){
	
		$query = $this->db->query("SELECT * FROM catalogo_supervisor c where c.estatus = 1;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->result();
	
	}//termina getCatalogoSupervisor

	public function getCatalogoPuesto(){
	
		$query = $this->db->query("SELECT * FROM catalogo_puesto c where c.estatus = 1;;");
		
		return ($query->num_rows() <= 0) ? NULL : $query->result();
	
	}  //termina getCatalogoPuesto
	
	public function getCatalogoSupervisorById($id){
	
		$query = $this->db->query("SELECT * FROM catalogo_supervisor c WHERE c.id_catalogo_supervisor = ? ", array($id));
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getCatalogoSupervisorById

	public function getCatalogoPuestoById($id){
	
		$query = $this->db->query("SELECT * FROM catalogo_puesto c WHERE c.id_catalogo_puesto = ? ", array($id));
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getCatalogoPuestoById

	public function getFiltroPaquetesArchivos($inicio, $fin){
	
		$query = $this->db->query("SELECT  GROUP_CONCAT(a.url_archivo SEPARATOR ', ') AS archivos, pa.fecha_registro, pa.lada_pais, pa.celular_persona, pa.foto_candidato, pa.id_paquete_archivo, dco.rfc, di.curp, di.nombres,
				di.primerApellido, di.segundoApellido, di.sexo, di.fechaNacimiento, di.claveElector, dc.calle, dc.colonia, dc.cp,
				dco.situacionContribuyente, dco.correoElectronico, 
				ht.messageCode, ht.message, ht.nss, ht.registroPatronal, ht.rfcPatron, ht.modalidad, ht.razonSocial, ht.salarioBase, ht.dias, ht.fechaRegistro
				FROM paquete_archivo pa
				INNER JOIN archivos a ON a.id_paquete_archivo             = pa.id_paquete_archivo
				INNER JOIN datos_comprobante dc ON dc.id_paquete_archivo  = pa.id_paquete_archivo
				INNER JOIN datos_ine di ON di.id_paquete_archivo          = pa.id_paquete_archivo
				INNER JOIN datos_constancia dco ON dco.id_paquete_archivo = pa.id_paquete_archivo
				LEFT JOIN historial_trabajado ht ON (ht.curp = di.curp AND  ht.nss = pa.nss)
				WHERE DATE(pa.fecha_registro) BETWEEN ? AND ?
				GROUP BY pa.id_paquete_archivo ORDER BY pa.id_paquete_archivo DESC;", array($inicio, $fin));
		
		return ($query->num_rows() <= 0) ? NULL : $query->result();
	
	}//termina getFiltroPaquetesArchivos


	public function getHistorialTrabajado($id_paquete_archivo){
	
		$query = $this->db->query("SELECT h.* 
			FROM paquete_archivo p
			INNER JOIN historial_trabajado h ON (h.nss = p.nss OR (h.nss IS NULL AND p.nss IS NULL))
			WHERE p.id_paquete_archivo = ?;", array($id_paquete_archivo));
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getHistorialTrabajado

	public function getDatosArchivo($id_paquete_archivo){
	
		$query = $this->db->query("SELECT  GROUP_CONCAT(a.url_archivo SEPARATOR ', ') AS archivos, pa.nss as nss_actual, pa.celular_persona, pa.lada_pais, pa.id_paquete_archivo, dco.rfc, di.curp, di.nombres, di.primerApellido, di.segundoApellido, di.sexo, di.fechaNacimiento, di.claveElector,
				dc.calle, dc.colonia, dc.cp,
				dco.situacionContribuyente, dco.correoElectronico, 
				ht.id_historial_trabajado, ht.messageCode, ht.message, ht.nss, ht.registroPatronal, ht.rfcPatron, ht.modalidad, ht.razonSocial, ht.salarioBase, ht.dias, ht.fechaRegistro
				FROM paquete_archivo pa
				INNER JOIN archivos a ON a.id_paquete_archivo             = pa.id_paquete_archivo
				INNER JOIN datos_comprobante dc ON dc.id_paquete_archivo  = pa.id_paquete_archivo
				INNER JOIN datos_ine di ON di.id_paquete_archivo          = pa.id_paquete_archivo
				INNER JOIN datos_constancia dco ON dco.id_paquete_archivo = pa.id_paquete_archivo
				LEFT JOIN historial_trabajado ht ON (ht.curp = di.curp AND  ht.nss = pa.nss)
				WHERE pa.id_paquete_archivo = ?
				GROUP BY pa.id_paquete_archivo;", array($id_paquete_archivo));
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getDatosArchivo

	public function getDatosINe($id_paquete_archivo){
	
		$query = $this->db->query("SELECT * FROM datos_ine d WHERE d.id_paquete_archivo = ?;", array($id_paquete_archivo));
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	

	}//termina getDatosINe


	public function getDatosHistorialLaboral($id_paquete_archivo){
	
		$query = $this->db->query("SELECT * FROM historial_laboral h WHERE h.id_paquete_archivo = ?;", array($id_paquete_archivo));
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getDatosHistorialLaboral

	public function getDatosConstancia($id_paquete_archivo){
	
		$query = $this->db->query("SELECT * FROM datos_constancia d WHERE d.id_paquete_archivo = ?;", array($id_paquete_archivo));
		
		return ($query->num_rows() <= 0) ? NULL : $query->row();
	
	}//termina getDatosConstancia

	public function insertPaqueteArchivo($datos){

		$this->db->insert('paquete_archivo', $datos);
        return ($this->db->affected_rows() > 0) ? $this->db->insert_id() : NULL;
			
	}//insertPaqueteArchivo

	public function insertHistorialTrabajo($datos){

		$this->db->insert('historial_trabajado', $datos);
        
		$error = $this->db->error();
		if ($error['code'] != 0) {
			return FALSE;
		}

		return TRUE;
			
	}//insertHistorialTrabajo

	public function insertArchivo($datos){

		$this->db->insert('archivos', $datos);
        return ($this->db->affected_rows() > 0) ? $this->db->insert_id() : NULL;
			
	}//insertArchivo

	public function insertDatosConstancia($datos){

		$this->db->insert('datos_constancia', $datos);
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}//insertDatosConstancia

	public function insertDatosIne($datos){

		$this->db->insert('datos_ine', $datos);
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}//insertDatosIne

	public function insertDatosComprobante($datos){

		$this->db->insert('datos_comprobante', $datos);
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}//insertDatosComprobante

	public function insertRegimenFiscal($datos){

		$this->db->insert('regimen_fiscal', $datos);
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}//insertRegimenFiscal

	public function insertHistorialLaboral($datos){

		$this->db->insert('regimen_fiscal', $datos);
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}//insertHistorialLaboral

	
	public function updateArchivo($datos, $id_archivo){

		$this->db->where('id_archivo', $id_archivo);
		$this->db->update('archivos',$datos);
		
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}  //updateArchivo 
	
	public function updateHistorialLaboral($datos, $id_historial_trabajado){

		$this->db->where('id_historial_trabajado', $id_historial_trabajado);
		$this->db->update('historial_trabajado',$datos);
		
        // return ($this->db->affected_rows() > 0) ? TRUE : NULL;
		$error = $this->db->error();
		if ($error['code'] != 0) {
			return FALSE;
		}

		return TRUE;
			
	}//updateHistorialLaboral 

	public function updateDatosConstancia($datos, $id_paquete_archivo){

		$this->db->where('id_paquete_archivo', $id_paquete_archivo);
		$this->db->update('datos_constancia',$datos);
		
        // return ($this->db->affected_rows() > 0) ? TRUE : NULL;
		$error = $this->db->error();
		if ($error['code'] != 0) {
			return FALSE;
		}

		return TRUE;
			
	}//updateDatosConstancia 

	public function updateDatosINEPaquete($datos, $id_paquete_archivo){

		$this->db->where('id_paquete_archivo', $id_paquete_archivo);
		$this->db->update('datos_ine',$datos);
		
		$error = $this->db->error();
		if ($error['code'] != 0) {
			return FALSE;
		}

		return TRUE;
			
	}//updateDatosINEPaquete 

	public function updateDatosConstanciaPaquete($datos, $id_paquete_archivo){

		$this->db->where('id_paquete_archivo', $id_paquete_archivo);
		$this->db->update('datos_constancia',$datos);
		
		$error = $this->db->error();
		if ($error['code'] != 0) {
			return FALSE;
		}

		return TRUE;
			
	}//updateDatosConstanciaPaquete 

	public function updateDatosComprobantePaquete($datos, $id_paquete_archivo){

		$this->db->where('id_paquete_archivo', $id_paquete_archivo);
		$this->db->update('datos_comprobante',$datos);
		
		$error = $this->db->error();
		if ($error['code'] != 0) {
			return FALSE;
		}

		return TRUE;

	}//updateDatosComprobantePaquete 

	public function updateDatosPaqueteArchivo($datos, $id_paquete_archivo){

		$this->db->where('id_paquete_archivo', $id_paquete_archivo);
		$this->db->update('paquete_archivo',$datos);
		
		$error = $this->db->error();
		if ($error['code'] != 0) {
			return FALSE;
		}

		return TRUE;
		
	}//updateDatosPaqueteArchivo 

	public function updateDatosINE($datos, $id_datos_ine){

		$this->db->where('id_datos_ine', $id_datos_ine);
		$this->db->update('datos_ine',$datos);
		
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}//updateDatosINE 

	public function updatePaqueteArchivo($datos, $id_paquete_archivo){

		$this->db->where('id_paquete_archivo', $id_paquete_archivo);
		$this->db->update('paquete_archivo',$datos);
		
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}//updatePaqueteArchivo


	public function deleteArchivo($id_archivo){

		$this->db->where('id_archivo', $id_archivo);
		$this->db->delete('archivos');
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}//deleteArchivo

	public function deleteDatosComprobante($id_archivo){

		$this->db->where('id_archivo', $id_archivo);
		$this->db->delete('datos_comprobante');
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}  //deleteDatosComprobante
	

	public function deleteDatosConstancia($id_archivo){

		$this->db->where('id_archivo', $id_archivo);
		$this->db->delete('datos_constancia');
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}//deleteDatosConstancia datos_ine

	public function deleteDatosIne($id_archivo){

		$this->db->where('id_archivo', $id_archivo);
		$this->db->delete('datos_ine');
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}//deleteDatosIne 

	public function deletePaqueteArchivo($id_paquete_archivo){

		$this->db->where('id_paquete_archivo', $id_paquete_archivo);
		$this->db->delete('paquete_archivo');
        return ($this->db->affected_rows() > 0) ? TRUE : NULL;
			
	}//deletePaqueteArchivo 


}