<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Vacantes extends CI_Controller {

	/*
	Creamos un constructor para validar que exista una sesion 
	y poder dar acceso a las siguientes vistas
	*/
	
	public function __construct(){
		
		parent::__construct();
		// $this->load->library('encrypt');
		
		header("Cache-Control: no-store,no-cache,must-revalidate;");
		header("Cache-Control: post-check=0,pre-check=0", FALSE);
		header("Pragma:no-chache");
	 	
		if($this->session->userdata("usuario") == false){
		
			$this->session->set_flashdata("error","Acceso Restringido");
	
			redirect("login/");
	
		}
		$this->load->model("vacantes_model", "model");		
	}

	public function index(){

		$data["_APP_TITTLE"] = "Vacantes";
		$data["_TAB"]        = "vaca";
		$data["main_menu"]   = $this->load->view('app/admin/nav/main_menu_nav', $data, TRUE);
		$data["nav"]         = $this->load->view('app/admin/nav/main_nav', $data, TRUE);
		$data["vacantes"]    = $this->model->getVacantes();
		$data["fragment"]    = $this->load->view('app/admin/fragments/vacantes_view', $data, TRUE);
		$this->load->view('app/admin/main_view', $data, FALSE);
	
	}//termina index

	public function viewInteresados() {

		if ($this->input->get("id")) {
			$id_vacante = $this->input->get("id");

			$vacante 		= $this->model->getInfoVacante($id_vacante);
			$postulaciones 	= $this->model->getPostulaciones($id_vacante);

			if (!is_null($postulaciones)) {

				$data["_APP_TITTLE"]     = "Interesados";
				$data["_TAB"]            = "inte";
				$data["main_menu"]       = $this->load->view('app/admin/nav/main_menu_nav', $data, TRUE);
				$data["nav"]             = $this->load->view('app/admin/nav/main_nav', $data, TRUE);
				$data["vacante"]   		 = $vacante;
				$data["postulaciones"]   = $postulaciones;
				$data["fragment"]        = $this->load->view('app/admin/fragments/interesados_view', $data, TRUE);
				$this->load->view('app/admin/main_view', $data, FALSE);

			}else {
				redirect("admin/vacantes");
			}

		}else{
			redirect("admin/vacantes");
		}

	}

	public function deleteTurno(){
		
		$id_turno_vacante = $this->input->post("id_turno_vacante");
			
		$update_t 					= array();
		$update_t['estatus'] 		= 0;

		if ($this->model->updateTurno($id_turno_vacante, $update_t)) {

			$respuesta   = 200;
			$mensaje     = "Turno eliminado con éxito";
			
		}else {

			$respuesta   = 500;
			$mensaje     = "Error al eliminar turno, vuelve a intentarlo";

		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina deleteTurno

	public function desactivarVacante(){
		
		$id_vacante = $this->input->post("id_vacante");
		$estatus 	= $this->input->post("estatus");

		$respuesta   	= 500;
		$mensaje     	= "";
			
		$update_v 						= array();
		$update_v['estatus_vacante']	= $estatus;

		if ($this->model->updateVacante($id_vacante, $update_v)) {

			$respuesta   = 200;
			$mensaje     = "Vacante desactivada con éxito";
			
		}else {

			$respuesta   = 500;
			$mensaje     = "Error al desactivar vacante, vuelve a intentarlo";

		}


		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina desactivarVacante

	public function activarVacante(){
		
		$id_vacante = $this->input->post("id_vacante");
		$estatus 	= $this->input->post("estatus");
		$respuesta  = 500;
		$mensaje    = "";

		$getVacante = $this->model->getInfoVacante($id_vacante);

		if (is_null($this->model->getVacanteUpdate($getVacante->id_vacante, $getVacante->nombre_vacante))) {
				
			$update_v 						= array();
			$update_v['estatus_vacante']	= $estatus;
	
			if ($this->model->updateVacante($id_vacante, $update_v)) {
	
				$respuesta   = 200;
				$mensaje     = "Vacante activada con éxito";
				
			}else {
	
				$respuesta   = 500;
				$mensaje     = "Error al activar vacante, vuelve a intentarlo";
	
			}

		}else {

			$respuesta   = 400;
			$mensaje     = "Parece que ya existe una vacante con este nombre";

		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina activarVacante

	public function updateVacante(){
		
		$id_vacante 	= $this->input->post("id_vacante");
		$nombre_vacante = $this->input->post("nombre_vacante");
		// $direccion 		= $this->input->post("direccion");

		$getVacante     = $this->model->getVacanteUpdate($id_vacante, $nombre_vacante);

		$respuesta   	= 500;
		$mensaje     	= "";

		if (is_null($getVacante)) {
			
			$update_v 					= array();
			$update_v['nombre_vacante']	= $nombre_vacante;
			// $update_v['direccion']		= $direccion;
	
			if ($this->model->updateVacante($id_vacante, $update_v)) {
	
				$respuesta   = 200;
				$mensaje     = "Vacante actualizada con éxito";
				
			}else {
	
				$respuesta   = 500;
				$mensaje     = "Error al actualizar vacante, vuelve a intentarlo";
	
			}

		}else {


			$respuesta   = 400;
			$mensaje     = "Parece que ya existe una vacante con este nombre";

		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina updateVacante

	public function updateTurno(){
		
		$id_turno_vacante 	= $this->input->post("id_turno_vacante");
		$id_vacante 		= $this->input->post("id_vacante");
		$nombre_turno 		= $this->input->post("nombre_turno");

		$getTurno     	= $this->model->getTurnoUpdate($id_turno_vacante, $id_vacante, $nombre_turno);

		$respuesta   	= 500;
		$mensaje     	= "";

		if (is_null($getTurno)) {
			
			$update_t 					= array();
			$update_t['desc_turno'] 	= $nombre_turno;
	
			if ($this->model->updateTurno($id_turno_vacante, $update_t)) {
	
				$respuesta   = 200;
				$mensaje     = "Turno actualizado con éxito";
				
			}else {
	
				$respuesta   = 500;
				$mensaje     = "Error al actualizar turno, vuelve a intentarlo";
	
			}

		}else {


			$respuesta   = 400;
			$mensaje     = "Parece que ya existe un turno con esta descripción";

		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina updateTurno

	public function addTurno(){
		
		$id_vacante 	= $this->input->post("id_vacante");
		$nombre_turno 	= $this->input->post("nombre_turno");

		$getTurno     	= $this->model->getTurno($id_vacante, $nombre_turno);

		$respuesta   	= 500;
		$mensaje     	= "";

		if (is_null($getTurno)) {
			
			$add_turno 					= array();
			$add_turno['desc_turno'] 	= $nombre_turno;
			$add_turno['id_vacante'] 	= $id_vacante;
	
			if ($this->model->insertTurno($add_turno)) {
	
				$respuesta   = 200;
				$mensaje     = "Turno agregado con éxito";
				
			}else {
	
				$respuesta   = 500;
				$mensaje     = "Error al agregar turno, vuelve a intentarlo";
	
			}

		}else {


			$respuesta   = 400;
			$mensaje     = "Parece que ya existe un turno con esta descripción";

		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina addTurno

	public function addVacante(){
		
		$nombre_vacante = $this->input->post("nombre_vacante");
		// $direccion 		= $this->input->post("direccion");

		$getVacante     = $this->model->getVacante($nombre_vacante);

		$respuesta   	= 500;
		$mensaje     	= "";

		if (is_null($getVacante)) {
			
			$add_vacante 					= array();
			$add_vacante['nombre_vacante'] 	= $nombre_vacante;
			// $add_vacante['direccion'] 		= $direccion;
			$add_vacante['id_usuario'] 		= $this->session->userdata("id_usuario");
	
			if ($this->model->insertVacante($add_vacante)) {
	
				$respuesta   = 200;
				$mensaje     = "Vacante agregada con éxito";
				
			}else {
	
				$respuesta   = 500;
				$mensaje     = "Error al agregar vacante, vuelve a intentarlo";
	
			}

		}else {


			$respuesta   = 400;
			$mensaje     = "Parece que ya existe una vacante con este nombre";

		}

		echo json_encode(array("respuesta" => $respuesta, "mensaje" => $mensaje));

	}//termina addVacante

	public function getTurnos(){
		
		$id_vacante = $this->input->post("id_vacante");

		$getTurnos  = $this->model->getTurnos($id_vacante);

		$tabla     = "";
		$cont      = 1;
		$respuesta = 400;

		if (!is_null($getTurnos)) {

			$respuesta 	= 200;
			$cont       = 1;
			$estatus	= "";
			foreach ($getTurnos as $v) {
				
				$tabla .= "<tr><td>".$cont."</td>";
				$tabla .= "<td>".$v->desc_turno."</td>";
				$tabla .= "<td><h4><span class='label label-success'>Activo<span></h4></td>";
				$tabla .= "<td><button class='getInfoTurno btn btn-warning' data-id=".$v->id_turno_vacante." data-id-vacante=".$v->id_vacante." style='width: 100px;'><i class='fa fa-refresh'></i> Actualizar</button><br>";
				$tabla .= "<button class='deleteTurno btn btn-danger' data-id=".$v->id_turno_vacante." data-id-vacante=".$v->id_vacante." style='width: 100px;'><i class='fa fa-trash'></i> Eliminar</button><br></td></tr>";

				$cont++;
			}//termina foreach

		}//termina isnull

		echo json_encode(array("tabla" => $tabla, "respuesta" => $respuesta));

	}//termina getTurnos

	public function getInfoTurno(){
		
		$id_turno_vacante = $this->input->post("id_turno_vacante");

		$getInfoTurno  	  = $this->model->getInfoTurno($id_turno_vacante);

		echo json_encode(array("id_turno_vacante" => $getInfoTurno->id_turno_vacante, "desc_turno" => $getInfoTurno->desc_turno));

	}//termina getInfoTurno

	public function getInfoVacante(){
		
		$id_vacante 	= $this->input->post("id_vacante");

		$getInfoVacante = $this->model->getInfoVacante($id_vacante);

		// echo json_encode(array("id_vacante" => $getInfoVacante->id_vacante, "nombre_vacante" => $getInfoVacante->nombre_vacante, "direccion" => $getInfoVacante->direccion));
		echo json_encode(array("id_vacante" => $getInfoVacante->id_vacante, "nombre_vacante" => $getInfoVacante->nombre_vacante));

	}//termina getInfoVacante

	public function filtrar(){
		
		$estatus = $this->input->post("estatus");

		if ($estatus == "#") {
			$getFiltro = $this->model->getFiltroTodos();
		}else {
			$getFiltro = $this->model->getFiltroEstatus($estatus);
		}

		$tabla     = "";
		$cont      = 1;
		$respuesta = 400;

		if (!is_null($getFiltro)) {

			
			$respuesta 		= 200;
			$cont           = 1;
			$btn_estatus    = "";
			$label_estatus  = "";
			foreach ($getFiltro as $v) {

				if ($v->estatus_vacante == 1) {
					$btn_estatus    = '<button class="updateEstatusVacante btn btn-danger" data-id="'.$v->id_vacante.'" data-estatus="0" style="width: 130px;"><i class="fa fa-arrow-down"></i> Desactivar</button><br>';
					$label_estatus  = "<h4><span class='label label-success'>Activa<span></h4>";
				}else {
					$btn_estatus    = '<button class="updateEstatusVacante btn btn-success" data-id="'.$v->id_vacante.'" data-estatus="1" style="width: 130px;"><i class="fa fa-arrow-up"></i> Activar</button><br>';
					$label_estatus  = "<h4><span class='label label-danger'>Desactivada<span></h4>";
				}
				
				$tabla .= "<tr><td>".$cont."</td>";
				$tabla .= "<td>".$v->nombre_vacante."</td>";
				// $tabla .= "<td>".$v->direccion."</td>";
				$tabla .= "<td>".$v->usuario."</td>";
				$tabla .= "<td>".$label_estatus."</td>";
				$tabla .= "<td>";
				$tabla .= "<a href='".base_url()."index.php/admin/vacantes/viewInteresados?id=".$v->id_vacante."' class='btn btn-primary' style='width: 130px;'><i class='fa fa-book'></i> Interesados</a><br>";
				$tabla .= "<button class='getInfoVacante btn btn-warning' data-id='".$v->id_vacante."' style='width: 130px;'><i class='fa fa-refresh'></i> Actualizar</button><br>";
				$tabla .= "<button class='verTurnos btn btn-info' data-id='".$v->id_vacante."' style='width: 130px;'><i class='fa fa-eye'></i> Turnos</button><br>";
				$tabla .= $btn_estatus."</td></tr>";

				$cont++;
			}//termina foreach

		}//termina isnull

		echo json_encode(array("tabla" => $tabla, "respuesta" => $respuesta));

	}//termina getTurnos

}
