<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Metricas extends CI_Controller {


	public function __construct(){
		
		parent::__construct();

		$this->load->model("metricas_model", "model");
		
		header("Cache-Control: no-store,no-cache,must-revalidate;");
		header("Cache-Control: post-check=0,pre-check=0", FALSE);
		header("Pragma:no-chache");
	 	
		if($this->session->userdata("usuario") == false){
		
			$this->session->set_flashdata("error","Acceso Restringido");
	
			redirect("login/");
	
		}
		
	}

	public function index(){

		$data["_APP_TITTLE"] = "Métricas";
		$data["_TAB"]        = "met";
		$data["main_menu"]   = $this->load->view('app/admin/nav/main_menu_nav', $data, TRUE);
		$data["nav"]         = $this->load->view('app/admin/nav/main_nav', $data, TRUE);
		$data["fragment"]    = $this->load->view('app/admin/fragments/metricas_view', $data, TRUE);
		$this->load->view('app/admin/main_view', $data, FALSE);
	}// termina index

	public function filtrar(){

		$inicio  = $this->input->post("inicio");
		$fin     = $this->input->post("fin");
		$inicio  = date("Y-m-d", strtotime($inicio));
		$fin     = date("Y-m-d", strtotime($fin));

		$personasRegistradas  = $this->model->personasRegistradas($inicio, $fin);
		$data_0     = array();
		$name_0     = array();
		$contPers   = 0;
		$color 		= '';

		if (!is_null($personasRegistradas)) {
			foreach ($personasRegistradas as $v) {

				if ($v->descripcion == "Facebook") {
					$color = "#4267B2";
				}else {
					$color = "#25D366";
				}

				$data_0 	= null;
				$data_0[]   = array('name'=> ''.$v->descripcion.'', 'y' => (int)$v->tot, 'drilldown' => 'Tipo', 'color' => $color);
				$name_0[]   = array('name' => "", 'colorByPoint' => true, 'data' => $data_0);
				$contPers 	= $contPers + $v->tot;
			}
		}//termina is_null

		$horasMasUtilizadoWhatsApp = $this->model->horasMasUtilizadoWhatsApp($inicio, $fin);
		$data_1     = array();
		$name_1     = array();

		if (!is_null($horasMasUtilizadoWhatsApp)) {
			
			foreach ($horasMasUtilizadoWhatsApp as $v) {
				$data_1 = null;
				$data_1[] = array('name'=> ''.$v->hora.' Hrs', 'y' => (int)$v->tot, 'drilldown' => 'Tipo');
				$name_1[] = array('name' => "", 'colorByPoint' => true, 'data' => $data_1);
			}

		}//termina is_null

		$horasMasUtilizadoFacebook = $this->model->horasMasUtilizadoFacebook($inicio, $fin);
		$data_2     = array();
		$name_2     = array();

		if (!is_null($horasMasUtilizadoFacebook)) {
			
			foreach ($horasMasUtilizadoFacebook as $v) {
				$data_2 = null;
				$data_2[] = array('name'=> ''.$v->hora.' Hrs', 'y' => (int)$v->tot, 'drilldown' => 'Tipo');
				$name_2[] = array('name' => "", 'colorByPoint' => true, 'data' => $data_2);
			}

		}//termina is_null

		$totalPostulaciones = $this->model->totalPostulaciones($inicio, $fin);
		$data_3     = array();
		$name_3     = array();
		$contPost   = 0;

		if (!is_null($totalPostulaciones)) {
			
			foreach ($totalPostulaciones as $v) {
				$data_3 = null;
				$data_3[] = array('name'=> 'Postulaciones', 'y' => (int)$v->tot, 'drilldown' => 'Tipo');
				$name_3[] = array('name' => "", 'colorByPoint' => true, 'data' => $data_3);
				$contPost = $contPost + $v->tot;
			}

		}//termina is_null

		$postulacionesVacantes 	= $this->model->postulacionesVacantes($inicio, $fin);
		$data_4     			= array();
		$name_4     			= array();

		if (!is_null($postulacionesVacantes)) {
			
			foreach ($postulacionesVacantes as $v) {
				$data_4 = null;
				$data_4[] = array('name'=> ''.$v->descripcion.'', 'y' => (int)$v->tot, 'drilldown' => 'Tipo');
				$name_4[] = array('name' => "", 'colorByPoint' => true, 'data' => $data_4);
			}

		}//termina is_null

		$getDatosBot = $this->getDatosBot($inicio, $fin);

		$name_5 = array(
			'0' => (int)$getDatosBot["tot_sesiones"],
			'1' => (int)$getDatosBot["tot_usuarios"]
		);


		echo json_encode(array("personas_registradas" => $name_0, "hora_utilizado_whatsapp" => $name_1, "hora_utilizado_facebook" => $name_2, "total_postulaciones" => $name_3, "postulaciones_vacantes" => $name_4, "contPers" => $contPers, "contPost" => $contPost, "msjs_usuarios" => $getDatosBot["msjs_usuarios"], "msjs_bot" => $getDatosBot["msjs_bot"], "sesiones_usuarios" => $name_5));

	}//termina filtrar

	public function getDatosBot($fecha_inicio, $fecha_fin){

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://go.botmaker.com/api/v1.0/metrics');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
		
		
		$headers = array();
		$headers[] = 'Accept: application/json';
		$headers[] = 'Dateisofrom: '.$fecha_inicio.'T00:00:00.000Z';
		$headers[] = 'Dateisoto: '.$fecha_fin.'T00:00:00.000Z';
		$headers[] = 'Access-Token: eyJhbGciOiJIUzUxMiJ9.eyJidXNpbmVzc0lkIjoiRmFjdG9yWCIsIm5hbWUiOiJEYW5pZWwgTMOzcGV6IiwiYXBpIjp0cnVlLCJpZCI6Ik51QVkyenozbFlPUjd3NVFCR3pNWms1SFo2azEiLCJleHAiOjE3NTI1OTMwODUsImp0aSI6Ik51QVkyenozbFlPUjd3NVFCR3pNWms1SFo2azEifQ.NF4Ab9BQZfJ1DcgbgR9a2fuNFMu8j1KPDKf0bNoCwoJZpxjN94JhNuCpPsflLVmTT3x38vkrjMnrV9_Ew_-EJg';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
		
		$result = curl_exec($ch);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);

		$json 		= json_decode($result);
		$respuesta 	= 500;

		$msjs_usuarios 	= 0;
		$msjs_bot 		= 0;
		$tot_sesiones 	= 0;
		$tot_usuarios 	= 0;

		if (is_object($json)) {

			if (count($json->byChannels) > 0) {

				$json = $json->byChannels;
		
				for ($i=0; $i < count($json); $i++) { 
					
					$channelId 			= $json[$i]->channelId;
					$explodeChannelId 	= explode("-",$channelId);
		
					if ($explodeChannelId[2] == "5216648841034") {
						$msjs_usuarios 	= $json[$i]->totalMsgByUser;
						$msjs_bot 		= $json[$i]->totalMsgByBot;
						$tot_sesiones 	= $json[$i]->totalSessions;
						$tot_usuarios 	= $json[$i]->totalUsers;
						$respuesta 		= 200;
					}
		
				}
				
			}
			
		}

		return array("respuesta" => $respuesta, "msjs_usuarios" => $msjs_usuarios, "msjs_bot" => $msjs_bot, "tot_sesiones" => $tot_sesiones, "tot_usuarios" => $tot_usuarios);

	}


}//termina CI Controller


