<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Catalogo_supervisor extends CI_Controller {

    public function __construct(){
        parent::__construct();
        header("Cache-Control: no-store,no-cache,must-revalidate;");
        header("Cache-Control: post-check=0,pre-check=0", FALSE);
        header("Pragma:no-chache");
        
        if($this->session->userdata("usuario") == false){
            $this->session->set_flashdata("error","Acceso Restringido");
            redirect("login/");
        }
        
        $this->load->model("catalogo_supervisor_model", "model");
    }

    public function index(){
        $data["_APP_TITTLE"] = "Catálogo de Supervisores";
        $data["_TAB"]        = "cat_supervisores";
        $data["main_menu"]   = $this->load->view('app/admin/nav/main_menu_nav', $data, TRUE);
        $data["nav"]         = $this->load->view('app/admin/nav/main_nav', $data, TRUE);
        $data["supervisores"] = $this->model->get_supervisores();
        $data["fragment"]    = $this->load->view('app/admin/fragments/catalogo_supervisor_fragment_view', $data, TRUE);
        $this->load->view('app/admin/main_view', $data, FALSE);
    }

    public function ajax_add_supervisor() {
        $data = array(
            'num_empleado' => $this->input->post('num_empleado'),
            'nombre_supervisor' => $this->input->post('nombre_supervisor'),
            'organizacion' => $this->input->post('organizacion'),
            'centro_costos' => $this->input->post('centro_costos'),
        );
        $this->model->insert_supervisor($data);
        echo json_encode(array("status" => TRUE));
    }

    public function ajax_update_supervisor() {
        $id = $this->input->post('id_catalogo_supervisor');
        $data = array(
            'num_empleado' => $this->input->post('num_empleado'),
            'nombre_supervisor' => $this->input->post('nombre_supervisor'),
            'organizacion' => $this->input->post('organizacion'),
            'centro_costos' => $this->input->post('centro_costos'),
        );
        $this->model->update_supervisor($id, $data);
        echo json_encode(array("status" => TRUE));
    }

    public function ajax_delete_supervisor() {
        $id = $this->input->post('id_catalogo_supervisor');
        $this->model->delete_supervisor($id);
        echo json_encode(array("status" => TRUE));
    }
}
