<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Catalogo_puesto extends CI_Controller {

    public function __construct(){
        parent::__construct();
        header("Cache-Control: no-store,no-cache,must-revalidate;");
        header("Cache-Control: post-check=0,pre-check=0", FALSE);
        header("Pragma:no-chache");
        
        if($this->session->userdata("usuario") == false){
            $this->session->set_flashdata("error","Acceso Restringido");
            redirect("login/");
        }
        
        $this->load->model("catalogo_puesto_model", "model");
    }

    public function index(){
        $data["_APP_TITTLE"] = "Catálogo de Puestos";
        $data["_TAB"]        = "cat_puestos";
        $data["main_menu"]   = $this->load->view('app/admin/nav/main_menu_nav', $data, TRUE);
        $data["nav"]         = $this->load->view('app/admin/nav/main_nav', $data, TRUE);
        $data["puestos"]     = $this->model->get_puestos();
        $data["fragment"]    = $this->load->view('app/admin/fragments/catalogo_puesto_fragment_view', $data, TRUE);
        $this->load->view('app/admin/main_view', $data, FALSE);
    }

    public function ajax_get_puestos() {
        $list = $this->model->get_puestos();
        $data = array();
        foreach ($list as $puesto) {
            $row = array();
            $row[] = $puesto->id_catalogo_puesto;
            $row[] = $puesto->puesto;
            $row[] = $puesto->job_profile;
            $row[] = $puesto->position_title;
            $row[] = $puesto->legacy_amount;
            $row[] = $puesto->jg;
            $data[] = $row;
        }

        $output = array(
            "draw" => $_POST['draw'],
            "recordsTotal" => count($list),
            "recordsFiltered" => count($list),
            "data" => $data,
        );
        echo json_encode($output);
    }

    public function ajax_add_puesto() {
        $data = array(
            'puesto' => $this->input->post('puesto'),
            'job_profile' => $this->input->post('job_profile'),
            'position_title' => $this->input->post('position_title'),
            'legacy_amount' => $this->input->post('legacy_amount'),
            'jg' => $this->input->post('jg'),
        );
        $this->model->insert_puesto($data);
        echo json_encode(array("status" => TRUE));
    }

    public function ajax_update_puesto() {
        $data = array(
            'puesto' => $this->input->post('puesto'),
            'job_profile' => $this->input->post('job_profile'),
            'position_title' => $this->input->post('position_title'),
            'legacy_amount' => $this->input->post('legacy_amount'),
            'jg' => $this->input->post('jg'),
        );
        $this->model->update_puesto($this->input->post('id_catalogo_puesto'), $data);
        echo json_encode(array("status" => TRUE));
    }

    public function ajax_delete_puesto() {
        $id = $this->input->post('id_catalogo_puesto');
        $this->model->delete_puesto($id);
        echo json_encode(array("status" => TRUE));
    }
}
