<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class getDatosImss extends CI_Controller{

	public function __construct(){
		parent::__construct();
		$this->load->model("archivos_model");

	}  //termina constructor
	
	public function index(){

		// Recibir el JSON desde la API
		$inputJSON = file_get_contents("php://input");
		$data      = json_decode($inputJSON, true);
		

		file_put_contents("TestWebHook.log", date("Y-m-d H:i:s") . " - " . json_encode($data) . PHP_EOL, FILE_APPEND);

		// Inicializar variables en null para evitar errores si no existen en la respuesta
		$status           = $messageCode = $message         = $validationCode  = null;
		$nss              = $curp        = $apellidoPaterno = $apellidoMaterno = $nombre              = $sexo         = null;
		$registroPatronal = $modalidad   = $rfcPatron       = $razonSocial     = $entidadFederativa   = $claveEntidad = $salarioBase  = $dias               = null;
		$mesOrigen        = $anioOrigen  = $mesOrigenInt    = $anioOrigenInt   = $fechaEmisionReporte = $mesCorriente = $mesSiguiente = $anioEmisionReporte = $mesProximoReporte = null;
		

		// Validar si el JSON tiene datos
		if (!isset($data['messageCode'])) {
			die(json_encode(["error" => "messageCode no encontrado en la respuesta."]));
		}

		// Asignar valores generales
		$status         = $data['status'] ?? null;
		$messageCode    = $data['messageCode'] ?? null;
		$message        = $data['message'] ?? null;
		$validationCode = $data['validationCode'] ?? null;
		
		// Verificar si la clave 'data' existe antes de acceder a sus valores
		if (isset($data['data'])) {

			$nss             = $data['data']['nss'] ?? null;
			$curp            = $data['data']['curp'] ?? null;
			$apellidoPaterno = $data['data']['apellidoPaterno'] ?? null;
			$apellidoMaterno = $data['data']['apellidoMaterno'] ?? null;
			$nombre          = $data['data']['nombre'] ?? null;
			$sexo            = $data['data']['sexo'] ?? null;
			

			// Verificar si 'informacionLaboral' existe antes de acceder a sus valores
			if (isset($data['data']['informacionLaboral'])) {

				$registroPatronal  = $data['data']['informacionLaboral']['registroPatronal'] ?? null;
				$modalidad         = $data['data']['informacionLaboral']['modalidad'] ?? null;
				$rfcPatron         = $data['data']['informacionLaboral']['rfcPatron'] ?? null;
				$razonSocial       = $data['data']['informacionLaboral']['razonSocial'] ?? null;
				$entidadFederativa = $data['data']['informacionLaboral']['entidadFederativa'] ?? null;
				$claveEntidad      = $data['data']['informacionLaboral']['claveEntidad'] ?? null;
				$salarioBase       = $data['data']['informacionLaboral']['salarioBase'] ?? null;
				$dias              = $data['data']['informacionLaboral']['dias'] ?? null;
				
			}

			// Verificar si 'datosOriginacion' existe antes de acceder a sus valores
			if (isset($data['data']['datosOriginacion'])) {

				$mesOrigen           = $data['data']['datosOriginacion']['mesOrigen'] ?? null;
				$anioOrigen          = $data['data']['datosOriginacion']['anioOrigen'] ?? null;
				$mesOrigenInt        = $data['data']['datosOriginacion']['mesOrigenInt'] ?? null;
				$anioOrigenInt       = $data['data']['datosOriginacion']['anioOrigenInt'] ?? null;
				$fechaEmisionReporte = $data['data']['datosOriginacion']['fechaEmisionReporte'] ?? null;
				$mesCorriente        = $data['data']['datosOriginacion']['mesCorriente'] ?? null;
				$mesSiguiente        = $data['data']['datosOriginacion']['mesSiguiente'] ?? null;
				$anioEmisionReporte  = $data['data']['datosOriginacion']['anioEmisionReporte'] ?? null;
				$mesProximoReporte   = $data['data']['datosOriginacion']['mesProximoReporte'] ?? null;
				
			}
		}


        $historialData = [

			"status"              => $status,
            "messageCode"         => $messageCode,
            "message"             => $message,
            "validationCode"      => $validationCode,
            "nss"                 => $nss,
            "curp"                => $curp,
            "apellidoPaterno"     => $apellidoPaterno,
            "apellidoMaterno"     => $apellidoMaterno,
            "nombre"              => $nombre,
            "sexo"                => $sexo,
            "registroPatronal"    => $registroPatronal,
            "modalidad"           => $modalidad,
            "rfcPatron"           => $rfcPatron,
            "razonSocial"         => $razonSocial,
            "entidadFederativa"   => $entidadFederativa,
            "claveEntidad"        => $claveEntidad,
            "salarioBase"         => $salarioBase,
            "dias"                => $dias,
            "mesOrigen"           => $mesOrigen,
            "anioOrigen"          => $anioOrigen,
            "mesOrigenInt"        => $mesOrigenInt,
            "anioOrigenInt"       => $anioOrigenInt,
            "fechaEmisionReporte" => $fechaEmisionReporte,
            "mesCorriente"        => $mesCorriente,
            "mesSiguiente"        => $mesSiguiente,
            "anioEmisionReporte"  => $anioEmisionReporte,
            "mesProximoReporte"   => $mesProximoReporte	
        ];

		$respuesta = 400;

		// Procesar según el messageCode
		
		file_put_contents("TestWebHook.log",  $messageCode. PHP_EOL, FILE_APPEND);
		switch ($messageCode) {
			case 0:
				// echo "NSS Activo y contribuye:\n";
				// echo "Nombre: $nombre $apellidoPaterno $apellidoMaterno\n";
				// echo "CURP: $curp\n";
				// echo "NSS: $nss\n";
				// echo "Registro Patronal: $registroPatronal\n";
				// echo "Razón Social: $razonSocial\n";
				// echo "Salario Base: $salarioBase\n";
					
				$this->archivos_model->insertHistorialTrabajo($historialData);
				$respuesta = 200;
				break;
			
			case 1:
				// echo "NSS Inactivo y no contribuye:\n";
				// echo "Nombre: $nombre $apellidoPaterno $apellidoMaterno\n";
				// echo "CURP: $curp\n";
				// echo "NSS: $nss\n";
				

				$this->archivos_model->insertHistorialTrabajo($historialData);
				$respuesta = 200;
				break;

			case 3:
				echo "Error en el IMSS: Necesita acudir a la subdelegación.\n";
				break;

			default:
				echo "Código de mensaje no reconocido.\n";
				break;
		}


		echo "Respuesta: ".$respuesta;

	}//termina index

} //termina class Chatbot extends CI_Controll 