<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Chatbot_bd extends CI_Controller{

	public function __construct(){
		parent::__construct();
		$this->load->model("chatbot_model");

	} //termina constructor

	public function index(){

		// die();

		$json    = file_get_contents('php://input');
		$decoded = json_decode($json,true);
		http_response_code(200);

		$fromCustomer = false;
		$cel          = null;
		$mensaje_whats = '';


		date_default_timezone_set('America/Tijuana');
		
		$tiempo = date("Y-m-d H:i");
		
		$p0           = "";
		$p1           = "";
		$p2           = "";
		$p3           = "";
		$p4           = "";
		$p5           = "";
		$p6           = "";
		$id_persona   = 0;
		$conversacion = 1;
		$id_paquete   = 0;
		
		// ob_start();
        // var_dump($decoded);
        // $input = ob_get_contents()."mnsj2";
        // ob_end_clean();
        // file_put_contents('bd_normal.log',$input.PHP_EOL,FILE_APPEND);


        if(!is_null($decoded)){
			
			$payload       = $decoded["payload"];
			$timestamp_bot = $decoded["timestamp"];

			if (isset($decoded["type"])) {
				$type_event = $decoded["type"];
				if ($type_event == "message-event") {
					$payEvento     = $decoded["payload"];
					$evento        = $payEvento["type"];
				}
			}

			if(!is_null($payload)){

				if (isset($payload["source"])) {
					$cel = $payload["source"];
				}

				$sender        = $payload["sender"];

				if(array_key_exists('name', $sender)){
					$nombre_whats = $sender["name"];
				}

				if(array_key_exists('payload', $payload)){

					$pay           = $payload["payload"];
					$type           = $payload["type"];
				
					if (array_key_exists('text', $pay)) {
						$mensaje_whats = $pay["text"];
					}else if ($type == "file") {
						$file          = $pay["url"];
						$mensaje_whats = '';
						$content_type  = $pay["contentType"];
					}else if ($type == "button_reply") {
						$title_button = $pay["title"];
					}else if ($type == "image") {
						$image         = $pay["url"];
						$content_type  = $pay["contentType"];
						$mensaje_whats = '';
					}else if ($type == "video") {
						$video         = $pay["url"];
						$content_type  = $pay["contentType"];
						$mensaje_whats = '';
					}
					else if ($type == "sticker") {
						$sticker       = $pay["url"];
						$content_type  = $pay["contentType"];
						$mensaje_whats = '';
					}
					else if ($type == "audio") {
						$audio         = $pay["url"];
						$content_type  = $pay["contentType"];
						$mensaje_whats = '';
					}
					else if ($type == "contact") {
						$count_contact = count($pay["contacts"]);
						$contact       = $pay["contacts"][0]["phones"][0]["phone"];
						$mensaje_whats = '';
					}else if($type == "list_reply"){
						$mensaje_whats = $pay["title"];
						$valor_list    = $pay["postbackText"];
					}

					if (array_key_exists('latitude', $pay) && array_key_exists('longitude', $pay)) {
						$latitude = $pay["latitude"];
						$longitude = $pay["longitude"];
					}


				}else{
					$mensaje_whats = "NA";
				}

				$type          = $payload["type"];

				if($type == "order"){

					$context = $payload["context"];

				}


			}//termina is null payload

		}//termina isnull decoded

        // ob_start();
        // var_dump($decoded);
        // $input = ob_get_contents()."mnsj2";
        // //$input = $decoded["message"];
        // ob_end_clean();
        // file_put_contents('gabinete_p.log',$input.PHP_EOL,FILE_APPEND);


		


		$v = $this->chatbot_model->getPregunta($cel);
		
		$nombre_c = '';
		$curp     = null;
		
		if (!is_null($v)) {
			
			$p0           = $v->pregunta_0;
			$p1           = $v->pregunta_1;
			$p2           = $v->pregunta_2;
			$p3           = $v->pregunta_3;
			$p4           = $v->pregunta_4;
			$p5           = $v->pregunta_5;
			$p6           = $v->pregunta_6;
			$nombre_c     = $v->nombre;
			$id_persona   = $v->id_persona;
			$conversacion = $v->conversacion;
			$id_paquete   = $v->id_paquete;
			$curp         = $v->curp;
			

		} //termina if !is_null

		$asesores = $this->chatbot_model->getAsesores($cel);
		$asesor   = 400;
		
		if (!is_null($asesores)) {
			$asesor = 200;
		} //termina if !is_null
		

		
		$mensaje_w         = strtoupper($mensaje_whats);
		$mensaje_w         = $this->quitar_tildes($mensaje_w);

		$arreglo_menu                = array('pregunta','hola','menu');
		list($return_menu, $palabra) = $this->palabra_clave($arreglo_menu, $mensaje_w);

		if(!is_null($cel)){

			if($conversacion == 1){
				
				if($asesor == 200){//Si es asesor...

					if($p0 == ""){
						$this->pregunta0_asesor($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo);
					}
					else if($p1 == ""){
						$this->pregunta1_asesor($mensaje_whats, $title_button, $cel, $nombre_c, $fromCustomer, $tiempo);
					}
					else if($p2 == ""){
						$this->pregunta2_asesor($mensaje_whats, $image, $cel, $nombre_c, $fromCustomer, $tiempo);
					}
					else if($p3 == ""){
						$this->pregunta3_asesor($mensaje_whats, $file, $cel, $nombre_c, $fromCustomer, $tiempo, $id_paquete);
					}
					else if($p4 == ""){
						$this->pregunta4_asesor($mensaje_whats, $file, $image, $cel, $nombre_c, $fromCustomer, $tiempo, $id_paquete, $curp);
					}
				}else{

					if($p0 == ""){
						$this->pregunta0($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo);
					}

					else if($p1 == ""){
						$this->pregunta1($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo);
					}
					else if($p2 == "" && $p1 == "RH"){
						$this->pregunta2_RH($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo);
					}
					else if($p2 == ""){
						$this->pregunta2($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo);
					}
					else if($p3 == ""){
						$this->pregunta3($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo);
					}

					// =========== VACANTES ===========

						else if($p4 == "" && $p3 == "VACANTES"){
							$this->pregunta4_vacantes($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo, $id_persona);
						}
						else if ($p5 == "" && $p3 == "VACANTES") {
							$this->pregunta5_vacantes($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo, $id_persona, $p4);
						}
						else if($p6 == "" && $p3 == "VACANTES"){
							$this->pregunta_reinicio($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo);
						}



					// =========== ¿Cómo puedo ser parte del equipo BD? ===========

						else if($p4 == "" && $p3 == "SER_PARTE_BD"){
							$this->pregunta4_parte_bd($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo);
						}
						else if($p5 == "" && $p3 == "SER_PARTE_BD"){
							$this->pregunta_reinicio($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo);
						}

					// =========== RUTAS ===========

						else if($p4 == "" && $p3 == "RUTAS"){
							$this->pregunta_reinicio($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo);
						}

					// =========== DOCUMENTOS ===========

						else if($p4 == "" && $p3 == "DOCUMENTOS"){
							$this->pregunta_reinicio($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo);
						}

					// =========== BANCO ===========

						else if($p4 == "" && $p3 == "BANCO"){
							$this->pregunta_reinicio($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo);
						}



				}

			}//termina conversación


		}//termina if $fromCustomer



	}//termina index


	public function pregunta4_asesor($mensaje_whats, $file, $image, $cel, $nombre_c, $fromCustomer, $tiempo, $id_paquete, $curp){



		if(!is_null($file)){

			$message = "Permiteme un momento, estoy analizando el comprobante... ⏳";
			$this->mensaje_bot($message,$cel,$fromCustomer);
			
			$extension = $this->getExtension($file);

			if($extension == "pdf"){

				$update_p                 = array();
				$update_p["conversacion"] = 0;
				$update_p["fecha_ultima"] = $tiempo;
				$this->chatbot_model->updatePregunta($cel,$update_p);

				$nombre_archivo = $id_paquete."-Comprobante.pdf";
				$url            = $file;
				$file_path      = "static/uploads/".$nombre_archivo;//Lugar donde se va a almacenar el archiv

				$comprobante = $this->comprobantePDF($url, $id_paquete, $file_path);

				if($comprobante == 200){

					if($this->fileDownload($url, $file_path)){

						$message = "🎉 ¡Maravilloso!, hemos terminado de subir los datos 👏. Si quieres realizar otro registro oprime el siguiente botón 👇.";
						$this->mensaje_bot($message,$cel,$fromCustomer);

						$cabecera = "";
						$mensaje  = "Oprime el botón para iniciar a registrar 👇";
						$pie      = "";
			
						$options[] = array('type' => 'text', 'title' => 'Comenzar', "encodeText" => true);
						$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);

						
						$update_p                 = array();
						$update_p["pregunta_1"]   = NULL;
						$update_p["pregunta_2"]   = NULL;
						$update_p["pregunta_3"]   = NULL;
						$update_p["pregunta_4"]   = NULL;
						$update_p["conversacion"] = 1;
						$update_p["fecha_ultima"] = $tiempo;
						$this->chatbot_model->updatePregunta($cel,$update_p);

						$getNss     = $this->getNss($curp, $id_paquete);
						$return_nss = $getNss["return"];
						
						if($return_nss == 200){
				
							$nss = $getNss["nss"];
							$this->getHistorialImss($curp, $nss);
			
						}


					}else{
					
						
						$update_p                 = array();
						$update_p["conversacion"] = 1;
						$update_p["fecha_ultima"] = $tiempo;
						$this->chatbot_model->updatePregunta($cel,$update_p);

						$message = "Ocurrio un error al guardar la *Constancia* por favor vuelve a intentarlo";
						$this->mensaje_bot($message,$cel,$fromCustomer);

					}
					
				}else{

					$update_p                 = array();
					$update_p["conversacion"] = 1;
					$update_p["fecha_ultima"] = $tiempo;
					$this->chatbot_model->updatePregunta($cel,$update_p);

					$message = "No pude leer el comprobante de domicilio, asegurate que sea un archivo correcto por favor.";
					$this->mensaje_bot($message,$cel,$fromCustomer);

				}

			}else{

				$update_p                 = array();
				$update_p["conversacion"] = 1;
				$update_p["fecha_ultima"] = $tiempo;
				$this->chatbot_model->updatePregunta($cel,$update_p);

				$message = "Por favor comparteme la foto o archivo (PDF) del *comprobante de domicilio*";
				$this->mensaje_bot($message,$cel,$fromCustomer);

			}


		}else if(!is_null($image)){

			$message = "Permiteme un momento, estoy analizando el comprobante... ⏳";
			$this->mensaje_bot($message,$cel,$fromCustomer);

			$update_p                 = array();
			$update_p["conversacion"] = 0;
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

			$nombre_archivo = $id_paquete."-Comprobante.jpeg";
			$url            = $image;
			$file_path      = "static/uploads/".$nombre_archivo;//Lugar donde se va a almacenar el archiv

			$comprobante = $this->comprobantePDF($url, $id_paquete, $file_path);

			if($comprobante == 200){

				if($this->fileDownload($url, $file_path)){

					$message = "🎉 ¡Maravilloso!, hemos terminado de subir los datos 👏. Si quieres realizar otro registro oprime el siguiente botón 👇.";
					$this->mensaje_bot($message,$cel,$fromCustomer);

					$cabecera = "";
					$mensaje  = "Oprime el botón para iniciar a registrar 👇";
					$pie      = "";
		
					$options[] = array('type' => 'text', 'title' => 'Comenzar', "encodeText" => true);
					$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);

					$update_p                 = array();
					$update_p["pregunta_1"]   = NULL;
					$update_p["pregunta_2"]   = NULL;
					$update_p["pregunta_3"]   = NULL;
					$update_p["pregunta_4"]   = NULL;
					$update_p["conversacion"] = 1;
					$update_p["fecha_ultima"] = $tiempo;
					$this->chatbot_model->updatePregunta($cel,$update_p);

					$getNss     = $this->getNss($curp, $id_paquete);
					$return_nss = $getNss["return"];
					
					if($return_nss == 200){
			
						$nss = $getNss["nss"];
						$this->getHistorialImss($curp, $nss);
		
					}

				}else{
				
					
					$update_p                 = array();
					$update_p["conversacion"] = 1;
					$update_p["fecha_ultima"] = $tiempo;
					$this->chatbot_model->updatePregunta($cel,$update_p);

					$message = "Ocurrio un error al guardar el *Comprobante* por favor vuelve a intentarlo";
					$this->mensaje_bot($message,$cel,$fromCustomer);

				}
				
			}else{

				$update_p                 = array();
				$update_p["conversacion"] = 1;
				$update_p["fecha_ultima"] = $tiempo;
				$this->chatbot_model->updatePregunta($cel,$update_p);

				$message = "No pude leer el comprobante de domicilio, asegurate que sea un archivo correcto por favor.";
				$this->mensaje_bot($message,$cel,$fromCustomer);

			}


		}else{

			$message = "Por favor comparteme la foto o archivo (PDF) del *comprobante de domicilio*";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}


	}//termina pregunta4_asesor

	public function pregunta3_asesor($mensaje_whats, $file, $cel, $nombre_c, $fromCustomer, $tiempo, $id_paquete){

		if(!is_null($file)){

			$message = "Permiteme un momento, estoy analizando la constancia... ⏳";
			$this->mensaje_bot($message,$cel,$fromCustomer);

			$extension = $this->getExtension($file);
						
			if($extension == "pdf"){

				$update_p                 = array();
				$update_p["conversacion"] = 0;
				$update_p["fecha_ultima"] = $tiempo;
				$this->chatbot_model->updatePregunta($cel,$update_p);

				$constancia = $this->constanciaPDF($file, $id_paquete);
				$return     = $constancia["return"];
				
				if($return == 200){

					$nombre_archivo = $id_paquete."-Constancia.pdf";
					$url            = $file;
					$file_path      = "static/uploads/".$nombre_archivo;
	
					if($this->fileDownload($url, $file_path)){

						$message = "¡Perfecto! por último comparteme una foto o documento del *comprobante de domicilio* 📄👇.";
						$this->mensaje_bot($message,$cel,$fromCustomer);
	
						$update_p                 = array();
						$update_p["pregunta_3"]   = "COMPROBANTE";
						$update_p["conversacion"] = 1;
						$update_p["fecha_ultima"] = $tiempo;
						$this->chatbot_model->updatePregunta($cel,$update_p);

					}else{
					
						
						$update_p                 = array();
						$update_p["conversacion"] = 1;
						$update_p["fecha_ultima"] = $tiempo;
						$this->chatbot_model->updatePregunta($cel,$update_p);
	
						$message = "Ocurrio un error al guardar la *Constancia* por favor vuelve a intentarlo";
						$this->mensaje_bot($message,$cel,$fromCustomer);

					}




				}else{

					$update_p                 = array();
					$update_p["conversacion"] = 1;
					$update_p["fecha_ultima"] = $tiempo;
					$this->chatbot_model->updatePregunta($cel,$update_p);

					$message = "No pudimos leer la constancia, por favor intentalo con un archivo valido 📄👇. file: ".$file;
					$this->mensaje_bot($message,$cel,$fromCustomer);

				}



			}else{

				$update_p                 = array();
				$update_p["conversacion"] = 1;
				$update_p["fecha_ultima"] = $tiempo;
				$this->chatbot_model->updatePregunta($cel,$update_p);

				$message = "Por favor envíame la constancia en formato PDF 📄👇.";
				$this->mensaje_bot($message,$cel,$fromCustomer);

			}


		}else{
			

			$message = "Por favor envíame la constancia en formato PDF 📄👇.";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}

	}//termina pregunta3_asesor








	public function pregunta2_asesor($mensaje_whats, $image, $cel, $nombre_c, $fromCustomer, $tiempo){

		if(!is_null($image)){


			$update_p                 = array();
			$update_p["conversacion"] = 0;
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

			$escanear           = $this->escanearINE($image, $cel);
			$return             = $escanear["return"];
			$id_paquete_archivo = $escanear["id_paquete_archivo"];
			$curp               = $escanear["curp"];
			
			if($return == 200){

				$nombre_archivo = $id_paquete_archivo."-INE.jpeg";
				$url            = $image;
				$file_path      = "static/uploads/".$nombre_archivo;

				if($this->fileDownload($url, $file_path)){
					
					$message = "¡Muy bien! ahora comparte la *constancia de situación* fiscal en formato PDF 📄👇.";
					$this->mensaje_bot($message,$cel,$fromCustomer);

					$update_p                 = array();
					$update_p["pregunta_2"]   = "CONSTANCIA";
					$update_p["conversacion"] = 1;
					$update_p["id_paquete"]   = $id_paquete_archivo;
					$update_p["curp"]         = $curp;
					$update_p["fecha_ultima"] = $tiempo;
					$this->chatbot_model->updatePregunta($cel,$update_p);

				}else{

					$update_p                 = array();
					$update_p["conversacion"] = 1;
					$update_p["fecha_ultima"] = $tiempo;
					$this->chatbot_model->updatePregunta($cel,$update_p);

					$message = "Ocurrio un error al guardar la *INE* por favor intenta con una foto más clara.";
					$this->mensaje_bot($message,$cel,$fromCustomer);

				}


			}else{

				$message = "No pudimos leer la *INE* por favor intenta con una foto más clara.";
				$this->mensaje_bot($message,$cel,$fromCustomer);

				$update_p                 = array();
				$update_p["conversacion"] = 1;
				$update_p["fecha_ultima"] = $tiempo;
				$this->chatbot_model->updatePregunta($cel,$update_p);

			}

		}else{//No es imagen

			$message = "❌ Por favor envíame únicamente una *FOTO* 📸 de la INE/IFE 👇";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}

	}//termina pregunta2_asesor

	public function escanearINE($image, $cel){
	// public function escanearINE(){
	// 	$image = "https://filemanager.gupshup.io/wa/bd0cba81-bacd-41b0-a160-2ae4c7b5efb3/wa/media/675210178323422?download=false";
	// 	$cel   = "5214423275640";
		
	
		$data       = file_get_contents($image);
	
		$string_b64 = base64_encode($data);
		
		$username   = "factorx";
		$password   = "x_i.E4h18";
		
		$ch         = curl_init();

		$datos = "";
		$datos = array(
			'id' => $string_b64 //SE ENVIA FOTO EN FORMATO BASE64
		);

		curl_setopt($ch, CURLOPT_URL, 'https://ine.nubarium.com/ocr/obtener_datos'); //URL ENDPOINT
		//curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		$payload = json_encode($datos, JSON_PRETTY_PRINT); //JSON
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload); //TIPO POST
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password); //AUTHORIZATION BASIC

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'Accept: application/json';
		$headers[] = 'Cache-Control: no-cache';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch); //RETORNA EL JSON ARRAY CON LOS DATOS DETECTADOS
	
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}
		
		$json = json_decode($result, true);

		curl_close($ch);

		$return         = 500;
		$id_colaborador = null;
		$curp_return    = null;
		$nombre_return  = null;

		$curp             = NULL;
		$nombres          = NULL;
		$primerApellido   = NULL;
		$segundoApellido  = NULL;
		$calle            = NULL;
		$colonia          = NULL;
		$ciudad           = NULL;
		$sexo_colaborador = NULL;
		$fecha_nacimiento = NULL;
		$clave_elector    = NULL;

		$id_paquete_archivo = 0;
		// header('Content-Type: application/json');
		// print_r($json);
		// die();

		if (!array_key_exists("curp", $json)) {
			
			$return         = 500;
			$id_colaborador = null;
			$curp_return    = null;
			$curp           = null;

		}else{

			  // header('Content-Type: application/json');
			  // print_r($json);
			  // die();
			$insert_pa                     = array();
			$insert_pa["nombre"]           = "Paquete";
			$insert_pa["celular_registro"] = $cel;
			$id_paquete_archivo            = $this->chatbot_model->insertPaqueteArchivo($insert_pa);
			

			$insert_a                       = array();
			$insert_a["id_paquete_archivo"] = $id_paquete_archivo;
			$insert_a["url_archivo"]        = "static/uploads/".$id_paquete_archivo."-INE.jpeg";
			$id_archivo                     = $this->chatbot_model->insertArchivo($insert_a);
			
			
			$curp             = $json["curp"];
			$nombres          = $json["nombres"];
			$primerApellido   = $json["primerApellido"];
			$segundoApellido  = $json["segundoApellido"];
			$calle            = $json["calle"];
			$colonia          = $json["colonia"];
			$ciudad           = $json["ciudad"];
			$sexo_colaborador = $json["sexo"];
			$fecha_nacimiento = $json["fechaNacimiento"];
			$clave_elector    = $json["claveElector"];
			$date             = str_replace('/', '-', $fecha_nacimiento);
			$fecha_nacimiento = date('Y-m-d', strtotime($date));
			
			$insert_ine                       = array();
			$insert_ine["curp"]               = $curp;
			$insert_ine["nombres"]            = $nombres;
			$insert_ine["primerApellido"]     = $primerApellido;
			$insert_ine["segundoApellido"]    = $segundoApellido;
			$insert_ine["calle"]              = $calle;
			$insert_ine["colonia"]            = $colonia;
			$insert_ine["ciudad"]             = $ciudad;
			$insert_ine["sexo"]               = $sexo_colaborador;
			$insert_ine["fechaNacimiento"]    = $fecha_nacimiento;
			$insert_ine["claveElector"]       = $clave_elector;
			$insert_ine["id_archivo"]         = $id_archivo;
			$insert_ine["id_paquete_archivo"] = $id_paquete_archivo;
			$insert_ine["celular_alta"]       = $cel;
			$insert_ine["estatus_cron"]       = 0;
			
			$insert_i = $this->chatbot_model->insertDatosIne($insert_ine);

			if(!is_null($insert_i)){
				$return = 200;
			}

		}//termina else isset

		// var_dump(array("return" => $return, "curp" => $curp, "id_paquete_archivo" => $id_paquete_archivo));
		// echo "código: ".$return." id_colaborador: ".$id_colaborador." curp: ".$curp_return;
		// echo "return: ".$return;
		return array("return" => $return, "curp" => $curp, "id_paquete_archivo" => $id_paquete_archivo);


	}//termina escanearINE

	public function pregunta1_asesor($mensaje_whats, $title_button, $cel, $nombre_c, $fromCustomer, $tiempo){

		$mensaje_button = $this->quitar_tildes(strtoupper($title_button));

		if($mensaje_button == "comenzar"){

			$update_p                 = array();
			$update_p["pregunta_1"]   = "INE";
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

			$message = "¡Excelente 👏! vamos a iniciar.

Por favor comparteme una fotografía del *INE* 💳 👇";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}else{


			$cabecera = "¡Bienvenido!";
			$mensaje  = "Oprime el botón para iniciar a registrar 👇";
			$pie      = "";

			$options[] = array('type' => 'text', 'title' => 'Comenzar', "encodeText" => true);
			$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);

		}


	}//termina pregunta1_asesor

	public function pregunta0_asesor($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo){

		$insert_pre                 = array();
		$insert_pre["pregunta_0"]   = "Bienvenida";
		$insert_pre["celular"]      = $cel;
		$insert_pre["fecha_ultima"] = $tiempo;
		$insert_pre["fecha_inicio"] = $tiempo;
		
		if($this->chatbot_model->insertPregunta($insert_pre)){

			$cabecera = "¡Bienvenido!";
			$mensaje  = "Oprime el botón para iniciar a registrar 👇";
			$pie      = "";

			$options[] = array('type' => 'text', 'title' => 'Comenzar', "encodeText" => true);
			$this->mensaje_boton($cel, $cabecera, $mensaje, $pie, $options);

		}


	}//termina pregunta0_asesor

	public function pregunta4_parte_bd($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo){


		$mensaje_w                = $this->quitar_tildes(strtoupper($mensaje_whats));
		
		$arreglo_1                = array('(1)','(1','1','uno', 'si', 'claro', 'yes');
		list($return_1, $palabra) = $this->palabra_clave($arreglo_1, $mensaje_w);
		
		$arreglo_2                = array('(2)','(2','2','dos', 'no, en otro momento', 'no');
		list($return_2, $palabra) = $this->palabra_clave($arreglo_2, $mensaje_w);

		$arreglo_3                = array('(3)','(3','3','tres', 'salir', 'atras', 'regresar');
		list($return_3, $palabra) = $this->palabra_clave($arreglo_3, $mensaje_w);


		if($return_1){

			$vacantes = $this->chatbot_model->getVacantes();			
			$cont     = 1;
			$msj      = ""; 

			if(!is_null($vacantes)){

				foreach ($vacantes as $v) {
					
					$msj .= "*(".$cont.")* ".$v->nombre_vacante." \n";
					$cont++;

				}//termina foreach

			}//termina is null

			$update_p                 = array();
			$update_p["pregunta_3"]   = "VACANTES";
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

// 			$message = "¿A qué vacante deseas aplicar?

// ".$msj."
// *(".$cont.")* Regresar al menú principal

// Para posiciones técnicas y administrativas favor de acceder a: https://www.empleonuevo.com/empleoen/alaris, donde nos encontrarás como *Sistemas Medicos Alaris*.

// *PARA VACANTES DE BD Tijuana 2 (localizada en El Realito) enviar información a Daniela.Ibarra@bd.com*";

			$message = "¿A qué vacante deseas aplicar?

".$msj."
*(".$cont.")* Regresar al menú principal

Para posiciones técnicas y administrativas favor de acceder a: https://www.empleonuevo.com/empleo-en/sistemas-medicos-alaris, donde nos encontrarás como *Sistemas Medicos Alaris*.";
			$this->mensaje_bot($message,$cel,$fromCustomer);


		}else if($return_2){

			$message = "Fue un placer atenderte ".$nombre_c.".

¡Hasta luego!";
			$this->mensaje_bot($message,$cel,$fromCustomer);

			$update_p                 = array();
			$update_p["pregunta_4"]   = "FIN";
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

		}else if ($return_3) {

			$update_p                 = array();
			$update_p["pregunta_3"]   = NULL;
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);
			
			$message = "Muy bien, estamos de regreso.

¿En qué podemos ayudarte?

*(1)* ¿Que vacantes hay disponibles?
*(2)* ¿Cómo puedo ser parte del equipo BD?
*(3)* Rutas de transporte
*(4)* ¿Qué documentos necesito para contratación?
*(5)* ¿Con qué banco pagan?

_Escribe el número de la opción de tu interés_";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}else{

			$message = "❌ Respuesta incorrecta, por favor escribe el número de tu opción preferida:

*¿Deseas conocer nuestras vacantes?*

*(1)* Si
*(2)* No, en otro momento";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}




	}//termina pregunta4_parte_bd

	public function pregunta5_vacantes($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo, $id_persona, $p4){

		$mensaje_w                = $this->quitar_tildes(strtoupper($mensaje_whats));
		
		$arreglo_1                = array('(1)','(1','1','uno', 'interesado', 'aplicar');
		list($return_1, $palabra) = $this->palabra_clave($arreglo_1, $mensaje_w);
		
		$arreglo_2                = array('(2)','(2','2','dos', 'regresar','atras', 'menu', 'anterior');
		list($return_2, $palabra) = $this->palabra_clave($arreglo_2, $mensaje_w);

		$id_vacante = $p4;

		if($return_1){

			$update_p                 = array();
			$update_p["pregunta_5"]   = "FIN";
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

			$insert_pv               = array();
			$insert_pv["id_persona"] = $id_persona;
			$insert_pv["id_vacante"] = $id_vacante;
			$insert_pv["fecha"]      = $tiempo;
			$this->chatbot_model->insertPersonaVacante($insert_pv);

			$message = "Favor de presentarte directamente en la planta, Blvd. Insurgentes 20351 | Parque Industrial El Florido | Tijuana B.C | CP 22244, en horario de 7 am a 11 am de Lunes a Viernes";

			$this->mensaje_bot($message,$cel,$fromCustomer);

		}else if($return_2){

			$update_p                 = array();
			$update_p["pregunta_4"]   = NULL;
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

			$vacantes = $this->chatbot_model->getVacantes();			
			$cont     = 1;
			$msj      = ""; 

			if(!is_null($vacantes)){

				foreach ($vacantes as $v) {
					
					$msj .= "*(".$cont.")* ".$v->nombre_vacante." \n";
					$cont++;

				}//termina foreach

			}//termina is null

			$message = "¿A qué vacante deseas aplicar?

".$msj."
*(".$cont.")* Regresar al menú principal

Para posiciones técnicas y administrativas favor de acceder a: https://www.empleonuevo.com/empleo-en/sistemas-medicos-alaris, donde nos encontrarás como *Sistemas Medicos Alaris*.";

			$this->mensaje_bot($message,$cel,$fromCustomer);


		}else{

			$message = "❌ Respuesta incorrecta, por favor escribe el número de tu opción preferida:

*(1)* Estoy interesado en aplicar
*(2)* Regresar al menú anterior";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}


	}//termina pregunta5_vacantes

	public function pregunta4_vacantes($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo, $id_persona){

		$nombre_vacante = "";
		$id_vacante     = 0;
		$respuesta      = 500;
		$i              = 1;
		$msj            = "";
		$direccion      = "";
		
		$vacantes  = $this->chatbot_model->getVacantes();
		
		$mensaje_w = $this->quitar_tildes(strtoupper($mensaje_whats));
		
		if (!is_null($vacantes)) {
			foreach($vacantes as $v) {

				$arreglo = array(''.strtolower(ltrim($this->quitar_tildes($v->nombre_vacante))).'',$i);
				list($return, $palabra) = $this->palabra_clave($arreglo, $mensaje_w);

				$msj.= "*(" . $i . ")*" . " " . $v->nombre_vacante . "\n";//solo es por si se equivoca volver a construir las vacantes

				if($return){
					
					$respuesta      = 200;
					$nombre_vacante = $v->nombre_vacante;
					$id_vacante     = $v->id_vacante;
					$direccion      = $v->direccion;
					break;	

				}
								
				$i++;
			} //termina foreach
		} //termina if null

		$cont_r = count($vacantes) + 1;

		$arreglo_r                = array('('.$cont_r.')','('.$cont_r.'',''.$cont_r.'','regresar al menu principal', 'regresar', 'salir', 'atras');
		list($return_r, $palabra) = $this->palabra_clave($arreglo_r, $mensaje_w);


		if($respuesta == 200){

			$turnos    = $this->chatbot_model->getTurnosVacantes($id_vacante);
			$msj_turno = "";

			if(!is_null($turnos)){

				foreach ($turnos as $v) {
		
					$msj_turno .= "*-* ".$v->desc_turno."\n";

				}//foreach

			}//is_null

			$message = "Los turnos disponibles para la vacante de *".$nombre_vacante."* son:

".$msj_turno."
*(1)* Estoy interesado en aplicar
*(2)* Regresar al menú anterior";
			$this->mensaje_bot($message,$cel,$fromCustomer);

			// sleep(1);

// 			$message2 = "Si estás interesado en la vacante por favor presentate en la siguiente ubicación:

// ".$direccion."";
// 			$this->mensaje_bot($message2,$cel,$fromCustomer);

			$update_p                 = array();
			$update_p["pregunta_4"]   = $id_vacante;
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

		}else if($return_r){

			$update_p                 = array();
			$update_p["pregunta_3"]   = NULL;
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

			$message = "Estoy de regreso ".$nombre_c.", ¿En qué podemos ayudarte?

*(1)* ¿Que vacantes hay disponibles?
*(2)* ¿Cómo puedo ser parte del equipo BD?
*(3)* Rutas de transporte
*(4)* ¿Qué documentos necesito para contratación?
*(5)* ¿Con qué banco pagan?

_Escribe el número de la opción de tu interés_";
			$this->mensaje_bot($message,$cel,$fromCustomer);


		}else{

			$message = "❌ Respuesta incorrecta, por favor escribe el número de tu opción preferida:

¿A qué vacante deseas aplicar?

".$msj."
*(".$i.")* Regresar al menú principal";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}


	}//termina pregunta4_vacantes


	public function prueba(){

		$pdf = $this->chatbot_model->getPdfRuta();

		die(var_dump($pdf));

	}

	public function pregunta3($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo){

		$mensaje_w                = $this->quitar_tildes(strtoupper($mensaje_whats));
		
		$arreglo_1                = array('(1)','(1','1','uno', 'vacantes disponibles', 'vacantes', 'que vacantes disponibles');
		list($return_1, $palabra) = $this->palabra_clave($arreglo_1, $mensaje_w);
		
		$arreglo_2                = array('(2)','(2','2','dos', 'como puedo ser parte del equipo bd','ser parte del equipo bd');
		list($return_2, $palabra) = $this->palabra_clave($arreglo_2, $mensaje_w);

		$arreglo_3                = array('(3)','(3','3','tres', 'rutas de transporte');
		list($return_3, $palabra) = $this->palabra_clave($arreglo_3, $mensaje_w);

		$arreglo_4                = array('(4)','(4','4','cuatro', 'que documentos necesito');
		list($return_4, $palabra) = $this->palabra_clave($arreglo_4, $mensaje_w);

		$arreglo_5                = array('(5)','(5','5','cinco', 'con que banco pagan','banco');
		list($return_5, $palabra) = $this->palabra_clave($arreglo_5, $mensaje_w);

		if($return_1){

			$vacantes = $this->chatbot_model->getVacantes();			
			$cont     = 1;
			$msj      = ""; 

			if(!is_null($vacantes)){

				foreach ($vacantes as $v) {
					
					$msj .= "*(".$cont.")* ".$v->nombre_vacante." \n";
					$cont++;

				}//termina foreach

			}//termina is null

			$update_p                 = array();
			$update_p["pregunta_3"]   = "VACANTES";
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

// 			$message = "¿A qué vacante deseas aplicar?

// ".$msj."
// *(".$cont.")* Regresar al menú principal

// Para posiciones técnicas y administrativas favor de acceder a: https://www.empleonuevo.com/empleoen/alaris, donde nos encontrarás como *Sistemas Medicos Alaris*.

// *PARA VACANTES DE BD Tijuana 2 (localizada en El Realito) enviar información a Daniela.Ibarra@bd.com*";

			$message = "¿A qué vacante deseas aplicar?

".$msj."
*(".$cont.")* Regresar al menú principal

Para posiciones técnicas y administrativas favor de acceder a: https://www.empleonuevo.com/empleo-en/sistemas-medicos-alaris, donde nos encontrarás como *Sistemas Medicos Alaris*.";

			$this->mensaje_bot($message,$cel,$fromCustomer);

		}else if($return_2){

// 			$message = "*¿Cómo puedo ser parte del equipo BD?*

// Paso 1: Examen de conocimientos
// Paso 2: Examen médico
// Paso 3: Indispensable contar con correo electrónico";

			$message = "Favor de presentarte directamente en la planta, Blvd. Insurgentes 20351 | Parque Industrial El Florido | Tijuana B.C | CP 22244, en horario de 7 am a 11 am de Lunes a Viernes con los siguientes documentos:

- Acta de Nacimiento
- Comprobante de Domicilio reciente
- Constancia de Situación Fiscal (RFC)
- Número de Seguro Social
- Ultimo comprobante de estudios
- INE
- Carta de Retención Infonavit (En caso de aplicar)
- Comprobante de Vacunación COVID (En caso de aplicar)";

			$this->mensaje_bot($message,$cel,$fromCustomer);

			sleep(1);

			$message2 = "*¿Deseas conocer nuestras vacantes?*

*(1)* Si
*(2)* No, en otro momento

*(3)* Regresar al menú anterior";
			$this->mensaje_bot($message2,$cel,$fromCustomer);

			$update_p                 = array();
			$update_p["pregunta_3"]   = "SER_PARTE_BD";
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);


		}else if($return_3){

			$getRuta  = $this->chatbot_model->getPdfRuta();
			$tipo     = $getRuta->tipo;
			$url      = $getRuta->pdf_ruta;
			$message  = "Rutas de Transporte";
			$filename = 'Rutas';
			
			if($tipo == 'image'){
				$this->mensaje_image($cel, $url, $filename);	
			}else{
				$this->mensaje_file($cel, $url, $filename);
			}

			sleep(2);

			$message = "- Es importante que revises paradas y horas";
			$this->mensaje_bot($message,$cel,$fromCustomer);

			sleep(1);

			$message2 = "- Si no ves transporte cerca de tu colonia, podemos dar un bono de transporte";
			$this->mensaje_bot($message2,$cel,$fromCustomer);

			$update_p                 = array();
			$update_p["pregunta_3"]   = "RUTAS";
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);


		}else if($return_4){

			$message = "Los documentos necesarios para tu contratación son:

- Acta de Nacimiento
- Comprobante de domicilio no anterior a 3 meses
- Comprobante de último grado de estudios
- Constancia de Situación Fiscal
- INE
- Número de seguro social
- Hoja de retención Infonavit (en caso de aplicar)
- Certificado de vacunación COVID-19 (en caso de aplicar)";
			$this->mensaje_bot($message,$cel,$fromCustomer);

			$update_p                 = array();
			$update_p["pregunta_3"]   = "DOCUMENTOS";
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

		}else if($return_5){

			$message = "- *BANORTE*
- No depositamos a otros bancos
- No hay necesidad de acudir al banco, nosotros te entregamos tu tarjeta para que la actives al primer deposito
- Pagamos los días Jueves
- Si tenemos semana atrasada";
			$this->mensaje_bot($message,$cel,$fromCustomer);

			$update_p                 = array();
			$update_p["pregunta_3"]   = "BANCO";
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

		}else{

			$message = "❌ Respuesta incorrecta, por favor escribe el número de tu opción preferida:

¿En qué podemos ayudarte?

*(1)* ¿Que vacantes hay disponibles?
*(2)* ¿Cómo puedo ser parte del equipo BD?
*(3)* Rutas de transporte
*(4)* ¿Qué documentos necesito para contratación?
*(5)* ¿Con qué banco pagan?

_Escribe el número de la opción de tu interés_";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}


	}//termina pregunta3

	public function pregunta2($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo){

		$persona = $this->chatbot_model->getPersona($cel);

		if(strlen($mensaje_whats) > 2 && strlen($mensaje_whats) < 100){

			if(is_null($persona)){

				$insert_c                    = array();
				$insert_c["nombre_persona"]  = $mensaje_whats;
				$insert_c["celular_persona"] = $cel;
				$insert_c["fecha_registro"]  = $tiempo;
				$id_persona                  = $this->chatbot_model->insertPersona($insert_c);
			}else{
				$id_persona = $persona->id_persona;
			}

			$update_p                 = array();
			$update_p["pregunta_2"]   = "NOMBRE";
			$update_p["id_persona"]   = $id_persona;
			$update_p["nombre"]       = $mensaje_whats;
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

			$message = "¿En qué podemos ayudarte?

*(1)* ¿Que vacantes hay disponibles?
*(2)* ¿Cómo puedo ser parte del equipo BD?
*(3)* Rutas de transporte
*(4)* ¿Qué documentos necesito para contratación?
*(5)* ¿Con qué banco pagan?

_Escribe el número de la opción de tu interés_";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}else{

			$message = "❌ Por favor escribenos tu *Nombre Completo*:";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}

	}//termina pregunta2

	public function pregunta2_RH($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo){

		$mensaje_w                = $this->quitar_tildes(strtoupper($mensaje_whats));
		
		$arreglo_1                = array('(1)','(1','1','uno', 'regresar', 'atras', 'regresar al menu principal');
		list($return_1, $palabra) = $this->palabra_clave($arreglo_1, $mensaje_w);

		if ($return_1) {

			$update_p                 = array();
			$update_p["pregunta_1"]   = NULL;
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

			$message = "Estoy de regreso.

Selecciona una opción:

*(1)* Si estas interesado en conocer los procesos de contrataciones y vacantes
*(2)* Si eres colaborador de BD y necesitas información relacionada a Recursos Humanos";
			$this->mensaje_bot($message,$cel,$fromCustomer);
			
		}else{

			$message = "❌ Respuesta incorrecta, por favor escribe el número de tu opción preferida:

Comunícate al área de Recursos Humanos por medio de Whatsapp al número 664 388 0809

*(1)* Regresar al menú principal";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}

	}

	public function pregunta1($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo){

		$mensaje_w                = $this->quitar_tildes(strtoupper($mensaje_whats));
		
		$arreglo_1                = array('(1)','(1','1','uno', 'estoy interesado en conocer los procesos de contrataciones');
		list($return_1, $palabra) = $this->palabra_clave($arreglo_1, $mensaje_w);
		
		$arreglo_2                = array('(2)','(2','2','dos', 'soy colaborador de bd');
		list($return_2, $palabra) = $this->palabra_clave($arreglo_2, $mensaje_w);

		if($return_1){

			$message = "Muy bien, comencemos. Compártenos por favor tu *Nombre Completo*:";
			$this->mensaje_bot($message,$cel,$fromCustomer);

			$update_p                 = array();
			$update_p["pregunta_1"]   = "SIGUIENTE";
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

		}else if($return_2){

			$message = "Comunícate al área de Recursos Humanos por medio de Whatsapp al número 664 388 0809

*(1)* Regresar al menú principal";
			$this->mensaje_bot($message,$cel,$fromCustomer);

			$update_p                 = array();
			$update_p["pregunta_1"]   = "RH";
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

		}else{

			$message = "❌ Respuesta incorrecta, por favor escribe el número de tu opción preferida:

Selecciona una opción:

*(1)* Si estas interesado en conocer los procesos de contrataciones y vacantes
*(2)* Si eres colaborador de BD y necesitas información relacionada a Recursos Humanos";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}

	}//termina pregunta1

	public function pregunta0($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo){

		$insert_pre                     = array();
		$insert_pre["pregunta_0"]       = "Bienvenida";
		$insert_pre["celular"]          = $cel;
		$insert_pre["fecha_ultima"]     = $tiempo;
		$insert_pre["fecha_inicio"]     = $tiempo;
		
		if($this->chatbot_model->insertPregunta($insert_pre)){

			$message = "*BD* agradece tu interés en querer formar parte de nuestro equipo de trabajo.

Te invitamos a que leas nuestro aviso de privacidad: https://www.bd.com/es-mx/privacypolicy

Selecciona una opción:

*(1)* Si estas interesado en conocer los procesos de contrataciones y vacantes

*(2)* Si eres colaborador de BD y necesitas información relacionada a Recursos Humanos";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}//termina insert

	}//termina pregunta0



	public function pregunta_reinicio($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo){

		$update_p                     = array();
		$update_p["pregunta_3"]       = NULL;
		$update_p["pregunta_4"]       = NULL;
		$update_p["pregunta_5"]       = NULL;
		$update_p["pregunta_6"]       = NULL;
		$update_p["pregunta_7"]       = NULL;
		$update_p["fecha_ultima"] = $tiempo;
		$this->chatbot_model->updatePregunta($cel,$update_p);


		$message = "Estoy de regreso ".$nombre_c.", ¿En qué podemos ayudarte?

*(1)* ¿Que vacantes hay disponibles?
*(2)* ¿Cómo puedo ser parte del equipo BD?
*(3)* Rutas de transporte
*(4)* ¿Qué documentos necesito para contratación?
*(5)* ¿Con qué banco pagan?

_Escribe el número de la opción de tu interés_";
		$this->mensaje_bot($message,$cel,$fromCustomer);

	}//termina pregunta_colab_reinicio


	public function pregunta_SI_reinicio($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo){

		$update_p                 = array();
		$update_p["pregunta_2"]   = NULL;
		$update_p["pregunta_3"]   = NULL;
		$update_p["pregunta_4"]   = NULL;
		$update_p["pregunta_5"]   = NULL;
		$update_p["pregunta_6"]   = NULL;
		$update_p["pregunta_7"]   = NULL;
		$update_p["fecha_ultima"] = $tiempo;
		$this->chatbot_model->updatePregunta($cel,$update_p);

		$message = "Estoy de regreso, tengo estas opciones para ti:

*(1)* Consultar status procesal
*(2)* Solicitar el último acuerdo
*(3)* Contactar a mi asesor
*(4)* Solicitar nuevo servicio
*(5)* Quejas
*(6)* Despacho Virtual

*(7)* Regresar";
		$this->mensaje_bot($message,$cel,$fromCustomer);

	}//termina pregunta_SI_reinicio

	public function pregunta_SI_final($mensaje_whats, $cel, $nombre_c, $fromCustomer, $tiempo){

		$mensaje_w                = $this->quitar_tildes(strtoupper($mensaje_whats));
		
		$arreglo_1                = array('(1)','(1','1','uno');
		list($return_1, $palabra) = $this->palabra_clave($arreglo_1, $mensaje_w);
		
		$arreglo_2                = array('(2)','(2','2','dos');
		list($return_2, $palabra) = $this->palabra_clave($arreglo_2, $mensaje_w);

		if($return_1){

			$update_p                 = array();
			$update_p["pregunta_2"]   = NULL;
			$update_p["pregunta_3"]   = NULL;
			$update_p["pregunta_4"]   = NULL;
			$update_p["pregunta_5"]   = NULL;
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

			$message = "Tengo estas opciones para ti:

*(1)* Consultar status procesal
*(2)* Solicitar el último acuerdo
*(3)* Contactar a mi asesor
*(4)* Solicitar nuevo servicio
*(5)* Quejas
*(6)* Despacho Virtual

*(7)* Regresar";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}else if($return_2){

			$update_p                 = array();
			$update_p["pregunta_4"]   = "FIN";
			$update_p["pregunta_5"]   = "FIN";
			$update_p["pregunta_6"]   = "FIN";
			$update_p["fecha_ultima"] = $tiempo;
			$this->chatbot_model->updatePregunta($cel,$update_p);

			$message = "Fue un placer ayudarte";
			$this->mensaje_bot($message,$cel,$fromCustomer);

		}else{

			$message = "❌ Respuesta incorrecta, por favor escribe el número de tu opción preferida:

¿Te puedo ayudar con algo más?			

*(1)* Si
*(2)* No";

			$this->mensaje_bot($message,$cel,$fromCustomer);

		}


	}//termina pregunta_SI_final



	public function mensaje_bot_test(){

		$message = "Hola";
		$numero = "5214423275640";

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/sm/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$payload = [
			'channel' => 'whatsapp',
			'source' => '5216648841034',
			'destination' => ''.$numero.'',
			'src.name' => 'bdreclu',
			'message' => json_encode(array('type' => 'text', 'text' => $message))
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Cache-Control: no-cache';
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Apikey: xmon4bizq85hhnqbbu3j4xvekau6vh87';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		print_r($result);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);

		// $message = nl2br($message);

	}//termina mensaje_bot_test

	public function mensaje_boton($numero, $cabecera, $mensaje, $pie, $options){

		$payload = [
		    'channel' => 'whatsapp',
		    'source' => '5216648841034',
		    'destination' => ''.$numero.'',
		    'src.bdreclu',
		    'disablePreview' => 'false',
		    'encode' => 'false',
		    'message' => json_encode(array('content' => array('type' => 'text', 'header' => ''.$cabecera.'', 'text' => ''.$mensaje.'', 'caption' => ''.$pie.''), 'type' => 'quick_reply', 'msgid' => 'qr1', 'options' => $options))
		];

		$limpio = array();
	    for ($i = 0; $i < count($options); $i++) {
     		foreach ($options[$i] as $key => $op){
	            if ($key == "title") {
	                $new = array("options" => $op);
	           		array_push($limpio, $new);
	            }
	         }
	    }


		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/wa/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Accept: application/json';
		$headers[] = 'Apikey: xmon4bizq85hhnqbbu3j4xvekau6vh87';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);

		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}

		// var_dump($result);
		curl_close($ch);

	}//termina mensaje_boton

	public function mensaje_bot($message,$numero,$fromCustomer){

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/sm/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$payload = [
			'channel' => 'whatsapp',
			'source' => '5216648841034',
			'destination' => ''.$numero.'',
			'src.name' => 'bdreclu',
			'message' => json_encode(array('type' => 'text', 'text' => $message))
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Cache-Control: no-cache';
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Apikey: xmon4bizq85hhnqbbu3j4xvekau6vh87';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
			echo 'Error:' . curl_error($ch);
		}
		curl_close($ch);

		// $message = nl2br($message);

	}//termina mensaje_bot


	public function mensaje_image($numero, $url, $caption){

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/sm/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$payload = [
		    'channel' => 'whatsapp',
		    'source' => '5216648841034',
		    'destination' => ''.$numero.'',
		    'src.name' => 'bdreclu',
		    'message' => json_encode(array('type' => 'image', "originalUrl" => $url, "previewUrl" => $url, "caption" => $caption))
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Cache-Control: no-cache';
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Apikey: xmon4bizq85hhnqbbu3j4xvekau6vh87';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}

		$json = json_decode($result);

		$status = $json->status;

		curl_close($ch);

	}//termina mensaje_image


	public function mensaje_file($numero, $url, $filename){

		$ch = curl_init();

		curl_setopt($ch, CURLOPT_URL, 'https://api.gupshup.io/sm/api/v1/msg');
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_POST, 1);

		$payload = [
		    'channel' => 'whatsapp',
		    'source' => '5216648841034',
		    'destination' => ''.$numero.'',
		    'src.name' => 'bdreclu',
		    'message' => json_encode(array('type' => 'file', "url" => $url, "filename" => $filename))
		];

		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($payload));

		$headers = array();
		$headers[] = 'Cache-Control: no-cache';
		$headers[] = 'Content-Type: application/x-www-form-urlencoded';
		$headers[] = 'Apikey: xmon4bizq85hhnqbbu3j4xvekau6vh87';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch);
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}

		$json = json_decode($result);

		$status = $json->status;

		curl_close($ch);


	}//termina mensaje_file


	public function fileDownload($url, $destination){
		  $fp = fopen ($destination, 'w+');
		  $ch = curl_init();
		  curl_setopt( $ch, CURLOPT_URL, $url );
		  curl_setopt( $ch, CURLOPT_BINARYTRANSFER, true );
		  curl_setopt( $ch, CURLOPT_RETURNTRANSFER, false );
		  curl_setopt( $ch, CURLOPT_SSL_VERIFYPEER, false );
		 
		  curl_setopt( $ch, CURLOPT_CONNECTTIMEOUT, 10 );
		  curl_setopt( $ch, CURLOPT_FILE, $fp );
		  $result = curl_exec( $ch );
		  curl_close( $ch );
		  fclose( $fp );
		 
		 if ($result) {
		 	return true;
		 }else{

		 	return false;
		 }
		  
	}//termina fileDownload




	public function palabra_clave($arreglo, $mensaje_whats){
		$offset = 0;
		$chr = array();
		$palabra = "";
		$return  = false;
		if (array_search(strtolower($mensaje_whats) , $arreglo, false) !== false) {
			$return = true;
		}

		return array(
			$return,
			$palabra
		);

	} //termina funcion palabra_clave


	public function quitar_tildes($cadena){

		$originales  = 'ÀÁÂÃÄÅÆÇÈÉÊËÌÍÎÏÐÑÒÓÔÕÖØÙÚÛÜÝÞßàáâãäåæçèéêëìíîïðñòóôõöøùúûýýþÿŔŕ';
		$modificadas = 'aaaaaaaceeeeiiiidnoooooouuuuybsaaaaaaaceeeeiiiidnoooooouuuyybyRr';
		$cadena      = utf8_decode($cadena);
		$cadena      = strtr($cadena, utf8_decode($originales) , $modificadas);
		$cadena      = strtolower($cadena);

		return utf8_encode($cadena);

	} //termina quitar_tildes

	public function validar_fecha_espanol($fecha){

		$fecha = str_replace("-", "/", $fecha);

		$valores = explode('/', $fecha);
		if(count($valores) == 3 && checkdate($valores[1], $valores[0], $valores[2])){
			return true;
	    }else{
	    	return false;
	    }
		
	}//termina validar_fecha_espanol

	public function validarFecha($fecha){
		
		$regexFecha = '/^([0-2][0-9]|3[0-1])(\/|-)(0[1-9]|1[0-2])\2(\d{4})$/';

	
		$replace_fecha = str_replace("-","/",$fecha);

	
		if ( !preg_match($regexFecha, $replace_fecha, $matchFecha) ) {
		        return false;

		}else{
		    return true;
		    

		}


	}//termina validarFecha


	public function validarEmail($str){
	
	  	$matches = null;
	  	return (1 === preg_match('/^[A-z0-9\\._-]+@[A-z0-9][A-z0-9-]*(\\.[A-z0-9_-]+)*\\.([A-z]{2,6})$/', $str, $matches));

	}//termina funcion validar validarEmail


	public function buscar_extension($url){

		$cadena_pdf  = "pdf";
		$cadena_doc  = "msword";
		$cadena_docx = "wordprocessingml";
		
		$buscar_docx = strpos($url, $cadena_docx);		
		$buscar_pdf  = strpos($url, $cadena_pdf);
		$buscar_doc  = strpos($url, $cadena_doc);


		if($buscar_pdf !== false){
			return "pdf";
		}else if($buscar_docx !== false){
			return "docx";
		}else if($buscar_doc !== false){
			return "doc";
		}else{
			return "error";
		}


	}//termina buscar_extension


	public function busqueda_palabra($arreglo,$mensaje_whats){
		$offset = 0;
		$chr = array();
		
		
		$foo = strtolower($mensaje_whats);
		
		foreach($arreglo as $v) {
			$res = strpos($foo , $v);
			if ($res !== false) {
				$palabra = $v;
				$return = true;
			 	break;
			}
			else {
				$palabra = $v;
				$return = false;
			}
		}

		return array(
			$return,
			$palabra
		);


	} //termina funcion busqueda_palabra


	public function getExtension($url){

		$extension = "NA";

		preg_match('/fileName=([^&]+)/', $url, $matches);
		
		if (isset($matches[1])) {
			$fileName = urldecode($matches[1]); // Decodificar caracteres URL
			$extension = pathinfo($fileName, PATHINFO_EXTENSION);
			
		}

		return $extension;

	}//termina getExtension


	public function constanciaPDF($url, $id_paquete_archivo){
			
		$data       = file_get_contents($url);
		
	
		$string_b64 = base64_encode($data);
		
		$username   = "factorx";
		$password   = "x_i.E4h18";
		
		$ch         = curl_init();

		$datos = "";
		$datos = array(
			'documento' => $string_b64, //SE ENVIA FOTO EN FORMATO BASE64
			'tipo' => 'pdf'
		);

		curl_setopt($ch, CURLOPT_URL, 'https://api.nubarium.com/sat/v1/consultar_cif'); //URL ENDPOINT
		//curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

		$payload = json_encode($datos, JSON_PRETTY_PRINT); //JSON
		curl_setopt($ch, CURLOPT_POSTFIELDS, $payload); //TIPO POST
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
		curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password); //AUTHORIZATION BASIC

		$headers = array();
		$headers[] = 'Content-Type: application/json';
		$headers[] = 'Accept: application/json';
		$headers[] = 'Cache-Control: no-cache';
		curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

		$result = curl_exec($ch); //RETORNA EL JSON ARRAY CON LOS DATOS DETECTADOS
	
		if (curl_errno($ch)) {
		    echo 'Error:' . curl_error($ch);
		}
		
		$json = json_decode($result, true);

		$return = 400;
		$curp   = null;


	

		$rfc                        = NULL;
		$apellidoMaterno            = NULL;
		$apellidoPaterno            = NULL;
		$curp                       = NULL;
		$fechaInicioOperaciones     = NULL;
		$fechaNacimiento            = NULL;
		$fechaUltimoCambioSituacion = NULL;
		$nombres                    = NULL;
		$situacionContribuyente     = NULL;
		$colonia                    = NULL;
		$correoElectronico          = NULL;
		$cp                         = NULL;
		$entidadFederativa          = NULL;
		$municipioDelegacion        = NULL;
		$nombreVialidad             = NULL;
		$numeroExterior             = NULL;
		$numeroInterior             = NULL;

		$insert_constancia = NULL;

		// header('Content-Type: application/json');
		// print_r($json);
		// die();

		if(array_key_exists("datosIdentificacion", $json)){

			$apellidoMaterno            = $json["datosIdentificacion"]["apellidoMaterno"];
			$apellidoPaterno            = $json["datosIdentificacion"]["apellidoPaterno"];
			$curp                       = $json["datosIdentificacion"]["curp"];
			$fechaInicioOperaciones     = $json["datosIdentificacion"]["fechaInicioOperaciones"];
			$fechaNacimiento            = $json["datosIdentificacion"]["fechaNacimiento"];
			$fechaUltimoCambioSituacion = $json["datosIdentificacion"]["fechaUltimoCambioSituacion"];
			$nombres                    = $json["datosIdentificacion"]["nombres"];
			$situacionContribuyente     = $json["datosIdentificacion"]["situacionContribuyente"];

			$return = 200;

		}else{
			$return = 400;
			$curp   = null;
		}

		if(array_key_exists("datosUbicacion", $json)){

			$colonia                    = $json["datosUbicacion"]["colonia"];
			$correoElectronico          = $json["datosUbicacion"]["correoElectronico"];
			$cp                         = $json["datosUbicacion"]["cp"];
			$entidadFederativa          = $json["datosUbicacion"]["entidadFederativa"];
			$municipioDelegacion        = $json["datosUbicacion"]["municipioDelegacion"];
			$nombreVialidad             = $json["datosUbicacion"]["nombreVialidad"];
			$numeroExterior             = $json["datosUbicacion"]["numeroExterior"];
			$numeroInterior             = $json["datosUbicacion"]["numeroInterior"];
			$return = 200;

		}else{
			$return = 400;
			$curp   = null;
		}


		if (array_key_exists("caracteristicasFiscales", $json)) {


			$insert_a                       = array();
			$insert_a["id_paquete_archivo"] = $id_paquete_archivo;
			$insert_a["url_archivo"]        = "static/uploads/".$id_paquete_archivo."-Constancia.pdf";
			$id_archivo                     = $this->chatbot_model->insertArchivo($insert_a);

			$datos = $json["caracteristicasFiscales"];
		
			// ✅ Validamos que sea array
			if (!is_array($datos)) {
				$datos = json_decode(json_encode($datos), true); // Convertir a array si es objeto
			}
		
			$getRegimen = $this->chatbot_model->getRegimenFiscal($id_paquete_archivo);
		
			if (is_null($getRegimen)) { // Si es null entonces insertamos
		
				foreach ($datos as $item) {
					if (is_array($item)) { // ✅ Validamos que $item sea array
						$codigo       = $item['codigo'] ?? null;
						$descripcion  = $item['regimen'] ?? null;
						$fechaAlta    = $item['fechaAlta'] ?? null;
		
						$insert_r = array(
							"regimen"            => $descripcion,
							"codigo"             => $codigo,
							"fechaAlta"          => $fechaAlta,
							"id_paquete_archivo" => $id_paquete_archivo
						);
		
						$this->chatbot_model->insertRegimenFiscal($insert_r);
					} else {
						// log_message('error', 'Elemento inválido en caracteristicasFiscales: ' . print_r($item, true));
					}
				} // foreach
			} // termina is_null
		}
		

		if(array_key_exists("rfc", $json)){
			$rfc = $json["rfc"];
		}

		if($return == 200){

			$insert_c = array();

			$fechaUltimoCambioSituacion       = str_replace('/', '-', $fechaUltimoCambioSituacion);
			$fechaUltimoCambioSituacion_final = date('Y-m-d', strtotime($fechaUltimoCambioSituacion));
			
			
			$fechaNacimiento       = str_replace('/', '-', $fechaNacimiento);
			$fechaNacimiento_final = date('Y-m-d', strtotime($fechaNacimiento));
			
			$fechaInicioOperaciones       = str_replace('/', '-', $fechaInicioOperaciones);
			$fechaInicioOperaciones_final = date('Y-m-d', strtotime($fechaInicioOperaciones));

			$insert_c["apellidoMaterno"]            = $apellidoMaterno;
			$insert_c["apellidoPaterno"]            = $apellidoPaterno;
			$insert_c["curp"]                       = $curp;
			$insert_c["fechaInicioOperaciones"]     = $fechaInicioOperaciones_final;
			$insert_c["fechaNacimiento"]            = $fechaNacimiento_final;
			$insert_c["fechaUltimoCambioSituacion"] = $fechaUltimoCambioSituacion_final;
			$insert_c["nombres"]                    = $nombres;
			$insert_c["situacionContribuyente"]     = $situacionContribuyente;
			$insert_c["colonia"]                    = $colonia;
			$insert_c["correoElectronico"]          = $correoElectronico;
			$insert_c["cp"]                         = $cp;
			$insert_c["entidadFederativa"]          = $entidadFederativa;
			$insert_c["municipioDelegacion"]        = $municipioDelegacion;
			$insert_c["nombreVialidad"]             = $nombreVialidad;
			$insert_c["numeroExterior"]             = $numeroExterior;
			$insert_c["numeroInterior"]             = $numeroInterior;
			$insert_c["rfc"]                        = $rfc;
			$insert_c["id_archivo"]                 = $id_archivo;
			$insert_c["id_paquete_archivo"]         = $id_paquete_archivo;
			
			$insert_constancia =  $this->chatbot_model->insertDatosConstancia($insert_c);
		}

		
		if(!is_null($insert_constancia)){
			$return = 200;
		}else{
			$return = 500;
		}

		return array("return" => $return, "rfc" => $rfc, "curp" => $curp);

	}//termina constanciaPDF


	public function comprobantePDF($url, $id_paquete_archivo, $url_archivo){
		// public function comprobantePDF(){
			// OCR COMPROBANTE DE DOMICILIO
			$curl = curl_init();
	
			// $url = "https://filemanager.gupshup.io/wa/bd0cba81-bacd-41b0-a160-2ae4c7b5efb3/wa/media/630098589888681?download=false&fileName=Constancia.pdf";
			$data = file_get_contents($url);
			$string_b64 = base64_encode($data);
	
	
			$method = 'POST';
			$headers = [
				'Content-Type: application/json',
				'Authorization: Basic ZmFjdG9yeDp4X2kuRTRoMTg='
			];
	
			$datos = array(
				'comprobante' => $string_b64
			);
	
			$payload = json_encode($datos, JSON_PRETTY_PRINT); //JSON
	
			$options = [
				CURLOPT_URL => "https://ocr.nubarium.com/ocr/v2/comprobante_domicilio",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => '',
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => $method,
				CURLOPT_POSTFIELDS => $payload,
				CURLOPT_HTTPHEADER => $headers,
			];
	
			curl_setopt_array($curl, $options);
	
			$response = curl_exec($curl);
	
			curl_close($curl);
	
			$json   = json_decode($response, true);
			$return = 400;
	
			// header('Content-Type: application/json');
			// print_r($json);
			// die();
	
			if(array_key_exists("QR", $json)){
	
				$qr               = $json["QR"];
				$adeudoAnterior   = $json["adeudoAnterior"];
				$calle            = $json["calle"];
				$ciudad           = $json["ciudad"];
				$colonia          = $json["colonia"];
				$cp               = $json["cp"];
				$fecha            = $json["fecha"];
				$fechaLimitePago  = $json["fechaLimitePago"];
				$nombre           = $json["nombre"];
				$referencia       = $json["referencia"];
				$periodoFacturado = $json["periodoFacturado"];
				$totalPagar       = $json["totalPagar"];
				
				if(array_key_exists("validaciones", $json)){
	
					$codigoNumerico = $json["validaciones"]["codigoNumerico"];
					$fecha          = $json["validaciones"]["fecha"];
					$numeroServicio = $json["validaciones"]["numeroServicio"];
					$rmu            = $json["validaciones"]["rmu"];
					$tarifa         = $json["validaciones"]["tarifa"];
					$totalPagar     = $json["validaciones"]["totalPagar"];
	
					$insert_c = array();
					
					$insert_a                       = array();
					$insert_a["id_paquete_archivo"] = $id_paquete_archivo;
					$insert_a["url_archivo"]        = $url_archivo;
					$id_archivo                     = $this->chatbot_model->insertArchivo($insert_a);
					

					$insert_c["qr"]                 = $qr;
					$insert_c["adeudoAnterior"]     = $adeudoAnterior;
					$insert_c["calle"]              = $calle;
					$insert_c["ciudad"]             = $ciudad;
					$insert_c["colonia"]            = $colonia;
					$insert_c["cp"]                 = $cp;
					$insert_c["fecha"]              = $fecha;
					$insert_c["fechaLimitePago"]    = $fechaLimitePago;
					$insert_c["nombre"]             = $nombre;
					$insert_c["referencia"]         = $referencia;
					$insert_c["periodoFacturado"]   = $periodoFacturado;
					$insert_c["totalPagar"]         = $totalPagar;
					$insert_c["codigoNumerico"]     = $codigoNumerico;
					$insert_c["fecha"]              = $fecha;
					$insert_c["numeroServicio"]     = $numeroServicio;
					$insert_c["rmu"]                = $rmu;
					$insert_c["tarifa"]             = $tarifa;
					$insert_c["totalPagar"]         = $totalPagar;
					$insert_c["id_archivo"]         = $id_archivo;
					$insert_c["id_paquete_archivo"] = $id_paquete_archivo;
											
					$comprobante = $this->chatbot_model->insertDatosComprobante($insert_c);
	
					if(!is_null($comprobante)){
						$return = 200;
					}
	
				}
				
			}
	
			return $return;
	
			// header('Content-Type: application/json');
			// print_r($json);
			// die();
	
	}//termina comprobantePDF


	public function getNss($curp, $id_paquete_archivo){
		
		$curl = curl_init();

		// $curp = "LOID930710HQTPBN04";
		// $id_paquete_archivo = 1;

		$url = 'https://apimarket.mx/api/imss/grupo/localizar-nss';
		$method = 'POST';
		$queryParams = http_build_query(["curp" => $curp]);
		$headers = [
			'Authorization: Bearer badd8309-2da2-4810-b564-6c903326b5a1',
			'Accept: application/json'
		];
		
		$options = [
			CURLOPT_URL => "$url?$queryParams",
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => $method,
			CURLOPT_HTTPHEADER => $headers,
		];
		
		curl_setopt_array($curl, $options);
		
		$response = curl_exec($curl);
		
		curl_close($curl);
		
		$json   = json_decode($response, true);
		$return = 400;
		$nss    = null;

		if(array_key_exists("data", $json)){

			$data = $json["data"];

			if(array_key_exists("nss", $data)){

				$nss                            = $data["nss"];
				$return                         = 200;
				
				$update_p        = array();
				$update_p["nss"] = $nss;
				$this->chatbot_model->updatePaqueteArchivo($update_p, $id_paquete_archivo);

			}

		}//termina

		return array("return" => $return, "nss" => $nss);
		// header('Content-Type: application/json');
		// print_r($json);
		// die();
	}//termina getNss

	public function getHistorialImss($curp, $nss){

		$url_w = base_url()."index.php/GetDatosImss";

		$username   = "factorx";
		$password   = "x_i.E4h18";

		$curl = curl_init();

		// curl_setopt($ch, CURLOPT_USERPWD, $username . ":" . $password); //AUTHORIZATION BASIC

		curl_setopt_array($curl, array(
		  CURLOPT_URL => 'https://api.nubarium.com/mex/ss/v1/employment-info-imss',
		  CURLOPT_RETURNTRANSFER => true,
		  CURLOPT_ENCODING => '',
		  CURLOPT_MAXREDIRS => 10,
		  CURLOPT_TIMEOUT => 0,
		  CURLOPT_FOLLOWLOCATION => true,
		  CURLOPT_USERPWD => $username . ":" . $password,
		  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
		  CURLOPT_CUSTOMREQUEST => 'POST',
		  CURLOPT_POSTFIELDS =>'{
		  "curp": "'.$curp.'",
		  "nss": "'.$nss.'",
		  "url": "'.$url_w.'"
		}',
		  CURLOPT_HTTPHEADER => array(
			'Content-Type: application/json'
		  ),
		));
		
		$response = curl_exec($curl);
		
		// echo "resp: ".$response;

		curl_close($curl);
		// echo $response;

		
	}//termina getHistorialImss


} //termina class Chatbot extends CI_Controll 